package software.amazon.awscdk.services.ec2;

/**
 * Peer object factories (to be used in Security Group management).
 * <p>
 * The static methods on this object can be used to create peer objects
 * which represent a connection partner in Security Group rules.
 * <p>
 * Use this object if you need to represent connection partners using plain IP
 * addresses, or a prefix list ID.
 * <p>
 * If you want to address a connection partner by Security Group, you can just
 * use the Security Group (or the construct that contains a Security Group)
 * directly, as it already implements <code>IPeer</code>.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-06-11T15:14:45.905Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.Peer")
public class Peer extends software.amazon.jsii.JsiiObject {

    protected Peer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Peer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Peer() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Any IPv4 address.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer anyIpv4() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Peer.class, "anyIpv4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IPeer.class));
    }

    /**
     * Any IPv6 address.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer anyIpv6() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Peer.class, "anyIpv6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IPeer.class));
    }

    /**
     * Create an IPv4 peer from a CIDR.
     * <p>
     * @param cidrIp This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer ipv4(final @org.jetbrains.annotations.NotNull java.lang.String cidrIp) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Peer.class, "ipv4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IPeer.class), new Object[] { java.util.Objects.requireNonNull(cidrIp, "cidrIp is required") });
    }

    /**
     * Create an IPv6 peer from a CIDR.
     * <p>
     * @param cidrIp This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer ipv6(final @org.jetbrains.annotations.NotNull java.lang.String cidrIp) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Peer.class, "ipv6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IPeer.class), new Object[] { java.util.Objects.requireNonNull(cidrIp, "cidrIp is required") });
    }

    /**
     * A prefix list.
     * <p>
     * @param prefixListId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer prefixList(final @org.jetbrains.annotations.NotNull java.lang.String prefixListId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Peer.class, "prefixList", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IPeer.class), new Object[] { java.util.Objects.requireNonNull(prefixListId, "prefixListId is required") });
    }
}
