package software.amazon.awscdk.services.ec2;

/**
 * Properties of the bastion host.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.1 (build f4a0dbe)", date = "2019-10-02T18:24:09.874Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface BastionHostLinuxProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * VPC to launch the instance in.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * In which AZ to place the instance within the VPC.
     * 
     * Default: - Random zone.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getAvailabilityZone();

    /**
     * The name of the instance.
     * 
     * Default: 'BastionHost'
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getInstanceName();

    /**
     * Type of instance to launch.
     * 
     * Default: 't3.nano'
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.ec2.InstanceType getInstanceType();

    /**
     * Security Group to assign to this instance.
     * 
     * Default: - create new security group with no inbound and all outbound traffic allowed
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup();

    /**
     * Select the subnets to run the bastion host in. Set this to PUBLIC if you need to connect to this instance via the internet and cannot use SSM. You have to allow port 22 manually by using the connections field.
     * 
     * Default: - private subnets of the supplied VPC
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection();

    /**
     * @return a {@link Builder} of {@link BastionHostLinuxProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BastionHostLinuxProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private software.amazon.awscdk.services.ec2.IVpc vpc;
        private java.lang.String availabilityZone;
        private java.lang.String instanceName;
        private software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;

        /**
         * Sets the value of Vpc
         * @param vpc VPC to launch the instance in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of AvailabilityZone
         * @param availabilityZone In which AZ to place the instance within the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of InstanceName
         * @param instanceName The name of the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceName(java.lang.String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        /**
         * Sets the value of InstanceType
         * @param instanceType Type of instance to launch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of SecurityGroup
         * @param securityGroup Security Group to assign to this instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of SubnetSelection
         * @param subnetSelection Select the subnets to run the bastion host in. Set this to PUBLIC if you need to connect to this instance via the internet and cannot use SSM. You have to allow port 22 manually by using the connections field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnetSelection(software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BastionHostLinuxProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public BastionHostLinuxProps build() {
            return new Jsii$Proxy(vpc, availabilityZone, instanceName, instanceType, securityGroup, subnetSelection);
        }
    }

    /**
     * An implementation for {@link BastionHostLinuxProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BastionHostLinuxProps {
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.String availabilityZone;
        private final java.lang.String instanceName;
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
            this.availabilityZone = this.jsiiGet("availabilityZone", java.lang.String.class);
            this.instanceName = this.jsiiGet("instanceName", java.lang.String.class);
            this.instanceType = this.jsiiGet("instanceType", software.amazon.awscdk.services.ec2.InstanceType.class);
            this.securityGroup = this.jsiiGet("securityGroup", software.amazon.awscdk.services.ec2.ISecurityGroup.class);
            this.subnetSelection = this.jsiiGet("subnetSelection", software.amazon.awscdk.services.ec2.SubnetSelection.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.services.ec2.IVpc vpc, java.lang.String availabilityZone, java.lang.String instanceName, software.amazon.awscdk.services.ec2.InstanceType instanceType, software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup, software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpc = java.util.Objects.requireNonNull(vpc, "vpc is required");
            this.availabilityZone = availabilityZone;
            this.instanceName = instanceName;
            this.instanceType = instanceType;
            this.securityGroup = securityGroup;
            this.subnetSelection = subnetSelection;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public java.lang.String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
            return this.subnetSelection;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getAvailabilityZone() != null) {
                obj.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getInstanceName() != null) {
                obj.set("instanceName", om.valueToTree(this.getInstanceName()));
            }
            if (this.getInstanceType() != null) {
                obj.set("instanceType", om.valueToTree(this.getInstanceType()));
            }
            if (this.getSecurityGroup() != null) {
                obj.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getSubnetSelection() != null) {
                obj.set("subnetSelection", om.valueToTree(this.getSubnetSelection()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BastionHostLinuxProps.Jsii$Proxy that = (BastionHostLinuxProps.Jsii$Proxy) o;

            if (!vpc.equals(that.vpc)) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.instanceName != null ? !this.instanceName.equals(that.instanceName) : that.instanceName != null) return false;
            if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            return this.subnetSelection != null ? this.subnetSelection.equals(that.subnetSelection) : that.subnetSelection == null;
        }

        @Override
        public int hashCode() {
            int result = this.vpc.hashCode();
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.instanceName != null ? this.instanceName.hashCode() : 0);
            result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.subnetSelection != null ? this.subnetSelection.hashCode() : 0);
            return result;
        }
    }
}
