package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::Host`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.1 (build f4a0dbe)", date = "2019-10-02T18:24:09.890Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnHostProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::Host.AvailabilityZone`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-availabilityzone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getAvailabilityZone();

    /**
     * `AWS::EC2::Host.InstanceType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-instancetype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getInstanceType();

    /**
     * `AWS::EC2::Host.AutoPlacement`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-autoplacement
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getAutoPlacement();

    /**
     * `AWS::EC2::Host.HostRecovery`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-hostrecovery
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getHostRecovery();

    /**
     * @return a {@link Builder} of {@link CfnHostProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnHostProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String availabilityZone;
        private java.lang.String instanceType;
        private java.lang.String autoPlacement;
        private java.lang.String hostRecovery;

        /**
         * Sets the value of AvailabilityZone
         * @param availabilityZone `AWS::EC2::Host.AvailabilityZone`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of InstanceType
         * @param instanceType `AWS::EC2::Host.InstanceType`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder instanceType(java.lang.String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of AutoPlacement
         * @param autoPlacement `AWS::EC2::Host.AutoPlacement`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder autoPlacement(java.lang.String autoPlacement) {
            this.autoPlacement = autoPlacement;
            return this;
        }

        /**
         * Sets the value of HostRecovery
         * @param hostRecovery `AWS::EC2::Host.HostRecovery`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder hostRecovery(java.lang.String hostRecovery) {
            this.hostRecovery = hostRecovery;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnHostProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnHostProps build() {
            return new Jsii$Proxy(availabilityZone, instanceType, autoPlacement, hostRecovery);
        }
    }

    /**
     * An implementation for {@link CfnHostProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnHostProps {
        private final java.lang.String availabilityZone;
        private final java.lang.String instanceType;
        private final java.lang.String autoPlacement;
        private final java.lang.String hostRecovery;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.availabilityZone = this.jsiiGet("availabilityZone", java.lang.String.class);
            this.instanceType = this.jsiiGet("instanceType", java.lang.String.class);
            this.autoPlacement = this.jsiiGet("autoPlacement", java.lang.String.class);
            this.hostRecovery = this.jsiiGet("hostRecovery", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String availabilityZone, java.lang.String instanceType, java.lang.String autoPlacement, java.lang.String hostRecovery) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.availabilityZone = java.util.Objects.requireNonNull(availabilityZone, "availabilityZone is required");
            this.instanceType = java.util.Objects.requireNonNull(instanceType, "instanceType is required");
            this.autoPlacement = autoPlacement;
            this.hostRecovery = hostRecovery;
        }

        @Override
        public java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public java.lang.String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public java.lang.String getAutoPlacement() {
            return this.autoPlacement;
        }

        @Override
        public java.lang.String getHostRecovery() {
            return this.hostRecovery;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            obj.set("instanceType", om.valueToTree(this.getInstanceType()));
            if (this.getAutoPlacement() != null) {
                obj.set("autoPlacement", om.valueToTree(this.getAutoPlacement()));
            }
            if (this.getHostRecovery() != null) {
                obj.set("hostRecovery", om.valueToTree(this.getHostRecovery()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnHostProps.Jsii$Proxy that = (CfnHostProps.Jsii$Proxy) o;

            if (!availabilityZone.equals(that.availabilityZone)) return false;
            if (!instanceType.equals(that.instanceType)) return false;
            if (this.autoPlacement != null ? !this.autoPlacement.equals(that.autoPlacement) : that.autoPlacement != null) return false;
            return this.hostRecovery != null ? this.hostRecovery.equals(that.hostRecovery) : that.hostRecovery == null;
        }

        @Override
        public int hashCode() {
            int result = this.availabilityZone.hashCode();
            result = 31 * result + (this.instanceType.hashCode());
            result = 31 * result + (this.autoPlacement != null ? this.autoPlacement.hashCode() : 0);
            result = 31 * result + (this.hostRecovery != null ? this.hostRecovery.hashCode() : 0);
            return result;
        }
    }
}
