package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::SubnetRouteTableAssociation`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.1 (build f4a0dbe)", date = "2019-10-02T18:24:09.961Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnSubnetRouteTableAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::SubnetRouteTableAssociation.RouteTableId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-routetableid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getRouteTableId();

    /**
     * `AWS::EC2::SubnetRouteTableAssociation.SubnetId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-subnetid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getSubnetId();

    /**
     * @return a {@link Builder} of {@link CfnSubnetRouteTableAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSubnetRouteTableAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String routeTableId;
        private java.lang.String subnetId;

        /**
         * Sets the value of RouteTableId
         * @param routeTableId `AWS::EC2::SubnetRouteTableAssociation.RouteTableId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder routeTableId(java.lang.String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        /**
         * Sets the value of SubnetId
         * @param subnetId `AWS::EC2::SubnetRouteTableAssociation.SubnetId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder subnetId(java.lang.String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSubnetRouteTableAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnSubnetRouteTableAssociationProps build() {
            return new Jsii$Proxy(routeTableId, subnetId);
        }
    }

    /**
     * An implementation for {@link CfnSubnetRouteTableAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSubnetRouteTableAssociationProps {
        private final java.lang.String routeTableId;
        private final java.lang.String subnetId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.routeTableId = this.jsiiGet("routeTableId", java.lang.String.class);
            this.subnetId = this.jsiiGet("subnetId", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String routeTableId, java.lang.String subnetId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.routeTableId = java.util.Objects.requireNonNull(routeTableId, "routeTableId is required");
            this.subnetId = java.util.Objects.requireNonNull(subnetId, "subnetId is required");
        }

        @Override
        public java.lang.String getRouteTableId() {
            return this.routeTableId;
        }

        @Override
        public java.lang.String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("routeTableId", om.valueToTree(this.getRouteTableId()));
            obj.set("subnetId", om.valueToTree(this.getSubnetId()));
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSubnetRouteTableAssociationProps.Jsii$Proxy that = (CfnSubnetRouteTableAssociationProps.Jsii$Proxy) o;

            if (!routeTableId.equals(that.routeTableId)) return false;
            return this.subnetId.equals(that.subnetId);
        }

        @Override
        public int hashCode() {
            int result = this.routeTableId.hashCode();
            result = 31 * result + (this.subnetId.hashCode());
            return result;
        }
    }
}
