package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::VPCEndpointServicePermissions`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.1 (build f4a0dbe)", date = "2019-10-02T18:24:09.966Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnVPCEndpointServicePermissionsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::VPCEndpointServicePermissions.ServiceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html#cfn-ec2-vpcendpointservicepermissions-serviceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getServiceId();

    /**
     * `AWS::EC2::VPCEndpointServicePermissions.AllowedPrincipals`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html#cfn-ec2-vpcendpointservicepermissions-allowedprincipals
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<java.lang.String> getAllowedPrincipals();

    /**
     * @return a {@link Builder} of {@link CfnVPCEndpointServicePermissionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVPCEndpointServicePermissionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String serviceId;
        private java.util.List<java.lang.String> allowedPrincipals;

        /**
         * Sets the value of ServiceId
         * @param serviceId `AWS::EC2::VPCEndpointServicePermissions.ServiceId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder serviceId(java.lang.String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        /**
         * Sets the value of AllowedPrincipals
         * @param allowedPrincipals `AWS::EC2::VPCEndpointServicePermissions.AllowedPrincipals`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder allowedPrincipals(java.util.List<java.lang.String> allowedPrincipals) {
            this.allowedPrincipals = allowedPrincipals;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVPCEndpointServicePermissionsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnVPCEndpointServicePermissionsProps build() {
            return new Jsii$Proxy(serviceId, allowedPrincipals);
        }
    }

    /**
     * An implementation for {@link CfnVPCEndpointServicePermissionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVPCEndpointServicePermissionsProps {
        private final java.lang.String serviceId;
        private final java.util.List<java.lang.String> allowedPrincipals;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.serviceId = this.jsiiGet("serviceId", java.lang.String.class);
            this.allowedPrincipals = this.jsiiGet("allowedPrincipals", java.util.List.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String serviceId, java.util.List<java.lang.String> allowedPrincipals) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.serviceId = java.util.Objects.requireNonNull(serviceId, "serviceId is required");
            this.allowedPrincipals = allowedPrincipals;
        }

        @Override
        public java.lang.String getServiceId() {
            return this.serviceId;
        }

        @Override
        public java.util.List<java.lang.String> getAllowedPrincipals() {
            return this.allowedPrincipals;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("serviceId", om.valueToTree(this.getServiceId()));
            if (this.getAllowedPrincipals() != null) {
                obj.set("allowedPrincipals", om.valueToTree(this.getAllowedPrincipals()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVPCEndpointServicePermissionsProps.Jsii$Proxy that = (CfnVPCEndpointServicePermissionsProps.Jsii$Proxy) o;

            if (!serviceId.equals(that.serviceId)) return false;
            return this.allowedPrincipals != null ? this.allowedPrincipals.equals(that.allowedPrincipals) : that.allowedPrincipals == null;
        }

        @Override
        public int hashCode() {
            int result = this.serviceId.hashCode();
            result = 31 * result + (this.allowedPrincipals != null ? this.allowedPrincipals.hashCode() : 0);
            return result;
        }
    }
}
