package software.amazon.awscdk.services.ec2;

/**
 * Specify configuration parameters for a single subnet group in a VPC.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.1 (build f4a0dbe)", date = "2019-10-02T18:24:10.001Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SubnetConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * Logical name for the subnet group.
     * 
     * This name can be used when selecting VPC subnets to distinguish
     * between different subnet groups of the same type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getName();

    /**
     * The type of Subnet to configure.
     * 
     * The Subnet type will control the ability to route and connect to the
     * Internet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.SubnetType getSubnetType();

    /**
     * The number of leading 1 bits in the routing mask.
     * 
     * The number of available IP addresses in each subnet of this group
     * will be equal to `2^(32 - cidrMask) - 2`.
     * 
     * Valid values are `16--28`.
     * 
     * Default: - Available IP space is evenly divided across subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getCidrMask();

    /**
     * Controls if subnet IP space needs to be reserved.
     * 
     * When true, the IP space for the subnet is reserved but no actual
     * resources are provisioned. This space is only dependent on the
     * number of availibility zones and on `cidrMask` - all other subnet
     * properties are ignored.
     * 
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getReserved();

    /**
     * @return a {@link Builder} of {@link SubnetConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SubnetConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String name;
        private software.amazon.awscdk.services.ec2.SubnetType subnetType;
        private java.lang.Number cidrMask;
        private java.lang.Boolean reserved;

        /**
         * Sets the value of Name
         * @param name Logical name for the subnet group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of SubnetType
         * @param subnetType The type of Subnet to configure. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetType(software.amazon.awscdk.services.ec2.SubnetType subnetType) {
            this.subnetType = subnetType;
            return this;
        }

        /**
         * Sets the value of CidrMask
         * @param cidrMask The number of leading 1 bits in the routing mask.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrMask(java.lang.Number cidrMask) {
            this.cidrMask = cidrMask;
            return this;
        }

        /**
         * Sets the value of Reserved
         * @param reserved Controls if subnet IP space needs to be reserved.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reserved(java.lang.Boolean reserved) {
            this.reserved = reserved;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SubnetConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public SubnetConfiguration build() {
            return new Jsii$Proxy(name, subnetType, cidrMask, reserved);
        }
    }

    /**
     * An implementation for {@link SubnetConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubnetConfiguration {
        private final java.lang.String name;
        private final software.amazon.awscdk.services.ec2.SubnetType subnetType;
        private final java.lang.Number cidrMask;
        private final java.lang.Boolean reserved;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.name = this.jsiiGet("name", java.lang.String.class);
            this.subnetType = this.jsiiGet("subnetType", software.amazon.awscdk.services.ec2.SubnetType.class);
            this.cidrMask = this.jsiiGet("cidrMask", java.lang.Number.class);
            this.reserved = this.jsiiGet("reserved", java.lang.Boolean.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String name, software.amazon.awscdk.services.ec2.SubnetType subnetType, java.lang.Number cidrMask, java.lang.Boolean reserved) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(name, "name is required");
            this.subnetType = java.util.Objects.requireNonNull(subnetType, "subnetType is required");
            this.cidrMask = cidrMask;
            this.reserved = reserved;
        }

        @Override
        public java.lang.String getName() {
            return this.name;
        }

        @Override
        public software.amazon.awscdk.services.ec2.SubnetType getSubnetType() {
            return this.subnetType;
        }

        @Override
        public java.lang.Number getCidrMask() {
            return this.cidrMask;
        }

        @Override
        public java.lang.Boolean getReserved() {
            return this.reserved;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("name", om.valueToTree(this.getName()));
            obj.set("subnetType", om.valueToTree(this.getSubnetType()));
            if (this.getCidrMask() != null) {
                obj.set("cidrMask", om.valueToTree(this.getCidrMask()));
            }
            if (this.getReserved() != null) {
                obj.set("reserved", om.valueToTree(this.getReserved()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SubnetConfiguration.Jsii$Proxy that = (SubnetConfiguration.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!subnetType.equals(that.subnetType)) return false;
            if (this.cidrMask != null ? !this.cidrMask.equals(that.cidrMask) : that.cidrMask != null) return false;
            return this.reserved != null ? this.reserved.equals(that.reserved) : that.reserved == null;
        }

        @Override
        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.subnetType.hashCode());
            result = 31 * result + (this.cidrMask != null ? this.cidrMask.hashCode() : 0);
            result = 31 * result + (this.reserved != null ? this.reserved.hashCode() : 0);
            return result;
        }
    }
}
