package software.amazon.awscdk.services.ec2;

/**
 * Options for attaching a CloudFormationInit to a resource.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-06-24T10:28:26.324Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.AttachInitOptions")
@software.amazon.jsii.Jsii.Proxy(AttachInitOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AttachInitOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Instance role of the consuming instance or fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getInstanceRole();

    /**
     * OS Platform the init config will be used for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.OperatingSystemType getPlatform();

    /**
     * UserData to add commands to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.UserData getUserData();

    /**
     * ConfigSet to activate.
     * <p>
     * Default: ['default']
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getConfigSets() {
        return null;
    }

    /**
     * Whether to embed a hash into the userData.
     * <p>
     * If <code>true</code> (the default), a hash of the config will be embedded into the
     * UserData, so that if the config changes, the UserData changes and
     * the instance will be replaced.
     * <p>
     * If <code>false</code>, no such hash will be embedded, and if the CloudFormation Init
     * config changes nothing will happen to the running instance.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEmbedFingerprint() {
        return null;
    }

    /**
     * Don't fail the instance creation when cfn-init fails.
     * <p>
     * You can use this to prevent CloudFormation from rolling back when
     * instances fail to start up, to help in debugging.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIgnoreFailures() {
        return null;
    }

    /**
     * Print the results of running cfn-init to the Instance System Log.
     * <p>
     * By default, the output of running cfn-init is written to a log file
     * on the instance. Set this to <code>true</code> to print it to the System Log
     * (visible from the EC2 Console), <code>false</code> to not print it.
     * <p>
     * (Be aware that the system log is refreshed at certain points in
     * time of the instance life cycle, and successful execution may
     * not always show up).
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPrintLog() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AttachInitOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AttachInitOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AttachInitOptions> {
        private software.amazon.awscdk.services.iam.IRole instanceRole;
        private software.amazon.awscdk.services.ec2.OperatingSystemType platform;
        private software.amazon.awscdk.services.ec2.UserData userData;
        private java.util.List<java.lang.String> configSets;
        private java.lang.Boolean embedFingerprint;
        private java.lang.Boolean ignoreFailures;
        private java.lang.Boolean printLog;

        /**
         * Sets the value of {@link AttachInitOptions#getInstanceRole}
         * @param instanceRole Instance role of the consuming instance or fleet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceRole(software.amazon.awscdk.services.iam.IRole instanceRole) {
            this.instanceRole = instanceRole;
            return this;
        }

        /**
         * Sets the value of {@link AttachInitOptions#getPlatform}
         * @param platform OS Platform the init config will be used for. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platform(software.amazon.awscdk.services.ec2.OperatingSystemType platform) {
            this.platform = platform;
            return this;
        }

        /**
         * Sets the value of {@link AttachInitOptions#getUserData}
         * @param userData UserData to add commands to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(software.amazon.awscdk.services.ec2.UserData userData) {
            this.userData = userData;
            return this;
        }

        /**
         * Sets the value of {@link AttachInitOptions#getConfigSets}
         * @param configSets ConfigSet to activate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configSets(java.util.List<java.lang.String> configSets) {
            this.configSets = configSets;
            return this;
        }

        /**
         * Sets the value of {@link AttachInitOptions#getEmbedFingerprint}
         * @param embedFingerprint Whether to embed a hash into the userData.
         *                         If <code>true</code> (the default), a hash of the config will be embedded into the
         *                         UserData, so that if the config changes, the UserData changes and
         *                         the instance will be replaced.
         *                         <p>
         *                         If <code>false</code>, no such hash will be embedded, and if the CloudFormation Init
         *                         config changes nothing will happen to the running instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder embedFingerprint(java.lang.Boolean embedFingerprint) {
            this.embedFingerprint = embedFingerprint;
            return this;
        }

        /**
         * Sets the value of {@link AttachInitOptions#getIgnoreFailures}
         * @param ignoreFailures Don't fail the instance creation when cfn-init fails.
         *                       You can use this to prevent CloudFormation from rolling back when
         *                       instances fail to start up, to help in debugging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreFailures(java.lang.Boolean ignoreFailures) {
            this.ignoreFailures = ignoreFailures;
            return this;
        }

        /**
         * Sets the value of {@link AttachInitOptions#getPrintLog}
         * @param printLog Print the results of running cfn-init to the Instance System Log.
         *                 By default, the output of running cfn-init is written to a log file
         *                 on the instance. Set this to <code>true</code> to print it to the System Log
         *                 (visible from the EC2 Console), <code>false</code> to not print it.
         *                 <p>
         *                 (Be aware that the system log is refreshed at certain points in
         *                 time of the instance life cycle, and successful execution may
         *                 not always show up).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder printLog(java.lang.Boolean printLog) {
            this.printLog = printLog;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AttachInitOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AttachInitOptions build() {
            return new Jsii$Proxy(instanceRole, platform, userData, configSets, embedFingerprint, ignoreFailures, printLog);
        }
    }

    /**
     * An implementation for {@link AttachInitOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AttachInitOptions {
        private final software.amazon.awscdk.services.iam.IRole instanceRole;
        private final software.amazon.awscdk.services.ec2.OperatingSystemType platform;
        private final software.amazon.awscdk.services.ec2.UserData userData;
        private final java.util.List<java.lang.String> configSets;
        private final java.lang.Boolean embedFingerprint;
        private final java.lang.Boolean ignoreFailures;
        private final java.lang.Boolean printLog;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceRole = software.amazon.jsii.Kernel.get(this, "instanceRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.platform = software.amazon.jsii.Kernel.get(this, "platform", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.OperatingSystemType.class));
            this.userData = software.amazon.jsii.Kernel.get(this, "userData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.UserData.class));
            this.configSets = software.amazon.jsii.Kernel.get(this, "configSets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.embedFingerprint = software.amazon.jsii.Kernel.get(this, "embedFingerprint", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ignoreFailures = software.amazon.jsii.Kernel.get(this, "ignoreFailures", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.printLog = software.amazon.jsii.Kernel.get(this, "printLog", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.iam.IRole instanceRole, final software.amazon.awscdk.services.ec2.OperatingSystemType platform, final software.amazon.awscdk.services.ec2.UserData userData, final java.util.List<java.lang.String> configSets, final java.lang.Boolean embedFingerprint, final java.lang.Boolean ignoreFailures, final java.lang.Boolean printLog) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceRole = java.util.Objects.requireNonNull(instanceRole, "instanceRole is required");
            this.platform = java.util.Objects.requireNonNull(platform, "platform is required");
            this.userData = java.util.Objects.requireNonNull(userData, "userData is required");
            this.configSets = configSets;
            this.embedFingerprint = embedFingerprint;
            this.ignoreFailures = ignoreFailures;
            this.printLog = printLog;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getInstanceRole() {
            return this.instanceRole;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.OperatingSystemType getPlatform() {
            return this.platform;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.UserData getUserData() {
            return this.userData;
        }

        @Override
        public final java.util.List<java.lang.String> getConfigSets() {
            return this.configSets;
        }

        @Override
        public final java.lang.Boolean getEmbedFingerprint() {
            return this.embedFingerprint;
        }

        @Override
        public final java.lang.Boolean getIgnoreFailures() {
            return this.ignoreFailures;
        }

        @Override
        public final java.lang.Boolean getPrintLog() {
            return this.printLog;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceRole", om.valueToTree(this.getInstanceRole()));
            data.set("platform", om.valueToTree(this.getPlatform()));
            data.set("userData", om.valueToTree(this.getUserData()));
            if (this.getConfigSets() != null) {
                data.set("configSets", om.valueToTree(this.getConfigSets()));
            }
            if (this.getEmbedFingerprint() != null) {
                data.set("embedFingerprint", om.valueToTree(this.getEmbedFingerprint()));
            }
            if (this.getIgnoreFailures() != null) {
                data.set("ignoreFailures", om.valueToTree(this.getIgnoreFailures()));
            }
            if (this.getPrintLog() != null) {
                data.set("printLog", om.valueToTree(this.getPrintLog()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.AttachInitOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AttachInitOptions.Jsii$Proxy that = (AttachInitOptions.Jsii$Proxy) o;

            if (!instanceRole.equals(that.instanceRole)) return false;
            if (!platform.equals(that.platform)) return false;
            if (!userData.equals(that.userData)) return false;
            if (this.configSets != null ? !this.configSets.equals(that.configSets) : that.configSets != null) return false;
            if (this.embedFingerprint != null ? !this.embedFingerprint.equals(that.embedFingerprint) : that.embedFingerprint != null) return false;
            if (this.ignoreFailures != null ? !this.ignoreFailures.equals(that.ignoreFailures) : that.ignoreFailures != null) return false;
            return this.printLog != null ? this.printLog.equals(that.printLog) : that.printLog == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceRole.hashCode();
            result = 31 * result + (this.platform.hashCode());
            result = 31 * result + (this.userData.hashCode());
            result = 31 * result + (this.configSets != null ? this.configSets.hashCode() : 0);
            result = 31 * result + (this.embedFingerprint != null ? this.embedFingerprint.hashCode() : 0);
            result = 31 * result + (this.ignoreFailures != null ? this.ignoreFailures.hashCode() : 0);
            result = 31 * result + (this.printLog != null ? this.printLog.hashCode() : 0);
            return result;
        }
    }
}
