package software.amazon.awscdk.services.ec2;

/**
 * Properties for a client VPN endpoint.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-06-24T10:28:26.427Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.ClientVpnEndpointProps")
@software.amazon.jsii.Jsii.Proxy(ClientVpnEndpointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ClientVpnEndpointProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.ClientVpnEndpointOptions {

    /**
     * The VPC to connect to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * @return a {@link Builder} of {@link ClientVpnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ClientVpnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ClientVpnEndpointProps> {
        private software.amazon.awscdk.services.ec2.IVpc vpc;
        private java.lang.String cidr;
        private java.lang.String serverCertificateArn;
        private java.lang.Boolean authorizeAllUsersToVpcCidr;
        private java.lang.String clientCertificateArn;
        private software.amazon.awscdk.services.ec2.IClientVpnConnectionHandler clientConnectionHandler;
        private java.lang.String description;
        private java.util.List<java.lang.String> dnsServers;
        private java.lang.Boolean logging;
        private software.amazon.awscdk.services.logs.ILogGroup logGroup;
        private software.amazon.awscdk.services.logs.ILogStream logStream;
        private software.amazon.awscdk.services.ec2.VpnPort port;
        private java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private java.lang.Boolean selfServicePortal;
        private java.lang.Boolean splitTunnel;
        private software.amazon.awscdk.services.ec2.TransportProtocol transportProtocol;
        private software.amazon.awscdk.services.ec2.ClientVpnUserBasedAuthentication userBasedAuthentication;
        private software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link ClientVpnEndpointProps#getVpc}
         * @param vpc The VPC to connect to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnEndpointProps#getCidr}
         * @param cidr The IPv4 address range, in CIDR notation, from which to assign client IP addresses. This parameter is required.
         *             The address range cannot overlap with the local CIDR of the VPC
         *             in which the associated subnet is located, or the routes that you add manually.
         *             <p>
         *             Changing the address range will replace the Client VPN endpoint.
         *             <p>
         *             The CIDR block should be /22 or greater.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidr(java.lang.String cidr) {
            this.cidr = cidr;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnEndpointProps#getServerCertificateArn}
         * @param serverCertificateArn The ARN of the server certificate. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverCertificateArn(java.lang.String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnEndpointProps#getAuthorizeAllUsersToVpcCidr}
         * @param authorizeAllUsersToVpcCidr Whether to authorize all users to the VPC CIDR.
         *                                   This automatically creates an authorization rule. Set this to <code>false</code> and
         *                                   use <code>addAuthorizationRule()</code> to create your own rules instead.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizeAllUsersToVpcCidr(java.lang.Boolean authorizeAllUsersToVpcCidr) {
            this.authorizeAllUsersToVpcCidr = authorizeAllUsersToVpcCidr;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnEndpointProps#getClientCertificateArn}
         * @param clientCertificateArn The ARN of the client certificate for mutual authentication.
         *                             The certificate must be signed by a certificate authority (CA) and it must
         *                             be provisioned in AWS Certificate Manager (ACM).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientCertificateArn(java.lang.String clientCertificateArn) {
            this.clientCertificateArn = clientCertificateArn;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnEndpointProps#getClientConnectionHandler}
         * @param clientConnectionHandler The AWS Lambda function used for connection authorization.
         *                                The name of the Lambda function must begin with the <code>AWSClientVPN-</code> prefix
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientConnectionHandler(software.amazon.awscdk.services.ec2.IClientVpnConnectionHandler clientConnectionHandler) {
            this.clientConnectionHandler = clientConnectionHandler;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnEndpointProps#getDescription}
         * @param description A brief description of the Client VPN endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnEndpointProps#getDnsServers}
         * @param dnsServers Information about the DNS servers to be used for DNS resolution.
         *                   A Client VPN endpoint can have up to two DNS servers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsServers(java.util.List<java.lang.String> dnsServers) {
            this.dnsServers = dnsServers;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnEndpointProps#getLogging}
         * @param logging Whether to enable connections logging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(java.lang.Boolean logging) {
            this.logging = logging;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnEndpointProps#getLogGroup}
         * @param logGroup A CloudWatch Logs log group for connection logging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroup(software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnEndpointProps#getLogStream}
         * @param logStream A CloudWatch Logs log stream for connection logging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logStream(software.amazon.awscdk.services.logs.ILogStream logStream) {
            this.logStream = logStream;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnEndpointProps#getPort}
         * @param port The port number to assign to the Client VPN endpoint for TCP and UDP traffic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(software.amazon.awscdk.services.ec2.VpnPort port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnEndpointProps#getSecurityGroups}
         * @param securityGroups The security groups to apply to the target network.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnEndpointProps#getSelfServicePortal}
         * @param selfServicePortal Specify whether to enable the self-service portal for the Client VPN endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfServicePortal(java.lang.Boolean selfServicePortal) {
            this.selfServicePortal = selfServicePortal;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnEndpointProps#getSplitTunnel}
         * @param splitTunnel Indicates whether split-tunnel is enabled on the AWS Client VPN endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder splitTunnel(java.lang.Boolean splitTunnel) {
            this.splitTunnel = splitTunnel;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnEndpointProps#getTransportProtocol}
         * @param transportProtocol The transport protocol to be used by the VPN session.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transportProtocol(software.amazon.awscdk.services.ec2.TransportProtocol transportProtocol) {
            this.transportProtocol = transportProtocol;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnEndpointProps#getUserBasedAuthentication}
         * @param userBasedAuthentication The type of user-based authentication to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userBasedAuthentication(software.amazon.awscdk.services.ec2.ClientVpnUserBasedAuthentication userBasedAuthentication) {
            this.userBasedAuthentication = userBasedAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnEndpointProps#getVpcSubnets}
         * @param vpcSubnets Subnets to associate to the client VPN endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClientVpnEndpointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ClientVpnEndpointProps build() {
            return new Jsii$Proxy(vpc, cidr, serverCertificateArn, authorizeAllUsersToVpcCidr, clientCertificateArn, clientConnectionHandler, description, dnsServers, logging, logGroup, logStream, port, securityGroups, selfServicePortal, splitTunnel, transportProtocol, userBasedAuthentication, vpcSubnets);
        }
    }

    /**
     * An implementation for {@link ClientVpnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClientVpnEndpointProps {
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.String cidr;
        private final java.lang.String serverCertificateArn;
        private final java.lang.Boolean authorizeAllUsersToVpcCidr;
        private final java.lang.String clientCertificateArn;
        private final software.amazon.awscdk.services.ec2.IClientVpnConnectionHandler clientConnectionHandler;
        private final java.lang.String description;
        private final java.util.List<java.lang.String> dnsServers;
        private final java.lang.Boolean logging;
        private final software.amazon.awscdk.services.logs.ILogGroup logGroup;
        private final software.amazon.awscdk.services.logs.ILogStream logStream;
        private final software.amazon.awscdk.services.ec2.VpnPort port;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final java.lang.Boolean selfServicePortal;
        private final java.lang.Boolean splitTunnel;
        private final software.amazon.awscdk.services.ec2.TransportProtocol transportProtocol;
        private final software.amazon.awscdk.services.ec2.ClientVpnUserBasedAuthentication userBasedAuthentication;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.cidr = software.amazon.jsii.Kernel.get(this, "cidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serverCertificateArn = software.amazon.jsii.Kernel.get(this, "serverCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizeAllUsersToVpcCidr = software.amazon.jsii.Kernel.get(this, "authorizeAllUsersToVpcCidr", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.clientCertificateArn = software.amazon.jsii.Kernel.get(this, "clientCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clientConnectionHandler = software.amazon.jsii.Kernel.get(this, "clientConnectionHandler", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IClientVpnConnectionHandler.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dnsServers = software.amazon.jsii.Kernel.get(this, "dnsServers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.logGroup = software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
            this.logStream = software.amazon.jsii.Kernel.get(this, "logStream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogStream.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.VpnPort.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.selfServicePortal = software.amazon.jsii.Kernel.get(this, "selfServicePortal", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.splitTunnel = software.amazon.jsii.Kernel.get(this, "splitTunnel", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.transportProtocol = software.amazon.jsii.Kernel.get(this, "transportProtocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.TransportProtocol.class));
            this.userBasedAuthentication = software.amazon.jsii.Kernel.get(this, "userBasedAuthentication", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ClientVpnUserBasedAuthentication.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final software.amazon.awscdk.services.ec2.IVpc vpc, final java.lang.String cidr, final java.lang.String serverCertificateArn, final java.lang.Boolean authorizeAllUsersToVpcCidr, final java.lang.String clientCertificateArn, final software.amazon.awscdk.services.ec2.IClientVpnConnectionHandler clientConnectionHandler, final java.lang.String description, final java.util.List<java.lang.String> dnsServers, final java.lang.Boolean logging, final software.amazon.awscdk.services.logs.ILogGroup logGroup, final software.amazon.awscdk.services.logs.ILogStream logStream, final software.amazon.awscdk.services.ec2.VpnPort port, final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups, final java.lang.Boolean selfServicePortal, final java.lang.Boolean splitTunnel, final software.amazon.awscdk.services.ec2.TransportProtocol transportProtocol, final software.amazon.awscdk.services.ec2.ClientVpnUserBasedAuthentication userBasedAuthentication, final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpc = java.util.Objects.requireNonNull(vpc, "vpc is required");
            this.cidr = java.util.Objects.requireNonNull(cidr, "cidr is required");
            this.serverCertificateArn = java.util.Objects.requireNonNull(serverCertificateArn, "serverCertificateArn is required");
            this.authorizeAllUsersToVpcCidr = authorizeAllUsersToVpcCidr;
            this.clientCertificateArn = clientCertificateArn;
            this.clientConnectionHandler = clientConnectionHandler;
            this.description = description;
            this.dnsServers = dnsServers;
            this.logging = logging;
            this.logGroup = logGroup;
            this.logStream = logStream;
            this.port = port;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            this.selfServicePortal = selfServicePortal;
            this.splitTunnel = splitTunnel;
            this.transportProtocol = transportProtocol;
            this.userBasedAuthentication = userBasedAuthentication;
            this.vpcSubnets = vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final java.lang.String getCidr() {
            return this.cidr;
        }

        @Override
        public final java.lang.String getServerCertificateArn() {
            return this.serverCertificateArn;
        }

        @Override
        public final java.lang.Boolean getAuthorizeAllUsersToVpcCidr() {
            return this.authorizeAllUsersToVpcCidr;
        }

        @Override
        public final java.lang.String getClientCertificateArn() {
            return this.clientCertificateArn;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IClientVpnConnectionHandler getClientConnectionHandler() {
            return this.clientConnectionHandler;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<java.lang.String> getDnsServers() {
            return this.dnsServers;
        }

        @Override
        public final java.lang.Boolean getLogging() {
            return this.logging;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
            return this.logGroup;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogStream getLogStream() {
            return this.logStream;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.VpnPort getPort() {
            return this.port;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final java.lang.Boolean getSelfServicePortal() {
            return this.selfServicePortal;
        }

        @Override
        public final java.lang.Boolean getSplitTunnel() {
            return this.splitTunnel;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.TransportProtocol getTransportProtocol() {
            return this.transportProtocol;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ClientVpnUserBasedAuthentication getUserBasedAuthentication() {
            return this.userBasedAuthentication;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpc", om.valueToTree(this.getVpc()));
            data.set("cidr", om.valueToTree(this.getCidr()));
            data.set("serverCertificateArn", om.valueToTree(this.getServerCertificateArn()));
            if (this.getAuthorizeAllUsersToVpcCidr() != null) {
                data.set("authorizeAllUsersToVpcCidr", om.valueToTree(this.getAuthorizeAllUsersToVpcCidr()));
            }
            if (this.getClientCertificateArn() != null) {
                data.set("clientCertificateArn", om.valueToTree(this.getClientCertificateArn()));
            }
            if (this.getClientConnectionHandler() != null) {
                data.set("clientConnectionHandler", om.valueToTree(this.getClientConnectionHandler()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDnsServers() != null) {
                data.set("dnsServers", om.valueToTree(this.getDnsServers()));
            }
            if (this.getLogging() != null) {
                data.set("logging", om.valueToTree(this.getLogging()));
            }
            if (this.getLogGroup() != null) {
                data.set("logGroup", om.valueToTree(this.getLogGroup()));
            }
            if (this.getLogStream() != null) {
                data.set("logStream", om.valueToTree(this.getLogStream()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSelfServicePortal() != null) {
                data.set("selfServicePortal", om.valueToTree(this.getSelfServicePortal()));
            }
            if (this.getSplitTunnel() != null) {
                data.set("splitTunnel", om.valueToTree(this.getSplitTunnel()));
            }
            if (this.getTransportProtocol() != null) {
                data.set("transportProtocol", om.valueToTree(this.getTransportProtocol()));
            }
            if (this.getUserBasedAuthentication() != null) {
                data.set("userBasedAuthentication", om.valueToTree(this.getUserBasedAuthentication()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.ClientVpnEndpointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ClientVpnEndpointProps.Jsii$Proxy that = (ClientVpnEndpointProps.Jsii$Proxy) o;

            if (!vpc.equals(that.vpc)) return false;
            if (!cidr.equals(that.cidr)) return false;
            if (!serverCertificateArn.equals(that.serverCertificateArn)) return false;
            if (this.authorizeAllUsersToVpcCidr != null ? !this.authorizeAllUsersToVpcCidr.equals(that.authorizeAllUsersToVpcCidr) : that.authorizeAllUsersToVpcCidr != null) return false;
            if (this.clientCertificateArn != null ? !this.clientCertificateArn.equals(that.clientCertificateArn) : that.clientCertificateArn != null) return false;
            if (this.clientConnectionHandler != null ? !this.clientConnectionHandler.equals(that.clientConnectionHandler) : that.clientConnectionHandler != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.dnsServers != null ? !this.dnsServers.equals(that.dnsServers) : that.dnsServers != null) return false;
            if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) return false;
            if (this.logGroup != null ? !this.logGroup.equals(that.logGroup) : that.logGroup != null) return false;
            if (this.logStream != null ? !this.logStream.equals(that.logStream) : that.logStream != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.selfServicePortal != null ? !this.selfServicePortal.equals(that.selfServicePortal) : that.selfServicePortal != null) return false;
            if (this.splitTunnel != null ? !this.splitTunnel.equals(that.splitTunnel) : that.splitTunnel != null) return false;
            if (this.transportProtocol != null ? !this.transportProtocol.equals(that.transportProtocol) : that.transportProtocol != null) return false;
            if (this.userBasedAuthentication != null ? !this.userBasedAuthentication.equals(that.userBasedAuthentication) : that.userBasedAuthentication != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.vpc.hashCode();
            result = 31 * result + (this.cidr.hashCode());
            result = 31 * result + (this.serverCertificateArn.hashCode());
            result = 31 * result + (this.authorizeAllUsersToVpcCidr != null ? this.authorizeAllUsersToVpcCidr.hashCode() : 0);
            result = 31 * result + (this.clientCertificateArn != null ? this.clientCertificateArn.hashCode() : 0);
            result = 31 * result + (this.clientConnectionHandler != null ? this.clientConnectionHandler.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.dnsServers != null ? this.dnsServers.hashCode() : 0);
            result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
            result = 31 * result + (this.logGroup != null ? this.logGroup.hashCode() : 0);
            result = 31 * result + (this.logStream != null ? this.logStream.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.selfServicePortal != null ? this.selfServicePortal.hashCode() : 0);
            result = 31 * result + (this.splitTunnel != null ? this.splitTunnel.hashCode() : 0);
            result = 31 * result + (this.transportProtocol != null ? this.transportProtocol.hashCode() : 0);
            result = 31 * result + (this.userBasedAuthentication != null ? this.userBasedAuthentication.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
