package software.amazon.awscdk.services.ec2;

/**
 * The type of Subnet.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-06-24T10:28:26.511Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.SubnetType")
public enum SubnetType {
    /**
     * Isolated Subnets do not route traffic to the Internet (in this VPC).
     * <p>
     * This can be good for subnets with RDS or Elasticache instances,
     * or which route Internet traffic through a peer VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ISOLATED,
    /**
     * Subnet that routes to the internet, but not vice versa.
     * <p>
     * Instances in a private subnet can connect to the Internet, but will not
     * allow connections to be initiated from the Internet. Internet traffic will
     * be routed via a NAT Gateway.
     * <p>
     * Normally a Private subnet will use a NAT gateway in the same AZ, but
     * if <code>natGateways</code> is used to reduce the number of NAT gateways, a NAT
     * gateway from another AZ will be used instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PRIVATE,
    /**
     * Subnet connected to the Internet.
     * <p>
     * Instances in a Public subnet can connect to the Internet and can be
     * connected to from the Internet as long as they are launched with public
     * IPs (controlled on the AutoScalingGroup or other constructs that launch
     * instances).
     * <p>
     * Public subnets route outbound traffic via an Internet Gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PUBLIC,
}
