/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.ec2.;
import software.amazon.awscdk.services.ec2.CfnLaunchTemplate;
import software.amazon.awscdk.services.ec2.CfnLaunchTemplateProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate")
public class CfnLaunchTemplate
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnLaunchTemplate.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnLaunchTemplate(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLaunchTemplate(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnLaunchTemplate(@NotNull Construct scope, @NotNull String id, @Nullable CfnLaunchTemplateProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnLaunchTemplate(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrDefaultVersionNumber() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrDefaultVersionNumber", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrLatestVersionNumber() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrLatestVersionNumber", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Nullable
    public Object getLaunchTemplateData() {
        return Kernel.get((Object)((Object)this), (String)"launchTemplateData", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLaunchTemplateData(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"launchTemplateData", (Object)value);
    }

    public void setLaunchTemplateData(@Nullable LaunchTemplateDataProperty value) {
        Kernel.set((Object)((Object)this), (String)"launchTemplateData", (Object)value);
    }

    @Nullable
    public String getLaunchTemplateName() {
        return (String)Kernel.get((Object)((Object)this), (String)"launchTemplateName", (NativeType)NativeType.forClass(String.class));
    }

    public void setLaunchTemplateName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"launchTemplateName", (Object)value);
    }

    @Nullable
    public Object getTagSpecifications() {
        return Kernel.get((Object)((Object)this), (String)"tagSpecifications", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTagSpecifications(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"tagSpecifications", (Object)value);
    }

    public void setTagSpecifications(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"tagSpecifications", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnLaunchTemplate> {
        private final Construct scope;
        private final String id;
        private CfnLaunchTemplateProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder launchTemplateData(IResolvable launchTemplateData) {
            this.props().launchTemplateData(launchTemplateData);
            return this;
        }

        public Builder launchTemplateData(LaunchTemplateDataProperty launchTemplateData) {
            this.props().launchTemplateData(launchTemplateData);
            return this;
        }

        public Builder launchTemplateName(String launchTemplateName) {
            this.props().launchTemplateName(launchTemplateName);
            return this;
        }

        public Builder tagSpecifications(IResolvable tagSpecifications) {
            this.props().tagSpecifications(tagSpecifications);
            return this;
        }

        public Builder tagSpecifications(List<? extends Object> tagSpecifications) {
            this.props().tagSpecifications(tagSpecifications);
            return this;
        }

        public CfnLaunchTemplate build() {
            return new CfnLaunchTemplate(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnLaunchTemplateProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnLaunchTemplateProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate.TagSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TagSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getResourceType() {
            return null;
        }

        @Nullable
        default public List<CfnTag> getTags() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TagSpecificationProperty> {
            private String resourceType;
            private List<CfnTag> tags;

            public Builder resourceType(String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            public Builder tags(List<? extends CfnTag> tags) {
                this.tags = tags;
                return this;
            }

            public TagSpecificationProperty build() {
                return new Jsii.Proxy(this.resourceType, this.tags);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate.SpotOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SpotOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getBlockDurationMinutes() {
            return null;
        }

        @Nullable
        default public String getInstanceInterruptionBehavior() {
            return null;
        }

        @Nullable
        default public String getMaxPrice() {
            return null;
        }

        @Nullable
        default public String getSpotInstanceType() {
            return null;
        }

        @Nullable
        default public String getValidUntil() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SpotOptionsProperty> {
            private Number blockDurationMinutes;
            private String instanceInterruptionBehavior;
            private String maxPrice;
            private String spotInstanceType;
            private String validUntil;

            public Builder blockDurationMinutes(Number blockDurationMinutes) {
                this.blockDurationMinutes = blockDurationMinutes;
                return this;
            }

            public Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
                this.instanceInterruptionBehavior = instanceInterruptionBehavior;
                return this;
            }

            public Builder maxPrice(String maxPrice) {
                this.maxPrice = maxPrice;
                return this;
            }

            public Builder spotInstanceType(String spotInstanceType) {
                this.spotInstanceType = spotInstanceType;
                return this;
            }

            public Builder validUntil(String validUntil) {
                this.validUntil = validUntil;
                return this;
            }

            public SpotOptionsProperty build() {
                return new Jsii.Proxy(this.blockDurationMinutes, this.instanceInterruptionBehavior, this.maxPrice, this.spotInstanceType, this.validUntil);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate.PrivateIpAddProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PrivateIpAddProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPrimary() {
            return null;
        }

        @Nullable
        default public String getPrivateIpAddress() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PrivateIpAddProperty> {
            private Object primary;
            private String privateIpAddress;

            public Builder primary(Boolean primary) {
                this.primary = primary;
                return this;
            }

            public Builder primary(IResolvable primary) {
                this.primary = primary;
                return this;
            }

            public Builder privateIpAddress(String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            public PrivateIpAddProperty build() {
                return new Jsii.Proxy(this.primary, this.privateIpAddress);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate.PlacementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PlacementProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAffinity() {
            return null;
        }

        @Nullable
        default public String getAvailabilityZone() {
            return null;
        }

        @Nullable
        default public String getGroupName() {
            return null;
        }

        @Nullable
        default public String getHostId() {
            return null;
        }

        @Nullable
        default public String getHostResourceGroupArn() {
            return null;
        }

        @Nullable
        default public Number getPartitionNumber() {
            return null;
        }

        @Nullable
        default public String getSpreadDomain() {
            return null;
        }

        @Nullable
        default public String getTenancy() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PlacementProperty> {
            private String affinity;
            private String availabilityZone;
            private String groupName;
            private String hostId;
            private String hostResourceGroupArn;
            private Number partitionNumber;
            private String spreadDomain;
            private String tenancy;

            public Builder affinity(String affinity) {
                this.affinity = affinity;
                return this;
            }

            public Builder availabilityZone(String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            public Builder groupName(String groupName) {
                this.groupName = groupName;
                return this;
            }

            public Builder hostId(String hostId) {
                this.hostId = hostId;
                return this;
            }

            public Builder hostResourceGroupArn(String hostResourceGroupArn) {
                this.hostResourceGroupArn = hostResourceGroupArn;
                return this;
            }

            public Builder partitionNumber(Number partitionNumber) {
                this.partitionNumber = partitionNumber;
                return this;
            }

            public Builder spreadDomain(String spreadDomain) {
                this.spreadDomain = spreadDomain;
                return this;
            }

            public Builder tenancy(String tenancy) {
                this.tenancy = tenancy;
                return this;
            }

            public PlacementProperty build() {
                return new Jsii.Proxy(this.affinity, this.availabilityZone, this.groupName, this.hostId, this.hostResourceGroupArn, this.partitionNumber, this.spreadDomain, this.tenancy);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate.NetworkInterfaceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkInterfaceProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAssociateCarrierIpAddress() {
            return null;
        }

        @Nullable
        default public Object getAssociatePublicIpAddress() {
            return null;
        }

        @Nullable
        default public Object getDeleteOnTermination() {
            return null;
        }

        @Nullable
        default public String getDescription() {
            return null;
        }

        @Nullable
        default public Number getDeviceIndex() {
            return null;
        }

        @Nullable
        default public List<String> getGroups() {
            return null;
        }

        @Nullable
        default public String getInterfaceType() {
            return null;
        }

        @Nullable
        default public Number getIpv6AddressCount() {
            return null;
        }

        @Nullable
        default public Object getIpv6Addresses() {
            return null;
        }

        @Nullable
        default public Number getNetworkCardIndex() {
            return null;
        }

        @Nullable
        default public String getNetworkInterfaceId() {
            return null;
        }

        @Nullable
        default public String getPrivateIpAddress() {
            return null;
        }

        @Nullable
        default public Object getPrivateIpAddresses() {
            return null;
        }

        @Nullable
        default public Number getSecondaryPrivateIpAddressCount() {
            return null;
        }

        @Nullable
        default public String getSubnetId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NetworkInterfaceProperty> {
            private Object associateCarrierIpAddress;
            private Object associatePublicIpAddress;
            private Object deleteOnTermination;
            private String description;
            private Number deviceIndex;
            private List<String> groups;
            private String interfaceType;
            private Number ipv6AddressCount;
            private Object ipv6Addresses;
            private Number networkCardIndex;
            private String networkInterfaceId;
            private String privateIpAddress;
            private Object privateIpAddresses;
            private Number secondaryPrivateIpAddressCount;
            private String subnetId;

            public Builder associateCarrierIpAddress(Boolean associateCarrierIpAddress) {
                this.associateCarrierIpAddress = associateCarrierIpAddress;
                return this;
            }

            public Builder associateCarrierIpAddress(IResolvable associateCarrierIpAddress) {
                this.associateCarrierIpAddress = associateCarrierIpAddress;
                return this;
            }

            public Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            public Builder associatePublicIpAddress(IResolvable associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            public Builder deleteOnTermination(Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder deleteOnTermination(IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder deviceIndex(Number deviceIndex) {
                this.deviceIndex = deviceIndex;
                return this;
            }

            public Builder groups(List<String> groups) {
                this.groups = groups;
                return this;
            }

            public Builder interfaceType(String interfaceType) {
                this.interfaceType = interfaceType;
                return this;
            }

            public Builder ipv6AddressCount(Number ipv6AddressCount) {
                this.ipv6AddressCount = ipv6AddressCount;
                return this;
            }

            public Builder ipv6Addresses(IResolvable ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            public Builder ipv6Addresses(List<? extends Object> ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            public Builder networkCardIndex(Number networkCardIndex) {
                this.networkCardIndex = networkCardIndex;
                return this;
            }

            public Builder networkInterfaceId(String networkInterfaceId) {
                this.networkInterfaceId = networkInterfaceId;
                return this;
            }

            public Builder privateIpAddress(String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            public Builder privateIpAddresses(IResolvable privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            public Builder privateIpAddresses(List<? extends Object> privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            public Builder secondaryPrivateIpAddressCount(Number secondaryPrivateIpAddressCount) {
                this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
                return this;
            }

            public Builder subnetId(String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            public NetworkInterfaceProperty build() {
                return new Jsii.Proxy(this.associateCarrierIpAddress, this.associatePublicIpAddress, this.deleteOnTermination, this.description, this.deviceIndex, this.groups, this.interfaceType, this.ipv6AddressCount, this.ipv6Addresses, this.networkCardIndex, this.networkInterfaceId, this.privateIpAddress, this.privateIpAddresses, this.secondaryPrivateIpAddressCount, this.subnetId);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate.MonitoringProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MonitoringProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MonitoringProperty> {
            private Object enabled;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public MonitoringProperty build() {
                return new Jsii.Proxy(this.enabled);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate.MetadataOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetadataOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getHttpEndpoint() {
            return null;
        }

        @Nullable
        default public Number getHttpPutResponseHopLimit() {
            return null;
        }

        @Nullable
        default public String getHttpTokens() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetadataOptionsProperty> {
            private String httpEndpoint;
            private Number httpPutResponseHopLimit;
            private String httpTokens;

            public Builder httpEndpoint(String httpEndpoint) {
                this.httpEndpoint = httpEndpoint;
                return this;
            }

            public Builder httpPutResponseHopLimit(Number httpPutResponseHopLimit) {
                this.httpPutResponseHopLimit = httpPutResponseHopLimit;
                return this;
            }

            public Builder httpTokens(String httpTokens) {
                this.httpTokens = httpTokens;
                return this;
            }

            public MetadataOptionsProperty build() {
                return new Jsii.Proxy(this.httpEndpoint, this.httpPutResponseHopLimit, this.httpTokens);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate.LicenseSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LicenseSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLicenseConfigurationArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LicenseSpecificationProperty> {
            private String licenseConfigurationArn;

            public Builder licenseConfigurationArn(String licenseConfigurationArn) {
                this.licenseConfigurationArn = licenseConfigurationArn;
                return this;
            }

            public LicenseSpecificationProperty build() {
                return new Jsii.Proxy(this.licenseConfigurationArn);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate.LaunchTemplateTagSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LaunchTemplateTagSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getResourceType() {
            return null;
        }

        @Nullable
        default public List<CfnTag> getTags() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LaunchTemplateTagSpecificationProperty> {
            private String resourceType;
            private List<CfnTag> tags;

            public Builder resourceType(String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            public Builder tags(List<? extends CfnTag> tags) {
                this.tags = tags;
                return this;
            }

            public LaunchTemplateTagSpecificationProperty build() {
                return new Jsii.Proxy(this.resourceType, this.tags);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LaunchTemplateElasticInferenceAcceleratorProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getCount() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LaunchTemplateElasticInferenceAcceleratorProperty> {
            private Number count;
            private String type;

            public Builder count(Number count) {
                this.count = count;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public LaunchTemplateElasticInferenceAcceleratorProperty build() {
                return new Jsii.Proxy(this.count, this.type);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate.LaunchTemplateDataProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LaunchTemplateDataProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBlockDeviceMappings() {
            return null;
        }

        @Nullable
        default public Object getCapacityReservationSpecification() {
            return null;
        }

        @Nullable
        default public Object getCpuOptions() {
            return null;
        }

        @Nullable
        default public Object getCreditSpecification() {
            return null;
        }

        @Nullable
        default public Object getDisableApiTermination() {
            return null;
        }

        @Nullable
        default public Object getEbsOptimized() {
            return null;
        }

        @Nullable
        default public Object getElasticGpuSpecifications() {
            return null;
        }

        @Nullable
        default public Object getElasticInferenceAccelerators() {
            return null;
        }

        @Nullable
        default public Object getEnclaveOptions() {
            return null;
        }

        @Nullable
        default public Object getHibernationOptions() {
            return null;
        }

        @Nullable
        default public Object getIamInstanceProfile() {
            return null;
        }

        @Nullable
        default public String getImageId() {
            return null;
        }

        @Nullable
        default public String getInstanceInitiatedShutdownBehavior() {
            return null;
        }

        @Nullable
        default public Object getInstanceMarketOptions() {
            return null;
        }

        @Nullable
        default public String getInstanceType() {
            return null;
        }

        @Nullable
        default public String getKernelId() {
            return null;
        }

        @Nullable
        default public String getKeyName() {
            return null;
        }

        @Nullable
        default public Object getLicenseSpecifications() {
            return null;
        }

        @Nullable
        default public Object getMetadataOptions() {
            return null;
        }

        @Nullable
        default public Object getMonitoring() {
            return null;
        }

        @Nullable
        default public Object getNetworkInterfaces() {
            return null;
        }

        @Nullable
        default public Object getPlacement() {
            return null;
        }

        @Nullable
        default public String getRamDiskId() {
            return null;
        }

        @Nullable
        default public List<String> getSecurityGroupIds() {
            return null;
        }

        @Nullable
        default public List<String> getSecurityGroups() {
            return null;
        }

        @Nullable
        default public Object getTagSpecifications() {
            return null;
        }

        @Nullable
        default public String getUserData() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LaunchTemplateDataProperty> {
            private Object blockDeviceMappings;
            private Object capacityReservationSpecification;
            private Object cpuOptions;
            private Object creditSpecification;
            private Object disableApiTermination;
            private Object ebsOptimized;
            private Object elasticGpuSpecifications;
            private Object elasticInferenceAccelerators;
            private Object enclaveOptions;
            private Object hibernationOptions;
            private Object iamInstanceProfile;
            private String imageId;
            private String instanceInitiatedShutdownBehavior;
            private Object instanceMarketOptions;
            private String instanceType;
            private String kernelId;
            private String keyName;
            private Object licenseSpecifications;
            private Object metadataOptions;
            private Object monitoring;
            private Object networkInterfaces;
            private Object placement;
            private String ramDiskId;
            private List<String> securityGroupIds;
            private List<String> securityGroups;
            private Object tagSpecifications;
            private String userData;

            public Builder blockDeviceMappings(IResolvable blockDeviceMappings) {
                this.blockDeviceMappings = blockDeviceMappings;
                return this;
            }

            public Builder blockDeviceMappings(List<? extends Object> blockDeviceMappings) {
                this.blockDeviceMappings = blockDeviceMappings;
                return this;
            }

            public Builder capacityReservationSpecification(IResolvable capacityReservationSpecification) {
                this.capacityReservationSpecification = capacityReservationSpecification;
                return this;
            }

            public Builder capacityReservationSpecification(CapacityReservationSpecificationProperty capacityReservationSpecification) {
                this.capacityReservationSpecification = capacityReservationSpecification;
                return this;
            }

            public Builder cpuOptions(IResolvable cpuOptions) {
                this.cpuOptions = cpuOptions;
                return this;
            }

            public Builder cpuOptions(CpuOptionsProperty cpuOptions) {
                this.cpuOptions = cpuOptions;
                return this;
            }

            public Builder creditSpecification(IResolvable creditSpecification) {
                this.creditSpecification = creditSpecification;
                return this;
            }

            public Builder creditSpecification(CreditSpecificationProperty creditSpecification) {
                this.creditSpecification = creditSpecification;
                return this;
            }

            public Builder disableApiTermination(Boolean disableApiTermination) {
                this.disableApiTermination = disableApiTermination;
                return this;
            }

            public Builder disableApiTermination(IResolvable disableApiTermination) {
                this.disableApiTermination = disableApiTermination;
                return this;
            }

            public Builder ebsOptimized(Boolean ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            public Builder ebsOptimized(IResolvable ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            public Builder elasticGpuSpecifications(IResolvable elasticGpuSpecifications) {
                this.elasticGpuSpecifications = elasticGpuSpecifications;
                return this;
            }

            public Builder elasticGpuSpecifications(List<? extends Object> elasticGpuSpecifications) {
                this.elasticGpuSpecifications = elasticGpuSpecifications;
                return this;
            }

            public Builder elasticInferenceAccelerators(IResolvable elasticInferenceAccelerators) {
                this.elasticInferenceAccelerators = elasticInferenceAccelerators;
                return this;
            }

            public Builder elasticInferenceAccelerators(List<? extends Object> elasticInferenceAccelerators) {
                this.elasticInferenceAccelerators = elasticInferenceAccelerators;
                return this;
            }

            public Builder enclaveOptions(IResolvable enclaveOptions) {
                this.enclaveOptions = enclaveOptions;
                return this;
            }

            public Builder enclaveOptions(EnclaveOptionsProperty enclaveOptions) {
                this.enclaveOptions = enclaveOptions;
                return this;
            }

            public Builder hibernationOptions(IResolvable hibernationOptions) {
                this.hibernationOptions = hibernationOptions;
                return this;
            }

            public Builder hibernationOptions(HibernationOptionsProperty hibernationOptions) {
                this.hibernationOptions = hibernationOptions;
                return this;
            }

            public Builder iamInstanceProfile(IResolvable iamInstanceProfile) {
                this.iamInstanceProfile = iamInstanceProfile;
                return this;
            }

            public Builder iamInstanceProfile(IamInstanceProfileProperty iamInstanceProfile) {
                this.iamInstanceProfile = iamInstanceProfile;
                return this;
            }

            public Builder imageId(String imageId) {
                this.imageId = imageId;
                return this;
            }

            public Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
                this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
                return this;
            }

            public Builder instanceMarketOptions(IResolvable instanceMarketOptions) {
                this.instanceMarketOptions = instanceMarketOptions;
                return this;
            }

            public Builder instanceMarketOptions(InstanceMarketOptionsProperty instanceMarketOptions) {
                this.instanceMarketOptions = instanceMarketOptions;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder kernelId(String kernelId) {
                this.kernelId = kernelId;
                return this;
            }

            public Builder keyName(String keyName) {
                this.keyName = keyName;
                return this;
            }

            public Builder licenseSpecifications(IResolvable licenseSpecifications) {
                this.licenseSpecifications = licenseSpecifications;
                return this;
            }

            public Builder licenseSpecifications(List<? extends Object> licenseSpecifications) {
                this.licenseSpecifications = licenseSpecifications;
                return this;
            }

            public Builder metadataOptions(IResolvable metadataOptions) {
                this.metadataOptions = metadataOptions;
                return this;
            }

            public Builder metadataOptions(MetadataOptionsProperty metadataOptions) {
                this.metadataOptions = metadataOptions;
                return this;
            }

            public Builder monitoring(IResolvable monitoring) {
                this.monitoring = monitoring;
                return this;
            }

            public Builder monitoring(MonitoringProperty monitoring) {
                this.monitoring = monitoring;
                return this;
            }

            public Builder networkInterfaces(IResolvable networkInterfaces) {
                this.networkInterfaces = networkInterfaces;
                return this;
            }

            public Builder networkInterfaces(List<? extends Object> networkInterfaces) {
                this.networkInterfaces = networkInterfaces;
                return this;
            }

            public Builder placement(IResolvable placement) {
                this.placement = placement;
                return this;
            }

            public Builder placement(PlacementProperty placement) {
                this.placement = placement;
                return this;
            }

            public Builder ramDiskId(String ramDiskId) {
                this.ramDiskId = ramDiskId;
                return this;
            }

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder securityGroups(List<String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            public Builder tagSpecifications(IResolvable tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            public Builder tagSpecifications(List<? extends Object> tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            public Builder userData(String userData) {
                this.userData = userData;
                return this;
            }

            public LaunchTemplateDataProperty build() {
                return new Jsii.Proxy(this.blockDeviceMappings, this.capacityReservationSpecification, this.cpuOptions, this.creditSpecification, this.disableApiTermination, this.ebsOptimized, this.elasticGpuSpecifications, this.elasticInferenceAccelerators, this.enclaveOptions, this.hibernationOptions, this.iamInstanceProfile, this.imageId, this.instanceInitiatedShutdownBehavior, this.instanceMarketOptions, this.instanceType, this.kernelId, this.keyName, this.licenseSpecifications, this.metadataOptions, this.monitoring, this.networkInterfaces, this.placement, this.ramDiskId, this.securityGroupIds, this.securityGroups, this.tagSpecifications, this.userData);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate.Ipv6AddProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface Ipv6AddProperty
    extends JsiiSerializable {
        @Nullable
        default public String getIpv6Address() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<Ipv6AddProperty> {
            private String ipv6Address;

            public Builder ipv6Address(String ipv6Address) {
                this.ipv6Address = ipv6Address;
                return this;
            }

            public Ipv6AddProperty build() {
                return new Jsii.Proxy(this.ipv6Address);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate.InstanceMarketOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceMarketOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getMarketType() {
            return null;
        }

        @Nullable
        default public Object getSpotOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstanceMarketOptionsProperty> {
            private String marketType;
            private Object spotOptions;

            public Builder marketType(String marketType) {
                this.marketType = marketType;
                return this;
            }

            public Builder spotOptions(IResolvable spotOptions) {
                this.spotOptions = spotOptions;
                return this;
            }

            public Builder spotOptions(SpotOptionsProperty spotOptions) {
                this.spotOptions = spotOptions;
                return this;
            }

            public InstanceMarketOptionsProperty build() {
                return new Jsii.Proxy(this.marketType, this.spotOptions);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate.IamInstanceProfileProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IamInstanceProfileProperty
    extends JsiiSerializable {
        @Nullable
        default public String getArn() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IamInstanceProfileProperty> {
            private String arn;
            private String name;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public IamInstanceProfileProperty build() {
                return new Jsii.Proxy(this.arn, this.name);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate.HibernationOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HibernationOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getConfigured() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HibernationOptionsProperty> {
            private Object configured;

            public Builder configured(Boolean configured) {
                this.configured = configured;
                return this;
            }

            public Builder configured(IResolvable configured) {
                this.configured = configured;
                return this;
            }

            public HibernationOptionsProperty build() {
                return new Jsii.Proxy(this.configured);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate.EnclaveOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EnclaveOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EnclaveOptionsProperty> {
            private Object enabled;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public EnclaveOptionsProperty build() {
                return new Jsii.Proxy(this.enabled);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate.ElasticGpuSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ElasticGpuSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ElasticGpuSpecificationProperty> {
            private String type;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public ElasticGpuSpecificationProperty build() {
                return new Jsii.Proxy(this.type);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate.EbsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EbsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDeleteOnTermination() {
            return null;
        }

        @Nullable
        default public Object getEncrypted() {
            return null;
        }

        @Nullable
        default public Number getIops() {
            return null;
        }

        @Nullable
        default public String getKmsKeyId() {
            return null;
        }

        @Nullable
        default public String getSnapshotId() {
            return null;
        }

        @Nullable
        default public Number getThroughput() {
            return null;
        }

        @Nullable
        default public Number getVolumeSize() {
            return null;
        }

        @Nullable
        default public String getVolumeType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EbsProperty> {
            private Object deleteOnTermination;
            private Object encrypted;
            private Number iops;
            private String kmsKeyId;
            private String snapshotId;
            private Number throughput;
            private Number volumeSize;
            private String volumeType;

            public Builder deleteOnTermination(Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder deleteOnTermination(IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder encrypted(Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            public Builder encrypted(IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            public Builder iops(Number iops) {
                this.iops = iops;
                return this;
            }

            public Builder kmsKeyId(String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            public Builder snapshotId(String snapshotId) {
                this.snapshotId = snapshotId;
                return this;
            }

            public Builder throughput(Number throughput) {
                this.throughput = throughput;
                return this;
            }

            public Builder volumeSize(Number volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            public Builder volumeType(String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            public EbsProperty build() {
                return new Jsii.Proxy(this.deleteOnTermination, this.encrypted, this.iops, this.kmsKeyId, this.snapshotId, this.throughput, this.volumeSize, this.volumeType);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate.CreditSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CreditSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCpuCredits() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CreditSpecificationProperty> {
            private String cpuCredits;

            public Builder cpuCredits(String cpuCredits) {
                this.cpuCredits = cpuCredits;
                return this;
            }

            public CreditSpecificationProperty build() {
                return new Jsii.Proxy(this.cpuCredits);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate.CpuOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CpuOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getCoreCount() {
            return null;
        }

        @Nullable
        default public Number getThreadsPerCore() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CpuOptionsProperty> {
            private Number coreCount;
            private Number threadsPerCore;

            public Builder coreCount(Number coreCount) {
                this.coreCount = coreCount;
                return this;
            }

            public Builder threadsPerCore(Number threadsPerCore) {
                this.threadsPerCore = threadsPerCore;
                return this;
            }

            public CpuOptionsProperty build() {
                return new Jsii.Proxy(this.coreCount, this.threadsPerCore);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate.CapacityReservationTargetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CapacityReservationTargetProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCapacityReservationId() {
            return null;
        }

        @Nullable
        default public String getCapacityReservationResourceGroupArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CapacityReservationTargetProperty> {
            private String capacityReservationId;
            private String capacityReservationResourceGroupArn;

            public Builder capacityReservationId(String capacityReservationId) {
                this.capacityReservationId = capacityReservationId;
                return this;
            }

            public Builder capacityReservationResourceGroupArn(String capacityReservationResourceGroupArn) {
                this.capacityReservationResourceGroupArn = capacityReservationResourceGroupArn;
                return this;
            }

            public CapacityReservationTargetProperty build() {
                return new Jsii.Proxy(this.capacityReservationId, this.capacityReservationResourceGroupArn);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate.CapacityReservationSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CapacityReservationSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCapacityReservationPreference() {
            return null;
        }

        @Nullable
        default public Object getCapacityReservationTarget() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CapacityReservationSpecificationProperty> {
            private String capacityReservationPreference;
            private Object capacityReservationTarget;

            public Builder capacityReservationPreference(String capacityReservationPreference) {
                this.capacityReservationPreference = capacityReservationPreference;
                return this;
            }

            public Builder capacityReservationTarget(IResolvable capacityReservationTarget) {
                this.capacityReservationTarget = capacityReservationTarget;
                return this;
            }

            public Builder capacityReservationTarget(CapacityReservationTargetProperty capacityReservationTarget) {
                this.capacityReservationTarget = capacityReservationTarget;
                return this;
            }

            public CapacityReservationSpecificationProperty build() {
                return new Jsii.Proxy(this.capacityReservationPreference, this.capacityReservationTarget);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.CfnLaunchTemplate.BlockDeviceMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BlockDeviceMappingProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDeviceName() {
            return null;
        }

        @Nullable
        default public Object getEbs() {
            return null;
        }

        @Nullable
        default public String getNoDevice() {
            return null;
        }

        @Nullable
        default public String getVirtualName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BlockDeviceMappingProperty> {
            private String deviceName;
            private Object ebs;
            private String noDevice;
            private String virtualName;

            public Builder deviceName(String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            public Builder ebs(IResolvable ebs) {
                this.ebs = ebs;
                return this;
            }

            public Builder ebs(EbsProperty ebs) {
                this.ebs = ebs;
                return this;
            }

            public Builder noDevice(String noDevice) {
                this.noDevice = noDevice;
                return this;
            }

            public Builder virtualName(String virtualName) {
                this.virtualName = virtualName;
                return this;
            }

            public BlockDeviceMappingProperty build() {
                return new Jsii.Proxy(this.deviceName, this.ebs, this.noDevice, this.virtualName);
            }
        }
    }
}

