package software.amazon.awscdk.services.ec2;

/**
 * Properties for a NAT instance.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-28T11:52:49.804Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.NatInstanceProps")
@software.amazon.jsii.Jsii.Proxy(NatInstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NatInstanceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Instance type of the NAT instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceType getInstanceType();

    /**
     * (deprecated) Allow all inbound traffic through the NAT instance.
     * <p>
     * If you set this to false, you must configure the NAT instance's security
     * groups in another way, either by passing in a fully configured Security
     * Group using the <code>securityGroup</code> property, or by configuring it using the
     * <code>.securityGroup</code> or <code>.connections</code> members after passing the NAT Instance
     * Provider to a Vpc.
     * <p>
     * Default: true
     * <p>
     * @deprecated - Use `defaultAllowedTraffic`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAllowAllTraffic() {
        return null;
    }

    /**
     * Direction to allow all traffic through the NAT instance by default.
     * <p>
     * By default, inbound and outbound traffic is allowed.
     * <p>
     * If you set this to another value than INBOUND_AND_OUTBOUND, you must
     * configure the NAT instance's security groups in another way, either by
     * passing in a fully configured Security Group using the <code>securityGroup</code>
     * property, or by configuring it using the <code>.securityGroup</code> or
     * <code>.connections</code> members after passing the NAT Instance Provider to a Vpc.
     * <p>
     * Default: NatTrafficDirection.INBOUND_AND_OUTBOUND
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.NatTrafficDirection getDefaultAllowedTraffic() {
        return null;
    }

    /**
     * Name of SSH keypair to grant access to instance.
     * <p>
     * Default: - No SSH access will be possible.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyName() {
        return null;
    }

    /**
     * The machine image (AMI) to use.
     * <p>
     * By default, will do an AMI lookup for the latest NAT instance image.
     * <p>
     * If you have a specific AMI ID you want to use, pass a <code>GenericLinuxImage</code>. For example:
     * <p>
     * <blockquote><pre>
     * // Example automatically generated. See https://github.com/aws/jsii/issues/826
     * ec2.NatProvider.instance(Map.of(
     *         "instanceType", new InstanceType("t3.micro"),
     *         "machineImage", GenericLinuxImage.Builder.create()
     *                 .us-east-2("ami-0f9c61b5a562a16af")
     *                 .build()));
     * </pre></blockquote>
     * <p>
     * Default: - Latest NAT instance image
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IMachineImage getMachineImage() {
        return null;
    }

    /**
     * Security Group for NAT instances.
     * <p>
     * Default: - A new security group will be created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NatInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NatInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NatInstanceProps> {
        private software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private java.lang.Boolean allowAllTraffic;
        private software.amazon.awscdk.services.ec2.NatTrafficDirection defaultAllowedTraffic;
        private java.lang.String keyName;
        private software.amazon.awscdk.services.ec2.IMachineImage machineImage;
        private software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;

        /**
         * Sets the value of {@link NatInstanceProps#getInstanceType}
         * @param instanceType Instance type of the NAT instance. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link NatInstanceProps#getAllowAllTraffic}
         * @param allowAllTraffic Allow all inbound traffic through the NAT instance.
         *                        If you set this to false, you must configure the NAT instance's security
         *                        groups in another way, either by passing in a fully configured Security
         *                        Group using the <code>securityGroup</code> property, or by configuring it using the
         *                        <code>.securityGroup</code> or <code>.connections</code> members after passing the NAT Instance
         *                        Provider to a Vpc.
         * @return {@code this}
         * @deprecated - Use `defaultAllowedTraffic`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder allowAllTraffic(java.lang.Boolean allowAllTraffic) {
            this.allowAllTraffic = allowAllTraffic;
            return this;
        }

        /**
         * Sets the value of {@link NatInstanceProps#getDefaultAllowedTraffic}
         * @param defaultAllowedTraffic Direction to allow all traffic through the NAT instance by default.
         *                              By default, inbound and outbound traffic is allowed.
         *                              <p>
         *                              If you set this to another value than INBOUND_AND_OUTBOUND, you must
         *                              configure the NAT instance's security groups in another way, either by
         *                              passing in a fully configured Security Group using the <code>securityGroup</code>
         *                              property, or by configuring it using the <code>.securityGroup</code> or
         *                              <code>.connections</code> members after passing the NAT Instance Provider to a Vpc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAllowedTraffic(software.amazon.awscdk.services.ec2.NatTrafficDirection defaultAllowedTraffic) {
            this.defaultAllowedTraffic = defaultAllowedTraffic;
            return this;
        }

        /**
         * Sets the value of {@link NatInstanceProps#getKeyName}
         * @param keyName Name of SSH keypair to grant access to instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyName(java.lang.String keyName) {
            this.keyName = keyName;
            return this;
        }

        /**
         * Sets the value of {@link NatInstanceProps#getMachineImage}
         * @param machineImage The machine image (AMI) to use.
         *                     By default, will do an AMI lookup for the latest NAT instance image.
         *                     <p>
         *                     If you have a specific AMI ID you want to use, pass a <code>GenericLinuxImage</code>. For example:
         *                     <p>
         *                     <blockquote><pre>
         *                     // Example automatically generated. See https://github.com/aws/jsii/issues/826
         *                     ec2.NatProvider.instance(Map.of(
         *                             "instanceType", new InstanceType("t3.micro"),
         *                             "machineImage", GenericLinuxImage.Builder.create()
         *                                     .us-east-2("ami-0f9c61b5a562a16af")
         *                                     .build()));
         *                     </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder machineImage(software.amazon.awscdk.services.ec2.IMachineImage machineImage) {
            this.machineImage = machineImage;
            return this;
        }

        /**
         * Sets the value of {@link NatInstanceProps#getSecurityGroup}
         * @param securityGroup Security Group for NAT instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NatInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NatInstanceProps build() {
            return new Jsii$Proxy(instanceType, allowAllTraffic, defaultAllowedTraffic, keyName, machineImage, securityGroup);
        }
    }

    /**
     * An implementation for {@link NatInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NatInstanceProps {
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final java.lang.Boolean allowAllTraffic;
        private final software.amazon.awscdk.services.ec2.NatTrafficDirection defaultAllowedTraffic;
        private final java.lang.String keyName;
        private final software.amazon.awscdk.services.ec2.IMachineImage machineImage;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
            this.allowAllTraffic = software.amazon.jsii.Kernel.get(this, "allowAllTraffic", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.defaultAllowedTraffic = software.amazon.jsii.Kernel.get(this, "defaultAllowedTraffic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.NatTrafficDirection.class));
            this.keyName = software.amazon.jsii.Kernel.get(this, "keyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.machineImage = software.amazon.jsii.Kernel.get(this, "machineImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class));
            this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.ec2.InstanceType instanceType, final java.lang.Boolean allowAllTraffic, final software.amazon.awscdk.services.ec2.NatTrafficDirection defaultAllowedTraffic, final java.lang.String keyName, final software.amazon.awscdk.services.ec2.IMachineImage machineImage, final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceType = java.util.Objects.requireNonNull(instanceType, "instanceType is required");
            this.allowAllTraffic = allowAllTraffic;
            this.defaultAllowedTraffic = defaultAllowedTraffic;
            this.keyName = keyName;
            this.machineImage = machineImage;
            this.securityGroup = securityGroup;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final java.lang.Boolean getAllowAllTraffic() {
            return this.allowAllTraffic;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.NatTrafficDirection getDefaultAllowedTraffic() {
            return this.defaultAllowedTraffic;
        }

        @Override
        public final java.lang.String getKeyName() {
            return this.keyName;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IMachineImage getMachineImage() {
            return this.machineImage;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            if (this.getAllowAllTraffic() != null) {
                data.set("allowAllTraffic", om.valueToTree(this.getAllowAllTraffic()));
            }
            if (this.getDefaultAllowedTraffic() != null) {
                data.set("defaultAllowedTraffic", om.valueToTree(this.getDefaultAllowedTraffic()));
            }
            if (this.getKeyName() != null) {
                data.set("keyName", om.valueToTree(this.getKeyName()));
            }
            if (this.getMachineImage() != null) {
                data.set("machineImage", om.valueToTree(this.getMachineImage()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.NatInstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NatInstanceProps.Jsii$Proxy that = (NatInstanceProps.Jsii$Proxy) o;

            if (!instanceType.equals(that.instanceType)) return false;
            if (this.allowAllTraffic != null ? !this.allowAllTraffic.equals(that.allowAllTraffic) : that.allowAllTraffic != null) return false;
            if (this.defaultAllowedTraffic != null ? !this.defaultAllowedTraffic.equals(that.defaultAllowedTraffic) : that.defaultAllowedTraffic != null) return false;
            if (this.keyName != null ? !this.keyName.equals(that.keyName) : that.keyName != null) return false;
            if (this.machineImage != null ? !this.machineImage.equals(that.machineImage) : that.machineImage != null) return false;
            return this.securityGroup != null ? this.securityGroup.equals(that.securityGroup) : that.securityGroup == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceType.hashCode();
            result = 31 * result + (this.allowAllTraffic != null ? this.allowAllTraffic.hashCode() : 0);
            result = 31 * result + (this.defaultAllowedTraffic != null ? this.defaultAllowedTraffic.hashCode() : 0);
            result = 31 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
            result = 31 * result + (this.machineImage != null ? this.machineImage.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            return result;
        }
    }
}
