package software.amazon.awscdk.services.ec2;

/**
 * An object that represents reasons to restart an InitService.
 * <p>
 * Pass an instance of this object to the <code>InitFile</code>, <code>InitCommand</code>,
 * <code>InitSource</code> and <code>InitPackage</code> objects, and finally to an <code>InitService</code>
 * itself to cause the actions (files, commands, sources, and packages)
 * to trigger a restart of the service.
 * <p>
 * For example, the following will run a custom command to install Nginx,
 * and trigger the nginx service to be restarted after the command has run.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * Object handle = new InitServiceRestartHandle();
 * ec2.CloudFormationInit.fromElements(ec2.InitCommand.shellCommand("/usr/bin/custom-nginx-install.sh", Map.of("serviceRestartHandles", asList(handle))), ec2.InitService.enable("nginx", Map.of("serviceRestartHandle", handle)));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-08-05T11:20:50.293Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.InitServiceRestartHandle")
public class InitServiceRestartHandle extends software.amazon.jsii.JsiiObject {

    protected InitServiceRestartHandle(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InitServiceRestartHandle(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InitServiceRestartHandle() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }
}
