package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::EC2Fleet`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.18.0 (build f29d29c)", date = "2019-10-07T15:39:41.532Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnEC2FleetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::EC2Fleet.LaunchTemplateConfigs`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-launchtemplateconfigs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getLaunchTemplateConfigs();

    /**
     * `AWS::EC2::EC2Fleet.TargetCapacitySpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-targetcapacityspecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getTargetCapacitySpecification();

    /**
     * `AWS::EC2::EC2Fleet.ExcessCapacityTerminationPolicy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-excesscapacityterminationpolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getExcessCapacityTerminationPolicy();

    /**
     * `AWS::EC2::EC2Fleet.OnDemandOptions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-ondemandoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getOnDemandOptions();

    /**
     * `AWS::EC2::EC2Fleet.ReplaceUnhealthyInstances`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-replaceunhealthyinstances
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getReplaceUnhealthyInstances();

    /**
     * `AWS::EC2::EC2Fleet.SpotOptions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-spotoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getSpotOptions();

    /**
     * `AWS::EC2::EC2Fleet.TagSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-tagspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getTagSpecifications();

    /**
     * `AWS::EC2::EC2Fleet.TerminateInstancesWithExpiration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-terminateinstanceswithexpiration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getTerminateInstancesWithExpiration();

    /**
     * `AWS::EC2::EC2Fleet.Type`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getType();

    /**
     * `AWS::EC2::EC2Fleet.ValidFrom`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validfrom
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getValidFrom();

    /**
     * `AWS::EC2::EC2Fleet.ValidUntil`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validuntil
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getValidUntil();

    /**
     * @return a {@link Builder} of {@link CfnEC2FleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEC2FleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.Object launchTemplateConfigs;
        private java.lang.Object targetCapacitySpecification;
        private java.lang.String excessCapacityTerminationPolicy;
        private java.lang.Object onDemandOptions;
        private java.lang.Object replaceUnhealthyInstances;
        private java.lang.Object spotOptions;
        private java.lang.Object tagSpecifications;
        private java.lang.Object terminateInstancesWithExpiration;
        private java.lang.String type;
        private java.lang.String validFrom;
        private java.lang.String validUntil;

        /**
         * Sets the value of LaunchTemplateConfigs
         * @param launchTemplateConfigs `AWS::EC2::EC2Fleet.LaunchTemplateConfigs`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder launchTemplateConfigs(software.amazon.awscdk.core.IResolvable launchTemplateConfigs) {
            this.launchTemplateConfigs = launchTemplateConfigs;
            return this;
        }

        /**
         * Sets the value of LaunchTemplateConfigs
         * @param launchTemplateConfigs `AWS::EC2::EC2Fleet.LaunchTemplateConfigs`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder launchTemplateConfigs(java.util.List<java.lang.Object> launchTemplateConfigs) {
            this.launchTemplateConfigs = launchTemplateConfigs;
            return this;
        }

        /**
         * Sets the value of TargetCapacitySpecification
         * @param targetCapacitySpecification `AWS::EC2::EC2Fleet.TargetCapacitySpecification`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder targetCapacitySpecification(software.amazon.awscdk.core.IResolvable targetCapacitySpecification) {
            this.targetCapacitySpecification = targetCapacitySpecification;
            return this;
        }

        /**
         * Sets the value of TargetCapacitySpecification
         * @param targetCapacitySpecification `AWS::EC2::EC2Fleet.TargetCapacitySpecification`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder targetCapacitySpecification(software.amazon.awscdk.services.ec2.CfnEC2Fleet.TargetCapacitySpecificationRequestProperty targetCapacitySpecification) {
            this.targetCapacitySpecification = targetCapacitySpecification;
            return this;
        }

        /**
         * Sets the value of ExcessCapacityTerminationPolicy
         * @param excessCapacityTerminationPolicy `AWS::EC2::EC2Fleet.ExcessCapacityTerminationPolicy`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder excessCapacityTerminationPolicy(java.lang.String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
            return this;
        }

        /**
         * Sets the value of OnDemandOptions
         * @param onDemandOptions `AWS::EC2::EC2Fleet.OnDemandOptions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder onDemandOptions(software.amazon.awscdk.core.IResolvable onDemandOptions) {
            this.onDemandOptions = onDemandOptions;
            return this;
        }

        /**
         * Sets the value of OnDemandOptions
         * @param onDemandOptions `AWS::EC2::EC2Fleet.OnDemandOptions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder onDemandOptions(software.amazon.awscdk.services.ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty onDemandOptions) {
            this.onDemandOptions = onDemandOptions;
            return this;
        }

        /**
         * Sets the value of ReplaceUnhealthyInstances
         * @param replaceUnhealthyInstances `AWS::EC2::EC2Fleet.ReplaceUnhealthyInstances`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder replaceUnhealthyInstances(java.lang.Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
            return this;
        }

        /**
         * Sets the value of ReplaceUnhealthyInstances
         * @param replaceUnhealthyInstances `AWS::EC2::EC2Fleet.ReplaceUnhealthyInstances`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder replaceUnhealthyInstances(software.amazon.awscdk.core.IResolvable replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
            return this;
        }

        /**
         * Sets the value of SpotOptions
         * @param spotOptions `AWS::EC2::EC2Fleet.SpotOptions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder spotOptions(software.amazon.awscdk.core.IResolvable spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        /**
         * Sets the value of SpotOptions
         * @param spotOptions `AWS::EC2::EC2Fleet.SpotOptions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder spotOptions(software.amazon.awscdk.services.ec2.CfnEC2Fleet.SpotOptionsRequestProperty spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        /**
         * Sets the value of TagSpecifications
         * @param tagSpecifications `AWS::EC2::EC2Fleet.TagSpecifications`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tagSpecifications(software.amazon.awscdk.core.IResolvable tagSpecifications) {
            this.tagSpecifications = tagSpecifications;
            return this;
        }

        /**
         * Sets the value of TagSpecifications
         * @param tagSpecifications `AWS::EC2::EC2Fleet.TagSpecifications`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tagSpecifications(java.util.List<java.lang.Object> tagSpecifications) {
            this.tagSpecifications = tagSpecifications;
            return this;
        }

        /**
         * Sets the value of TerminateInstancesWithExpiration
         * @param terminateInstancesWithExpiration `AWS::EC2::EC2Fleet.TerminateInstancesWithExpiration`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder terminateInstancesWithExpiration(java.lang.Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
            return this;
        }

        /**
         * Sets the value of TerminateInstancesWithExpiration
         * @param terminateInstancesWithExpiration `AWS::EC2::EC2Fleet.TerminateInstancesWithExpiration`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder terminateInstancesWithExpiration(software.amazon.awscdk.core.IResolvable terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
            return this;
        }

        /**
         * Sets the value of Type
         * @param type `AWS::EC2::EC2Fleet.Type`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of ValidFrom
         * @param validFrom `AWS::EC2::EC2Fleet.ValidFrom`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder validFrom(java.lang.String validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        /**
         * Sets the value of ValidUntil
         * @param validUntil `AWS::EC2::EC2Fleet.ValidUntil`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder validUntil(java.lang.String validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEC2FleetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnEC2FleetProps build() {
            return new Jsii$Proxy(launchTemplateConfigs, targetCapacitySpecification, excessCapacityTerminationPolicy, onDemandOptions, replaceUnhealthyInstances, spotOptions, tagSpecifications, terminateInstancesWithExpiration, type, validFrom, validUntil);
        }
    }

    /**
     * An implementation for {@link CfnEC2FleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEC2FleetProps {
        private final java.lang.Object launchTemplateConfigs;
        private final java.lang.Object targetCapacitySpecification;
        private final java.lang.String excessCapacityTerminationPolicy;
        private final java.lang.Object onDemandOptions;
        private final java.lang.Object replaceUnhealthyInstances;
        private final java.lang.Object spotOptions;
        private final java.lang.Object tagSpecifications;
        private final java.lang.Object terminateInstancesWithExpiration;
        private final java.lang.String type;
        private final java.lang.String validFrom;
        private final java.lang.String validUntil;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.launchTemplateConfigs = this.jsiiGet("launchTemplateConfigs", java.lang.Object.class);
            this.targetCapacitySpecification = this.jsiiGet("targetCapacitySpecification", java.lang.Object.class);
            this.excessCapacityTerminationPolicy = this.jsiiGet("excessCapacityTerminationPolicy", java.lang.String.class);
            this.onDemandOptions = this.jsiiGet("onDemandOptions", java.lang.Object.class);
            this.replaceUnhealthyInstances = this.jsiiGet("replaceUnhealthyInstances", java.lang.Object.class);
            this.spotOptions = this.jsiiGet("spotOptions", java.lang.Object.class);
            this.tagSpecifications = this.jsiiGet("tagSpecifications", java.lang.Object.class);
            this.terminateInstancesWithExpiration = this.jsiiGet("terminateInstancesWithExpiration", java.lang.Object.class);
            this.type = this.jsiiGet("type", java.lang.String.class);
            this.validFrom = this.jsiiGet("validFrom", java.lang.String.class);
            this.validUntil = this.jsiiGet("validUntil", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Object launchTemplateConfigs, java.lang.Object targetCapacitySpecification, java.lang.String excessCapacityTerminationPolicy, java.lang.Object onDemandOptions, java.lang.Object replaceUnhealthyInstances, java.lang.Object spotOptions, java.lang.Object tagSpecifications, java.lang.Object terminateInstancesWithExpiration, java.lang.String type, java.lang.String validFrom, java.lang.String validUntil) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.launchTemplateConfigs = java.util.Objects.requireNonNull(launchTemplateConfigs, "launchTemplateConfigs is required");
            this.targetCapacitySpecification = java.util.Objects.requireNonNull(targetCapacitySpecification, "targetCapacitySpecification is required");
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
            this.onDemandOptions = onDemandOptions;
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
            this.spotOptions = spotOptions;
            this.tagSpecifications = tagSpecifications;
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
            this.type = type;
            this.validFrom = validFrom;
            this.validUntil = validUntil;
        }

        @Override
        public java.lang.Object getLaunchTemplateConfigs() {
            return this.launchTemplateConfigs;
        }

        @Override
        public java.lang.Object getTargetCapacitySpecification() {
            return this.targetCapacitySpecification;
        }

        @Override
        public java.lang.String getExcessCapacityTerminationPolicy() {
            return this.excessCapacityTerminationPolicy;
        }

        @Override
        public java.lang.Object getOnDemandOptions() {
            return this.onDemandOptions;
        }

        @Override
        public java.lang.Object getReplaceUnhealthyInstances() {
            return this.replaceUnhealthyInstances;
        }

        @Override
        public java.lang.Object getSpotOptions() {
            return this.spotOptions;
        }

        @Override
        public java.lang.Object getTagSpecifications() {
            return this.tagSpecifications;
        }

        @Override
        public java.lang.Object getTerminateInstancesWithExpiration() {
            return this.terminateInstancesWithExpiration;
        }

        @Override
        public java.lang.String getType() {
            return this.type;
        }

        @Override
        public java.lang.String getValidFrom() {
            return this.validFrom;
        }

        @Override
        public java.lang.String getValidUntil() {
            return this.validUntil;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("launchTemplateConfigs", om.valueToTree(this.getLaunchTemplateConfigs()));
            obj.set("targetCapacitySpecification", om.valueToTree(this.getTargetCapacitySpecification()));
            if (this.getExcessCapacityTerminationPolicy() != null) {
                obj.set("excessCapacityTerminationPolicy", om.valueToTree(this.getExcessCapacityTerminationPolicy()));
            }
            if (this.getOnDemandOptions() != null) {
                obj.set("onDemandOptions", om.valueToTree(this.getOnDemandOptions()));
            }
            if (this.getReplaceUnhealthyInstances() != null) {
                obj.set("replaceUnhealthyInstances", om.valueToTree(this.getReplaceUnhealthyInstances()));
            }
            if (this.getSpotOptions() != null) {
                obj.set("spotOptions", om.valueToTree(this.getSpotOptions()));
            }
            if (this.getTagSpecifications() != null) {
                obj.set("tagSpecifications", om.valueToTree(this.getTagSpecifications()));
            }
            if (this.getTerminateInstancesWithExpiration() != null) {
                obj.set("terminateInstancesWithExpiration", om.valueToTree(this.getTerminateInstancesWithExpiration()));
            }
            if (this.getType() != null) {
                obj.set("type", om.valueToTree(this.getType()));
            }
            if (this.getValidFrom() != null) {
                obj.set("validFrom", om.valueToTree(this.getValidFrom()));
            }
            if (this.getValidUntil() != null) {
                obj.set("validUntil", om.valueToTree(this.getValidUntil()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEC2FleetProps.Jsii$Proxy that = (CfnEC2FleetProps.Jsii$Proxy) o;

            if (!launchTemplateConfigs.equals(that.launchTemplateConfigs)) return false;
            if (!targetCapacitySpecification.equals(that.targetCapacitySpecification)) return false;
            if (this.excessCapacityTerminationPolicy != null ? !this.excessCapacityTerminationPolicy.equals(that.excessCapacityTerminationPolicy) : that.excessCapacityTerminationPolicy != null) return false;
            if (this.onDemandOptions != null ? !this.onDemandOptions.equals(that.onDemandOptions) : that.onDemandOptions != null) return false;
            if (this.replaceUnhealthyInstances != null ? !this.replaceUnhealthyInstances.equals(that.replaceUnhealthyInstances) : that.replaceUnhealthyInstances != null) return false;
            if (this.spotOptions != null ? !this.spotOptions.equals(that.spotOptions) : that.spotOptions != null) return false;
            if (this.tagSpecifications != null ? !this.tagSpecifications.equals(that.tagSpecifications) : that.tagSpecifications != null) return false;
            if (this.terminateInstancesWithExpiration != null ? !this.terminateInstancesWithExpiration.equals(that.terminateInstancesWithExpiration) : that.terminateInstancesWithExpiration != null) return false;
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
            if (this.validFrom != null ? !this.validFrom.equals(that.validFrom) : that.validFrom != null) return false;
            return this.validUntil != null ? this.validUntil.equals(that.validUntil) : that.validUntil == null;
        }

        @Override
        public int hashCode() {
            int result = this.launchTemplateConfigs.hashCode();
            result = 31 * result + (this.targetCapacitySpecification.hashCode());
            result = 31 * result + (this.excessCapacityTerminationPolicy != null ? this.excessCapacityTerminationPolicy.hashCode() : 0);
            result = 31 * result + (this.onDemandOptions != null ? this.onDemandOptions.hashCode() : 0);
            result = 31 * result + (this.replaceUnhealthyInstances != null ? this.replaceUnhealthyInstances.hashCode() : 0);
            result = 31 * result + (this.spotOptions != null ? this.spotOptions.hashCode() : 0);
            result = 31 * result + (this.tagSpecifications != null ? this.tagSpecifications.hashCode() : 0);
            result = 31 * result + (this.terminateInstancesWithExpiration != null ? this.terminateInstancesWithExpiration.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.validFrom != null ? this.validFrom.hashCode() : 0);
            result = 31 * result + (this.validUntil != null ? this.validUntil.hashCode() : 0);
            return result;
        }
    }
}
