package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::VPCPeeringConnection`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.18.0 (build f29d29c)", date = "2019-10-07T15:39:41.606Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnVPCPeeringConnectionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::VPCPeeringConnection.PeerVpcId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peervpcid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getPeerVpcId();

    /**
     * `AWS::EC2::VPCPeeringConnection.VpcId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-vpcid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getVpcId();

    /**
     * `AWS::EC2::VPCPeeringConnection.PeerOwnerId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerownerid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getPeerOwnerId();

    /**
     * `AWS::EC2::VPCPeeringConnection.PeerRegion`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerregion
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getPeerRegion();

    /**
     * `AWS::EC2::VPCPeeringConnection.PeerRoleArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerrolearn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getPeerRoleArn();

    /**
     * `AWS::EC2::VPCPeeringConnection.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<software.amazon.awscdk.core.CfnTag> getTags();

    /**
     * @return a {@link Builder} of {@link CfnVPCPeeringConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVPCPeeringConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String peerVpcId;
        private java.lang.String vpcId;
        private java.lang.String peerOwnerId;
        private java.lang.String peerRegion;
        private java.lang.String peerRoleArn;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of PeerVpcId
         * @param peerVpcId `AWS::EC2::VPCPeeringConnection.PeerVpcId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder peerVpcId(java.lang.String peerVpcId) {
            this.peerVpcId = peerVpcId;
            return this;
        }

        /**
         * Sets the value of VpcId
         * @param vpcId `AWS::EC2::VPCPeeringConnection.VpcId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of PeerOwnerId
         * @param peerOwnerId `AWS::EC2::VPCPeeringConnection.PeerOwnerId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder peerOwnerId(java.lang.String peerOwnerId) {
            this.peerOwnerId = peerOwnerId;
            return this;
        }

        /**
         * Sets the value of PeerRegion
         * @param peerRegion `AWS::EC2::VPCPeeringConnection.PeerRegion`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder peerRegion(java.lang.String peerRegion) {
            this.peerRegion = peerRegion;
            return this;
        }

        /**
         * Sets the value of PeerRoleArn
         * @param peerRoleArn `AWS::EC2::VPCPeeringConnection.PeerRoleArn`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder peerRoleArn(java.lang.String peerRoleArn) {
            this.peerRoleArn = peerRoleArn;
            return this;
        }

        /**
         * Sets the value of Tags
         * @param tags `AWS::EC2::VPCPeeringConnection.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVPCPeeringConnectionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnVPCPeeringConnectionProps build() {
            return new Jsii$Proxy(peerVpcId, vpcId, peerOwnerId, peerRegion, peerRoleArn, tags);
        }
    }

    /**
     * An implementation for {@link CfnVPCPeeringConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVPCPeeringConnectionProps {
        private final java.lang.String peerVpcId;
        private final java.lang.String vpcId;
        private final java.lang.String peerOwnerId;
        private final java.lang.String peerRegion;
        private final java.lang.String peerRoleArn;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.peerVpcId = this.jsiiGet("peerVpcId", java.lang.String.class);
            this.vpcId = this.jsiiGet("vpcId", java.lang.String.class);
            this.peerOwnerId = this.jsiiGet("peerOwnerId", java.lang.String.class);
            this.peerRegion = this.jsiiGet("peerRegion", java.lang.String.class);
            this.peerRoleArn = this.jsiiGet("peerRoleArn", java.lang.String.class);
            this.tags = this.jsiiGet("tags", java.util.List.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String peerVpcId, java.lang.String vpcId, java.lang.String peerOwnerId, java.lang.String peerRegion, java.lang.String peerRoleArn, java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.peerVpcId = java.util.Objects.requireNonNull(peerVpcId, "peerVpcId is required");
            this.vpcId = java.util.Objects.requireNonNull(vpcId, "vpcId is required");
            this.peerOwnerId = peerOwnerId;
            this.peerRegion = peerRegion;
            this.peerRoleArn = peerRoleArn;
            this.tags = tags;
        }

        @Override
        public java.lang.String getPeerVpcId() {
            return this.peerVpcId;
        }

        @Override
        public java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public java.lang.String getPeerOwnerId() {
            return this.peerOwnerId;
        }

        @Override
        public java.lang.String getPeerRegion() {
            return this.peerRegion;
        }

        @Override
        public java.lang.String getPeerRoleArn() {
            return this.peerRoleArn;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("peerVpcId", om.valueToTree(this.getPeerVpcId()));
            obj.set("vpcId", om.valueToTree(this.getVpcId()));
            if (this.getPeerOwnerId() != null) {
                obj.set("peerOwnerId", om.valueToTree(this.getPeerOwnerId()));
            }
            if (this.getPeerRegion() != null) {
                obj.set("peerRegion", om.valueToTree(this.getPeerRegion()));
            }
            if (this.getPeerRoleArn() != null) {
                obj.set("peerRoleArn", om.valueToTree(this.getPeerRoleArn()));
            }
            if (this.getTags() != null) {
                obj.set("tags", om.valueToTree(this.getTags()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVPCPeeringConnectionProps.Jsii$Proxy that = (CfnVPCPeeringConnectionProps.Jsii$Proxy) o;

            if (!peerVpcId.equals(that.peerVpcId)) return false;
            if (!vpcId.equals(that.vpcId)) return false;
            if (this.peerOwnerId != null ? !this.peerOwnerId.equals(that.peerOwnerId) : that.peerOwnerId != null) return false;
            if (this.peerRegion != null ? !this.peerRegion.equals(that.peerRegion) : that.peerRegion != null) return false;
            if (this.peerRoleArn != null ? !this.peerRoleArn.equals(that.peerRoleArn) : that.peerRoleArn != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public int hashCode() {
            int result = this.peerVpcId.hashCode();
            result = 31 * result + (this.vpcId.hashCode());
            result = 31 * result + (this.peerOwnerId != null ? this.peerOwnerId.hashCode() : 0);
            result = 31 * result + (this.peerRegion != null ? this.peerRegion.hashCode() : 0);
            result = 31 * result + (this.peerRoleArn != null ? this.peerRoleArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
