package software.amazon.awscdk.services.ec2;

/**
 * Options to add a gateway endpoint to a VPC.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.18.0 (build f29d29c)", date = "2019-10-07T15:39:41.614Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GatewayVpcEndpointOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The service to use for this gateway VPC endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService getService();

    /**
     * Where to add endpoint routing.
     * 
     * Default: private subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getSubnets();

    /**
     * @return a {@link Builder} of {@link GatewayVpcEndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GatewayVpcEndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService service;
        private java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> subnets;

        /**
         * Sets the value of Service
         * @param service The service to use for this gateway VPC endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService service) {
            this.service = service;
            return this;
        }

        /**
         * Sets the value of Subnets
         * @param subnets Where to add endpoint routing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnets(java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> subnets) {
            this.subnets = subnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GatewayVpcEndpointOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public GatewayVpcEndpointOptions build() {
            return new Jsii$Proxy(service, subnets);
        }
    }

    /**
     * An implementation for {@link GatewayVpcEndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GatewayVpcEndpointOptions {
        private final software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService service;
        private final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> subnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.service = this.jsiiGet("service", software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService.class);
            this.subnets = this.jsiiGet("subnets", java.util.List.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService service, java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> subnets) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.service = java.util.Objects.requireNonNull(service, "service is required");
            this.subnets = subnets;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService getService() {
            return this.service;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getSubnets() {
            return this.subnets;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("service", om.valueToTree(this.getService()));
            if (this.getSubnets() != null) {
                obj.set("subnets", om.valueToTree(this.getSubnets()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GatewayVpcEndpointOptions.Jsii$Proxy that = (GatewayVpcEndpointOptions.Jsii$Proxy) o;

            if (!service.equals(that.service)) return false;
            return this.subnets != null ? this.subnets.equals(that.subnets) : that.subnets == null;
        }

        @Override
        public int hashCode() {
            int result = this.service.hashCode();
            result = 31 * result + (this.subnets != null ? this.subnets.hashCode() : 0);
            return result;
        }
    }
}
