/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.ec2.$Module;
import software.amazon.awscdk.services.ec2.CfnSpotFleet;
import software.amazon.awscdk.services.ec2.CfnSpotFleetProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnSpotFleet")
public class CfnSpotFleet
extends CfnResource {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnSpotFleet.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnSpotFleet(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSpotFleet(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnSpotFleet(Construct scope, String id, CfnSpotFleetProps props) {
        super(JsiiObject.InitializationMode.JSII);
        this.setObjRef(JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")}));
    }

    protected Map<String, Object> renderProperties(Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", Map.class, new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", Map.class));
    }

    public Object getSpotFleetRequestConfigData() {
        return this.jsiiGet("spotFleetRequestConfigData", Object.class);
    }

    public void setSpotFleetRequestConfigData(IResolvable value) {
        this.jsiiSet("spotFleetRequestConfigData", Objects.requireNonNull(value, "spotFleetRequestConfigData is required"));
    }

    public void setSpotFleetRequestConfigData(SpotFleetRequestConfigDataProperty value) {
        this.jsiiSet("spotFleetRequestConfigData", Objects.requireNonNull(value, "spotFleetRequestConfigData is required"));
    }

    public static interface TargetGroupsConfigProperty
    extends JsiiSerializable {
        public Object getTargetGroups();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object targetGroups;

            public Builder targetGroups(IResolvable targetGroups) {
                this.targetGroups = targetGroups;
                return this;
            }

            public Builder targetGroups(List<Object> targetGroups) {
                this.targetGroups = targetGroups;
                return this;
            }

            public TargetGroupsConfigProperty build() {
                return new Jsii.Proxy(this.targetGroups, null);
            }
        }
    }

    public static interface TargetGroupProperty
    extends JsiiSerializable {
        public String getArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String arn;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public TargetGroupProperty build() {
                return new Jsii.Proxy(this.arn, null);
            }
        }
    }

    public static interface SpotPlacementProperty
    extends JsiiSerializable {
        public String getAvailabilityZone();

        public String getGroupName();

        public String getTenancy();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String availabilityZone;
            private String groupName;
            private String tenancy;

            public Builder availabilityZone(String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            public Builder groupName(String groupName) {
                this.groupName = groupName;
                return this;
            }

            public Builder tenancy(String tenancy) {
                this.tenancy = tenancy;
                return this;
            }

            public SpotPlacementProperty build() {
                return new Jsii.Proxy(this.availabilityZone, this.groupName, this.tenancy, null);
            }
        }
    }

    public static interface SpotFleetTagSpecificationProperty
    extends JsiiSerializable {
        public String getResourceType();

        public List<CfnTag> getTags();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String resourceType;
            private List<CfnTag> tags;

            public Builder resourceType(String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            public Builder tags(List<CfnTag> tags) {
                this.tags = tags;
                return this;
            }

            public SpotFleetTagSpecificationProperty build() {
                return new Jsii.Proxy(this.resourceType, this.tags, null);
            }
        }
    }

    public static interface SpotFleetRequestConfigDataProperty
    extends JsiiSerializable {
        public String getIamFleetRole();

        public Number getTargetCapacity();

        public String getAllocationStrategy();

        public String getExcessCapacityTerminationPolicy();

        public String getInstanceInterruptionBehavior();

        public Object getLaunchSpecifications();

        public Object getLaunchTemplateConfigs();

        public Object getLoadBalancersConfig();

        public Object getReplaceUnhealthyInstances();

        public String getSpotPrice();

        public Object getTerminateInstancesWithExpiration();

        public String getType();

        public String getValidFrom();

        public String getValidUntil();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String iamFleetRole;
            private Number targetCapacity;
            private String allocationStrategy;
            private String excessCapacityTerminationPolicy;
            private String instanceInterruptionBehavior;
            private Object launchSpecifications;
            private Object launchTemplateConfigs;
            private Object loadBalancersConfig;
            private Object replaceUnhealthyInstances;
            private String spotPrice;
            private Object terminateInstancesWithExpiration;
            private String type;
            private String validFrom;
            private String validUntil;

            public Builder iamFleetRole(String iamFleetRole) {
                this.iamFleetRole = iamFleetRole;
                return this;
            }

            public Builder targetCapacity(Number targetCapacity) {
                this.targetCapacity = targetCapacity;
                return this;
            }

            public Builder allocationStrategy(String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            public Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
                this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
                return this;
            }

            public Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
                this.instanceInterruptionBehavior = instanceInterruptionBehavior;
                return this;
            }

            public Builder launchSpecifications(IResolvable launchSpecifications) {
                this.launchSpecifications = launchSpecifications;
                return this;
            }

            public Builder launchSpecifications(List<Object> launchSpecifications) {
                this.launchSpecifications = launchSpecifications;
                return this;
            }

            public Builder launchTemplateConfigs(IResolvable launchTemplateConfigs) {
                this.launchTemplateConfigs = launchTemplateConfigs;
                return this;
            }

            public Builder launchTemplateConfigs(List<Object> launchTemplateConfigs) {
                this.launchTemplateConfigs = launchTemplateConfigs;
                return this;
            }

            public Builder loadBalancersConfig(IResolvable loadBalancersConfig) {
                this.loadBalancersConfig = loadBalancersConfig;
                return this;
            }

            public Builder loadBalancersConfig(LoadBalancersConfigProperty loadBalancersConfig) {
                this.loadBalancersConfig = loadBalancersConfig;
                return this;
            }

            public Builder replaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
                this.replaceUnhealthyInstances = replaceUnhealthyInstances;
                return this;
            }

            public Builder replaceUnhealthyInstances(IResolvable replaceUnhealthyInstances) {
                this.replaceUnhealthyInstances = replaceUnhealthyInstances;
                return this;
            }

            public Builder spotPrice(String spotPrice) {
                this.spotPrice = spotPrice;
                return this;
            }

            public Builder terminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
                this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
                return this;
            }

            public Builder terminateInstancesWithExpiration(IResolvable terminateInstancesWithExpiration) {
                this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder validFrom(String validFrom) {
                this.validFrom = validFrom;
                return this;
            }

            public Builder validUntil(String validUntil) {
                this.validUntil = validUntil;
                return this;
            }

            public SpotFleetRequestConfigDataProperty build() {
                return new Jsii.Proxy(this.iamFleetRole, this.targetCapacity, this.allocationStrategy, this.excessCapacityTerminationPolicy, this.instanceInterruptionBehavior, this.launchSpecifications, this.launchTemplateConfigs, this.loadBalancersConfig, this.replaceUnhealthyInstances, this.spotPrice, this.terminateInstancesWithExpiration, this.type, this.validFrom, this.validUntil, null);
            }
        }
    }

    public static interface SpotFleetMonitoringProperty
    extends JsiiSerializable {
        public Object getEnabled();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object enabled;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public SpotFleetMonitoringProperty build() {
                return new Jsii.Proxy(this.enabled, null);
            }
        }
    }

    public static interface SpotFleetLaunchSpecificationProperty
    extends JsiiSerializable {
        public String getImageId();

        public String getInstanceType();

        public Object getBlockDeviceMappings();

        public Object getEbsOptimized();

        public Object getIamInstanceProfile();

        public String getKernelId();

        public String getKeyName();

        public Object getMonitoring();

        public Object getNetworkInterfaces();

        public Object getPlacement();

        public String getRamdiskId();

        public Object getSecurityGroups();

        public String getSpotPrice();

        public String getSubnetId();

        public Object getTagSpecifications();

        public String getUserData();

        public Number getWeightedCapacity();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String imageId;
            private String instanceType;
            private Object blockDeviceMappings;
            private Object ebsOptimized;
            private Object iamInstanceProfile;
            private String kernelId;
            private String keyName;
            private Object monitoring;
            private Object networkInterfaces;
            private Object placement;
            private String ramdiskId;
            private Object securityGroups;
            private String spotPrice;
            private String subnetId;
            private Object tagSpecifications;
            private String userData;
            private Number weightedCapacity;

            public Builder imageId(String imageId) {
                this.imageId = imageId;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder blockDeviceMappings(IResolvable blockDeviceMappings) {
                this.blockDeviceMappings = blockDeviceMappings;
                return this;
            }

            public Builder blockDeviceMappings(List<Object> blockDeviceMappings) {
                this.blockDeviceMappings = blockDeviceMappings;
                return this;
            }

            public Builder ebsOptimized(Boolean ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            public Builder ebsOptimized(IResolvable ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            public Builder iamInstanceProfile(IResolvable iamInstanceProfile) {
                this.iamInstanceProfile = iamInstanceProfile;
                return this;
            }

            public Builder iamInstanceProfile(IamInstanceProfileSpecificationProperty iamInstanceProfile) {
                this.iamInstanceProfile = iamInstanceProfile;
                return this;
            }

            public Builder kernelId(String kernelId) {
                this.kernelId = kernelId;
                return this;
            }

            public Builder keyName(String keyName) {
                this.keyName = keyName;
                return this;
            }

            public Builder monitoring(IResolvable monitoring) {
                this.monitoring = monitoring;
                return this;
            }

            public Builder monitoring(SpotFleetMonitoringProperty monitoring) {
                this.monitoring = monitoring;
                return this;
            }

            public Builder networkInterfaces(IResolvable networkInterfaces) {
                this.networkInterfaces = networkInterfaces;
                return this;
            }

            public Builder networkInterfaces(List<Object> networkInterfaces) {
                this.networkInterfaces = networkInterfaces;
                return this;
            }

            public Builder placement(IResolvable placement) {
                this.placement = placement;
                return this;
            }

            public Builder placement(SpotPlacementProperty placement) {
                this.placement = placement;
                return this;
            }

            public Builder ramdiskId(String ramdiskId) {
                this.ramdiskId = ramdiskId;
                return this;
            }

            public Builder securityGroups(IResolvable securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            public Builder securityGroups(List<Object> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            public Builder spotPrice(String spotPrice) {
                this.spotPrice = spotPrice;
                return this;
            }

            public Builder subnetId(String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            public Builder tagSpecifications(IResolvable tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            public Builder tagSpecifications(List<Object> tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            public Builder userData(String userData) {
                this.userData = userData;
                return this;
            }

            public Builder weightedCapacity(Number weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            public SpotFleetLaunchSpecificationProperty build() {
                return new Jsii.Proxy(this.imageId, this.instanceType, this.blockDeviceMappings, this.ebsOptimized, this.iamInstanceProfile, this.kernelId, this.keyName, this.monitoring, this.networkInterfaces, this.placement, this.ramdiskId, this.securityGroups, this.spotPrice, this.subnetId, this.tagSpecifications, this.userData, this.weightedCapacity, null);
            }
        }
    }

    public static interface PrivateIpAddressSpecificationProperty
    extends JsiiSerializable {
        public String getPrivateIpAddress();

        public Object getPrimary();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String privateIpAddress;
            private Object primary;

            public Builder privateIpAddress(String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            public Builder primary(Boolean primary) {
                this.primary = primary;
                return this;
            }

            public Builder primary(IResolvable primary) {
                this.primary = primary;
                return this;
            }

            public PrivateIpAddressSpecificationProperty build() {
                return new Jsii.Proxy(this.privateIpAddress, this.primary, null);
            }
        }
    }

    public static interface LoadBalancersConfigProperty
    extends JsiiSerializable {
        public Object getClassicLoadBalancersConfig();

        public Object getTargetGroupsConfig();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object classicLoadBalancersConfig;
            private Object targetGroupsConfig;

            public Builder classicLoadBalancersConfig(IResolvable classicLoadBalancersConfig) {
                this.classicLoadBalancersConfig = classicLoadBalancersConfig;
                return this;
            }

            public Builder classicLoadBalancersConfig(ClassicLoadBalancersConfigProperty classicLoadBalancersConfig) {
                this.classicLoadBalancersConfig = classicLoadBalancersConfig;
                return this;
            }

            public Builder targetGroupsConfig(IResolvable targetGroupsConfig) {
                this.targetGroupsConfig = targetGroupsConfig;
                return this;
            }

            public Builder targetGroupsConfig(TargetGroupsConfigProperty targetGroupsConfig) {
                this.targetGroupsConfig = targetGroupsConfig;
                return this;
            }

            public LoadBalancersConfigProperty build() {
                return new Jsii.Proxy(this.classicLoadBalancersConfig, this.targetGroupsConfig, null);
            }
        }
    }

    public static interface LaunchTemplateOverridesProperty
    extends JsiiSerializable {
        public String getAvailabilityZone();

        public String getInstanceType();

        public String getSpotPrice();

        public String getSubnetId();

        public Number getWeightedCapacity();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String availabilityZone;
            private String instanceType;
            private String spotPrice;
            private String subnetId;
            private Number weightedCapacity;

            public Builder availabilityZone(String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder spotPrice(String spotPrice) {
                this.spotPrice = spotPrice;
                return this;
            }

            public Builder subnetId(String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            public Builder weightedCapacity(Number weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            public LaunchTemplateOverridesProperty build() {
                return new Jsii.Proxy(this.availabilityZone, this.instanceType, this.spotPrice, this.subnetId, this.weightedCapacity, null);
            }
        }
    }

    public static interface LaunchTemplateConfigProperty
    extends JsiiSerializable {
        public Object getLaunchTemplateSpecification();

        public Object getOverrides();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object launchTemplateSpecification;
            private Object overrides;

            public Builder launchTemplateSpecification(IResolvable launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            public Builder launchTemplateSpecification(FleetLaunchTemplateSpecificationProperty launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            public Builder overrides(IResolvable overrides) {
                this.overrides = overrides;
                return this;
            }

            public Builder overrides(List<Object> overrides) {
                this.overrides = overrides;
                return this;
            }

            public LaunchTemplateConfigProperty build() {
                return new Jsii.Proxy(this.launchTemplateSpecification, this.overrides, null);
            }
        }
    }

    public static interface InstanceNetworkInterfaceSpecificationProperty
    extends JsiiSerializable {
        public Object getAssociatePublicIpAddress();

        public Object getDeleteOnTermination();

        public String getDescription();

        public Number getDeviceIndex();

        public List<String> getGroups();

        public Number getIpv6AddressCount();

        public Object getIpv6Addresses();

        public String getNetworkInterfaceId();

        public Object getPrivateIpAddresses();

        public Number getSecondaryPrivateIpAddressCount();

        public String getSubnetId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object associatePublicIpAddress;
            private Object deleteOnTermination;
            private String description;
            private Number deviceIndex;
            private List<String> groups;
            private Number ipv6AddressCount;
            private Object ipv6Addresses;
            private String networkInterfaceId;
            private Object privateIpAddresses;
            private Number secondaryPrivateIpAddressCount;
            private String subnetId;

            public Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            public Builder associatePublicIpAddress(IResolvable associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            public Builder deleteOnTermination(Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder deleteOnTermination(IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder deviceIndex(Number deviceIndex) {
                this.deviceIndex = deviceIndex;
                return this;
            }

            public Builder groups(List<String> groups) {
                this.groups = groups;
                return this;
            }

            public Builder ipv6AddressCount(Number ipv6AddressCount) {
                this.ipv6AddressCount = ipv6AddressCount;
                return this;
            }

            public Builder ipv6Addresses(IResolvable ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            public Builder ipv6Addresses(List<Object> ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            public Builder networkInterfaceId(String networkInterfaceId) {
                this.networkInterfaceId = networkInterfaceId;
                return this;
            }

            public Builder privateIpAddresses(IResolvable privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            public Builder privateIpAddresses(List<Object> privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            public Builder secondaryPrivateIpAddressCount(Number secondaryPrivateIpAddressCount) {
                this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
                return this;
            }

            public Builder subnetId(String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            public InstanceNetworkInterfaceSpecificationProperty build() {
                return new Jsii.Proxy(this.associatePublicIpAddress, this.deleteOnTermination, this.description, this.deviceIndex, this.groups, this.ipv6AddressCount, this.ipv6Addresses, this.networkInterfaceId, this.privateIpAddresses, this.secondaryPrivateIpAddressCount, this.subnetId, null);
            }
        }
    }

    public static interface InstanceIpv6AddressProperty
    extends JsiiSerializable {
        public String getIpv6Address();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String ipv6Address;

            public Builder ipv6Address(String ipv6Address) {
                this.ipv6Address = ipv6Address;
                return this;
            }

            public InstanceIpv6AddressProperty build() {
                return new Jsii.Proxy(this.ipv6Address, null);
            }
        }
    }

    public static interface IamInstanceProfileSpecificationProperty
    extends JsiiSerializable {
        public String getArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String arn;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public IamInstanceProfileSpecificationProperty build() {
                return new Jsii.Proxy(this.arn, null);
            }
        }
    }

    public static interface GroupIdentifierProperty
    extends JsiiSerializable {
        public String getGroupId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String groupId;

            public Builder groupId(String groupId) {
                this.groupId = groupId;
                return this;
            }

            public GroupIdentifierProperty build() {
                return new Jsii.Proxy(this.groupId, null);
            }
        }
    }

    public static interface FleetLaunchTemplateSpecificationProperty
    extends JsiiSerializable {
        public String getVersion();

        public String getLaunchTemplateId();

        public String getLaunchTemplateName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String version;
            private String launchTemplateId;
            private String launchTemplateName;

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public Builder launchTemplateId(String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            public Builder launchTemplateName(String launchTemplateName) {
                this.launchTemplateName = launchTemplateName;
                return this;
            }

            public FleetLaunchTemplateSpecificationProperty build() {
                return new Jsii.Proxy(this.version, this.launchTemplateId, this.launchTemplateName, null);
            }
        }
    }

    public static interface EbsBlockDeviceProperty
    extends JsiiSerializable {
        public Object getDeleteOnTermination();

        public Object getEncrypted();

        public Number getIops();

        public String getSnapshotId();

        public Number getVolumeSize();

        public String getVolumeType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object deleteOnTermination;
            private Object encrypted;
            private Number iops;
            private String snapshotId;
            private Number volumeSize;
            private String volumeType;

            public Builder deleteOnTermination(Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder deleteOnTermination(IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder encrypted(Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            public Builder encrypted(IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            public Builder iops(Number iops) {
                this.iops = iops;
                return this;
            }

            public Builder snapshotId(String snapshotId) {
                this.snapshotId = snapshotId;
                return this;
            }

            public Builder volumeSize(Number volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            public Builder volumeType(String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            public EbsBlockDeviceProperty build() {
                return new Jsii.Proxy(this.deleteOnTermination, this.encrypted, this.iops, this.snapshotId, this.volumeSize, this.volumeType, null);
            }
        }
    }

    public static interface ClassicLoadBalancersConfigProperty
    extends JsiiSerializable {
        public Object getClassicLoadBalancers();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object classicLoadBalancers;

            public Builder classicLoadBalancers(IResolvable classicLoadBalancers) {
                this.classicLoadBalancers = classicLoadBalancers;
                return this;
            }

            public Builder classicLoadBalancers(List<Object> classicLoadBalancers) {
                this.classicLoadBalancers = classicLoadBalancers;
                return this;
            }

            public ClassicLoadBalancersConfigProperty build() {
                return new Jsii.Proxy(this.classicLoadBalancers, null);
            }
        }
    }

    public static interface ClassicLoadBalancerProperty
    extends JsiiSerializable {
        public String getName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public ClassicLoadBalancerProperty build() {
                return new Jsii.Proxy(this.name, null);
            }
        }
    }

    public static interface BlockDeviceMappingProperty
    extends JsiiSerializable {
        public String getDeviceName();

        public Object getEbs();

        public String getNoDevice();

        public String getVirtualName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String deviceName;
            private Object ebs;
            private String noDevice;
            private String virtualName;

            public Builder deviceName(String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            public Builder ebs(IResolvable ebs) {
                this.ebs = ebs;
                return this;
            }

            public Builder ebs(EbsBlockDeviceProperty ebs) {
                this.ebs = ebs;
                return this;
            }

            public Builder noDevice(String noDevice) {
                this.noDevice = noDevice;
                return this;
            }

            public Builder virtualName(String virtualName) {
                this.virtualName = virtualName;
                return this;
            }

            public BlockDeviceMappingProperty build() {
                return new Jsii.Proxy(this.deviceName, this.ebs, this.noDevice, this.virtualName, null);
            }
        }
    }
}

