/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import software.amazon.awscdk.services.ec2.AclCidr;
import software.amazon.awscdk.services.ec2.AclTraffic;
import software.amazon.awscdk.services.ec2.Action;
import software.amazon.awscdk.services.ec2.CommonNetworkAclEntryOptions;
import software.amazon.awscdk.services.ec2.TrafficDirection;
import software.amazon.jsii.JsiiSerializable;

public interface CommonNetworkAclEntryOptions
extends JsiiSerializable {
    public AclCidr getCidr();

    public Number getRuleNumber();

    public AclTraffic getTraffic();

    public TrafficDirection getDirection();

    public String getNetworkAclEntryName();

    public Action getRuleAction();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AclCidr cidr;
        private Number ruleNumber;
        private AclTraffic traffic;
        private TrafficDirection direction;
        private String networkAclEntryName;
        private Action ruleAction;

        public Builder cidr(AclCidr cidr) {
            this.cidr = cidr;
            return this;
        }

        public Builder ruleNumber(Number ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public Builder traffic(AclTraffic traffic) {
            this.traffic = traffic;
            return this;
        }

        public Builder direction(TrafficDirection direction) {
            this.direction = direction;
            return this;
        }

        public Builder networkAclEntryName(String networkAclEntryName) {
            this.networkAclEntryName = networkAclEntryName;
            return this;
        }

        public Builder ruleAction(Action ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        public CommonNetworkAclEntryOptions build() {
            return new Jsii.Proxy(this.cidr, this.ruleNumber, this.traffic, this.direction, this.networkAclEntryName, this.ruleAction, null);
        }
    }
}

