package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation-init configuration.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.35.0 (build 6ebef96)", date = "2021-10-05T13:29:04.722Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CloudFormationInit")
public class CloudFormationInit extends software.amazon.jsii.JsiiObject {

    protected CloudFormationInit(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudFormationInit(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Use an existing InitConfig object as the default and only config.
     * <p>
     * @param config This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CloudFormationInit fromConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitConfig config) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.CloudFormationInit.class, "fromConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.CloudFormationInit.class), new Object[] { java.util.Objects.requireNonNull(config, "config is required") });
    }

    /**
     * Build a CloudFormationInit from config sets.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CloudFormationInit fromConfigSets(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ConfigSetProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.CloudFormationInit.class, "fromConfigSets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.CloudFormationInit.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Build a new config from a set of Init Elements.
     * <p>
     * @param elements This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CloudFormationInit fromElements(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitElement... elements) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.CloudFormationInit.class, "fromElements", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.CloudFormationInit.class), java.util.Arrays.<Object>stream(elements).toArray(Object[]::new));
    }

    /**
     * Add a config with the given name to this CloudFormationInit object.
     * <p>
     * @param configName This parameter is required.
     * @param config This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addConfig(final @org.jetbrains.annotations.NotNull java.lang.String configName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitConfig config) {
        software.amazon.jsii.Kernel.call(this, "addConfig", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(configName, "configName is required"), java.util.Objects.requireNonNull(config, "config is required") });
    }

    /**
     * Add a config set with the given name to this CloudFormationInit object.
     * <p>
     * The new configset will reference the given configs in the given order.
     * <p>
     * @param configSetName This parameter is required.
     * @param configNames
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addConfigSet(final @org.jetbrains.annotations.NotNull java.lang.String configSetName, final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> configNames) {
        software.amazon.jsii.Kernel.call(this, "addConfigSet", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(configSetName, "configSetName is required"), configNames });
    }

    /**
     * Add a config set with the given name to this CloudFormationInit object.
     * <p>
     * The new configset will reference the given configs in the given order.
     * <p>
     * @param configSetName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addConfigSet(final @org.jetbrains.annotations.NotNull java.lang.String configSetName) {
        software.amazon.jsii.Kernel.call(this, "addConfigSet", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(configSetName, "configSetName is required") });
    }

    /**
     * Attach the CloudFormation Init config to the given resource.
     * <p>
     * As an app builder, use <code>instance.applyCloudFormationInit()</code> or
     * <code>autoScalingGroup.applyCloudFormationInit()</code> to trigger this method.
     * <p>
     * This method does the following:
     * <p>
     * <ul>
     * <li>Renders the <code>AWS::CloudFormation::Init</code> object to the given resource's
     * metadata, potentially adding a <code>AWS::CloudFormation::Authentication</code> object
     * next to it if required.</li>
     * <li>Updates the instance role policy to be able to call the APIs required for
     * <code>cfn-init</code> and <code>cfn-signal</code> to work, and potentially add permissions to download
     * referenced asset and bucket resources.</li>
     * <li>Updates the given UserData with commands to execute the <code>cfn-init</code> script.</li>
     * </ul>
     * <p>
     * @param attachedResource This parameter is required.
     * @param attachOptions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void attach(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnResource attachedResource, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.AttachInitOptions attachOptions) {
        software.amazon.jsii.Kernel.call(this, "attach", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(attachedResource, "attachedResource is required"), java.util.Objects.requireNonNull(attachOptions, "attachOptions is required") });
    }
}
