package software.amazon.awscdk.services.ec2;

/**
 * This represents an EC2 LaunchTemplate.
 * <p>
 * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.39.0 (build 8af72c2)", date = "2021-10-14T05:49:00.094Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.LaunchTemplate")
public class LaunchTemplate extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.ec2.ILaunchTemplate, software.amazon.awscdk.services.iam.IGrantable, software.amazon.awscdk.services.ec2.IConnectable {

    protected LaunchTemplate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LaunchTemplate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LaunchTemplate(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.LaunchTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LaunchTemplate(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing LaunchTemplate.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ILaunchTemplate fromLaunchTemplateAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.LaunchTemplateAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.LaunchTemplate.class, "fromLaunchTemplateAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ILaunchTemplate.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Allows specifying security group connections for the instance.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * The default version for the launch template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDefaultVersionNumber() {
        return software.amazon.jsii.Kernel.get(this, "defaultVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * The latest version of the launch template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLatestVersionNumber() {
        return software.amazon.jsii.Kernel.get(this, "latestVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * TagManager for tagging support.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The version number of this launch template to use.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVersionNumber() {
        return software.amazon.jsii.Kernel.get(this, "versionNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the Launch Template.
     * <p>
     * Exactly one of <code>launchTemplateId</code> and <code>launchTemplateName</code> will be set.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateId() {
        return software.amazon.jsii.Kernel.get(this, "launchTemplateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Launch Template.
     * <p>
     * Exactly one of <code>launchTemplateId</code> and <code>launchTemplateName</code> will be set.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateName() {
        return software.amazon.jsii.Kernel.get(this, "launchTemplateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of OS the instance is running.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.OperatingSystemType getOsType() {
        return software.amazon.jsii.Kernel.get(this, "osType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.OperatingSystemType.class));
    }

    /**
     * IAM Role assumed by instances that are launched from this template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * UserData executed by instances that are launched from this template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.UserData getUserData() {
        return software.amazon.jsii.Kernel.get(this, "userData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.UserData.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.LaunchTemplate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.LaunchTemplate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ec2.LaunchTemplateProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
         * <p>
         * Each instance that is launched has an associated root device volume,
         * either an Amazon EBS volume or an instance store volume.
         * You can use block device mappings to specify additional EBS volumes or
         * instance store volumes to attach to an instance when it is launched.
         * <p>
         * Default: - Uses the block device mapping of the AMI
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html
         * @param blockDevices Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockDevices(final java.util.List<? extends software.amazon.awscdk.services.ec2.BlockDevice> blockDevices) {
            this.props().blockDevices(blockDevices);
            return this;
        }

        /**
         * CPU credit type for burstable EC2 instance types.
         * <p>
         * Default: - No credit type is specified in the Launch Template.
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html
         * @param cpuCredits CPU credit type for burstable EC2 instance types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpuCredits(final software.amazon.awscdk.services.ec2.CpuCredits cpuCredits) {
            this.props().cpuCredits(cpuCredits);
            return this;
        }

        /**
         * If set to true, then detailed monitoring will be enabled on instances created with this launch template.
         * <p>
         * Default: False - Detailed monitoring is disabled.
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch-new.html
         * @param detailedMonitoring If set to true, then detailed monitoring will be enabled on instances created with this launch template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detailedMonitoring(final java.lang.Boolean detailedMonitoring) {
            this.props().detailedMonitoring(detailedMonitoring);
            return this;
        }

        /**
         * If you set this parameter to true, you cannot terminate the instances launched with this launch template using the Amazon EC2 console, CLI, or API;
         * <p>
         * otherwise, you can.
         * <p>
         * Default: - The API termination setting is not specified in the Launch Template.
         * <p>
         * @return {@code this}
         * @param disableApiTermination If you set this parameter to true, you cannot terminate the instances launched with this launch template using the Amazon EC2 console, CLI, or API;. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableApiTermination(final java.lang.Boolean disableApiTermination) {
            this.props().disableApiTermination(disableApiTermination);
            return this;
        }

        /**
         * Indicates whether the instances are optimized for Amazon EBS I/O.
         * <p>
         * This optimization provides dedicated throughput
         * to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization
         * isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
         * <p>
         * Default: - EBS optimization is not specified in the launch template.
         * <p>
         * @return {@code this}
         * @param ebsOptimized Indicates whether the instances are optimized for Amazon EBS I/O. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptimized(final java.lang.Boolean ebsOptimized) {
            this.props().ebsOptimized(ebsOptimized);
            return this;
        }

        /**
         * If you set this parameter to true, the instance is enabled for hibernation.
         * <p>
         * Default: - Hibernation configuration is not specified in the launch template; defaulting to false.
         * <p>
         * @return {@code this}
         * @param hibernationConfigured If you set this parameter to true, the instance is enabled for hibernation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hibernationConfigured(final java.lang.Boolean hibernationConfigured) {
            this.props().hibernationConfigured(hibernationConfigured);
            return this;
        }

        /**
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
         * <p>
         * Default: - Shutdown behavior is not specified in the launch template; defaults to STOP.
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior
         * @param instanceInitiatedShutdownBehavior Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceInitiatedShutdownBehavior(final software.amazon.awscdk.services.ec2.InstanceInitiatedShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.props().instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior);
            return this;
        }

        /**
         * Type of instance to launch.
         * <p>
         * Default: - This Launch Template does not specify a default Instance Type.
         * <p>
         * @return {@code this}
         * @param instanceType Type of instance to launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(final software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.props().instanceType(instanceType);
            return this;
        }

        /**
         * Name of SSH keypair to grant access to instance.
         * <p>
         * Default: - No SSH access will be possible.
         * <p>
         * @return {@code this}
         * @param keyName Name of SSH keypair to grant access to instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyName(final java.lang.String keyName) {
            this.props().keyName(keyName);
            return this;
        }

        /**
         * Name for this launch template.
         * <p>
         * Default: Automatically generated name
         * <p>
         * @return {@code this}
         * @param launchTemplateName Name for this launch template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplateName(final java.lang.String launchTemplateName) {
            this.props().launchTemplateName(launchTemplateName);
            return this;
        }

        /**
         * The AMI that will be used by instances.
         * <p>
         * Default: - This Launch Template does not specify a default AMI.
         * <p>
         * @return {@code this}
         * @param machineImage The AMI that will be used by instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder machineImage(final software.amazon.awscdk.services.ec2.IMachineImage machineImage) {
            this.props().machineImage(machineImage);
            return this;
        }

        /**
         * If this parameter is set to true, the instance is enabled for AWS Nitro Enclaves;
         * <p>
         * otherwise, it is not enabled for AWS Nitro Enclaves.
         * <p>
         * Default: - Enablement of Nitro enclaves is not specified in the launch template; defaulting to false.
         * <p>
         * @return {@code this}
         * @param nitroEnclaveEnabled If this parameter is set to true, the instance is enabled for AWS Nitro Enclaves;. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nitroEnclaveEnabled(final java.lang.Boolean nitroEnclaveEnabled) {
            this.props().nitroEnclaveEnabled(nitroEnclaveEnabled);
            return this;
        }

        /**
         * An IAM role to associate with the instance profile that is used by instances.
         * <p>
         * The role must be assumable by the service principal <code>ec2.amazonaws.com</code>:
         * <p>
         * Default: - No new role is created.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated. See https://github.com/aws/jsii/issues/826
         * Role role = new Role(this, "MyRole", new RoleProps()
         *         .assumedBy(new ServicePrincipal("ec2.amazonaws.com")));}</pre></blockquote>
         * <p>
         * @return {@code this}
         * @param role An IAM role to associate with the instance profile that is used by instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props().role(role);
            return this;
        }

        /**
         * Security group to assign to instances created with the launch template.
         * <p>
         * Default: No security group is assigned.
         * <p>
         * @return {@code this}
         * @param securityGroup Security group to assign to instances created with the launch template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props().securityGroup(securityGroup);
            return this;
        }

        /**
         * If this property is defined, then the Launch Template's InstanceMarketOptions will be set to use Spot instances, and the options for the Spot instances will be as defined.
         * <p>
         * Default: - Instance launched with this template will not be spot instances.
         * <p>
         * @return {@code this}
         * @param spotOptions If this property is defined, then the Launch Template's InstanceMarketOptions will be set to use Spot instances, and the options for the Spot instances will be as defined. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotOptions(final software.amazon.awscdk.services.ec2.LaunchTemplateSpotOptions spotOptions) {
            this.props().spotOptions(spotOptions);
            return this;
        }

        /**
         * The AMI that will be used by instances.
         * <p>
         * Default: - This Launch Template creates a UserData based on the type of provided
         * machineImage; no UserData is created if a machineImage is not provided
         * <p>
         * @return {@code this}
         * @param userData The AMI that will be used by instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(final software.amazon.awscdk.services.ec2.UserData userData) {
            this.props().userData(userData);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.LaunchTemplate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.LaunchTemplate build() {
            return new software.amazon.awscdk.services.ec2.LaunchTemplate(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.LaunchTemplateProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.LaunchTemplateProps.Builder();
            }
            return this.props;
        }
    }
}
