package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::VolumeAttachment`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T12:29:50.323Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnVolumeAttachmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::VolumeAttachment.Device`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-device
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDevice();

    /**
     * `AWS::EC2::VolumeAttachment.InstanceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-instanceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getInstanceId();

    /**
     * `AWS::EC2::VolumeAttachment.VolumeId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-volumeid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getVolumeId();

    /**
     * @return a {@link Builder} of {@link CfnVolumeAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVolumeAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String device;
        private java.lang.String instanceId;
        private java.lang.String volumeId;

        /**
         * Sets the value of Device
         * @param device `AWS::EC2::VolumeAttachment.Device`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder device(java.lang.String device) {
            this.device = device;
            return this;
        }

        /**
         * Sets the value of InstanceId
         * @param instanceId `AWS::EC2::VolumeAttachment.InstanceId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder instanceId(java.lang.String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        /**
         * Sets the value of VolumeId
         * @param volumeId `AWS::EC2::VolumeAttachment.VolumeId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder volumeId(java.lang.String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVolumeAttachmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnVolumeAttachmentProps build() {
            return new Jsii$Proxy(device, instanceId, volumeId);
        }
    }

    /**
     * An implementation for {@link CfnVolumeAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVolumeAttachmentProps {
        private final java.lang.String device;
        private final java.lang.String instanceId;
        private final java.lang.String volumeId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.device = this.jsiiGet("device", java.lang.String.class);
            this.instanceId = this.jsiiGet("instanceId", java.lang.String.class);
            this.volumeId = this.jsiiGet("volumeId", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String device, java.lang.String instanceId, java.lang.String volumeId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.device = java.util.Objects.requireNonNull(device, "device is required");
            this.instanceId = java.util.Objects.requireNonNull(instanceId, "instanceId is required");
            this.volumeId = java.util.Objects.requireNonNull(volumeId, "volumeId is required");
        }

        @Override
        public java.lang.String getDevice() {
            return this.device;
        }

        @Override
        public java.lang.String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public java.lang.String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("device", om.valueToTree(this.getDevice()));
            obj.set("instanceId", om.valueToTree(this.getInstanceId()));
            obj.set("volumeId", om.valueToTree(this.getVolumeId()));
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVolumeAttachmentProps.Jsii$Proxy that = (CfnVolumeAttachmentProps.Jsii$Proxy) o;

            if (!device.equals(that.device)) return false;
            if (!instanceId.equals(that.instanceId)) return false;
            return this.volumeId.equals(that.volumeId);
        }

        @Override
        public int hashCode() {
            int result = this.device.hashCode();
            result = 31 * result + (this.instanceId.hashCode());
            result = 31 * result + (this.volumeId.hashCode());
            return result;
        }
    }
}
