package software.amazon.awscdk.services.ec2;

/**
 * Properties to intialize a new Connections object.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T12:29:50.326Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ConnectionsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Default port range for initiating connections to and from this object.
     * 
     * Default: - No default port
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.Port getDefaultPort();

    /**
     * Class that represents the rule by which others can connect to this connectable.
     * 
     * This object is required, but will be derived from securityGroup if that is passed.
     * 
     * Default: Derived from securityGroup if set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.IPeer getPeer();

    /**
     * What securityGroup(s) this object is managing connections for.
     * 
     * Default: No security groups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups();

    /**
     * @return a {@link Builder} of {@link ConnectionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ConnectionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.ec2.Port defaultPort;
        private software.amazon.awscdk.services.ec2.IPeer peer;
        private java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;

        /**
         * Sets the value of DefaultPort
         * @param defaultPort Default port range for initiating connections to and from this object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultPort(software.amazon.awscdk.services.ec2.Port defaultPort) {
            this.defaultPort = defaultPort;
            return this;
        }

        /**
         * Sets the value of Peer
         * @param peer Class that represents the rule by which others can connect to this connectable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder peer(software.amazon.awscdk.services.ec2.IPeer peer) {
            this.peer = peer;
            return this;
        }

        /**
         * Sets the value of SecurityGroups
         * @param securityGroups What securityGroup(s) this object is managing connections for.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConnectionsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ConnectionsProps build() {
            return new Jsii$Proxy(defaultPort, peer, securityGroups);
        }
    }

    /**
     * An implementation for {@link ConnectionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectionsProps {
        private final software.amazon.awscdk.services.ec2.Port defaultPort;
        private final software.amazon.awscdk.services.ec2.IPeer peer;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.defaultPort = this.jsiiGet("defaultPort", software.amazon.awscdk.services.ec2.Port.class);
            this.peer = this.jsiiGet("peer", software.amazon.awscdk.services.ec2.IPeer.class);
            this.securityGroups = this.jsiiGet("securityGroups", java.util.List.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.services.ec2.Port defaultPort, software.amazon.awscdk.services.ec2.IPeer peer, java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.defaultPort = defaultPort;
            this.peer = peer;
            this.securityGroups = securityGroups;
        }

        @Override
        public software.amazon.awscdk.services.ec2.Port getDefaultPort() {
            return this.defaultPort;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IPeer getPeer() {
            return this.peer;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getDefaultPort() != null) {
                obj.set("defaultPort", om.valueToTree(this.getDefaultPort()));
            }
            if (this.getPeer() != null) {
                obj.set("peer", om.valueToTree(this.getPeer()));
            }
            if (this.getSecurityGroups() != null) {
                obj.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ConnectionsProps.Jsii$Proxy that = (ConnectionsProps.Jsii$Proxy) o;

            if (this.defaultPort != null ? !this.defaultPort.equals(that.defaultPort) : that.defaultPort != null) return false;
            if (this.peer != null ? !this.peer.equals(that.peer) : that.peer != null) return false;
            return this.securityGroups != null ? this.securityGroups.equals(that.securityGroups) : that.securityGroups == null;
        }

        @Override
        public int hashCode() {
            int result = this.defaultPort != null ? this.defaultPort.hashCode() : 0;
            result = 31 * result + (this.peer != null ? this.peer.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            return result;
        }
    }
}
