package software.amazon.awscdk.services.ec2;

/**
 * Options to add an interface endpoint to a VPC.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T12:29:50.345Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InterfaceVpcEndpointOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The service to use for this interface VPC endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService getService();

    /**
     * Whether to associate a private hosted zone with the specified VPC.
     * 
     * This
     * allows you to make requests to the service using its default DNS hostname.
     * 
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getPrivateDnsEnabled();

    /**
     * The subnets in which to create an endpoint network interface.
     * 
     * At most one
     * per availability zone.
     * 
     * Default: private subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.SubnetSelection getSubnets();

    /**
     * @return a {@link Builder} of {@link InterfaceVpcEndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InterfaceVpcEndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService service;
        private java.lang.Boolean privateDnsEnabled;
        private software.amazon.awscdk.services.ec2.SubnetSelection subnets;

        /**
         * Sets the value of Service
         * @param service The service to use for this interface VPC endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService service) {
            this.service = service;
            return this;
        }

        /**
         * Sets the value of PrivateDnsEnabled
         * @param privateDnsEnabled Whether to associate a private hosted zone with the specified VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateDnsEnabled(java.lang.Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        /**
         * Sets the value of Subnets
         * @param subnets The subnets in which to create an endpoint network interface.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnets(software.amazon.awscdk.services.ec2.SubnetSelection subnets) {
            this.subnets = subnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InterfaceVpcEndpointOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public InterfaceVpcEndpointOptions build() {
            return new Jsii$Proxy(service, privateDnsEnabled, subnets);
        }
    }

    /**
     * An implementation for {@link InterfaceVpcEndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InterfaceVpcEndpointOptions {
        private final software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService service;
        private final java.lang.Boolean privateDnsEnabled;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.service = this.jsiiGet("service", software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService.class);
            this.privateDnsEnabled = this.jsiiGet("privateDnsEnabled", java.lang.Boolean.class);
            this.subnets = this.jsiiGet("subnets", software.amazon.awscdk.services.ec2.SubnetSelection.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService service, java.lang.Boolean privateDnsEnabled, software.amazon.awscdk.services.ec2.SubnetSelection subnets) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.service = java.util.Objects.requireNonNull(service, "service is required");
            this.privateDnsEnabled = privateDnsEnabled;
            this.subnets = subnets;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService getService() {
            return this.service;
        }

        @Override
        public java.lang.Boolean getPrivateDnsEnabled() {
            return this.privateDnsEnabled;
        }

        @Override
        public software.amazon.awscdk.services.ec2.SubnetSelection getSubnets() {
            return this.subnets;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("service", om.valueToTree(this.getService()));
            if (this.getPrivateDnsEnabled() != null) {
                obj.set("privateDnsEnabled", om.valueToTree(this.getPrivateDnsEnabled()));
            }
            if (this.getSubnets() != null) {
                obj.set("subnets", om.valueToTree(this.getSubnets()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InterfaceVpcEndpointOptions.Jsii$Proxy that = (InterfaceVpcEndpointOptions.Jsii$Proxy) o;

            if (!service.equals(that.service)) return false;
            if (this.privateDnsEnabled != null ? !this.privateDnsEnabled.equals(that.privateDnsEnabled) : that.privateDnsEnabled != null) return false;
            return this.subnets != null ? this.subnets.equals(that.subnets) : that.subnets == null;
        }

        @Override
        public int hashCode() {
            int result = this.service.hashCode();
            result = 31 * result + (this.privateDnsEnabled != null ? this.privateDnsEnabled.hashCode() : 0);
            result = 31 * result + (this.subnets != null ? this.subnets.hashCode() : 0);
            return result;
        }
    }
}
