package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::ClientVpnEndpoint`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T19:55:07.779Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnClientVpnEndpointProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::ClientVpnEndpoint.AuthenticationOptions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-authenticationoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getAuthenticationOptions();

    /**
     * `AWS::EC2::ClientVpnEndpoint.ClientCidrBlock`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-clientcidrblock
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getClientCidrBlock();

    /**
     * `AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-connectionlogoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getConnectionLogOptions();

    /**
     * `AWS::EC2::ClientVpnEndpoint.ServerCertificateArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-servercertificatearn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getServerCertificateArn();

    /**
     * `AWS::EC2::ClientVpnEndpoint.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDescription();

    /**
     * `AWS::EC2::ClientVpnEndpoint.DnsServers`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-dnsservers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<java.lang.String> getDnsServers();

    /**
     * `AWS::EC2::ClientVpnEndpoint.SplitTunnel`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-splittunnel
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getSplitTunnel();

    /**
     * `AWS::EC2::ClientVpnEndpoint.TagSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-tagspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getTagSpecifications();

    /**
     * `AWS::EC2::ClientVpnEndpoint.TransportProtocol`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-transportprotocol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getTransportProtocol();

    /**
     * @return a {@link Builder} of {@link CfnClientVpnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnClientVpnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.Object authenticationOptions;
        private java.lang.String clientCidrBlock;
        private java.lang.Object connectionLogOptions;
        private java.lang.String serverCertificateArn;
        private java.lang.String description;
        private java.util.List<java.lang.String> dnsServers;
        private java.lang.Object splitTunnel;
        private java.lang.Object tagSpecifications;
        private java.lang.String transportProtocol;

        /**
         * Sets the value of AuthenticationOptions
         * @param authenticationOptions `AWS::EC2::ClientVpnEndpoint.AuthenticationOptions`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder authenticationOptions(software.amazon.awscdk.core.IResolvable authenticationOptions) {
            this.authenticationOptions = authenticationOptions;
            return this;
        }

        /**
         * Sets the value of AuthenticationOptions
         * @param authenticationOptions `AWS::EC2::ClientVpnEndpoint.AuthenticationOptions`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder authenticationOptions(java.util.List<java.lang.Object> authenticationOptions) {
            this.authenticationOptions = authenticationOptions;
            return this;
        }

        /**
         * Sets the value of ClientCidrBlock
         * @param clientCidrBlock `AWS::EC2::ClientVpnEndpoint.ClientCidrBlock`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder clientCidrBlock(java.lang.String clientCidrBlock) {
            this.clientCidrBlock = clientCidrBlock;
            return this;
        }

        /**
         * Sets the value of ConnectionLogOptions
         * @param connectionLogOptions `AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder connectionLogOptions(software.amazon.awscdk.core.IResolvable connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions;
            return this;
        }

        /**
         * Sets the value of ConnectionLogOptions
         * @param connectionLogOptions `AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder connectionLogOptions(software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.ConnectionLogOptionsProperty connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions;
            return this;
        }

        /**
         * Sets the value of ServerCertificateArn
         * @param serverCertificateArn `AWS::EC2::ClientVpnEndpoint.ServerCertificateArn`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder serverCertificateArn(java.lang.String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
            return this;
        }

        /**
         * Sets the value of Description
         * @param description `AWS::EC2::ClientVpnEndpoint.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of DnsServers
         * @param dnsServers `AWS::EC2::ClientVpnEndpoint.DnsServers`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder dnsServers(java.util.List<java.lang.String> dnsServers) {
            this.dnsServers = dnsServers;
            return this;
        }

        /**
         * Sets the value of SplitTunnel
         * @param splitTunnel `AWS::EC2::ClientVpnEndpoint.SplitTunnel`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder splitTunnel(java.lang.Boolean splitTunnel) {
            this.splitTunnel = splitTunnel;
            return this;
        }

        /**
         * Sets the value of SplitTunnel
         * @param splitTunnel `AWS::EC2::ClientVpnEndpoint.SplitTunnel`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder splitTunnel(software.amazon.awscdk.core.IResolvable splitTunnel) {
            this.splitTunnel = splitTunnel;
            return this;
        }

        /**
         * Sets the value of TagSpecifications
         * @param tagSpecifications `AWS::EC2::ClientVpnEndpoint.TagSpecifications`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tagSpecifications(software.amazon.awscdk.core.IResolvable tagSpecifications) {
            this.tagSpecifications = tagSpecifications;
            return this;
        }

        /**
         * Sets the value of TagSpecifications
         * @param tagSpecifications `AWS::EC2::ClientVpnEndpoint.TagSpecifications`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tagSpecifications(java.util.List<java.lang.Object> tagSpecifications) {
            this.tagSpecifications = tagSpecifications;
            return this;
        }

        /**
         * Sets the value of TransportProtocol
         * @param transportProtocol `AWS::EC2::ClientVpnEndpoint.TransportProtocol`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder transportProtocol(java.lang.String transportProtocol) {
            this.transportProtocol = transportProtocol;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnClientVpnEndpointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnClientVpnEndpointProps build() {
            return new Jsii$Proxy(authenticationOptions, clientCidrBlock, connectionLogOptions, serverCertificateArn, description, dnsServers, splitTunnel, tagSpecifications, transportProtocol);
        }
    }

    /**
     * An implementation for {@link CfnClientVpnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnClientVpnEndpointProps {
        private final java.lang.Object authenticationOptions;
        private final java.lang.String clientCidrBlock;
        private final java.lang.Object connectionLogOptions;
        private final java.lang.String serverCertificateArn;
        private final java.lang.String description;
        private final java.util.List<java.lang.String> dnsServers;
        private final java.lang.Object splitTunnel;
        private final java.lang.Object tagSpecifications;
        private final java.lang.String transportProtocol;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.authenticationOptions = this.jsiiGet("authenticationOptions", java.lang.Object.class);
            this.clientCidrBlock = this.jsiiGet("clientCidrBlock", java.lang.String.class);
            this.connectionLogOptions = this.jsiiGet("connectionLogOptions", java.lang.Object.class);
            this.serverCertificateArn = this.jsiiGet("serverCertificateArn", java.lang.String.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.dnsServers = this.jsiiGet("dnsServers", java.util.List.class);
            this.splitTunnel = this.jsiiGet("splitTunnel", java.lang.Object.class);
            this.tagSpecifications = this.jsiiGet("tagSpecifications", java.lang.Object.class);
            this.transportProtocol = this.jsiiGet("transportProtocol", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Object authenticationOptions, java.lang.String clientCidrBlock, java.lang.Object connectionLogOptions, java.lang.String serverCertificateArn, java.lang.String description, java.util.List<java.lang.String> dnsServers, java.lang.Object splitTunnel, java.lang.Object tagSpecifications, java.lang.String transportProtocol) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authenticationOptions = java.util.Objects.requireNonNull(authenticationOptions, "authenticationOptions is required");
            this.clientCidrBlock = java.util.Objects.requireNonNull(clientCidrBlock, "clientCidrBlock is required");
            this.connectionLogOptions = java.util.Objects.requireNonNull(connectionLogOptions, "connectionLogOptions is required");
            this.serverCertificateArn = java.util.Objects.requireNonNull(serverCertificateArn, "serverCertificateArn is required");
            this.description = description;
            this.dnsServers = dnsServers;
            this.splitTunnel = splitTunnel;
            this.tagSpecifications = tagSpecifications;
            this.transportProtocol = transportProtocol;
        }

        @Override
        public java.lang.Object getAuthenticationOptions() {
            return this.authenticationOptions;
        }

        @Override
        public java.lang.String getClientCidrBlock() {
            return this.clientCidrBlock;
        }

        @Override
        public java.lang.Object getConnectionLogOptions() {
            return this.connectionLogOptions;
        }

        @Override
        public java.lang.String getServerCertificateArn() {
            return this.serverCertificateArn;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.util.List<java.lang.String> getDnsServers() {
            return this.dnsServers;
        }

        @Override
        public java.lang.Object getSplitTunnel() {
            return this.splitTunnel;
        }

        @Override
        public java.lang.Object getTagSpecifications() {
            return this.tagSpecifications;
        }

        @Override
        public java.lang.String getTransportProtocol() {
            return this.transportProtocol;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("authenticationOptions", om.valueToTree(this.getAuthenticationOptions()));
            obj.set("clientCidrBlock", om.valueToTree(this.getClientCidrBlock()));
            obj.set("connectionLogOptions", om.valueToTree(this.getConnectionLogOptions()));
            obj.set("serverCertificateArn", om.valueToTree(this.getServerCertificateArn()));
            if (this.getDescription() != null) {
                obj.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDnsServers() != null) {
                obj.set("dnsServers", om.valueToTree(this.getDnsServers()));
            }
            if (this.getSplitTunnel() != null) {
                obj.set("splitTunnel", om.valueToTree(this.getSplitTunnel()));
            }
            if (this.getTagSpecifications() != null) {
                obj.set("tagSpecifications", om.valueToTree(this.getTagSpecifications()));
            }
            if (this.getTransportProtocol() != null) {
                obj.set("transportProtocol", om.valueToTree(this.getTransportProtocol()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnClientVpnEndpointProps.Jsii$Proxy that = (CfnClientVpnEndpointProps.Jsii$Proxy) o;

            if (!authenticationOptions.equals(that.authenticationOptions)) return false;
            if (!clientCidrBlock.equals(that.clientCidrBlock)) return false;
            if (!connectionLogOptions.equals(that.connectionLogOptions)) return false;
            if (!serverCertificateArn.equals(that.serverCertificateArn)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.dnsServers != null ? !this.dnsServers.equals(that.dnsServers) : that.dnsServers != null) return false;
            if (this.splitTunnel != null ? !this.splitTunnel.equals(that.splitTunnel) : that.splitTunnel != null) return false;
            if (this.tagSpecifications != null ? !this.tagSpecifications.equals(that.tagSpecifications) : that.tagSpecifications != null) return false;
            return this.transportProtocol != null ? this.transportProtocol.equals(that.transportProtocol) : that.transportProtocol == null;
        }

        @Override
        public int hashCode() {
            int result = this.authenticationOptions.hashCode();
            result = 31 * result + (this.clientCidrBlock.hashCode());
            result = 31 * result + (this.connectionLogOptions.hashCode());
            result = 31 * result + (this.serverCertificateArn.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.dnsServers != null ? this.dnsServers.hashCode() : 0);
            result = 31 * result + (this.splitTunnel != null ? this.splitTunnel.hashCode() : 0);
            result = 31 * result + (this.tagSpecifications != null ? this.tagSpecifications.hashCode() : 0);
            result = 31 * result + (this.transportProtocol != null ? this.transportProtocol.hashCode() : 0);
            return result;
        }
    }
}
