package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::VPC`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T19:55:07.866Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnVPCProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::VPC.CidrBlock`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-cidrblock
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getCidrBlock();

    /**
     * `AWS::EC2::VPC.EnableDnsHostnames`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-EnableDnsHostnames
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getEnableDnsHostnames();

    /**
     * `AWS::EC2::VPC.EnableDnsSupport`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-EnableDnsSupport
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getEnableDnsSupport();

    /**
     * `AWS::EC2::VPC.InstanceTenancy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-instancetenancy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getInstanceTenancy();

    /**
     * `AWS::EC2::VPC.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<software.amazon.awscdk.core.CfnTag> getTags();

    /**
     * @return a {@link Builder} of {@link CfnVPCProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVPCProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String cidrBlock;
        private java.lang.Object enableDnsHostnames;
        private java.lang.Object enableDnsSupport;
        private java.lang.String instanceTenancy;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of CidrBlock
         * @param cidrBlock `AWS::EC2::VPC.CidrBlock`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cidrBlock(java.lang.String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        /**
         * Sets the value of EnableDnsHostnames
         * @param enableDnsHostnames `AWS::EC2::VPC.EnableDnsHostnames`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder enableDnsHostnames(java.lang.Boolean enableDnsHostnames) {
            this.enableDnsHostnames = enableDnsHostnames;
            return this;
        }

        /**
         * Sets the value of EnableDnsHostnames
         * @param enableDnsHostnames `AWS::EC2::VPC.EnableDnsHostnames`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder enableDnsHostnames(software.amazon.awscdk.core.IResolvable enableDnsHostnames) {
            this.enableDnsHostnames = enableDnsHostnames;
            return this;
        }

        /**
         * Sets the value of EnableDnsSupport
         * @param enableDnsSupport `AWS::EC2::VPC.EnableDnsSupport`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder enableDnsSupport(java.lang.Boolean enableDnsSupport) {
            this.enableDnsSupport = enableDnsSupport;
            return this;
        }

        /**
         * Sets the value of EnableDnsSupport
         * @param enableDnsSupport `AWS::EC2::VPC.EnableDnsSupport`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder enableDnsSupport(software.amazon.awscdk.core.IResolvable enableDnsSupport) {
            this.enableDnsSupport = enableDnsSupport;
            return this;
        }

        /**
         * Sets the value of InstanceTenancy
         * @param instanceTenancy `AWS::EC2::VPC.InstanceTenancy`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder instanceTenancy(java.lang.String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        /**
         * Sets the value of Tags
         * @param tags `AWS::EC2::VPC.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVPCProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnVPCProps build() {
            return new Jsii$Proxy(cidrBlock, enableDnsHostnames, enableDnsSupport, instanceTenancy, tags);
        }
    }

    /**
     * An implementation for {@link CfnVPCProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVPCProps {
        private final java.lang.String cidrBlock;
        private final java.lang.Object enableDnsHostnames;
        private final java.lang.Object enableDnsSupport;
        private final java.lang.String instanceTenancy;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.cidrBlock = this.jsiiGet("cidrBlock", java.lang.String.class);
            this.enableDnsHostnames = this.jsiiGet("enableDnsHostnames", java.lang.Object.class);
            this.enableDnsSupport = this.jsiiGet("enableDnsSupport", java.lang.Object.class);
            this.instanceTenancy = this.jsiiGet("instanceTenancy", java.lang.String.class);
            this.tags = this.jsiiGet("tags", java.util.List.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String cidrBlock, java.lang.Object enableDnsHostnames, java.lang.Object enableDnsSupport, java.lang.String instanceTenancy, java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cidrBlock = java.util.Objects.requireNonNull(cidrBlock, "cidrBlock is required");
            this.enableDnsHostnames = enableDnsHostnames;
            this.enableDnsSupport = enableDnsSupport;
            this.instanceTenancy = instanceTenancy;
            this.tags = tags;
        }

        @Override
        public java.lang.String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public java.lang.Object getEnableDnsHostnames() {
            return this.enableDnsHostnames;
        }

        @Override
        public java.lang.Object getEnableDnsSupport() {
            return this.enableDnsSupport;
        }

        @Override
        public java.lang.String getInstanceTenancy() {
            return this.instanceTenancy;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("cidrBlock", om.valueToTree(this.getCidrBlock()));
            if (this.getEnableDnsHostnames() != null) {
                obj.set("enableDnsHostnames", om.valueToTree(this.getEnableDnsHostnames()));
            }
            if (this.getEnableDnsSupport() != null) {
                obj.set("enableDnsSupport", om.valueToTree(this.getEnableDnsSupport()));
            }
            if (this.getInstanceTenancy() != null) {
                obj.set("instanceTenancy", om.valueToTree(this.getInstanceTenancy()));
            }
            if (this.getTags() != null) {
                obj.set("tags", om.valueToTree(this.getTags()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVPCProps.Jsii$Proxy that = (CfnVPCProps.Jsii$Proxy) o;

            if (!cidrBlock.equals(that.cidrBlock)) return false;
            if (this.enableDnsHostnames != null ? !this.enableDnsHostnames.equals(that.enableDnsHostnames) : that.enableDnsHostnames != null) return false;
            if (this.enableDnsSupport != null ? !this.enableDnsSupport.equals(that.enableDnsSupport) : that.enableDnsSupport != null) return false;
            if (this.instanceTenancy != null ? !this.instanceTenancy.equals(that.instanceTenancy) : that.instanceTenancy != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public int hashCode() {
            int result = this.cidrBlock.hashCode();
            result = 31 * result + (this.enableDnsHostnames != null ? this.enableDnsHostnames.hashCode() : 0);
            result = 31 * result + (this.enableDnsSupport != null ? this.enableDnsSupport.hashCode() : 0);
            result = 31 * result + (this.instanceTenancy != null ? this.instanceTenancy.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
