package software.amazon.awscdk.services.ec2;

/**
 * Specify configuration parameters for a VPC subnet.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T19:55:07.900Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SubnetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The availability zone for the subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getAvailabilityZone();

    /**
     * The CIDR notation for this subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getCidrBlock();

    /**
     * The VPC which this subnet is part of.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getVpcId();

    /**
     * Controls if a public IP is associated to an instance at launch.
     * 
     * Default: true in Subnet.Public, false in Subnet.Private or Subnet.Isolated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getMapPublicIpOnLaunch();

    /**
     * @return a {@link Builder} of {@link SubnetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SubnetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String availabilityZone;
        private java.lang.String cidrBlock;
        private java.lang.String vpcId;
        private java.lang.Boolean mapPublicIpOnLaunch;

        /**
         * Sets the value of AvailabilityZone
         * @param availabilityZone The availability zone for the subnet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of CidrBlock
         * @param cidrBlock The CIDR notation for this subnet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrBlock(java.lang.String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        /**
         * Sets the value of VpcId
         * @param vpcId The VPC which this subnet is part of. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of MapPublicIpOnLaunch
         * @param mapPublicIpOnLaunch Controls if a public IP is associated to an instance at launch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapPublicIpOnLaunch(java.lang.Boolean mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SubnetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public SubnetProps build() {
            return new Jsii$Proxy(availabilityZone, cidrBlock, vpcId, mapPublicIpOnLaunch);
        }
    }

    /**
     * An implementation for {@link SubnetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubnetProps {
        private final java.lang.String availabilityZone;
        private final java.lang.String cidrBlock;
        private final java.lang.String vpcId;
        private final java.lang.Boolean mapPublicIpOnLaunch;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.availabilityZone = this.jsiiGet("availabilityZone", java.lang.String.class);
            this.cidrBlock = this.jsiiGet("cidrBlock", java.lang.String.class);
            this.vpcId = this.jsiiGet("vpcId", java.lang.String.class);
            this.mapPublicIpOnLaunch = this.jsiiGet("mapPublicIpOnLaunch", java.lang.Boolean.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String availabilityZone, java.lang.String cidrBlock, java.lang.String vpcId, java.lang.Boolean mapPublicIpOnLaunch) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.availabilityZone = java.util.Objects.requireNonNull(availabilityZone, "availabilityZone is required");
            this.cidrBlock = java.util.Objects.requireNonNull(cidrBlock, "cidrBlock is required");
            this.vpcId = java.util.Objects.requireNonNull(vpcId, "vpcId is required");
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
        }

        @Override
        public java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public java.lang.String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public java.lang.Boolean getMapPublicIpOnLaunch() {
            return this.mapPublicIpOnLaunch;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            obj.set("cidrBlock", om.valueToTree(this.getCidrBlock()));
            obj.set("vpcId", om.valueToTree(this.getVpcId()));
            if (this.getMapPublicIpOnLaunch() != null) {
                obj.set("mapPublicIpOnLaunch", om.valueToTree(this.getMapPublicIpOnLaunch()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SubnetProps.Jsii$Proxy that = (SubnetProps.Jsii$Proxy) o;

            if (!availabilityZone.equals(that.availabilityZone)) return false;
            if (!cidrBlock.equals(that.cidrBlock)) return false;
            if (!vpcId.equals(that.vpcId)) return false;
            return this.mapPublicIpOnLaunch != null ? this.mapPublicIpOnLaunch.equals(that.mapPublicIpOnLaunch) : that.mapPublicIpOnLaunch == null;
        }

        @Override
        public int hashCode() {
            int result = this.availabilityZone.hashCode();
            result = 31 * result + (this.cidrBlock.hashCode());
            result = 31 * result + (this.vpcId.hashCode());
            result = 31 * result + (this.mapPublicIpOnLaunch != null ? this.mapPublicIpOnLaunch.hashCode() : 0);
            return result;
        }
    }
}
