package software.amazon.awscdk.services.ec2;

/**
 * Options for applying CloudFormation init to an instance or instance group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * InstanceType instanceType;
 * IMachineImage machineImage;
 * Instance.Builder.create(this, "Instance")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(machineImage)
 *         // Showing the most complex setup, if you have simpler requirements
 *         // you can use `CloudFormationInit.fromElements()`.
 *         .init(CloudFormationInit.fromConfigSets(ConfigSetProps.builder()
 *                 .configSets(Map.of(
 *                         // Applies the configs below in this order
 *                         "default", List.of("yumPreinstall", "config")))
 *                 .configs(Map.of(
 *                         "yumPreinstall", new InitConfig(List.of(InitPackage.yum("git"))),
 *                         "config", new InitConfig(List.of(InitFile.fromObject("/etc/stack.json", Map.of(
 *                                 "stackId", Stack.of(this).getStackId(),
 *                                 "stackName", Stack.of(this).getStackName(),
 *                                 "region", Stack.of(this).getRegion())), InitGroup.fromName("my-group"), InitUser.fromName("my-user"), InitPackage.rpm("http://mirrors.ukfast.co.uk/sites/dl.fedoraproject.org/pub/epel/8/Everything/x86_64/Packages/r/rubygem-git-1.5.0-2.el8.noarch.rpm")))))
 *                 .build()))
 *         .initOptions(ApplyCloudFormationInitOptions.builder()
 *                 // Optional, which configsets to activate (['default'] by default)
 *                 .configSets(List.of("default"))
 *                 // Optional, how long the installation is expected to take (5 minutes by default)
 *                 .timeout(Duration.minutes(30))
 *                 // Optional, whether to include the --url argument when running cfn-init and cfn-signal commands (false by default)
 *                 .includeUrl(true)
 *                 // Optional, whether to include the --role argument when running cfn-init and cfn-signal commands (false by default)
 *                 .includeRole(true)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.45.0 (build 61747b6)", date = "2021-11-19T21:31:10.373Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.ApplyCloudFormationInitOptions")
@software.amazon.jsii.Jsii.Proxy(ApplyCloudFormationInitOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplyCloudFormationInitOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * ConfigSet to activate.
     * <p>
     * Default: ['default']
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getConfigSets() {
        return null;
    }

    /**
     * Force instance replacement by embedding a config fingerprint.
     * <p>
     * If <code>true</code> (the default), a hash of the config will be embedded into the
     * UserData, so that if the config changes, the UserData changes.
     * <p>
     * <ul>
     * <li>If the EC2 instance is instance-store backed or
     * <code>userDataCausesReplacement</code> is set, this will cause the instance to be
     * replaced and the new configuration to be applied.</li>
     * <li>If the instance is EBS-backed and <code>userDataCausesReplacement</code> is not
     * set, the change of UserData will make the instance restart but not be
     * replaced, and the configuration will not be applied automatically.</li>
     * </ul>
     * <p>
     * If <code>false</code>, no hash will be embedded, and if the CloudFormation Init
     * config changes nothing will happen to the running instance. If a
     * config update introduces errors, you will not notice until after the
     * CloudFormation deployment successfully finishes and the next instance
     * fails to launch.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEmbedFingerprint() {
        return null;
    }

    /**
     * Don't fail the instance creation when cfn-init fails.
     * <p>
     * You can use this to prevent CloudFormation from rolling back when
     * instances fail to start up, to help in debugging.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIgnoreFailures() {
        return null;
    }

    /**
     * Include --role argument when running cfn-init and cfn-signal commands.
     * <p>
     * This will be the IAM instance profile attached to the EC2 instance
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIncludeRole() {
        return null;
    }

    /**
     * Include --url argument when running cfn-init and cfn-signal commands.
     * <p>
     * This will be the cloudformation endpoint in the deployed region
     * e.g. https://cloudformation.us-east-1.amazonaws.com
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIncludeUrl() {
        return null;
    }

    /**
     * Print the results of running cfn-init to the Instance System Log.
     * <p>
     * By default, the output of running cfn-init is written to a log file
     * on the instance. Set this to <code>true</code> to print it to the System Log
     * (visible from the EC2 Console), <code>false</code> to not print it.
     * <p>
     * (Be aware that the system log is refreshed at certain points in
     * time of the instance life cycle, and successful execution may
     * not always show up).
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPrintLog() {
        return null;
    }

    /**
     * Timeout waiting for the configuration to be applied.
     * <p>
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApplyCloudFormationInitOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplyCloudFormationInitOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApplyCloudFormationInitOptions> {
        java.util.List<java.lang.String> configSets;
        java.lang.Boolean embedFingerprint;
        java.lang.Boolean ignoreFailures;
        java.lang.Boolean includeRole;
        java.lang.Boolean includeUrl;
        java.lang.Boolean printLog;
        software.amazon.awscdk.core.Duration timeout;

        /**
         * Sets the value of {@link ApplyCloudFormationInitOptions#getConfigSets}
         * @param configSets ConfigSet to activate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configSets(java.util.List<java.lang.String> configSets) {
            this.configSets = configSets;
            return this;
        }

        /**
         * Sets the value of {@link ApplyCloudFormationInitOptions#getEmbedFingerprint}
         * @param embedFingerprint Force instance replacement by embedding a config fingerprint.
         *                         If <code>true</code> (the default), a hash of the config will be embedded into the
         *                         UserData, so that if the config changes, the UserData changes.
         *                         <p>
         *                         <ul>
         *                         <li>If the EC2 instance is instance-store backed or
         *                         <code>userDataCausesReplacement</code> is set, this will cause the instance to be
         *                         replaced and the new configuration to be applied.</li>
         *                         <li>If the instance is EBS-backed and <code>userDataCausesReplacement</code> is not
         *                         set, the change of UserData will make the instance restart but not be
         *                         replaced, and the configuration will not be applied automatically.</li>
         *                         </ul>
         *                         <p>
         *                         If <code>false</code>, no hash will be embedded, and if the CloudFormation Init
         *                         config changes nothing will happen to the running instance. If a
         *                         config update introduces errors, you will not notice until after the
         *                         CloudFormation deployment successfully finishes and the next instance
         *                         fails to launch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder embedFingerprint(java.lang.Boolean embedFingerprint) {
            this.embedFingerprint = embedFingerprint;
            return this;
        }

        /**
         * Sets the value of {@link ApplyCloudFormationInitOptions#getIgnoreFailures}
         * @param ignoreFailures Don't fail the instance creation when cfn-init fails.
         *                       You can use this to prevent CloudFormation from rolling back when
         *                       instances fail to start up, to help in debugging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreFailures(java.lang.Boolean ignoreFailures) {
            this.ignoreFailures = ignoreFailures;
            return this;
        }

        /**
         * Sets the value of {@link ApplyCloudFormationInitOptions#getIncludeRole}
         * @param includeRole Include --role argument when running cfn-init and cfn-signal commands.
         *                    This will be the IAM instance profile attached to the EC2 instance
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeRole(java.lang.Boolean includeRole) {
            this.includeRole = includeRole;
            return this;
        }

        /**
         * Sets the value of {@link ApplyCloudFormationInitOptions#getIncludeUrl}
         * @param includeUrl Include --url argument when running cfn-init and cfn-signal commands.
         *                   This will be the cloudformation endpoint in the deployed region
         *                   e.g. https://cloudformation.us-east-1.amazonaws.com
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeUrl(java.lang.Boolean includeUrl) {
            this.includeUrl = includeUrl;
            return this;
        }

        /**
         * Sets the value of {@link ApplyCloudFormationInitOptions#getPrintLog}
         * @param printLog Print the results of running cfn-init to the Instance System Log.
         *                 By default, the output of running cfn-init is written to a log file
         *                 on the instance. Set this to <code>true</code> to print it to the System Log
         *                 (visible from the EC2 Console), <code>false</code> to not print it.
         *                 <p>
         *                 (Be aware that the system log is refreshed at certain points in
         *                 time of the instance life cycle, and successful execution may
         *                 not always show up).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder printLog(java.lang.Boolean printLog) {
            this.printLog = printLog;
            return this;
        }

        /**
         * Sets the value of {@link ApplyCloudFormationInitOptions#getTimeout}
         * @param timeout Timeout waiting for the configuration to be applied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.core.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplyCloudFormationInitOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApplyCloudFormationInitOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApplyCloudFormationInitOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplyCloudFormationInitOptions {
        private final java.util.List<java.lang.String> configSets;
        private final java.lang.Boolean embedFingerprint;
        private final java.lang.Boolean ignoreFailures;
        private final java.lang.Boolean includeRole;
        private final java.lang.Boolean includeUrl;
        private final java.lang.Boolean printLog;
        private final software.amazon.awscdk.core.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configSets = software.amazon.jsii.Kernel.get(this, "configSets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.embedFingerprint = software.amazon.jsii.Kernel.get(this, "embedFingerprint", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ignoreFailures = software.amazon.jsii.Kernel.get(this, "ignoreFailures", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.includeRole = software.amazon.jsii.Kernel.get(this, "includeRole", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.includeUrl = software.amazon.jsii.Kernel.get(this, "includeUrl", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.printLog = software.amazon.jsii.Kernel.get(this, "printLog", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configSets = builder.configSets;
            this.embedFingerprint = builder.embedFingerprint;
            this.ignoreFailures = builder.ignoreFailures;
            this.includeRole = builder.includeRole;
            this.includeUrl = builder.includeUrl;
            this.printLog = builder.printLog;
            this.timeout = builder.timeout;
        }

        @Override
        public final java.util.List<java.lang.String> getConfigSets() {
            return this.configSets;
        }

        @Override
        public final java.lang.Boolean getEmbedFingerprint() {
            return this.embedFingerprint;
        }

        @Override
        public final java.lang.Boolean getIgnoreFailures() {
            return this.ignoreFailures;
        }

        @Override
        public final java.lang.Boolean getIncludeRole() {
            return this.includeRole;
        }

        @Override
        public final java.lang.Boolean getIncludeUrl() {
            return this.includeUrl;
        }

        @Override
        public final java.lang.Boolean getPrintLog() {
            return this.printLog;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getConfigSets() != null) {
                data.set("configSets", om.valueToTree(this.getConfigSets()));
            }
            if (this.getEmbedFingerprint() != null) {
                data.set("embedFingerprint", om.valueToTree(this.getEmbedFingerprint()));
            }
            if (this.getIgnoreFailures() != null) {
                data.set("ignoreFailures", om.valueToTree(this.getIgnoreFailures()));
            }
            if (this.getIncludeRole() != null) {
                data.set("includeRole", om.valueToTree(this.getIncludeRole()));
            }
            if (this.getIncludeUrl() != null) {
                data.set("includeUrl", om.valueToTree(this.getIncludeUrl()));
            }
            if (this.getPrintLog() != null) {
                data.set("printLog", om.valueToTree(this.getPrintLog()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.ApplyCloudFormationInitOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplyCloudFormationInitOptions.Jsii$Proxy that = (ApplyCloudFormationInitOptions.Jsii$Proxy) o;

            if (this.configSets != null ? !this.configSets.equals(that.configSets) : that.configSets != null) return false;
            if (this.embedFingerprint != null ? !this.embedFingerprint.equals(that.embedFingerprint) : that.embedFingerprint != null) return false;
            if (this.ignoreFailures != null ? !this.ignoreFailures.equals(that.ignoreFailures) : that.ignoreFailures != null) return false;
            if (this.includeRole != null ? !this.includeRole.equals(that.includeRole) : that.includeRole != null) return false;
            if (this.includeUrl != null ? !this.includeUrl.equals(that.includeUrl) : that.includeUrl != null) return false;
            if (this.printLog != null ? !this.printLog.equals(that.printLog) : that.printLog != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.configSets != null ? this.configSets.hashCode() : 0;
            result = 31 * result + (this.embedFingerprint != null ? this.embedFingerprint.hashCode() : 0);
            result = 31 * result + (this.ignoreFailures != null ? this.ignoreFailures.hashCode() : 0);
            result = 31 * result + (this.includeRole != null ? this.includeRole.hashCode() : 0);
            result = 31 * result + (this.includeUrl != null ? this.includeUrl.hashCode() : 0);
            result = 31 * result + (this.printLog != null ? this.printLog.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
