package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::CapacityReservationFleet`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnCapacityReservationFleetProps cfnCapacityReservationFleetProps = CfnCapacityReservationFleetProps.builder()
 *         .allocationStrategy("allocationStrategy")
 *         .endDate("endDate")
 *         .instanceMatchCriteria("instanceMatchCriteria")
 *         .instanceTypeSpecifications(List.of(InstanceTypeSpecificationProperty.builder()
 *                 .availabilityZone("availabilityZone")
 *                 .availabilityZoneId("availabilityZoneId")
 *                 .ebsOptimized(false)
 *                 .instancePlatform("instancePlatform")
 *                 .instanceType("instanceType")
 *                 .priority(123)
 *                 .weight(123)
 *                 .build()))
 *         .noRemoveEndDate(false)
 *         .removeEndDate(false)
 *         .tagSpecifications(List.of(TagSpecificationProperty.builder()
 *                 .resourceType("resourceType")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build()))
 *         .tenancy("tenancy")
 *         .totalTargetCapacity(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.45.0 (build 61747b6)", date = "2021-11-19T21:31:10.378Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnCapacityReservationFleetProps")
@software.amazon.jsii.Jsii.Proxy(CfnCapacityReservationFleetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCapacityReservationFleetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::CapacityReservationFleet.AllocationStrategy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAllocationStrategy() {
        return null;
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.EndDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndDate() {
        return null;
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.InstanceMatchCriteria`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceMatchCriteria() {
        return null;
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.InstanceTypeSpecifications`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceTypeSpecifications() {
        return null;
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.NoRemoveEndDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNoRemoveEndDate() {
        return null;
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.RemoveEndDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRemoveEndDate() {
        return null;
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.TagSpecifications`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTagSpecifications() {
        return null;
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.Tenancy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTenancy() {
        return null;
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.TotalTargetCapacity`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTotalTargetCapacity() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCapacityReservationFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCapacityReservationFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCapacityReservationFleetProps> {
        java.lang.String allocationStrategy;
        java.lang.String endDate;
        java.lang.String instanceMatchCriteria;
        java.lang.Object instanceTypeSpecifications;
        java.lang.Object noRemoveEndDate;
        java.lang.Object removeEndDate;
        java.lang.Object tagSpecifications;
        java.lang.String tenancy;
        java.lang.Number totalTargetCapacity;

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getAllocationStrategy}
         * @param allocationStrategy `AWS::EC2::CapacityReservationFleet.AllocationStrategy`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationStrategy(java.lang.String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getEndDate}
         * @param endDate `AWS::EC2::CapacityReservationFleet.EndDate`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endDate(java.lang.String endDate) {
            this.endDate = endDate;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getInstanceMatchCriteria}
         * @param instanceMatchCriteria `AWS::EC2::CapacityReservationFleet.InstanceMatchCriteria`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceMatchCriteria(java.lang.String instanceMatchCriteria) {
            this.instanceMatchCriteria = instanceMatchCriteria;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getInstanceTypeSpecifications}
         * @param instanceTypeSpecifications `AWS::EC2::CapacityReservationFleet.InstanceTypeSpecifications`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceTypeSpecifications(software.amazon.awscdk.core.IResolvable instanceTypeSpecifications) {
            this.instanceTypeSpecifications = instanceTypeSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getInstanceTypeSpecifications}
         * @param instanceTypeSpecifications `AWS::EC2::CapacityReservationFleet.InstanceTypeSpecifications`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceTypeSpecifications(java.util.List<? extends java.lang.Object> instanceTypeSpecifications) {
            this.instanceTypeSpecifications = instanceTypeSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getNoRemoveEndDate}
         * @param noRemoveEndDate `AWS::EC2::CapacityReservationFleet.NoRemoveEndDate`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder noRemoveEndDate(java.lang.Boolean noRemoveEndDate) {
            this.noRemoveEndDate = noRemoveEndDate;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getNoRemoveEndDate}
         * @param noRemoveEndDate `AWS::EC2::CapacityReservationFleet.NoRemoveEndDate`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder noRemoveEndDate(software.amazon.awscdk.core.IResolvable noRemoveEndDate) {
            this.noRemoveEndDate = noRemoveEndDate;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getRemoveEndDate}
         * @param removeEndDate `AWS::EC2::CapacityReservationFleet.RemoveEndDate`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removeEndDate(java.lang.Boolean removeEndDate) {
            this.removeEndDate = removeEndDate;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getRemoveEndDate}
         * @param removeEndDate `AWS::EC2::CapacityReservationFleet.RemoveEndDate`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removeEndDate(software.amazon.awscdk.core.IResolvable removeEndDate) {
            this.removeEndDate = removeEndDate;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getTagSpecifications}
         * @param tagSpecifications `AWS::EC2::CapacityReservationFleet.TagSpecifications`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(software.amazon.awscdk.core.IResolvable tagSpecifications) {
            this.tagSpecifications = tagSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getTagSpecifications}
         * @param tagSpecifications `AWS::EC2::CapacityReservationFleet.TagSpecifications`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(java.util.List<? extends java.lang.Object> tagSpecifications) {
            this.tagSpecifications = tagSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getTenancy}
         * @param tenancy `AWS::EC2::CapacityReservationFleet.Tenancy`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tenancy(java.lang.String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationFleetProps#getTotalTargetCapacity}
         * @param totalTargetCapacity `AWS::EC2::CapacityReservationFleet.TotalTargetCapacity`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder totalTargetCapacity(java.lang.Number totalTargetCapacity) {
            this.totalTargetCapacity = totalTargetCapacity;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCapacityReservationFleetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCapacityReservationFleetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCapacityReservationFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCapacityReservationFleetProps {
        private final java.lang.String allocationStrategy;
        private final java.lang.String endDate;
        private final java.lang.String instanceMatchCriteria;
        private final java.lang.Object instanceTypeSpecifications;
        private final java.lang.Object noRemoveEndDate;
        private final java.lang.Object removeEndDate;
        private final java.lang.Object tagSpecifications;
        private final java.lang.String tenancy;
        private final java.lang.Number totalTargetCapacity;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allocationStrategy = software.amazon.jsii.Kernel.get(this, "allocationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endDate = software.amazon.jsii.Kernel.get(this, "endDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceMatchCriteria = software.amazon.jsii.Kernel.get(this, "instanceMatchCriteria", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceTypeSpecifications = software.amazon.jsii.Kernel.get(this, "instanceTypeSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.noRemoveEndDate = software.amazon.jsii.Kernel.get(this, "noRemoveEndDate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.removeEndDate = software.amazon.jsii.Kernel.get(this, "removeEndDate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tagSpecifications = software.amazon.jsii.Kernel.get(this, "tagSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tenancy = software.amazon.jsii.Kernel.get(this, "tenancy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.totalTargetCapacity = software.amazon.jsii.Kernel.get(this, "totalTargetCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allocationStrategy = builder.allocationStrategy;
            this.endDate = builder.endDate;
            this.instanceMatchCriteria = builder.instanceMatchCriteria;
            this.instanceTypeSpecifications = builder.instanceTypeSpecifications;
            this.noRemoveEndDate = builder.noRemoveEndDate;
            this.removeEndDate = builder.removeEndDate;
            this.tagSpecifications = builder.tagSpecifications;
            this.tenancy = builder.tenancy;
            this.totalTargetCapacity = builder.totalTargetCapacity;
        }

        @Override
        public final java.lang.String getAllocationStrategy() {
            return this.allocationStrategy;
        }

        @Override
        public final java.lang.String getEndDate() {
            return this.endDate;
        }

        @Override
        public final java.lang.String getInstanceMatchCriteria() {
            return this.instanceMatchCriteria;
        }

        @Override
        public final java.lang.Object getInstanceTypeSpecifications() {
            return this.instanceTypeSpecifications;
        }

        @Override
        public final java.lang.Object getNoRemoveEndDate() {
            return this.noRemoveEndDate;
        }

        @Override
        public final java.lang.Object getRemoveEndDate() {
            return this.removeEndDate;
        }

        @Override
        public final java.lang.Object getTagSpecifications() {
            return this.tagSpecifications;
        }

        @Override
        public final java.lang.String getTenancy() {
            return this.tenancy;
        }

        @Override
        public final java.lang.Number getTotalTargetCapacity() {
            return this.totalTargetCapacity;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllocationStrategy() != null) {
                data.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
            }
            if (this.getEndDate() != null) {
                data.set("endDate", om.valueToTree(this.getEndDate()));
            }
            if (this.getInstanceMatchCriteria() != null) {
                data.set("instanceMatchCriteria", om.valueToTree(this.getInstanceMatchCriteria()));
            }
            if (this.getInstanceTypeSpecifications() != null) {
                data.set("instanceTypeSpecifications", om.valueToTree(this.getInstanceTypeSpecifications()));
            }
            if (this.getNoRemoveEndDate() != null) {
                data.set("noRemoveEndDate", om.valueToTree(this.getNoRemoveEndDate()));
            }
            if (this.getRemoveEndDate() != null) {
                data.set("removeEndDate", om.valueToTree(this.getRemoveEndDate()));
            }
            if (this.getTagSpecifications() != null) {
                data.set("tagSpecifications", om.valueToTree(this.getTagSpecifications()));
            }
            if (this.getTenancy() != null) {
                data.set("tenancy", om.valueToTree(this.getTenancy()));
            }
            if (this.getTotalTargetCapacity() != null) {
                data.set("totalTargetCapacity", om.valueToTree(this.getTotalTargetCapacity()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnCapacityReservationFleetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCapacityReservationFleetProps.Jsii$Proxy that = (CfnCapacityReservationFleetProps.Jsii$Proxy) o;

            if (this.allocationStrategy != null ? !this.allocationStrategy.equals(that.allocationStrategy) : that.allocationStrategy != null) return false;
            if (this.endDate != null ? !this.endDate.equals(that.endDate) : that.endDate != null) return false;
            if (this.instanceMatchCriteria != null ? !this.instanceMatchCriteria.equals(that.instanceMatchCriteria) : that.instanceMatchCriteria != null) return false;
            if (this.instanceTypeSpecifications != null ? !this.instanceTypeSpecifications.equals(that.instanceTypeSpecifications) : that.instanceTypeSpecifications != null) return false;
            if (this.noRemoveEndDate != null ? !this.noRemoveEndDate.equals(that.noRemoveEndDate) : that.noRemoveEndDate != null) return false;
            if (this.removeEndDate != null ? !this.removeEndDate.equals(that.removeEndDate) : that.removeEndDate != null) return false;
            if (this.tagSpecifications != null ? !this.tagSpecifications.equals(that.tagSpecifications) : that.tagSpecifications != null) return false;
            if (this.tenancy != null ? !this.tenancy.equals(that.tenancy) : that.tenancy != null) return false;
            return this.totalTargetCapacity != null ? this.totalTargetCapacity.equals(that.totalTargetCapacity) : that.totalTargetCapacity == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allocationStrategy != null ? this.allocationStrategy.hashCode() : 0;
            result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
            result = 31 * result + (this.instanceMatchCriteria != null ? this.instanceMatchCriteria.hashCode() : 0);
            result = 31 * result + (this.instanceTypeSpecifications != null ? this.instanceTypeSpecifications.hashCode() : 0);
            result = 31 * result + (this.noRemoveEndDate != null ? this.noRemoveEndDate.hashCode() : 0);
            result = 31 * result + (this.removeEndDate != null ? this.removeEndDate.hashCode() : 0);
            result = 31 * result + (this.tagSpecifications != null ? this.tagSpecifications.hashCode() : 0);
            result = 31 * result + (this.tenancy != null ? this.tenancy.hashCode() : 0);
            result = 31 * result + (this.totalTargetCapacity != null ? this.totalTargetCapacity.hashCode() : 0);
            return result;
        }
    }
}
