package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::VPCEndpointServicePermissions`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnVPCEndpointServicePermissionsProps cfnVPCEndpointServicePermissionsProps = CfnVPCEndpointServicePermissionsProps.builder()
 *         .serviceId("serviceId")
 *         // the properties below are optional
 *         .allowedPrincipals(List.of("allowedPrincipals"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.45.0 (build 61747b6)", date = "2021-11-19T21:31:10.516Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnVPCEndpointServicePermissionsProps")
@software.amazon.jsii.Jsii.Proxy(CfnVPCEndpointServicePermissionsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVPCEndpointServicePermissionsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::VPCEndpointServicePermissions.AllowedPrincipals`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedPrincipals() {
        return null;
    }

    /**
     * `AWS::EC2::VPCEndpointServicePermissions.ServiceId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceId();

    /**
     * @return a {@link Builder} of {@link CfnVPCEndpointServicePermissionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVPCEndpointServicePermissionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVPCEndpointServicePermissionsProps> {
        java.util.List<java.lang.String> allowedPrincipals;
        java.lang.String serviceId;

        /**
         * Sets the value of {@link CfnVPCEndpointServicePermissionsProps#getAllowedPrincipals}
         * @param allowedPrincipals `AWS::EC2::VPCEndpointServicePermissions.AllowedPrincipals`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedPrincipals(java.util.List<java.lang.String> allowedPrincipals) {
            this.allowedPrincipals = allowedPrincipals;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointServicePermissionsProps#getServiceId}
         * @param serviceId `AWS::EC2::VPCEndpointServicePermissions.ServiceId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceId(java.lang.String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVPCEndpointServicePermissionsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVPCEndpointServicePermissionsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVPCEndpointServicePermissionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVPCEndpointServicePermissionsProps {
        private final java.util.List<java.lang.String> allowedPrincipals;
        private final java.lang.String serviceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowedPrincipals = software.amazon.jsii.Kernel.get(this, "allowedPrincipals", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.serviceId = software.amazon.jsii.Kernel.get(this, "serviceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowedPrincipals = builder.allowedPrincipals;
            this.serviceId = java.util.Objects.requireNonNull(builder.serviceId, "serviceId is required");
        }

        @Override
        public final java.util.List<java.lang.String> getAllowedPrincipals() {
            return this.allowedPrincipals;
        }

        @Override
        public final java.lang.String getServiceId() {
            return this.serviceId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllowedPrincipals() != null) {
                data.set("allowedPrincipals", om.valueToTree(this.getAllowedPrincipals()));
            }
            data.set("serviceId", om.valueToTree(this.getServiceId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnVPCEndpointServicePermissionsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVPCEndpointServicePermissionsProps.Jsii$Proxy that = (CfnVPCEndpointServicePermissionsProps.Jsii$Proxy) o;

            if (this.allowedPrincipals != null ? !this.allowedPrincipals.equals(that.allowedPrincipals) : that.allowedPrincipals != null) return false;
            return this.serviceId.equals(that.serviceId);
        }

        @Override
        public final int hashCode() {
            int result = this.allowedPrincipals != null ? this.allowedPrincipals.hashCode() : 0;
            result = 31 * result + (this.serviceId.hashCode());
            return result;
        }
    }
}
