package software.amazon.awscdk.services.ec2;

/**
 * Create Linux/UNIX groups and assign group IDs.
 * <p>
 * Not supported for Windows systems.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * InstanceType instanceType;
 * IMachineImage machineImage;
 * Instance.Builder.create(this, "Instance")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(machineImage)
 *         // Showing the most complex setup, if you have simpler requirements
 *         // you can use `CloudFormationInit.fromElements()`.
 *         .init(CloudFormationInit.fromConfigSets(ConfigSetProps.builder()
 *                 .configSets(Map.of(
 *                         // Applies the configs below in this order
 *                         "default", List.of("yumPreinstall", "config")))
 *                 .configs(Map.of(
 *                         "yumPreinstall", new InitConfig(List.of(InitPackage.yum("git"))),
 *                         "config", new InitConfig(List.of(InitFile.fromObject("/etc/stack.json", Map.of(
 *                                 "stackId", Stack.of(this).getStackId(),
 *                                 "stackName", Stack.of(this).getStackName(),
 *                                 "region", Stack.of(this).getRegion())), InitGroup.fromName("my-group"), InitUser.fromName("my-user"), InitPackage.rpm("http://mirrors.ukfast.co.uk/sites/dl.fedoraproject.org/pub/epel/8/Everything/x86_64/Packages/r/rubygem-git-1.5.0-2.el8.noarch.rpm")))))
 *                 .build()))
 *         .initOptions(ApplyCloudFormationInitOptions.builder()
 *                 // Optional, which configsets to activate (['default'] by default)
 *                 .configSets(List.of("default"))
 *                 // Optional, how long the installation is expected to take (5 minutes by default)
 *                 .timeout(Duration.minutes(30))
 *                 // Optional, whether to include the --url argument when running cfn-init and cfn-signal commands (false by default)
 *                 .includeUrl(true)
 *                 // Optional, whether to include the --role argument when running cfn-init and cfn-signal commands (false by default)
 *                 .includeRole(true)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.45.0 (build 61747b6)", date = "2021-11-19T21:31:10.577Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.InitGroup")
public class InitGroup extends software.amazon.awscdk.services.ec2.InitElement {

    protected InitGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InitGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param groupName This parameter is required.
     * @param groupId
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected InitGroup(final @org.jetbrains.annotations.NotNull java.lang.String groupName, final @org.jetbrains.annotations.Nullable java.lang.Number groupId) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(groupName, "groupName is required"), groupId });
    }

    /**
     * @param groupName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected InitGroup(final @org.jetbrains.annotations.NotNull java.lang.String groupName) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(groupName, "groupName is required") });
    }

    /**
     * Create a group from its name, and optionally, group id.
     * <p>
     * @param groupName This parameter is required.
     * @param groupId
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitGroup fromName(final @org.jetbrains.annotations.NotNull java.lang.String groupName, final @org.jetbrains.annotations.Nullable java.lang.Number groupId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InitGroup.class, "fromName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitGroup.class), new Object[] { java.util.Objects.requireNonNull(groupName, "groupName is required"), groupId });
    }

    /**
     * Create a group from its name, and optionally, group id.
     * <p>
     * @param groupName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitGroup fromName(final @org.jetbrains.annotations.NotNull java.lang.String groupName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InitGroup.class, "fromName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitGroup.class), new Object[] { java.util.Objects.requireNonNull(groupName, "groupName is required") });
    }

    /**
     * Returns the init element type for this element.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getElementType() {
        return software.amazon.jsii.Kernel.get(this, "elementType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
