package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::CapacityReservationFleet`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnCapacityReservationFleet cfnCapacityReservationFleet = CfnCapacityReservationFleet.Builder.create(this, "MyCfnCapacityReservationFleet")
 *         .allocationStrategy("allocationStrategy")
 *         .endDate("endDate")
 *         .instanceMatchCriteria("instanceMatchCriteria")
 *         .instanceTypeSpecifications(List.of(InstanceTypeSpecificationProperty.builder()
 *                 .availabilityZone("availabilityZone")
 *                 .availabilityZoneId("availabilityZoneId")
 *                 .ebsOptimized(false)
 *                 .instancePlatform("instancePlatform")
 *                 .instanceType("instanceType")
 *                 .priority(123)
 *                 .weight(123)
 *                 .build()))
 *         .noRemoveEndDate(false)
 *         .removeEndDate(false)
 *         .tagSpecifications(List.of(TagSpecificationProperty.builder()
 *                 .resourceType("resourceType")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build()))
 *         .tenancy("tenancy")
 *         .totalTargetCapacity(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.46.0 (build cd08c55)", date = "2021-11-23T14:40:39.506Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnCapacityReservationFleet")
public class CfnCapacityReservationFleet extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnCapacityReservationFleet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCapacityReservationFleet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnCapacityReservationFleet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::EC2::CapacityReservationFleet`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCapacityReservationFleet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnCapacityReservationFleetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::EC2::CapacityReservationFleet`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCapacityReservationFleet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.AllocationStrategy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAllocationStrategy() {
        return software.amazon.jsii.Kernel.get(this, "allocationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.AllocationStrategy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllocationStrategy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "allocationStrategy", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCapacityReservationFleetId() {
        return software.amazon.jsii.Kernel.get(this, "attrCapacityReservationFleetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.EndDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndDate() {
        return software.amazon.jsii.Kernel.get(this, "endDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.EndDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndDate(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endDate", value);
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.InstanceMatchCriteria`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInstanceMatchCriteria() {
        return software.amazon.jsii.Kernel.get(this, "instanceMatchCriteria", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.InstanceMatchCriteria`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceMatchCriteria(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceMatchCriteria", value);
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.InstanceTypeSpecifications`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInstanceTypeSpecifications() {
        return software.amazon.jsii.Kernel.get(this, "instanceTypeSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.InstanceTypeSpecifications`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceTypeSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "instanceTypeSpecifications", value);
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.InstanceTypeSpecifications`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceTypeSpecifications(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "instanceTypeSpecifications", value);
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.NoRemoveEndDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNoRemoveEndDate() {
        return software.amazon.jsii.Kernel.get(this, "noRemoveEndDate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.NoRemoveEndDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNoRemoveEndDate(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "noRemoveEndDate", value);
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.NoRemoveEndDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNoRemoveEndDate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "noRemoveEndDate", value);
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.RemoveEndDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRemoveEndDate() {
        return software.amazon.jsii.Kernel.get(this, "removeEndDate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.RemoveEndDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRemoveEndDate(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "removeEndDate", value);
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.RemoveEndDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRemoveEndDate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "removeEndDate", value);
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.TagSpecifications`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTagSpecifications() {
        return software.amazon.jsii.Kernel.get(this, "tagSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.TagSpecifications`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "tagSpecifications", value);
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.TagSpecifications`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagSpecifications(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "tagSpecifications", value);
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.Tenancy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTenancy() {
        return software.amazon.jsii.Kernel.get(this, "tenancy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.Tenancy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTenancy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tenancy", value);
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.TotalTargetCapacity`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getTotalTargetCapacity() {
        return software.amazon.jsii.Kernel.get(this, "totalTargetCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * `AWS::EC2::CapacityReservationFleet.TotalTargetCapacity`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTotalTargetCapacity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "totalTargetCapacity", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * InstanceTypeSpecificationProperty instanceTypeSpecificationProperty = InstanceTypeSpecificationProperty.builder()
     *         .availabilityZone("availabilityZone")
     *         .availabilityZoneId("availabilityZoneId")
     *         .ebsOptimized(false)
     *         .instancePlatform("instancePlatform")
     *         .instanceType("instanceType")
     *         .priority(123)
     *         .weight(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnCapacityReservationFleet.InstanceTypeSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceTypeSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceTypeSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnCapacityReservationFleet.InstanceTypeSpecificationProperty.AvailabilityZone`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * `CfnCapacityReservationFleet.InstanceTypeSpecificationProperty.AvailabilityZoneId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZoneId() {
            return null;
        }

        /**
         * `CfnCapacityReservationFleet.InstanceTypeSpecificationProperty.EbsOptimized`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbsOptimized() {
            return null;
        }

        /**
         * `CfnCapacityReservationFleet.InstanceTypeSpecificationProperty.InstancePlatform`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstancePlatform() {
            return null;
        }

        /**
         * `CfnCapacityReservationFleet.InstanceTypeSpecificationProperty.InstanceType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * `CfnCapacityReservationFleet.InstanceTypeSpecificationProperty.Priority`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
            return null;
        }

        /**
         * `CfnCapacityReservationFleet.InstanceTypeSpecificationProperty.Weight`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeight() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceTypeSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceTypeSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceTypeSpecificationProperty> {
            java.lang.String availabilityZone;
            java.lang.String availabilityZoneId;
            java.lang.Object ebsOptimized;
            java.lang.String instancePlatform;
            java.lang.String instanceType;
            java.lang.Number priority;
            java.lang.Number weight;

            /**
             * Sets the value of {@link InstanceTypeSpecificationProperty#getAvailabilityZone}
             * @param availabilityZone `CfnCapacityReservationFleet.InstanceTypeSpecificationProperty.AvailabilityZone`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeSpecificationProperty#getAvailabilityZoneId}
             * @param availabilityZoneId `CfnCapacityReservationFleet.InstanceTypeSpecificationProperty.AvailabilityZoneId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZoneId(java.lang.String availabilityZoneId) {
                this.availabilityZoneId = availabilityZoneId;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeSpecificationProperty#getEbsOptimized}
             * @param ebsOptimized `CfnCapacityReservationFleet.InstanceTypeSpecificationProperty.EbsOptimized`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsOptimized(java.lang.Boolean ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeSpecificationProperty#getEbsOptimized}
             * @param ebsOptimized `CfnCapacityReservationFleet.InstanceTypeSpecificationProperty.EbsOptimized`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsOptimized(software.amazon.awscdk.core.IResolvable ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeSpecificationProperty#getInstancePlatform}
             * @param instancePlatform `CfnCapacityReservationFleet.InstanceTypeSpecificationProperty.InstancePlatform`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instancePlatform(java.lang.String instancePlatform) {
                this.instancePlatform = instancePlatform;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeSpecificationProperty#getInstanceType}
             * @param instanceType `CfnCapacityReservationFleet.InstanceTypeSpecificationProperty.InstanceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeSpecificationProperty#getPriority}
             * @param priority `CfnCapacityReservationFleet.InstanceTypeSpecificationProperty.Priority`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeSpecificationProperty#getWeight}
             * @param weight `CfnCapacityReservationFleet.InstanceTypeSpecificationProperty.Weight`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weight(java.lang.Number weight) {
                this.weight = weight;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceTypeSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceTypeSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceTypeSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceTypeSpecificationProperty {
            private final java.lang.String availabilityZone;
            private final java.lang.String availabilityZoneId;
            private final java.lang.Object ebsOptimized;
            private final java.lang.String instancePlatform;
            private final java.lang.String instanceType;
            private final java.lang.Number priority;
            private final java.lang.Number weight;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.availabilityZoneId = software.amazon.jsii.Kernel.get(this, "availabilityZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ebsOptimized = software.amazon.jsii.Kernel.get(this, "ebsOptimized", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.instancePlatform = software.amazon.jsii.Kernel.get(this, "instancePlatform", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZone = builder.availabilityZone;
                this.availabilityZoneId = builder.availabilityZoneId;
                this.ebsOptimized = builder.ebsOptimized;
                this.instancePlatform = builder.instancePlatform;
                this.instanceType = builder.instanceType;
                this.priority = builder.priority;
                this.weight = builder.weight;
            }

            @Override
            public final java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public final java.lang.String getAvailabilityZoneId() {
                return this.availabilityZoneId;
            }

            @Override
            public final java.lang.Object getEbsOptimized() {
                return this.ebsOptimized;
            }

            @Override
            public final java.lang.String getInstancePlatform() {
                return this.instancePlatform;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            public final java.lang.Number getWeight() {
                return this.weight;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getAvailabilityZoneId() != null) {
                    data.set("availabilityZoneId", om.valueToTree(this.getAvailabilityZoneId()));
                }
                if (this.getEbsOptimized() != null) {
                    data.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
                }
                if (this.getInstancePlatform() != null) {
                    data.set("instancePlatform", om.valueToTree(this.getInstancePlatform()));
                }
                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getPriority() != null) {
                    data.set("priority", om.valueToTree(this.getPriority()));
                }
                if (this.getWeight() != null) {
                    data.set("weight", om.valueToTree(this.getWeight()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnCapacityReservationFleet.InstanceTypeSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceTypeSpecificationProperty.Jsii$Proxy that = (InstanceTypeSpecificationProperty.Jsii$Proxy) o;

                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                if (this.availabilityZoneId != null ? !this.availabilityZoneId.equals(that.availabilityZoneId) : that.availabilityZoneId != null) return false;
                if (this.ebsOptimized != null ? !this.ebsOptimized.equals(that.ebsOptimized) : that.ebsOptimized != null) return false;
                if (this.instancePlatform != null ? !this.instancePlatform.equals(that.instancePlatform) : that.instancePlatform != null) return false;
                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) return false;
                return this.weight != null ? this.weight.equals(that.weight) : that.weight == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availabilityZone != null ? this.availabilityZone.hashCode() : 0;
                result = 31 * result + (this.availabilityZoneId != null ? this.availabilityZoneId.hashCode() : 0);
                result = 31 * result + (this.ebsOptimized != null ? this.ebsOptimized.hashCode() : 0);
                result = 31 * result + (this.instancePlatform != null ? this.instancePlatform.hashCode() : 0);
                result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
                result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
                result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * TagSpecificationProperty tagSpecificationProperty = TagSpecificationProperty.builder()
     *         .resourceType("resourceType")
     *         .tags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnCapacityReservationFleet.TagSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(TagSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnCapacityReservationFleet.TagSpecificationProperty.ResourceType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceType() {
            return null;
        }

        /**
         * `CfnCapacityReservationFleet.TagSpecificationProperty.Tags`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagSpecificationProperty> {
            java.lang.String resourceType;
            java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Sets the value of {@link TagSpecificationProperty#getResourceType}
             * @param resourceType `CfnCapacityReservationFleet.TagSpecificationProperty.ResourceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link TagSpecificationProperty#getTags}
             * @param tags `CfnCapacityReservationFleet.TagSpecificationProperty.Tags`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagSpecificationProperty {
            private final java.lang.String resourceType;
            private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceType = builder.resourceType;
                this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            }

            @Override
            public final java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getResourceType() != null) {
                    data.set("resourceType", om.valueToTree(this.getResourceType()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnCapacityReservationFleet.TagSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagSpecificationProperty.Jsii$Proxy that = (TagSpecificationProperty.Jsii$Proxy) o;

                if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resourceType != null ? this.resourceType.hashCode() : 0;
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnCapacityReservationFleet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnCapacityReservationFleet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ec2.CfnCapacityReservationFleetProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * `AWS::EC2::CapacityReservationFleet.AllocationStrategy`.
         * <p>
         * @return {@code this}
         * @param allocationStrategy `AWS::EC2::CapacityReservationFleet.AllocationStrategy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationStrategy(final java.lang.String allocationStrategy) {
            this.props().allocationStrategy(allocationStrategy);
            return this;
        }

        /**
         * `AWS::EC2::CapacityReservationFleet.EndDate`.
         * <p>
         * @return {@code this}
         * @param endDate `AWS::EC2::CapacityReservationFleet.EndDate`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endDate(final java.lang.String endDate) {
            this.props().endDate(endDate);
            return this;
        }

        /**
         * `AWS::EC2::CapacityReservationFleet.InstanceMatchCriteria`.
         * <p>
         * @return {@code this}
         * @param instanceMatchCriteria `AWS::EC2::CapacityReservationFleet.InstanceMatchCriteria`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceMatchCriteria(final java.lang.String instanceMatchCriteria) {
            this.props().instanceMatchCriteria(instanceMatchCriteria);
            return this;
        }

        /**
         * `AWS::EC2::CapacityReservationFleet.InstanceTypeSpecifications`.
         * <p>
         * @return {@code this}
         * @param instanceTypeSpecifications `AWS::EC2::CapacityReservationFleet.InstanceTypeSpecifications`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceTypeSpecifications(final software.amazon.awscdk.core.IResolvable instanceTypeSpecifications) {
            this.props().instanceTypeSpecifications(instanceTypeSpecifications);
            return this;
        }
        /**
         * `AWS::EC2::CapacityReservationFleet.InstanceTypeSpecifications`.
         * <p>
         * @return {@code this}
         * @param instanceTypeSpecifications `AWS::EC2::CapacityReservationFleet.InstanceTypeSpecifications`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceTypeSpecifications(final java.util.List<? extends java.lang.Object> instanceTypeSpecifications) {
            this.props().instanceTypeSpecifications(instanceTypeSpecifications);
            return this;
        }

        /**
         * `AWS::EC2::CapacityReservationFleet.NoRemoveEndDate`.
         * <p>
         * @return {@code this}
         * @param noRemoveEndDate `AWS::EC2::CapacityReservationFleet.NoRemoveEndDate`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder noRemoveEndDate(final java.lang.Boolean noRemoveEndDate) {
            this.props().noRemoveEndDate(noRemoveEndDate);
            return this;
        }
        /**
         * `AWS::EC2::CapacityReservationFleet.NoRemoveEndDate`.
         * <p>
         * @return {@code this}
         * @param noRemoveEndDate `AWS::EC2::CapacityReservationFleet.NoRemoveEndDate`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder noRemoveEndDate(final software.amazon.awscdk.core.IResolvable noRemoveEndDate) {
            this.props().noRemoveEndDate(noRemoveEndDate);
            return this;
        }

        /**
         * `AWS::EC2::CapacityReservationFleet.RemoveEndDate`.
         * <p>
         * @return {@code this}
         * @param removeEndDate `AWS::EC2::CapacityReservationFleet.RemoveEndDate`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removeEndDate(final java.lang.Boolean removeEndDate) {
            this.props().removeEndDate(removeEndDate);
            return this;
        }
        /**
         * `AWS::EC2::CapacityReservationFleet.RemoveEndDate`.
         * <p>
         * @return {@code this}
         * @param removeEndDate `AWS::EC2::CapacityReservationFleet.RemoveEndDate`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removeEndDate(final software.amazon.awscdk.core.IResolvable removeEndDate) {
            this.props().removeEndDate(removeEndDate);
            return this;
        }

        /**
         * `AWS::EC2::CapacityReservationFleet.TagSpecifications`.
         * <p>
         * @return {@code this}
         * @param tagSpecifications `AWS::EC2::CapacityReservationFleet.TagSpecifications`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(final software.amazon.awscdk.core.IResolvable tagSpecifications) {
            this.props().tagSpecifications(tagSpecifications);
            return this;
        }
        /**
         * `AWS::EC2::CapacityReservationFleet.TagSpecifications`.
         * <p>
         * @return {@code this}
         * @param tagSpecifications `AWS::EC2::CapacityReservationFleet.TagSpecifications`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(final java.util.List<? extends java.lang.Object> tagSpecifications) {
            this.props().tagSpecifications(tagSpecifications);
            return this;
        }

        /**
         * `AWS::EC2::CapacityReservationFleet.Tenancy`.
         * <p>
         * @return {@code this}
         * @param tenancy `AWS::EC2::CapacityReservationFleet.Tenancy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tenancy(final java.lang.String tenancy) {
            this.props().tenancy(tenancy);
            return this;
        }

        /**
         * `AWS::EC2::CapacityReservationFleet.TotalTargetCapacity`.
         * <p>
         * @return {@code this}
         * @param totalTargetCapacity `AWS::EC2::CapacityReservationFleet.TotalTargetCapacity`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder totalTargetCapacity(final java.lang.Number totalTargetCapacity) {
            this.props().totalTargetCapacity(totalTargetCapacity);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnCapacityReservationFleet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnCapacityReservationFleet build() {
            return new software.amazon.awscdk.services.ec2.CfnCapacityReservationFleet(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.CfnCapacityReservationFleetProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.CfnCapacityReservationFleetProps.Builder();
            }
            return this.props;
        }
    }
}
