package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::CapacityReservation`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnCapacityReservationProps cfnCapacityReservationProps = CfnCapacityReservationProps.builder()
 *         .availabilityZone("availabilityZone")
 *         .instanceCount(123)
 *         .instancePlatform("instancePlatform")
 *         .instanceType("instanceType")
 *         // the properties below are optional
 *         .ebsOptimized(false)
 *         .endDate("endDate")
 *         .endDateType("endDateType")
 *         .ephemeralStorage(false)
 *         .instanceMatchCriteria("instanceMatchCriteria")
 *         .outPostArn("outPostArn")
 *         .placementGroupArn("placementGroupArn")
 *         .tagSpecifications(List.of(TagSpecificationProperty.builder()
 *                 .resourceType("resourceType")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build()))
 *         .tenancy("tenancy")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.46.0 (build cd08c55)", date = "2021-11-23T14:40:39.507Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnCapacityReservationProps")
@software.amazon.jsii.Jsii.Proxy(CfnCapacityReservationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCapacityReservationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::CapacityReservation.AvailabilityZone`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAvailabilityZone();

    /**
     * `AWS::EC2::CapacityReservation.EbsOptimized`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEbsOptimized() {
        return null;
    }

    /**
     * `AWS::EC2::CapacityReservation.EndDate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndDate() {
        return null;
    }

    /**
     * `AWS::EC2::CapacityReservation.EndDateType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndDateType() {
        return null;
    }

    /**
     * `AWS::EC2::CapacityReservation.EphemeralStorage`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEphemeralStorage() {
        return null;
    }

    /**
     * `AWS::EC2::CapacityReservation.InstanceCount`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getInstanceCount();

    /**
     * `AWS::EC2::CapacityReservation.InstanceMatchCriteria`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceMatchCriteria() {
        return null;
    }

    /**
     * `AWS::EC2::CapacityReservation.InstancePlatform`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstancePlatform();

    /**
     * `AWS::EC2::CapacityReservation.InstanceType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

    /**
     * `AWS::EC2::CapacityReservation.OutPostArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOutPostArn() {
        return null;
    }

    /**
     * `AWS::EC2::CapacityReservation.PlacementGroupArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPlacementGroupArn() {
        return null;
    }

    /**
     * `AWS::EC2::CapacityReservation.TagSpecifications`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTagSpecifications() {
        return null;
    }

    /**
     * `AWS::EC2::CapacityReservation.Tenancy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTenancy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCapacityReservationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCapacityReservationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCapacityReservationProps> {
        java.lang.String availabilityZone;
        java.lang.Object ebsOptimized;
        java.lang.String endDate;
        java.lang.String endDateType;
        java.lang.Object ephemeralStorage;
        java.lang.Number instanceCount;
        java.lang.String instanceMatchCriteria;
        java.lang.String instancePlatform;
        java.lang.String instanceType;
        java.lang.String outPostArn;
        java.lang.String placementGroupArn;
        java.lang.Object tagSpecifications;
        java.lang.String tenancy;

        /**
         * Sets the value of {@link CfnCapacityReservationProps#getAvailabilityZone}
         * @param availabilityZone `AWS::EC2::CapacityReservation.AvailabilityZone`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationProps#getEbsOptimized}
         * @param ebsOptimized `AWS::EC2::CapacityReservation.EbsOptimized`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptimized(java.lang.Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationProps#getEbsOptimized}
         * @param ebsOptimized `AWS::EC2::CapacityReservation.EbsOptimized`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptimized(software.amazon.awscdk.core.IResolvable ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationProps#getEndDate}
         * @param endDate `AWS::EC2::CapacityReservation.EndDate`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endDate(java.lang.String endDate) {
            this.endDate = endDate;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationProps#getEndDateType}
         * @param endDateType `AWS::EC2::CapacityReservation.EndDateType`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endDateType(java.lang.String endDateType) {
            this.endDateType = endDateType;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationProps#getEphemeralStorage}
         * @param ephemeralStorage `AWS::EC2::CapacityReservation.EphemeralStorage`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorage(java.lang.Boolean ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationProps#getEphemeralStorage}
         * @param ephemeralStorage `AWS::EC2::CapacityReservation.EphemeralStorage`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorage(software.amazon.awscdk.core.IResolvable ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationProps#getInstanceCount}
         * @param instanceCount `AWS::EC2::CapacityReservation.InstanceCount`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceCount(java.lang.Number instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationProps#getInstanceMatchCriteria}
         * @param instanceMatchCriteria `AWS::EC2::CapacityReservation.InstanceMatchCriteria`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceMatchCriteria(java.lang.String instanceMatchCriteria) {
            this.instanceMatchCriteria = instanceMatchCriteria;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationProps#getInstancePlatform}
         * @param instancePlatform `AWS::EC2::CapacityReservation.InstancePlatform`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instancePlatform(java.lang.String instancePlatform) {
            this.instancePlatform = instancePlatform;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationProps#getInstanceType}
         * @param instanceType `AWS::EC2::CapacityReservation.InstanceType`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(java.lang.String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationProps#getOutPostArn}
         * @param outPostArn `AWS::EC2::CapacityReservation.OutPostArn`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outPostArn(java.lang.String outPostArn) {
            this.outPostArn = outPostArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationProps#getPlacementGroupArn}
         * @param placementGroupArn `AWS::EC2::CapacityReservation.PlacementGroupArn`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementGroupArn(java.lang.String placementGroupArn) {
            this.placementGroupArn = placementGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationProps#getTagSpecifications}
         * @param tagSpecifications `AWS::EC2::CapacityReservation.TagSpecifications`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(software.amazon.awscdk.core.IResolvable tagSpecifications) {
            this.tagSpecifications = tagSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationProps#getTagSpecifications}
         * @param tagSpecifications `AWS::EC2::CapacityReservation.TagSpecifications`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(java.util.List<? extends java.lang.Object> tagSpecifications) {
            this.tagSpecifications = tagSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapacityReservationProps#getTenancy}
         * @param tenancy `AWS::EC2::CapacityReservation.Tenancy`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tenancy(java.lang.String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCapacityReservationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCapacityReservationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCapacityReservationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCapacityReservationProps {
        private final java.lang.String availabilityZone;
        private final java.lang.Object ebsOptimized;
        private final java.lang.String endDate;
        private final java.lang.String endDateType;
        private final java.lang.Object ephemeralStorage;
        private final java.lang.Number instanceCount;
        private final java.lang.String instanceMatchCriteria;
        private final java.lang.String instancePlatform;
        private final java.lang.String instanceType;
        private final java.lang.String outPostArn;
        private final java.lang.String placementGroupArn;
        private final java.lang.Object tagSpecifications;
        private final java.lang.String tenancy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ebsOptimized = software.amazon.jsii.Kernel.get(this, "ebsOptimized", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.endDate = software.amazon.jsii.Kernel.get(this, "endDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endDateType = software.amazon.jsii.Kernel.get(this, "endDateType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ephemeralStorage = software.amazon.jsii.Kernel.get(this, "ephemeralStorage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.instanceCount = software.amazon.jsii.Kernel.get(this, "instanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.instanceMatchCriteria = software.amazon.jsii.Kernel.get(this, "instanceMatchCriteria", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instancePlatform = software.amazon.jsii.Kernel.get(this, "instancePlatform", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outPostArn = software.amazon.jsii.Kernel.get(this, "outPostArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.placementGroupArn = software.amazon.jsii.Kernel.get(this, "placementGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tagSpecifications = software.amazon.jsii.Kernel.get(this, "tagSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tenancy = software.amazon.jsii.Kernel.get(this, "tenancy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.availabilityZone = java.util.Objects.requireNonNull(builder.availabilityZone, "availabilityZone is required");
            this.ebsOptimized = builder.ebsOptimized;
            this.endDate = builder.endDate;
            this.endDateType = builder.endDateType;
            this.ephemeralStorage = builder.ephemeralStorage;
            this.instanceCount = java.util.Objects.requireNonNull(builder.instanceCount, "instanceCount is required");
            this.instanceMatchCriteria = builder.instanceMatchCriteria;
            this.instancePlatform = java.util.Objects.requireNonNull(builder.instancePlatform, "instancePlatform is required");
            this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
            this.outPostArn = builder.outPostArn;
            this.placementGroupArn = builder.placementGroupArn;
            this.tagSpecifications = builder.tagSpecifications;
            this.tenancy = builder.tenancy;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.lang.Object getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final java.lang.String getEndDate() {
            return this.endDate;
        }

        @Override
        public final java.lang.String getEndDateType() {
            return this.endDateType;
        }

        @Override
        public final java.lang.Object getEphemeralStorage() {
            return this.ephemeralStorage;
        }

        @Override
        public final java.lang.Number getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final java.lang.String getInstanceMatchCriteria() {
            return this.instanceMatchCriteria;
        }

        @Override
        public final java.lang.String getInstancePlatform() {
            return this.instancePlatform;
        }

        @Override
        public final java.lang.String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final java.lang.String getOutPostArn() {
            return this.outPostArn;
        }

        @Override
        public final java.lang.String getPlacementGroupArn() {
            return this.placementGroupArn;
        }

        @Override
        public final java.lang.Object getTagSpecifications() {
            return this.tagSpecifications;
        }

        @Override
        public final java.lang.String getTenancy() {
            return this.tenancy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            if (this.getEbsOptimized() != null) {
                data.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
            }
            if (this.getEndDate() != null) {
                data.set("endDate", om.valueToTree(this.getEndDate()));
            }
            if (this.getEndDateType() != null) {
                data.set("endDateType", om.valueToTree(this.getEndDateType()));
            }
            if (this.getEphemeralStorage() != null) {
                data.set("ephemeralStorage", om.valueToTree(this.getEphemeralStorage()));
            }
            data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
            if (this.getInstanceMatchCriteria() != null) {
                data.set("instanceMatchCriteria", om.valueToTree(this.getInstanceMatchCriteria()));
            }
            data.set("instancePlatform", om.valueToTree(this.getInstancePlatform()));
            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            if (this.getOutPostArn() != null) {
                data.set("outPostArn", om.valueToTree(this.getOutPostArn()));
            }
            if (this.getPlacementGroupArn() != null) {
                data.set("placementGroupArn", om.valueToTree(this.getPlacementGroupArn()));
            }
            if (this.getTagSpecifications() != null) {
                data.set("tagSpecifications", om.valueToTree(this.getTagSpecifications()));
            }
            if (this.getTenancy() != null) {
                data.set("tenancy", om.valueToTree(this.getTenancy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnCapacityReservationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCapacityReservationProps.Jsii$Proxy that = (CfnCapacityReservationProps.Jsii$Proxy) o;

            if (!availabilityZone.equals(that.availabilityZone)) return false;
            if (this.ebsOptimized != null ? !this.ebsOptimized.equals(that.ebsOptimized) : that.ebsOptimized != null) return false;
            if (this.endDate != null ? !this.endDate.equals(that.endDate) : that.endDate != null) return false;
            if (this.endDateType != null ? !this.endDateType.equals(that.endDateType) : that.endDateType != null) return false;
            if (this.ephemeralStorage != null ? !this.ephemeralStorage.equals(that.ephemeralStorage) : that.ephemeralStorage != null) return false;
            if (!instanceCount.equals(that.instanceCount)) return false;
            if (this.instanceMatchCriteria != null ? !this.instanceMatchCriteria.equals(that.instanceMatchCriteria) : that.instanceMatchCriteria != null) return false;
            if (!instancePlatform.equals(that.instancePlatform)) return false;
            if (!instanceType.equals(that.instanceType)) return false;
            if (this.outPostArn != null ? !this.outPostArn.equals(that.outPostArn) : that.outPostArn != null) return false;
            if (this.placementGroupArn != null ? !this.placementGroupArn.equals(that.placementGroupArn) : that.placementGroupArn != null) return false;
            if (this.tagSpecifications != null ? !this.tagSpecifications.equals(that.tagSpecifications) : that.tagSpecifications != null) return false;
            return this.tenancy != null ? this.tenancy.equals(that.tenancy) : that.tenancy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.availabilityZone.hashCode();
            result = 31 * result + (this.ebsOptimized != null ? this.ebsOptimized.hashCode() : 0);
            result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
            result = 31 * result + (this.endDateType != null ? this.endDateType.hashCode() : 0);
            result = 31 * result + (this.ephemeralStorage != null ? this.ephemeralStorage.hashCode() : 0);
            result = 31 * result + (this.instanceCount.hashCode());
            result = 31 * result + (this.instanceMatchCriteria != null ? this.instanceMatchCriteria.hashCode() : 0);
            result = 31 * result + (this.instancePlatform.hashCode());
            result = 31 * result + (this.instanceType.hashCode());
            result = 31 * result + (this.outPostArn != null ? this.outPostArn.hashCode() : 0);
            result = 31 * result + (this.placementGroupArn != null ? this.placementGroupArn.hashCode() : 0);
            result = 31 * result + (this.tagSpecifications != null ? this.tagSpecifications.hashCode() : 0);
            result = 31 * result + (this.tenancy != null ? this.tenancy.hashCode() : 0);
            return result;
        }
    }
}
