package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::EC2Fleet`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnEC2Fleet cfnEC2Fleet = CfnEC2Fleet.Builder.create(this, "MyCfnEC2Fleet")
 *         .launchTemplateConfigs(List.of(FleetLaunchTemplateConfigRequestProperty.builder()
 *                 .launchTemplateSpecification(FleetLaunchTemplateSpecificationRequestProperty.builder()
 *                         .launchTemplateId("launchTemplateId")
 *                         .launchTemplateName("launchTemplateName")
 *                         .version("version")
 *                         .build())
 *                 .overrides(List.of(FleetLaunchTemplateOverridesRequestProperty.builder()
 *                         .availabilityZone("availabilityZone")
 *                         .instanceRequirements(InstanceRequirementsRequestProperty.builder()
 *                                 .acceleratorCount(AcceleratorCountRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .acceleratorManufacturers(List.of("acceleratorManufacturers"))
 *                                 .acceleratorNames(List.of("acceleratorNames"))
 *                                 .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .acceleratorTypes(List.of("acceleratorTypes"))
 *                                 .bareMetal("bareMetal")
 *                                 .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .burstablePerformance("burstablePerformance")
 *                                 .cpuManufacturers(List.of("cpuManufacturers"))
 *                                 .excludedInstanceTypes(List.of("excludedInstanceTypes"))
 *                                 .instanceGenerations(List.of("instanceGenerations"))
 *                                 .localStorage("localStorage")
 *                                 .localStorageTypes(List.of("localStorageTypes"))
 *                                 .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .memoryMiB(MemoryMiBRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .onDemandMaxPricePercentageOverLowestPrice(123)
 *                                 .requireHibernateSupport(false)
 *                                 .spotMaxPricePercentageOverLowestPrice(123)
 *                                 .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .vCpuCount(VCpuCountRangeRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .build())
 *                         .instanceType("instanceType")
 *                         .maxPrice("maxPrice")
 *                         .placement(PlacementProperty.builder()
 *                                 .affinity("affinity")
 *                                 .availabilityZone("availabilityZone")
 *                                 .groupName("groupName")
 *                                 .hostId("hostId")
 *                                 .hostResourceGroupArn("hostResourceGroupArn")
 *                                 .partitionNumber(123)
 *                                 .spreadDomain("spreadDomain")
 *                                 .tenancy("tenancy")
 *                                 .build())
 *                         .priority(123)
 *                         .subnetId("subnetId")
 *                         .weightedCapacity(123)
 *                         .build()))
 *                 .build()))
 *         .targetCapacitySpecification(TargetCapacitySpecificationRequestProperty.builder()
 *                 .totalTargetCapacity(123)
 *                 // the properties below are optional
 *                 .defaultTargetCapacityType("defaultTargetCapacityType")
 *                 .onDemandTargetCapacity(123)
 *                 .spotTargetCapacity(123)
 *                 .targetCapacityUnitType("targetCapacityUnitType")
 *                 .build())
 *         // the properties below are optional
 *         .context("context")
 *         .excessCapacityTerminationPolicy("excessCapacityTerminationPolicy")
 *         .onDemandOptions(OnDemandOptionsRequestProperty.builder()
 *                 .allocationStrategy("allocationStrategy")
 *                 .capacityReservationOptions(CapacityReservationOptionsRequestProperty.builder()
 *                         .usageStrategy("usageStrategy")
 *                         .build())
 *                 .maxTotalPrice("maxTotalPrice")
 *                 .minTargetCapacity(123)
 *                 .singleAvailabilityZone(false)
 *                 .singleInstanceType(false)
 *                 .build())
 *         .replaceUnhealthyInstances(false)
 *         .spotOptions(SpotOptionsRequestProperty.builder()
 *                 .allocationStrategy("allocationStrategy")
 *                 .instanceInterruptionBehavior("instanceInterruptionBehavior")
 *                 .instancePoolsToUseCount(123)
 *                 .maintenanceStrategies(MaintenanceStrategiesProperty.builder()
 *                         .capacityRebalance(CapacityRebalanceProperty.builder()
 *                                 .replacementStrategy("replacementStrategy")
 *                                 .terminationDelay(123)
 *                                 .build())
 *                         .build())
 *                 .maxTotalPrice("maxTotalPrice")
 *                 .minTargetCapacity(123)
 *                 .singleAvailabilityZone(false)
 *                 .singleInstanceType(false)
 *                 .build())
 *         .tagSpecifications(List.of(TagSpecificationProperty.builder()
 *                 .resourceType("resourceType")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build()))
 *         .terminateInstancesWithExpiration(false)
 *         .type("type")
 *         .validFrom("validFrom")
 *         .validUntil("validUntil")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.46.0 (build cd08c55)", date = "2021-11-23T14:40:39.514Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet")
public class CfnEC2Fleet extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnEC2Fleet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEC2Fleet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnEC2Fleet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::EC2::EC2Fleet`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEC2Fleet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnEC2FleetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFleetId() {
        return software.amazon.jsii.Kernel.get(this, "attrFleetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::EC2::EC2Fleet.Context`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getContext() {
        return software.amazon.jsii.Kernel.get(this, "context", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::EC2::EC2Fleet.Context`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContext(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "context", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.ExcessCapacityTerminationPolicy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getExcessCapacityTerminationPolicy() {
        return software.amazon.jsii.Kernel.get(this, "excessCapacityTerminationPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::EC2::EC2Fleet.ExcessCapacityTerminationPolicy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExcessCapacityTerminationPolicy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "excessCapacityTerminationPolicy", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.LaunchTemplateConfigs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getLaunchTemplateConfigs() {
        return software.amazon.jsii.Kernel.get(this, "launchTemplateConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::EC2::EC2Fleet.LaunchTemplateConfigs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLaunchTemplateConfigs(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "launchTemplateConfigs", java.util.Objects.requireNonNull(value, "launchTemplateConfigs is required"));
    }

    /**
     * `AWS::EC2::EC2Fleet.LaunchTemplateConfigs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLaunchTemplateConfigs(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "launchTemplateConfigs", java.util.Objects.requireNonNull(value, "launchTemplateConfigs is required"));
    }

    /**
     * `AWS::EC2::EC2Fleet.OnDemandOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOnDemandOptions() {
        return software.amazon.jsii.Kernel.get(this, "onDemandOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::EC2::EC2Fleet.OnDemandOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOnDemandOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "onDemandOptions", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.OnDemandOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOnDemandOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty value) {
        software.amazon.jsii.Kernel.set(this, "onDemandOptions", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.ReplaceUnhealthyInstances`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getReplaceUnhealthyInstances() {
        return software.amazon.jsii.Kernel.get(this, "replaceUnhealthyInstances", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::EC2::EC2Fleet.ReplaceUnhealthyInstances`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplaceUnhealthyInstances(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "replaceUnhealthyInstances", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.ReplaceUnhealthyInstances`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplaceUnhealthyInstances(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "replaceUnhealthyInstances", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.SpotOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSpotOptions() {
        return software.amazon.jsii.Kernel.get(this, "spotOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::EC2::EC2Fleet.SpotOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpotOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "spotOptions", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.SpotOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpotOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnEC2Fleet.SpotOptionsRequestProperty value) {
        software.amazon.jsii.Kernel.set(this, "spotOptions", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.TagSpecifications`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTagSpecifications() {
        return software.amazon.jsii.Kernel.get(this, "tagSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::EC2::EC2Fleet.TagSpecifications`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "tagSpecifications", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.TagSpecifications`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagSpecifications(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "tagSpecifications", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.TargetCapacitySpecification`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTargetCapacitySpecification() {
        return software.amazon.jsii.Kernel.get(this, "targetCapacitySpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::EC2::EC2Fleet.TargetCapacitySpecification`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetCapacitySpecification(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targetCapacitySpecification", java.util.Objects.requireNonNull(value, "targetCapacitySpecification is required"));
    }

    /**
     * `AWS::EC2::EC2Fleet.TargetCapacitySpecification`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetCapacitySpecification(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnEC2Fleet.TargetCapacitySpecificationRequestProperty value) {
        software.amazon.jsii.Kernel.set(this, "targetCapacitySpecification", java.util.Objects.requireNonNull(value, "targetCapacitySpecification is required"));
    }

    /**
     * `AWS::EC2::EC2Fleet.TerminateInstancesWithExpiration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTerminateInstancesWithExpiration() {
        return software.amazon.jsii.Kernel.get(this, "terminateInstancesWithExpiration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::EC2::EC2Fleet.TerminateInstancesWithExpiration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTerminateInstancesWithExpiration(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "terminateInstancesWithExpiration", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.TerminateInstancesWithExpiration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTerminateInstancesWithExpiration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "terminateInstancesWithExpiration", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.Type`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::EC2::EC2Fleet.Type`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.ValidFrom`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getValidFrom() {
        return software.amazon.jsii.Kernel.get(this, "validFrom", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::EC2::EC2Fleet.ValidFrom`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValidFrom(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "validFrom", value);
    }

    /**
     * `AWS::EC2::EC2Fleet.ValidUntil`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getValidUntil() {
        return software.amazon.jsii.Kernel.get(this, "validUntil", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::EC2::EC2Fleet.ValidUntil`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValidUntil(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "validUntil", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * AcceleratorCountRequestProperty acceleratorCountRequestProperty = AcceleratorCountRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.AcceleratorCountRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(AcceleratorCountRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AcceleratorCountRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.AcceleratorCountRequestProperty.Max`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * `CfnEC2Fleet.AcceleratorCountRequestProperty.Min`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AcceleratorCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AcceleratorCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AcceleratorCountRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link AcceleratorCountRequestProperty#getMax}
             * @param max `CfnEC2Fleet.AcceleratorCountRequestProperty.Max`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link AcceleratorCountRequestProperty#getMin}
             * @param min `CfnEC2Fleet.AcceleratorCountRequestProperty.Min`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AcceleratorCountRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AcceleratorCountRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AcceleratorCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AcceleratorCountRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.AcceleratorCountRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AcceleratorCountRequestProperty.Jsii$Proxy that = (AcceleratorCountRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * AcceleratorTotalMemoryMiBRequestProperty acceleratorTotalMemoryMiBRequestProperty = AcceleratorTotalMemoryMiBRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.AcceleratorTotalMemoryMiBRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(AcceleratorTotalMemoryMiBRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AcceleratorTotalMemoryMiBRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.AcceleratorTotalMemoryMiBRequestProperty.Max`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * `CfnEC2Fleet.AcceleratorTotalMemoryMiBRequestProperty.Min`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AcceleratorTotalMemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AcceleratorTotalMemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AcceleratorTotalMemoryMiBRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link AcceleratorTotalMemoryMiBRequestProperty#getMax}
             * @param max `CfnEC2Fleet.AcceleratorTotalMemoryMiBRequestProperty.Max`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link AcceleratorTotalMemoryMiBRequestProperty#getMin}
             * @param min `CfnEC2Fleet.AcceleratorTotalMemoryMiBRequestProperty.Min`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AcceleratorTotalMemoryMiBRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AcceleratorTotalMemoryMiBRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AcceleratorTotalMemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AcceleratorTotalMemoryMiBRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.AcceleratorTotalMemoryMiBRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AcceleratorTotalMemoryMiBRequestProperty.Jsii$Proxy that = (AcceleratorTotalMemoryMiBRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * BaselineEbsBandwidthMbpsRequestProperty baselineEbsBandwidthMbpsRequestProperty = BaselineEbsBandwidthMbpsRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.BaselineEbsBandwidthMbpsRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(BaselineEbsBandwidthMbpsRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BaselineEbsBandwidthMbpsRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.BaselineEbsBandwidthMbpsRequestProperty.Max`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * `CfnEC2Fleet.BaselineEbsBandwidthMbpsRequestProperty.Min`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BaselineEbsBandwidthMbpsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BaselineEbsBandwidthMbpsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BaselineEbsBandwidthMbpsRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link BaselineEbsBandwidthMbpsRequestProperty#getMax}
             * @param max `CfnEC2Fleet.BaselineEbsBandwidthMbpsRequestProperty.Max`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link BaselineEbsBandwidthMbpsRequestProperty#getMin}
             * @param min `CfnEC2Fleet.BaselineEbsBandwidthMbpsRequestProperty.Min`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BaselineEbsBandwidthMbpsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BaselineEbsBandwidthMbpsRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BaselineEbsBandwidthMbpsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaselineEbsBandwidthMbpsRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.BaselineEbsBandwidthMbpsRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BaselineEbsBandwidthMbpsRequestProperty.Jsii$Proxy that = (BaselineEbsBandwidthMbpsRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * CapacityRebalanceProperty capacityRebalanceProperty = CapacityRebalanceProperty.builder()
     *         .replacementStrategy("replacementStrategy")
     *         .terminationDelay(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.CapacityRebalanceProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityRebalanceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityRebalanceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.CapacityRebalanceProperty.ReplacementStrategy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReplacementStrategy() {
            return null;
        }

        /**
         * `CfnEC2Fleet.CapacityRebalanceProperty.TerminationDelay`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTerminationDelay() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapacityRebalanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityRebalanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityRebalanceProperty> {
            java.lang.String replacementStrategy;
            java.lang.Number terminationDelay;

            /**
             * Sets the value of {@link CapacityRebalanceProperty#getReplacementStrategy}
             * @param replacementStrategy `CfnEC2Fleet.CapacityRebalanceProperty.ReplacementStrategy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replacementStrategy(java.lang.String replacementStrategy) {
                this.replacementStrategy = replacementStrategy;
                return this;
            }

            /**
             * Sets the value of {@link CapacityRebalanceProperty#getTerminationDelay}
             * @param terminationDelay `CfnEC2Fleet.CapacityRebalanceProperty.TerminationDelay`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder terminationDelay(java.lang.Number terminationDelay) {
                this.terminationDelay = terminationDelay;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityRebalanceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityRebalanceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacityRebalanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityRebalanceProperty {
            private final java.lang.String replacementStrategy;
            private final java.lang.Number terminationDelay;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.replacementStrategy = software.amazon.jsii.Kernel.get(this, "replacementStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.terminationDelay = software.amazon.jsii.Kernel.get(this, "terminationDelay", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.replacementStrategy = builder.replacementStrategy;
                this.terminationDelay = builder.terminationDelay;
            }

            @Override
            public final java.lang.String getReplacementStrategy() {
                return this.replacementStrategy;
            }

            @Override
            public final java.lang.Number getTerminationDelay() {
                return this.terminationDelay;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReplacementStrategy() != null) {
                    data.set("replacementStrategy", om.valueToTree(this.getReplacementStrategy()));
                }
                if (this.getTerminationDelay() != null) {
                    data.set("terminationDelay", om.valueToTree(this.getTerminationDelay()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.CapacityRebalanceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityRebalanceProperty.Jsii$Proxy that = (CapacityRebalanceProperty.Jsii$Proxy) o;

                if (this.replacementStrategy != null ? !this.replacementStrategy.equals(that.replacementStrategy) : that.replacementStrategy != null) return false;
                return this.terminationDelay != null ? this.terminationDelay.equals(that.terminationDelay) : that.terminationDelay == null;
            }

            @Override
            public final int hashCode() {
                int result = this.replacementStrategy != null ? this.replacementStrategy.hashCode() : 0;
                result = 31 * result + (this.terminationDelay != null ? this.terminationDelay.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * CapacityReservationOptionsRequestProperty capacityReservationOptionsRequestProperty = CapacityReservationOptionsRequestProperty.builder()
     *         .usageStrategy("usageStrategy")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.CapacityReservationOptionsRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityReservationOptionsRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityReservationOptionsRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.CapacityReservationOptionsRequestProperty.UsageStrategy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUsageStrategy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapacityReservationOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityReservationOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityReservationOptionsRequestProperty> {
            java.lang.String usageStrategy;

            /**
             * Sets the value of {@link CapacityReservationOptionsRequestProperty#getUsageStrategy}
             * @param usageStrategy `CfnEC2Fleet.CapacityReservationOptionsRequestProperty.UsageStrategy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder usageStrategy(java.lang.String usageStrategy) {
                this.usageStrategy = usageStrategy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityReservationOptionsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityReservationOptionsRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacityReservationOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityReservationOptionsRequestProperty {
            private final java.lang.String usageStrategy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.usageStrategy = software.amazon.jsii.Kernel.get(this, "usageStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.usageStrategy = builder.usageStrategy;
            }

            @Override
            public final java.lang.String getUsageStrategy() {
                return this.usageStrategy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getUsageStrategy() != null) {
                    data.set("usageStrategy", om.valueToTree(this.getUsageStrategy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.CapacityReservationOptionsRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityReservationOptionsRequestProperty.Jsii$Proxy that = (CapacityReservationOptionsRequestProperty.Jsii$Proxy) o;

                return this.usageStrategy != null ? this.usageStrategy.equals(that.usageStrategy) : that.usageStrategy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.usageStrategy != null ? this.usageStrategy.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * FleetLaunchTemplateConfigRequestProperty fleetLaunchTemplateConfigRequestProperty = FleetLaunchTemplateConfigRequestProperty.builder()
     *         .launchTemplateSpecification(FleetLaunchTemplateSpecificationRequestProperty.builder()
     *                 .launchTemplateId("launchTemplateId")
     *                 .launchTemplateName("launchTemplateName")
     *                 .version("version")
     *                 .build())
     *         .overrides(List.of(FleetLaunchTemplateOverridesRequestProperty.builder()
     *                 .availabilityZone("availabilityZone")
     *                 .instanceRequirements(InstanceRequirementsRequestProperty.builder()
     *                         .acceleratorCount(AcceleratorCountRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .acceleratorManufacturers(List.of("acceleratorManufacturers"))
     *                         .acceleratorNames(List.of("acceleratorNames"))
     *                         .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .acceleratorTypes(List.of("acceleratorTypes"))
     *                         .bareMetal("bareMetal")
     *                         .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .burstablePerformance("burstablePerformance")
     *                         .cpuManufacturers(List.of("cpuManufacturers"))
     *                         .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *                         .instanceGenerations(List.of("instanceGenerations"))
     *                         .localStorage("localStorage")
     *                         .localStorageTypes(List.of("localStorageTypes"))
     *                         .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .memoryMiB(MemoryMiBRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .onDemandMaxPricePercentageOverLowestPrice(123)
     *                         .requireHibernateSupport(false)
     *                         .spotMaxPricePercentageOverLowestPrice(123)
     *                         .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .vCpuCount(VCpuCountRangeRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .build())
     *                 .instanceType("instanceType")
     *                 .maxPrice("maxPrice")
     *                 .placement(PlacementProperty.builder()
     *                         .affinity("affinity")
     *                         .availabilityZone("availabilityZone")
     *                         .groupName("groupName")
     *                         .hostId("hostId")
     *                         .hostResourceGroupArn("hostResourceGroupArn")
     *                         .partitionNumber(123)
     *                         .spreadDomain("spreadDomain")
     *                         .tenancy("tenancy")
     *                         .build())
     *                 .priority(123)
     *                 .subnetId("subnetId")
     *                 .weightedCapacity(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(FleetLaunchTemplateConfigRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FleetLaunchTemplateConfigRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.LaunchTemplateSpecification`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLaunchTemplateSpecification() {
            return null;
        }

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.Overrides`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverrides() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FleetLaunchTemplateConfigRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FleetLaunchTemplateConfigRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FleetLaunchTemplateConfigRequestProperty> {
            java.lang.Object launchTemplateSpecification;
            java.lang.Object overrides;

            /**
             * Sets the value of {@link FleetLaunchTemplateConfigRequestProperty#getLaunchTemplateSpecification}
             * @param launchTemplateSpecification `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.LaunchTemplateSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateSpecification(software.amazon.awscdk.core.IResolvable launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateConfigRequestProperty#getLaunchTemplateSpecification}
             * @param launchTemplateSpecification `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.LaunchTemplateSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateSpecification(software.amazon.awscdk.services.ec2.CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateConfigRequestProperty#getOverrides}
             * @param overrides `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.Overrides`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrides(software.amazon.awscdk.core.IResolvable overrides) {
                this.overrides = overrides;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateConfigRequestProperty#getOverrides}
             * @param overrides `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.Overrides`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrides(java.util.List<? extends java.lang.Object> overrides) {
                this.overrides = overrides;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetLaunchTemplateConfigRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FleetLaunchTemplateConfigRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FleetLaunchTemplateConfigRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FleetLaunchTemplateConfigRequestProperty {
            private final java.lang.Object launchTemplateSpecification;
            private final java.lang.Object overrides;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.launchTemplateSpecification = software.amazon.jsii.Kernel.get(this, "launchTemplateSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.overrides = software.amazon.jsii.Kernel.get(this, "overrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.launchTemplateSpecification = builder.launchTemplateSpecification;
                this.overrides = builder.overrides;
            }

            @Override
            public final java.lang.Object getLaunchTemplateSpecification() {
                return this.launchTemplateSpecification;
            }

            @Override
            public final java.lang.Object getOverrides() {
                return this.overrides;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLaunchTemplateSpecification() != null) {
                    data.set("launchTemplateSpecification", om.valueToTree(this.getLaunchTemplateSpecification()));
                }
                if (this.getOverrides() != null) {
                    data.set("overrides", om.valueToTree(this.getOverrides()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FleetLaunchTemplateConfigRequestProperty.Jsii$Proxy that = (FleetLaunchTemplateConfigRequestProperty.Jsii$Proxy) o;

                if (this.launchTemplateSpecification != null ? !this.launchTemplateSpecification.equals(that.launchTemplateSpecification) : that.launchTemplateSpecification != null) return false;
                return this.overrides != null ? this.overrides.equals(that.overrides) : that.overrides == null;
            }

            @Override
            public final int hashCode() {
                int result = this.launchTemplateSpecification != null ? this.launchTemplateSpecification.hashCode() : 0;
                result = 31 * result + (this.overrides != null ? this.overrides.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * FleetLaunchTemplateOverridesRequestProperty fleetLaunchTemplateOverridesRequestProperty = FleetLaunchTemplateOverridesRequestProperty.builder()
     *         .availabilityZone("availabilityZone")
     *         .instanceRequirements(InstanceRequirementsRequestProperty.builder()
     *                 .acceleratorCount(AcceleratorCountRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .acceleratorManufacturers(List.of("acceleratorManufacturers"))
     *                 .acceleratorNames(List.of("acceleratorNames"))
     *                 .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .acceleratorTypes(List.of("acceleratorTypes"))
     *                 .bareMetal("bareMetal")
     *                 .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .burstablePerformance("burstablePerformance")
     *                 .cpuManufacturers(List.of("cpuManufacturers"))
     *                 .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *                 .instanceGenerations(List.of("instanceGenerations"))
     *                 .localStorage("localStorage")
     *                 .localStorageTypes(List.of("localStorageTypes"))
     *                 .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .memoryMiB(MemoryMiBRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .onDemandMaxPricePercentageOverLowestPrice(123)
     *                 .requireHibernateSupport(false)
     *                 .spotMaxPricePercentageOverLowestPrice(123)
     *                 .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .vCpuCount(VCpuCountRangeRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .build())
     *         .instanceType("instanceType")
     *         .maxPrice("maxPrice")
     *         .placement(PlacementProperty.builder()
     *                 .affinity("affinity")
     *                 .availabilityZone("availabilityZone")
     *                 .groupName("groupName")
     *                 .hostId("hostId")
     *                 .hostResourceGroupArn("hostResourceGroupArn")
     *                 .partitionNumber(123)
     *                 .spreadDomain("spreadDomain")
     *                 .tenancy("tenancy")
     *                 .build())
     *         .priority(123)
     *         .subnetId("subnetId")
     *         .weightedCapacity(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(FleetLaunchTemplateOverridesRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FleetLaunchTemplateOverridesRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.AvailabilityZone`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.InstanceRequirements`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceRequirements() {
            return null;
        }

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.InstanceType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.MaxPrice`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaxPrice() {
            return null;
        }

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.Placement`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPlacement() {
            return null;
        }

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.Priority`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
            return null;
        }

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.SubnetId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
            return null;
        }

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.WeightedCapacity`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeightedCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FleetLaunchTemplateOverridesRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FleetLaunchTemplateOverridesRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FleetLaunchTemplateOverridesRequestProperty> {
            java.lang.String availabilityZone;
            java.lang.Object instanceRequirements;
            java.lang.String instanceType;
            java.lang.String maxPrice;
            java.lang.Object placement;
            java.lang.Number priority;
            java.lang.String subnetId;
            java.lang.Number weightedCapacity;

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getAvailabilityZone}
             * @param availabilityZone `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.AvailabilityZone`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getInstanceRequirements}
             * @param instanceRequirements `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.InstanceRequirements`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceRequirements(software.amazon.awscdk.core.IResolvable instanceRequirements) {
                this.instanceRequirements = instanceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getInstanceRequirements}
             * @param instanceRequirements `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.InstanceRequirements`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceRequirements(software.amazon.awscdk.services.ec2.CfnEC2Fleet.InstanceRequirementsRequestProperty instanceRequirements) {
                this.instanceRequirements = instanceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getInstanceType}
             * @param instanceType `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.InstanceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getMaxPrice}
             * @param maxPrice `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.MaxPrice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxPrice(java.lang.String maxPrice) {
                this.maxPrice = maxPrice;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getPlacement}
             * @param placement `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.Placement`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placement(software.amazon.awscdk.core.IResolvable placement) {
                this.placement = placement;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getPlacement}
             * @param placement `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.Placement`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placement(software.amazon.awscdk.services.ec2.CfnEC2Fleet.PlacementProperty placement) {
                this.placement = placement;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getPriority}
             * @param priority `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.Priority`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getSubnetId}
             * @param subnetId `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.SubnetId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetId(java.lang.String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getWeightedCapacity}
             * @param weightedCapacity `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.WeightedCapacity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weightedCapacity(java.lang.Number weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetLaunchTemplateOverridesRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FleetLaunchTemplateOverridesRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FleetLaunchTemplateOverridesRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FleetLaunchTemplateOverridesRequestProperty {
            private final java.lang.String availabilityZone;
            private final java.lang.Object instanceRequirements;
            private final java.lang.String instanceType;
            private final java.lang.String maxPrice;
            private final java.lang.Object placement;
            private final java.lang.Number priority;
            private final java.lang.String subnetId;
            private final java.lang.Number weightedCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceRequirements = software.amazon.jsii.Kernel.get(this, "instanceRequirements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maxPrice = software.amazon.jsii.Kernel.get(this, "maxPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.placement = software.amazon.jsii.Kernel.get(this, "placement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.weightedCapacity = software.amazon.jsii.Kernel.get(this, "weightedCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZone = builder.availabilityZone;
                this.instanceRequirements = builder.instanceRequirements;
                this.instanceType = builder.instanceType;
                this.maxPrice = builder.maxPrice;
                this.placement = builder.placement;
                this.priority = builder.priority;
                this.subnetId = builder.subnetId;
                this.weightedCapacity = builder.weightedCapacity;
            }

            @Override
            public final java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public final java.lang.Object getInstanceRequirements() {
                return this.instanceRequirements;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.String getMaxPrice() {
                return this.maxPrice;
            }

            @Override
            public final java.lang.Object getPlacement() {
                return this.placement;
            }

            @Override
            public final java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            public final java.lang.String getSubnetId() {
                return this.subnetId;
            }

            @Override
            public final java.lang.Number getWeightedCapacity() {
                return this.weightedCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getInstanceRequirements() != null) {
                    data.set("instanceRequirements", om.valueToTree(this.getInstanceRequirements()));
                }
                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getMaxPrice() != null) {
                    data.set("maxPrice", om.valueToTree(this.getMaxPrice()));
                }
                if (this.getPlacement() != null) {
                    data.set("placement", om.valueToTree(this.getPlacement()));
                }
                if (this.getPriority() != null) {
                    data.set("priority", om.valueToTree(this.getPriority()));
                }
                if (this.getSubnetId() != null) {
                    data.set("subnetId", om.valueToTree(this.getSubnetId()));
                }
                if (this.getWeightedCapacity() != null) {
                    data.set("weightedCapacity", om.valueToTree(this.getWeightedCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FleetLaunchTemplateOverridesRequestProperty.Jsii$Proxy that = (FleetLaunchTemplateOverridesRequestProperty.Jsii$Proxy) o;

                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                if (this.instanceRequirements != null ? !this.instanceRequirements.equals(that.instanceRequirements) : that.instanceRequirements != null) return false;
                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.maxPrice != null ? !this.maxPrice.equals(that.maxPrice) : that.maxPrice != null) return false;
                if (this.placement != null ? !this.placement.equals(that.placement) : that.placement != null) return false;
                if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) return false;
                if (this.subnetId != null ? !this.subnetId.equals(that.subnetId) : that.subnetId != null) return false;
                return this.weightedCapacity != null ? this.weightedCapacity.equals(that.weightedCapacity) : that.weightedCapacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availabilityZone != null ? this.availabilityZone.hashCode() : 0;
                result = 31 * result + (this.instanceRequirements != null ? this.instanceRequirements.hashCode() : 0);
                result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
                result = 31 * result + (this.maxPrice != null ? this.maxPrice.hashCode() : 0);
                result = 31 * result + (this.placement != null ? this.placement.hashCode() : 0);
                result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
                result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
                result = 31 * result + (this.weightedCapacity != null ? this.weightedCapacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * FleetLaunchTemplateSpecificationRequestProperty fleetLaunchTemplateSpecificationRequestProperty = FleetLaunchTemplateSpecificationRequestProperty.builder()
     *         .launchTemplateId("launchTemplateId")
     *         .launchTemplateName("launchTemplateName")
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(FleetLaunchTemplateSpecificationRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FleetLaunchTemplateSpecificationRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateId() {
            return null;
        }

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateName() {
            return null;
        }

        /**
         * `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.Version`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FleetLaunchTemplateSpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FleetLaunchTemplateSpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FleetLaunchTemplateSpecificationRequestProperty> {
            java.lang.String launchTemplateId;
            java.lang.String launchTemplateName;
            java.lang.String version;

            /**
             * Sets the value of {@link FleetLaunchTemplateSpecificationRequestProperty#getLaunchTemplateId}
             * @param launchTemplateId `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateId(java.lang.String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateSpecificationRequestProperty#getLaunchTemplateName}
             * @param launchTemplateName `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateName(java.lang.String launchTemplateName) {
                this.launchTemplateName = launchTemplateName;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateSpecificationRequestProperty#getVersion}
             * @param version `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.Version`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetLaunchTemplateSpecificationRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FleetLaunchTemplateSpecificationRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FleetLaunchTemplateSpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FleetLaunchTemplateSpecificationRequestProperty {
            private final java.lang.String launchTemplateId;
            private final java.lang.String launchTemplateName;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.launchTemplateId = software.amazon.jsii.Kernel.get(this, "launchTemplateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.launchTemplateName = software.amazon.jsii.Kernel.get(this, "launchTemplateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.launchTemplateId = builder.launchTemplateId;
                this.launchTemplateName = builder.launchTemplateName;
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getLaunchTemplateId() {
                return this.launchTemplateId;
            }

            @Override
            public final java.lang.String getLaunchTemplateName() {
                return this.launchTemplateName;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLaunchTemplateId() != null) {
                    data.set("launchTemplateId", om.valueToTree(this.getLaunchTemplateId()));
                }
                if (this.getLaunchTemplateName() != null) {
                    data.set("launchTemplateName", om.valueToTree(this.getLaunchTemplateName()));
                }
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FleetLaunchTemplateSpecificationRequestProperty.Jsii$Proxy that = (FleetLaunchTemplateSpecificationRequestProperty.Jsii$Proxy) o;

                if (this.launchTemplateId != null ? !this.launchTemplateId.equals(that.launchTemplateId) : that.launchTemplateId != null) return false;
                if (this.launchTemplateName != null ? !this.launchTemplateName.equals(that.launchTemplateName) : that.launchTemplateName != null) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.launchTemplateId != null ? this.launchTemplateId.hashCode() : 0;
                result = 31 * result + (this.launchTemplateName != null ? this.launchTemplateName.hashCode() : 0);
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * InstanceRequirementsRequestProperty instanceRequirementsRequestProperty = InstanceRequirementsRequestProperty.builder()
     *         .acceleratorCount(AcceleratorCountRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .acceleratorManufacturers(List.of("acceleratorManufacturers"))
     *         .acceleratorNames(List.of("acceleratorNames"))
     *         .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .acceleratorTypes(List.of("acceleratorTypes"))
     *         .bareMetal("bareMetal")
     *         .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .burstablePerformance("burstablePerformance")
     *         .cpuManufacturers(List.of("cpuManufacturers"))
     *         .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *         .instanceGenerations(List.of("instanceGenerations"))
     *         .localStorage("localStorage")
     *         .localStorageTypes(List.of("localStorageTypes"))
     *         .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .memoryMiB(MemoryMiBRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .onDemandMaxPricePercentageOverLowestPrice(123)
     *         .requireHibernateSupport(false)
     *         .spotMaxPricePercentageOverLowestPrice(123)
     *         .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .vCpuCount(VCpuCountRangeRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.InstanceRequirementsRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceRequirementsRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceRequirementsRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.AcceleratorCount`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAcceleratorCount() {
            return null;
        }

        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.AcceleratorManufacturers`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAcceleratorManufacturers() {
            return null;
        }

        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.AcceleratorNames`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAcceleratorNames() {
            return null;
        }

        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.AcceleratorTotalMemoryMiB`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAcceleratorTotalMemoryMiB() {
            return null;
        }

        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.AcceleratorTypes`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAcceleratorTypes() {
            return null;
        }

        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.BareMetal`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBareMetal() {
            return null;
        }

        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.BaselineEbsBandwidthMbps`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBaselineEbsBandwidthMbps() {
            return null;
        }

        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.BurstablePerformance`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBurstablePerformance() {
            return null;
        }

        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.CpuManufacturers`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCpuManufacturers() {
            return null;
        }

        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.ExcludedInstanceTypes`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludedInstanceTypes() {
            return null;
        }

        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.InstanceGenerations`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstanceGenerations() {
            return null;
        }

        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.LocalStorage`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocalStorage() {
            return null;
        }

        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.LocalStorageTypes`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLocalStorageTypes() {
            return null;
        }

        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.MemoryGiBPerVCpu`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMemoryGiBPerVCpu() {
            return null;
        }

        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.MemoryMiB`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMemoryMiB() {
            return null;
        }

        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.NetworkInterfaceCount`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkInterfaceCount() {
            return null;
        }

        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.OnDemandMaxPricePercentageOverLowestPrice`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOnDemandMaxPricePercentageOverLowestPrice() {
            return null;
        }

        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.RequireHibernateSupport`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireHibernateSupport() {
            return null;
        }

        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.SpotMaxPricePercentageOverLowestPrice`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSpotMaxPricePercentageOverLowestPrice() {
            return null;
        }

        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.TotalLocalStorageGB`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTotalLocalStorageGb() {
            return null;
        }

        /**
         * `CfnEC2Fleet.InstanceRequirementsRequestProperty.VCpuCount`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVCpuCount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceRequirementsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceRequirementsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceRequirementsRequestProperty> {
            java.lang.Object acceleratorCount;
            java.util.List<java.lang.String> acceleratorManufacturers;
            java.util.List<java.lang.String> acceleratorNames;
            java.lang.Object acceleratorTotalMemoryMiB;
            java.util.List<java.lang.String> acceleratorTypes;
            java.lang.String bareMetal;
            java.lang.Object baselineEbsBandwidthMbps;
            java.lang.String burstablePerformance;
            java.util.List<java.lang.String> cpuManufacturers;
            java.util.List<java.lang.String> excludedInstanceTypes;
            java.util.List<java.lang.String> instanceGenerations;
            java.lang.String localStorage;
            java.util.List<java.lang.String> localStorageTypes;
            java.lang.Object memoryGiBPerVCpu;
            java.lang.Object memoryMiB;
            java.lang.Object networkInterfaceCount;
            java.lang.Number onDemandMaxPricePercentageOverLowestPrice;
            java.lang.Object requireHibernateSupport;
            java.lang.Number spotMaxPricePercentageOverLowestPrice;
            java.lang.Object totalLocalStorageGb;
            java.lang.Object vCpuCount;

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorCount}
             * @param acceleratorCount `CfnEC2Fleet.InstanceRequirementsRequestProperty.AcceleratorCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorCount(software.amazon.awscdk.core.IResolvable acceleratorCount) {
                this.acceleratorCount = acceleratorCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorCount}
             * @param acceleratorCount `CfnEC2Fleet.InstanceRequirementsRequestProperty.AcceleratorCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorCount(software.amazon.awscdk.services.ec2.CfnEC2Fleet.AcceleratorCountRequestProperty acceleratorCount) {
                this.acceleratorCount = acceleratorCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorManufacturers}
             * @param acceleratorManufacturers `CfnEC2Fleet.InstanceRequirementsRequestProperty.AcceleratorManufacturers`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorManufacturers(java.util.List<java.lang.String> acceleratorManufacturers) {
                this.acceleratorManufacturers = acceleratorManufacturers;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorNames}
             * @param acceleratorNames `CfnEC2Fleet.InstanceRequirementsRequestProperty.AcceleratorNames`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorNames(java.util.List<java.lang.String> acceleratorNames) {
                this.acceleratorNames = acceleratorNames;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorTotalMemoryMiB}
             * @param acceleratorTotalMemoryMiB `CfnEC2Fleet.InstanceRequirementsRequestProperty.AcceleratorTotalMemoryMiB`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorTotalMemoryMiB(software.amazon.awscdk.core.IResolvable acceleratorTotalMemoryMiB) {
                this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorTotalMemoryMiB}
             * @param acceleratorTotalMemoryMiB `CfnEC2Fleet.InstanceRequirementsRequestProperty.AcceleratorTotalMemoryMiB`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorTotalMemoryMiB(software.amazon.awscdk.services.ec2.CfnEC2Fleet.AcceleratorTotalMemoryMiBRequestProperty acceleratorTotalMemoryMiB) {
                this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorTypes}
             * @param acceleratorTypes `CfnEC2Fleet.InstanceRequirementsRequestProperty.AcceleratorTypes`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorTypes(java.util.List<java.lang.String> acceleratorTypes) {
                this.acceleratorTypes = acceleratorTypes;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getBareMetal}
             * @param bareMetal `CfnEC2Fleet.InstanceRequirementsRequestProperty.BareMetal`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bareMetal(java.lang.String bareMetal) {
                this.bareMetal = bareMetal;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getBaselineEbsBandwidthMbps}
             * @param baselineEbsBandwidthMbps `CfnEC2Fleet.InstanceRequirementsRequestProperty.BaselineEbsBandwidthMbps`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baselineEbsBandwidthMbps(software.amazon.awscdk.core.IResolvable baselineEbsBandwidthMbps) {
                this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getBaselineEbsBandwidthMbps}
             * @param baselineEbsBandwidthMbps `CfnEC2Fleet.InstanceRequirementsRequestProperty.BaselineEbsBandwidthMbps`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baselineEbsBandwidthMbps(software.amazon.awscdk.services.ec2.CfnEC2Fleet.BaselineEbsBandwidthMbpsRequestProperty baselineEbsBandwidthMbps) {
                this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getBurstablePerformance}
             * @param burstablePerformance `CfnEC2Fleet.InstanceRequirementsRequestProperty.BurstablePerformance`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder burstablePerformance(java.lang.String burstablePerformance) {
                this.burstablePerformance = burstablePerformance;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getCpuManufacturers}
             * @param cpuManufacturers `CfnEC2Fleet.InstanceRequirementsRequestProperty.CpuManufacturers`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpuManufacturers(java.util.List<java.lang.String> cpuManufacturers) {
                this.cpuManufacturers = cpuManufacturers;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getExcludedInstanceTypes}
             * @param excludedInstanceTypes `CfnEC2Fleet.InstanceRequirementsRequestProperty.ExcludedInstanceTypes`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludedInstanceTypes(java.util.List<java.lang.String> excludedInstanceTypes) {
                this.excludedInstanceTypes = excludedInstanceTypes;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getInstanceGenerations}
             * @param instanceGenerations `CfnEC2Fleet.InstanceRequirementsRequestProperty.InstanceGenerations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceGenerations(java.util.List<java.lang.String> instanceGenerations) {
                this.instanceGenerations = instanceGenerations;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getLocalStorage}
             * @param localStorage `CfnEC2Fleet.InstanceRequirementsRequestProperty.LocalStorage`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localStorage(java.lang.String localStorage) {
                this.localStorage = localStorage;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getLocalStorageTypes}
             * @param localStorageTypes `CfnEC2Fleet.InstanceRequirementsRequestProperty.LocalStorageTypes`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localStorageTypes(java.util.List<java.lang.String> localStorageTypes) {
                this.localStorageTypes = localStorageTypes;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getMemoryGiBPerVCpu}
             * @param memoryGiBPerVCpu `CfnEC2Fleet.InstanceRequirementsRequestProperty.MemoryGiBPerVCpu`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryGiBPerVCpu(software.amazon.awscdk.core.IResolvable memoryGiBPerVCpu) {
                this.memoryGiBPerVCpu = memoryGiBPerVCpu;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getMemoryGiBPerVCpu}
             * @param memoryGiBPerVCpu `CfnEC2Fleet.InstanceRequirementsRequestProperty.MemoryGiBPerVCpu`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryGiBPerVCpu(software.amazon.awscdk.services.ec2.CfnEC2Fleet.MemoryGiBPerVCpuRequestProperty memoryGiBPerVCpu) {
                this.memoryGiBPerVCpu = memoryGiBPerVCpu;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getMemoryMiB}
             * @param memoryMiB `CfnEC2Fleet.InstanceRequirementsRequestProperty.MemoryMiB`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryMiB(software.amazon.awscdk.core.IResolvable memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getMemoryMiB}
             * @param memoryMiB `CfnEC2Fleet.InstanceRequirementsRequestProperty.MemoryMiB`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryMiB(software.amazon.awscdk.services.ec2.CfnEC2Fleet.MemoryMiBRequestProperty memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getNetworkInterfaceCount}
             * @param networkInterfaceCount `CfnEC2Fleet.InstanceRequirementsRequestProperty.NetworkInterfaceCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceCount(software.amazon.awscdk.core.IResolvable networkInterfaceCount) {
                this.networkInterfaceCount = networkInterfaceCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getNetworkInterfaceCount}
             * @param networkInterfaceCount `CfnEC2Fleet.InstanceRequirementsRequestProperty.NetworkInterfaceCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceCount(software.amazon.awscdk.services.ec2.CfnEC2Fleet.NetworkInterfaceCountRequestProperty networkInterfaceCount) {
                this.networkInterfaceCount = networkInterfaceCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getOnDemandMaxPricePercentageOverLowestPrice}
             * @param onDemandMaxPricePercentageOverLowestPrice `CfnEC2Fleet.InstanceRequirementsRequestProperty.OnDemandMaxPricePercentageOverLowestPrice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onDemandMaxPricePercentageOverLowestPrice(java.lang.Number onDemandMaxPricePercentageOverLowestPrice) {
                this.onDemandMaxPricePercentageOverLowestPrice = onDemandMaxPricePercentageOverLowestPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getRequireHibernateSupport}
             * @param requireHibernateSupport `CfnEC2Fleet.InstanceRequirementsRequestProperty.RequireHibernateSupport`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireHibernateSupport(java.lang.Boolean requireHibernateSupport) {
                this.requireHibernateSupport = requireHibernateSupport;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getRequireHibernateSupport}
             * @param requireHibernateSupport `CfnEC2Fleet.InstanceRequirementsRequestProperty.RequireHibernateSupport`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireHibernateSupport(software.amazon.awscdk.core.IResolvable requireHibernateSupport) {
                this.requireHibernateSupport = requireHibernateSupport;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getSpotMaxPricePercentageOverLowestPrice}
             * @param spotMaxPricePercentageOverLowestPrice `CfnEC2Fleet.InstanceRequirementsRequestProperty.SpotMaxPricePercentageOverLowestPrice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotMaxPricePercentageOverLowestPrice(java.lang.Number spotMaxPricePercentageOverLowestPrice) {
                this.spotMaxPricePercentageOverLowestPrice = spotMaxPricePercentageOverLowestPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getTotalLocalStorageGb}
             * @param totalLocalStorageGb `CfnEC2Fleet.InstanceRequirementsRequestProperty.TotalLocalStorageGB`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder totalLocalStorageGb(software.amazon.awscdk.core.IResolvable totalLocalStorageGb) {
                this.totalLocalStorageGb = totalLocalStorageGb;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getTotalLocalStorageGb}
             * @param totalLocalStorageGb `CfnEC2Fleet.InstanceRequirementsRequestProperty.TotalLocalStorageGB`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder totalLocalStorageGb(software.amazon.awscdk.services.ec2.CfnEC2Fleet.TotalLocalStorageGBRequestProperty totalLocalStorageGb) {
                this.totalLocalStorageGb = totalLocalStorageGb;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getVCpuCount}
             * @param vCpuCount `CfnEC2Fleet.InstanceRequirementsRequestProperty.VCpuCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vCpuCount(software.amazon.awscdk.core.IResolvable vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getVCpuCount}
             * @param vCpuCount `CfnEC2Fleet.InstanceRequirementsRequestProperty.VCpuCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vCpuCount(software.amazon.awscdk.services.ec2.CfnEC2Fleet.VCpuCountRangeRequestProperty vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceRequirementsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceRequirementsRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceRequirementsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceRequirementsRequestProperty {
            private final java.lang.Object acceleratorCount;
            private final java.util.List<java.lang.String> acceleratorManufacturers;
            private final java.util.List<java.lang.String> acceleratorNames;
            private final java.lang.Object acceleratorTotalMemoryMiB;
            private final java.util.List<java.lang.String> acceleratorTypes;
            private final java.lang.String bareMetal;
            private final java.lang.Object baselineEbsBandwidthMbps;
            private final java.lang.String burstablePerformance;
            private final java.util.List<java.lang.String> cpuManufacturers;
            private final java.util.List<java.lang.String> excludedInstanceTypes;
            private final java.util.List<java.lang.String> instanceGenerations;
            private final java.lang.String localStorage;
            private final java.util.List<java.lang.String> localStorageTypes;
            private final java.lang.Object memoryGiBPerVCpu;
            private final java.lang.Object memoryMiB;
            private final java.lang.Object networkInterfaceCount;
            private final java.lang.Number onDemandMaxPricePercentageOverLowestPrice;
            private final java.lang.Object requireHibernateSupport;
            private final java.lang.Number spotMaxPricePercentageOverLowestPrice;
            private final java.lang.Object totalLocalStorageGb;
            private final java.lang.Object vCpuCount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.acceleratorCount = software.amazon.jsii.Kernel.get(this, "acceleratorCount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.acceleratorManufacturers = software.amazon.jsii.Kernel.get(this, "acceleratorManufacturers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.acceleratorNames = software.amazon.jsii.Kernel.get(this, "acceleratorNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.acceleratorTotalMemoryMiB = software.amazon.jsii.Kernel.get(this, "acceleratorTotalMemoryMiB", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.acceleratorTypes = software.amazon.jsii.Kernel.get(this, "acceleratorTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.bareMetal = software.amazon.jsii.Kernel.get(this, "bareMetal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.baselineEbsBandwidthMbps = software.amazon.jsii.Kernel.get(this, "baselineEbsBandwidthMbps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.burstablePerformance = software.amazon.jsii.Kernel.get(this, "burstablePerformance", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cpuManufacturers = software.amazon.jsii.Kernel.get(this, "cpuManufacturers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.excludedInstanceTypes = software.amazon.jsii.Kernel.get(this, "excludedInstanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.instanceGenerations = software.amazon.jsii.Kernel.get(this, "instanceGenerations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.localStorage = software.amazon.jsii.Kernel.get(this, "localStorage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localStorageTypes = software.amazon.jsii.Kernel.get(this, "localStorageTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.memoryGiBPerVCpu = software.amazon.jsii.Kernel.get(this, "memoryGiBPerVCpu", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.memoryMiB = software.amazon.jsii.Kernel.get(this, "memoryMiB", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkInterfaceCount = software.amazon.jsii.Kernel.get(this, "networkInterfaceCount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.onDemandMaxPricePercentageOverLowestPrice = software.amazon.jsii.Kernel.get(this, "onDemandMaxPricePercentageOverLowestPrice", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.requireHibernateSupport = software.amazon.jsii.Kernel.get(this, "requireHibernateSupport", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.spotMaxPricePercentageOverLowestPrice = software.amazon.jsii.Kernel.get(this, "spotMaxPricePercentageOverLowestPrice", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.totalLocalStorageGb = software.amazon.jsii.Kernel.get(this, "totalLocalStorageGb", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vCpuCount = software.amazon.jsii.Kernel.get(this, "vCpuCount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.acceleratorCount = builder.acceleratorCount;
                this.acceleratorManufacturers = builder.acceleratorManufacturers;
                this.acceleratorNames = builder.acceleratorNames;
                this.acceleratorTotalMemoryMiB = builder.acceleratorTotalMemoryMiB;
                this.acceleratorTypes = builder.acceleratorTypes;
                this.bareMetal = builder.bareMetal;
                this.baselineEbsBandwidthMbps = builder.baselineEbsBandwidthMbps;
                this.burstablePerformance = builder.burstablePerformance;
                this.cpuManufacturers = builder.cpuManufacturers;
                this.excludedInstanceTypes = builder.excludedInstanceTypes;
                this.instanceGenerations = builder.instanceGenerations;
                this.localStorage = builder.localStorage;
                this.localStorageTypes = builder.localStorageTypes;
                this.memoryGiBPerVCpu = builder.memoryGiBPerVCpu;
                this.memoryMiB = builder.memoryMiB;
                this.networkInterfaceCount = builder.networkInterfaceCount;
                this.onDemandMaxPricePercentageOverLowestPrice = builder.onDemandMaxPricePercentageOverLowestPrice;
                this.requireHibernateSupport = builder.requireHibernateSupport;
                this.spotMaxPricePercentageOverLowestPrice = builder.spotMaxPricePercentageOverLowestPrice;
                this.totalLocalStorageGb = builder.totalLocalStorageGb;
                this.vCpuCount = builder.vCpuCount;
            }

            @Override
            public final java.lang.Object getAcceleratorCount() {
                return this.acceleratorCount;
            }

            @Override
            public final java.util.List<java.lang.String> getAcceleratorManufacturers() {
                return this.acceleratorManufacturers;
            }

            @Override
            public final java.util.List<java.lang.String> getAcceleratorNames() {
                return this.acceleratorNames;
            }

            @Override
            public final java.lang.Object getAcceleratorTotalMemoryMiB() {
                return this.acceleratorTotalMemoryMiB;
            }

            @Override
            public final java.util.List<java.lang.String> getAcceleratorTypes() {
                return this.acceleratorTypes;
            }

            @Override
            public final java.lang.String getBareMetal() {
                return this.bareMetal;
            }

            @Override
            public final java.lang.Object getBaselineEbsBandwidthMbps() {
                return this.baselineEbsBandwidthMbps;
            }

            @Override
            public final java.lang.String getBurstablePerformance() {
                return this.burstablePerformance;
            }

            @Override
            public final java.util.List<java.lang.String> getCpuManufacturers() {
                return this.cpuManufacturers;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludedInstanceTypes() {
                return this.excludedInstanceTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getInstanceGenerations() {
                return this.instanceGenerations;
            }

            @Override
            public final java.lang.String getLocalStorage() {
                return this.localStorage;
            }

            @Override
            public final java.util.List<java.lang.String> getLocalStorageTypes() {
                return this.localStorageTypes;
            }

            @Override
            public final java.lang.Object getMemoryGiBPerVCpu() {
                return this.memoryGiBPerVCpu;
            }

            @Override
            public final java.lang.Object getMemoryMiB() {
                return this.memoryMiB;
            }

            @Override
            public final java.lang.Object getNetworkInterfaceCount() {
                return this.networkInterfaceCount;
            }

            @Override
            public final java.lang.Number getOnDemandMaxPricePercentageOverLowestPrice() {
                return this.onDemandMaxPricePercentageOverLowestPrice;
            }

            @Override
            public final java.lang.Object getRequireHibernateSupport() {
                return this.requireHibernateSupport;
            }

            @Override
            public final java.lang.Number getSpotMaxPricePercentageOverLowestPrice() {
                return this.spotMaxPricePercentageOverLowestPrice;
            }

            @Override
            public final java.lang.Object getTotalLocalStorageGb() {
                return this.totalLocalStorageGb;
            }

            @Override
            public final java.lang.Object getVCpuCount() {
                return this.vCpuCount;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAcceleratorCount() != null) {
                    data.set("acceleratorCount", om.valueToTree(this.getAcceleratorCount()));
                }
                if (this.getAcceleratorManufacturers() != null) {
                    data.set("acceleratorManufacturers", om.valueToTree(this.getAcceleratorManufacturers()));
                }
                if (this.getAcceleratorNames() != null) {
                    data.set("acceleratorNames", om.valueToTree(this.getAcceleratorNames()));
                }
                if (this.getAcceleratorTotalMemoryMiB() != null) {
                    data.set("acceleratorTotalMemoryMiB", om.valueToTree(this.getAcceleratorTotalMemoryMiB()));
                }
                if (this.getAcceleratorTypes() != null) {
                    data.set("acceleratorTypes", om.valueToTree(this.getAcceleratorTypes()));
                }
                if (this.getBareMetal() != null) {
                    data.set("bareMetal", om.valueToTree(this.getBareMetal()));
                }
                if (this.getBaselineEbsBandwidthMbps() != null) {
                    data.set("baselineEbsBandwidthMbps", om.valueToTree(this.getBaselineEbsBandwidthMbps()));
                }
                if (this.getBurstablePerformance() != null) {
                    data.set("burstablePerformance", om.valueToTree(this.getBurstablePerformance()));
                }
                if (this.getCpuManufacturers() != null) {
                    data.set("cpuManufacturers", om.valueToTree(this.getCpuManufacturers()));
                }
                if (this.getExcludedInstanceTypes() != null) {
                    data.set("excludedInstanceTypes", om.valueToTree(this.getExcludedInstanceTypes()));
                }
                if (this.getInstanceGenerations() != null) {
                    data.set("instanceGenerations", om.valueToTree(this.getInstanceGenerations()));
                }
                if (this.getLocalStorage() != null) {
                    data.set("localStorage", om.valueToTree(this.getLocalStorage()));
                }
                if (this.getLocalStorageTypes() != null) {
                    data.set("localStorageTypes", om.valueToTree(this.getLocalStorageTypes()));
                }
                if (this.getMemoryGiBPerVCpu() != null) {
                    data.set("memoryGiBPerVCpu", om.valueToTree(this.getMemoryGiBPerVCpu()));
                }
                if (this.getMemoryMiB() != null) {
                    data.set("memoryMiB", om.valueToTree(this.getMemoryMiB()));
                }
                if (this.getNetworkInterfaceCount() != null) {
                    data.set("networkInterfaceCount", om.valueToTree(this.getNetworkInterfaceCount()));
                }
                if (this.getOnDemandMaxPricePercentageOverLowestPrice() != null) {
                    data.set("onDemandMaxPricePercentageOverLowestPrice", om.valueToTree(this.getOnDemandMaxPricePercentageOverLowestPrice()));
                }
                if (this.getRequireHibernateSupport() != null) {
                    data.set("requireHibernateSupport", om.valueToTree(this.getRequireHibernateSupport()));
                }
                if (this.getSpotMaxPricePercentageOverLowestPrice() != null) {
                    data.set("spotMaxPricePercentageOverLowestPrice", om.valueToTree(this.getSpotMaxPricePercentageOverLowestPrice()));
                }
                if (this.getTotalLocalStorageGb() != null) {
                    data.set("totalLocalStorageGb", om.valueToTree(this.getTotalLocalStorageGb()));
                }
                if (this.getVCpuCount() != null) {
                    data.set("vCpuCount", om.valueToTree(this.getVCpuCount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.InstanceRequirementsRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceRequirementsRequestProperty.Jsii$Proxy that = (InstanceRequirementsRequestProperty.Jsii$Proxy) o;

                if (this.acceleratorCount != null ? !this.acceleratorCount.equals(that.acceleratorCount) : that.acceleratorCount != null) return false;
                if (this.acceleratorManufacturers != null ? !this.acceleratorManufacturers.equals(that.acceleratorManufacturers) : that.acceleratorManufacturers != null) return false;
                if (this.acceleratorNames != null ? !this.acceleratorNames.equals(that.acceleratorNames) : that.acceleratorNames != null) return false;
                if (this.acceleratorTotalMemoryMiB != null ? !this.acceleratorTotalMemoryMiB.equals(that.acceleratorTotalMemoryMiB) : that.acceleratorTotalMemoryMiB != null) return false;
                if (this.acceleratorTypes != null ? !this.acceleratorTypes.equals(that.acceleratorTypes) : that.acceleratorTypes != null) return false;
                if (this.bareMetal != null ? !this.bareMetal.equals(that.bareMetal) : that.bareMetal != null) return false;
                if (this.baselineEbsBandwidthMbps != null ? !this.baselineEbsBandwidthMbps.equals(that.baselineEbsBandwidthMbps) : that.baselineEbsBandwidthMbps != null) return false;
                if (this.burstablePerformance != null ? !this.burstablePerformance.equals(that.burstablePerformance) : that.burstablePerformance != null) return false;
                if (this.cpuManufacturers != null ? !this.cpuManufacturers.equals(that.cpuManufacturers) : that.cpuManufacturers != null) return false;
                if (this.excludedInstanceTypes != null ? !this.excludedInstanceTypes.equals(that.excludedInstanceTypes) : that.excludedInstanceTypes != null) return false;
                if (this.instanceGenerations != null ? !this.instanceGenerations.equals(that.instanceGenerations) : that.instanceGenerations != null) return false;
                if (this.localStorage != null ? !this.localStorage.equals(that.localStorage) : that.localStorage != null) return false;
                if (this.localStorageTypes != null ? !this.localStorageTypes.equals(that.localStorageTypes) : that.localStorageTypes != null) return false;
                if (this.memoryGiBPerVCpu != null ? !this.memoryGiBPerVCpu.equals(that.memoryGiBPerVCpu) : that.memoryGiBPerVCpu != null) return false;
                if (this.memoryMiB != null ? !this.memoryMiB.equals(that.memoryMiB) : that.memoryMiB != null) return false;
                if (this.networkInterfaceCount != null ? !this.networkInterfaceCount.equals(that.networkInterfaceCount) : that.networkInterfaceCount != null) return false;
                if (this.onDemandMaxPricePercentageOverLowestPrice != null ? !this.onDemandMaxPricePercentageOverLowestPrice.equals(that.onDemandMaxPricePercentageOverLowestPrice) : that.onDemandMaxPricePercentageOverLowestPrice != null) return false;
                if (this.requireHibernateSupport != null ? !this.requireHibernateSupport.equals(that.requireHibernateSupport) : that.requireHibernateSupport != null) return false;
                if (this.spotMaxPricePercentageOverLowestPrice != null ? !this.spotMaxPricePercentageOverLowestPrice.equals(that.spotMaxPricePercentageOverLowestPrice) : that.spotMaxPricePercentageOverLowestPrice != null) return false;
                if (this.totalLocalStorageGb != null ? !this.totalLocalStorageGb.equals(that.totalLocalStorageGb) : that.totalLocalStorageGb != null) return false;
                return this.vCpuCount != null ? this.vCpuCount.equals(that.vCpuCount) : that.vCpuCount == null;
            }

            @Override
            public final int hashCode() {
                int result = this.acceleratorCount != null ? this.acceleratorCount.hashCode() : 0;
                result = 31 * result + (this.acceleratorManufacturers != null ? this.acceleratorManufacturers.hashCode() : 0);
                result = 31 * result + (this.acceleratorNames != null ? this.acceleratorNames.hashCode() : 0);
                result = 31 * result + (this.acceleratorTotalMemoryMiB != null ? this.acceleratorTotalMemoryMiB.hashCode() : 0);
                result = 31 * result + (this.acceleratorTypes != null ? this.acceleratorTypes.hashCode() : 0);
                result = 31 * result + (this.bareMetal != null ? this.bareMetal.hashCode() : 0);
                result = 31 * result + (this.baselineEbsBandwidthMbps != null ? this.baselineEbsBandwidthMbps.hashCode() : 0);
                result = 31 * result + (this.burstablePerformance != null ? this.burstablePerformance.hashCode() : 0);
                result = 31 * result + (this.cpuManufacturers != null ? this.cpuManufacturers.hashCode() : 0);
                result = 31 * result + (this.excludedInstanceTypes != null ? this.excludedInstanceTypes.hashCode() : 0);
                result = 31 * result + (this.instanceGenerations != null ? this.instanceGenerations.hashCode() : 0);
                result = 31 * result + (this.localStorage != null ? this.localStorage.hashCode() : 0);
                result = 31 * result + (this.localStorageTypes != null ? this.localStorageTypes.hashCode() : 0);
                result = 31 * result + (this.memoryGiBPerVCpu != null ? this.memoryGiBPerVCpu.hashCode() : 0);
                result = 31 * result + (this.memoryMiB != null ? this.memoryMiB.hashCode() : 0);
                result = 31 * result + (this.networkInterfaceCount != null ? this.networkInterfaceCount.hashCode() : 0);
                result = 31 * result + (this.onDemandMaxPricePercentageOverLowestPrice != null ? this.onDemandMaxPricePercentageOverLowestPrice.hashCode() : 0);
                result = 31 * result + (this.requireHibernateSupport != null ? this.requireHibernateSupport.hashCode() : 0);
                result = 31 * result + (this.spotMaxPricePercentageOverLowestPrice != null ? this.spotMaxPricePercentageOverLowestPrice.hashCode() : 0);
                result = 31 * result + (this.totalLocalStorageGb != null ? this.totalLocalStorageGb.hashCode() : 0);
                result = 31 * result + (this.vCpuCount != null ? this.vCpuCount.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * MaintenanceStrategiesProperty maintenanceStrategiesProperty = MaintenanceStrategiesProperty.builder()
     *         .capacityRebalance(CapacityRebalanceProperty.builder()
     *                 .replacementStrategy("replacementStrategy")
     *                 .terminationDelay(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.MaintenanceStrategiesProperty")
    @software.amazon.jsii.Jsii.Proxy(MaintenanceStrategiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MaintenanceStrategiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.MaintenanceStrategiesProperty.CapacityRebalance`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCapacityRebalance() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MaintenanceStrategiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MaintenanceStrategiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MaintenanceStrategiesProperty> {
            java.lang.Object capacityRebalance;

            /**
             * Sets the value of {@link MaintenanceStrategiesProperty#getCapacityRebalance}
             * @param capacityRebalance `CfnEC2Fleet.MaintenanceStrategiesProperty.CapacityRebalance`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityRebalance(software.amazon.awscdk.core.IResolvable capacityRebalance) {
                this.capacityRebalance = capacityRebalance;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceStrategiesProperty#getCapacityRebalance}
             * @param capacityRebalance `CfnEC2Fleet.MaintenanceStrategiesProperty.CapacityRebalance`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityRebalance(software.amazon.awscdk.services.ec2.CfnEC2Fleet.CapacityRebalanceProperty capacityRebalance) {
                this.capacityRebalance = capacityRebalance;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaintenanceStrategiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MaintenanceStrategiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MaintenanceStrategiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MaintenanceStrategiesProperty {
            private final java.lang.Object capacityRebalance;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.capacityRebalance = software.amazon.jsii.Kernel.get(this, "capacityRebalance", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.capacityRebalance = builder.capacityRebalance;
            }

            @Override
            public final java.lang.Object getCapacityRebalance() {
                return this.capacityRebalance;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCapacityRebalance() != null) {
                    data.set("capacityRebalance", om.valueToTree(this.getCapacityRebalance()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.MaintenanceStrategiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MaintenanceStrategiesProperty.Jsii$Proxy that = (MaintenanceStrategiesProperty.Jsii$Proxy) o;

                return this.capacityRebalance != null ? this.capacityRebalance.equals(that.capacityRebalance) : that.capacityRebalance == null;
            }

            @Override
            public final int hashCode() {
                int result = this.capacityRebalance != null ? this.capacityRebalance.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * MemoryGiBPerVCpuRequestProperty memoryGiBPerVCpuRequestProperty = MemoryGiBPerVCpuRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.MemoryGiBPerVCpuRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(MemoryGiBPerVCpuRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MemoryGiBPerVCpuRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.MemoryGiBPerVCpuRequestProperty.Max`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * `CfnEC2Fleet.MemoryGiBPerVCpuRequestProperty.Min`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MemoryGiBPerVCpuRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemoryGiBPerVCpuRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MemoryGiBPerVCpuRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link MemoryGiBPerVCpuRequestProperty#getMax}
             * @param max `CfnEC2Fleet.MemoryGiBPerVCpuRequestProperty.Max`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link MemoryGiBPerVCpuRequestProperty#getMin}
             * @param min `CfnEC2Fleet.MemoryGiBPerVCpuRequestProperty.Min`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemoryGiBPerVCpuRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MemoryGiBPerVCpuRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MemoryGiBPerVCpuRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemoryGiBPerVCpuRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.MemoryGiBPerVCpuRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemoryGiBPerVCpuRequestProperty.Jsii$Proxy that = (MemoryGiBPerVCpuRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * MemoryMiBRequestProperty memoryMiBRequestProperty = MemoryMiBRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.MemoryMiBRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(MemoryMiBRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MemoryMiBRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.MemoryMiBRequestProperty.Max`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * `CfnEC2Fleet.MemoryMiBRequestProperty.Min`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MemoryMiBRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link MemoryMiBRequestProperty#getMax}
             * @param max `CfnEC2Fleet.MemoryMiBRequestProperty.Max`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link MemoryMiBRequestProperty#getMin}
             * @param min `CfnEC2Fleet.MemoryMiBRequestProperty.Min`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemoryMiBRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MemoryMiBRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemoryMiBRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.MemoryMiBRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemoryMiBRequestProperty.Jsii$Proxy that = (MemoryMiBRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * NetworkInterfaceCountRequestProperty networkInterfaceCountRequestProperty = NetworkInterfaceCountRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.NetworkInterfaceCountRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkInterfaceCountRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkInterfaceCountRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.NetworkInterfaceCountRequestProperty.Max`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * `CfnEC2Fleet.NetworkInterfaceCountRequestProperty.Min`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkInterfaceCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkInterfaceCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkInterfaceCountRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link NetworkInterfaceCountRequestProperty#getMax}
             * @param max `CfnEC2Fleet.NetworkInterfaceCountRequestProperty.Max`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceCountRequestProperty#getMin}
             * @param min `CfnEC2Fleet.NetworkInterfaceCountRequestProperty.Min`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkInterfaceCountRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkInterfaceCountRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkInterfaceCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkInterfaceCountRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.NetworkInterfaceCountRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkInterfaceCountRequestProperty.Jsii$Proxy that = (NetworkInterfaceCountRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * OnDemandOptionsRequestProperty onDemandOptionsRequestProperty = OnDemandOptionsRequestProperty.builder()
     *         .allocationStrategy("allocationStrategy")
     *         .capacityReservationOptions(CapacityReservationOptionsRequestProperty.builder()
     *                 .usageStrategy("usageStrategy")
     *                 .build())
     *         .maxTotalPrice("maxTotalPrice")
     *         .minTargetCapacity(123)
     *         .singleAvailabilityZone(false)
     *         .singleInstanceType(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(OnDemandOptionsRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OnDemandOptionsRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.OnDemandOptionsRequestProperty.AllocationStrategy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllocationStrategy() {
            return null;
        }

        /**
         * `CfnEC2Fleet.OnDemandOptionsRequestProperty.CapacityReservationOptions`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCapacityReservationOptions() {
            return null;
        }

        /**
         * `CfnEC2Fleet.OnDemandOptionsRequestProperty.MaxTotalPrice`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaxTotalPrice() {
            return null;
        }

        /**
         * `CfnEC2Fleet.OnDemandOptionsRequestProperty.MinTargetCapacity`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinTargetCapacity() {
            return null;
        }

        /**
         * `CfnEC2Fleet.OnDemandOptionsRequestProperty.SingleAvailabilityZone`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleAvailabilityZone() {
            return null;
        }

        /**
         * `CfnEC2Fleet.OnDemandOptionsRequestProperty.SingleInstanceType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleInstanceType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OnDemandOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OnDemandOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OnDemandOptionsRequestProperty> {
            java.lang.String allocationStrategy;
            java.lang.Object capacityReservationOptions;
            java.lang.String maxTotalPrice;
            java.lang.Number minTargetCapacity;
            java.lang.Object singleAvailabilityZone;
            java.lang.Object singleInstanceType;

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getAllocationStrategy}
             * @param allocationStrategy `CfnEC2Fleet.OnDemandOptionsRequestProperty.AllocationStrategy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allocationStrategy(java.lang.String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getCapacityReservationOptions}
             * @param capacityReservationOptions `CfnEC2Fleet.OnDemandOptionsRequestProperty.CapacityReservationOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationOptions(software.amazon.awscdk.core.IResolvable capacityReservationOptions) {
                this.capacityReservationOptions = capacityReservationOptions;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getCapacityReservationOptions}
             * @param capacityReservationOptions `CfnEC2Fleet.OnDemandOptionsRequestProperty.CapacityReservationOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationOptions(software.amazon.awscdk.services.ec2.CfnEC2Fleet.CapacityReservationOptionsRequestProperty capacityReservationOptions) {
                this.capacityReservationOptions = capacityReservationOptions;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getMaxTotalPrice}
             * @param maxTotalPrice `CfnEC2Fleet.OnDemandOptionsRequestProperty.MaxTotalPrice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTotalPrice(java.lang.String maxTotalPrice) {
                this.maxTotalPrice = maxTotalPrice;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getMinTargetCapacity}
             * @param minTargetCapacity `CfnEC2Fleet.OnDemandOptionsRequestProperty.MinTargetCapacity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minTargetCapacity(java.lang.Number minTargetCapacity) {
                this.minTargetCapacity = minTargetCapacity;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getSingleAvailabilityZone}
             * @param singleAvailabilityZone `CfnEC2Fleet.OnDemandOptionsRequestProperty.SingleAvailabilityZone`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleAvailabilityZone(java.lang.Boolean singleAvailabilityZone) {
                this.singleAvailabilityZone = singleAvailabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getSingleAvailabilityZone}
             * @param singleAvailabilityZone `CfnEC2Fleet.OnDemandOptionsRequestProperty.SingleAvailabilityZone`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleAvailabilityZone(software.amazon.awscdk.core.IResolvable singleAvailabilityZone) {
                this.singleAvailabilityZone = singleAvailabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getSingleInstanceType}
             * @param singleInstanceType `CfnEC2Fleet.OnDemandOptionsRequestProperty.SingleInstanceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleInstanceType(java.lang.Boolean singleInstanceType) {
                this.singleInstanceType = singleInstanceType;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getSingleInstanceType}
             * @param singleInstanceType `CfnEC2Fleet.OnDemandOptionsRequestProperty.SingleInstanceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleInstanceType(software.amazon.awscdk.core.IResolvable singleInstanceType) {
                this.singleInstanceType = singleInstanceType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnDemandOptionsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OnDemandOptionsRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OnDemandOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OnDemandOptionsRequestProperty {
            private final java.lang.String allocationStrategy;
            private final java.lang.Object capacityReservationOptions;
            private final java.lang.String maxTotalPrice;
            private final java.lang.Number minTargetCapacity;
            private final java.lang.Object singleAvailabilityZone;
            private final java.lang.Object singleInstanceType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allocationStrategy = software.amazon.jsii.Kernel.get(this, "allocationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.capacityReservationOptions = software.amazon.jsii.Kernel.get(this, "capacityReservationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxTotalPrice = software.amazon.jsii.Kernel.get(this, "maxTotalPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.minTargetCapacity = software.amazon.jsii.Kernel.get(this, "minTargetCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.singleAvailabilityZone = software.amazon.jsii.Kernel.get(this, "singleAvailabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.singleInstanceType = software.amazon.jsii.Kernel.get(this, "singleInstanceType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allocationStrategy = builder.allocationStrategy;
                this.capacityReservationOptions = builder.capacityReservationOptions;
                this.maxTotalPrice = builder.maxTotalPrice;
                this.minTargetCapacity = builder.minTargetCapacity;
                this.singleAvailabilityZone = builder.singleAvailabilityZone;
                this.singleInstanceType = builder.singleInstanceType;
            }

            @Override
            public final java.lang.String getAllocationStrategy() {
                return this.allocationStrategy;
            }

            @Override
            public final java.lang.Object getCapacityReservationOptions() {
                return this.capacityReservationOptions;
            }

            @Override
            public final java.lang.String getMaxTotalPrice() {
                return this.maxTotalPrice;
            }

            @Override
            public final java.lang.Number getMinTargetCapacity() {
                return this.minTargetCapacity;
            }

            @Override
            public final java.lang.Object getSingleAvailabilityZone() {
                return this.singleAvailabilityZone;
            }

            @Override
            public final java.lang.Object getSingleInstanceType() {
                return this.singleInstanceType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllocationStrategy() != null) {
                    data.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
                }
                if (this.getCapacityReservationOptions() != null) {
                    data.set("capacityReservationOptions", om.valueToTree(this.getCapacityReservationOptions()));
                }
                if (this.getMaxTotalPrice() != null) {
                    data.set("maxTotalPrice", om.valueToTree(this.getMaxTotalPrice()));
                }
                if (this.getMinTargetCapacity() != null) {
                    data.set("minTargetCapacity", om.valueToTree(this.getMinTargetCapacity()));
                }
                if (this.getSingleAvailabilityZone() != null) {
                    data.set("singleAvailabilityZone", om.valueToTree(this.getSingleAvailabilityZone()));
                }
                if (this.getSingleInstanceType() != null) {
                    data.set("singleInstanceType", om.valueToTree(this.getSingleInstanceType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OnDemandOptionsRequestProperty.Jsii$Proxy that = (OnDemandOptionsRequestProperty.Jsii$Proxy) o;

                if (this.allocationStrategy != null ? !this.allocationStrategy.equals(that.allocationStrategy) : that.allocationStrategy != null) return false;
                if (this.capacityReservationOptions != null ? !this.capacityReservationOptions.equals(that.capacityReservationOptions) : that.capacityReservationOptions != null) return false;
                if (this.maxTotalPrice != null ? !this.maxTotalPrice.equals(that.maxTotalPrice) : that.maxTotalPrice != null) return false;
                if (this.minTargetCapacity != null ? !this.minTargetCapacity.equals(that.minTargetCapacity) : that.minTargetCapacity != null) return false;
                if (this.singleAvailabilityZone != null ? !this.singleAvailabilityZone.equals(that.singleAvailabilityZone) : that.singleAvailabilityZone != null) return false;
                return this.singleInstanceType != null ? this.singleInstanceType.equals(that.singleInstanceType) : that.singleInstanceType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allocationStrategy != null ? this.allocationStrategy.hashCode() : 0;
                result = 31 * result + (this.capacityReservationOptions != null ? this.capacityReservationOptions.hashCode() : 0);
                result = 31 * result + (this.maxTotalPrice != null ? this.maxTotalPrice.hashCode() : 0);
                result = 31 * result + (this.minTargetCapacity != null ? this.minTargetCapacity.hashCode() : 0);
                result = 31 * result + (this.singleAvailabilityZone != null ? this.singleAvailabilityZone.hashCode() : 0);
                result = 31 * result + (this.singleInstanceType != null ? this.singleInstanceType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * PlacementProperty placementProperty = PlacementProperty.builder()
     *         .affinity("affinity")
     *         .availabilityZone("availabilityZone")
     *         .groupName("groupName")
     *         .hostId("hostId")
     *         .hostResourceGroupArn("hostResourceGroupArn")
     *         .partitionNumber(123)
     *         .spreadDomain("spreadDomain")
     *         .tenancy("tenancy")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.PlacementProperty")
    @software.amazon.jsii.Jsii.Proxy(PlacementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PlacementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.PlacementProperty.Affinity`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAffinity() {
            return null;
        }

        /**
         * `CfnEC2Fleet.PlacementProperty.AvailabilityZone`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * `CfnEC2Fleet.PlacementProperty.GroupName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroupName() {
            return null;
        }

        /**
         * `CfnEC2Fleet.PlacementProperty.HostId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostId() {
            return null;
        }

        /**
         * `CfnEC2Fleet.PlacementProperty.HostResourceGroupArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostResourceGroupArn() {
            return null;
        }

        /**
         * `CfnEC2Fleet.PlacementProperty.PartitionNumber`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPartitionNumber() {
            return null;
        }

        /**
         * `CfnEC2Fleet.PlacementProperty.SpreadDomain`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSpreadDomain() {
            return null;
        }

        /**
         * `CfnEC2Fleet.PlacementProperty.Tenancy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTenancy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PlacementProperty> {
            java.lang.String affinity;
            java.lang.String availabilityZone;
            java.lang.String groupName;
            java.lang.String hostId;
            java.lang.String hostResourceGroupArn;
            java.lang.Number partitionNumber;
            java.lang.String spreadDomain;
            java.lang.String tenancy;

            /**
             * Sets the value of {@link PlacementProperty#getAffinity}
             * @param affinity `CfnEC2Fleet.PlacementProperty.Affinity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder affinity(java.lang.String affinity) {
                this.affinity = affinity;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getAvailabilityZone}
             * @param availabilityZone `CfnEC2Fleet.PlacementProperty.AvailabilityZone`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getGroupName}
             * @param groupName `CfnEC2Fleet.PlacementProperty.GroupName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupName(java.lang.String groupName) {
                this.groupName = groupName;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getHostId}
             * @param hostId `CfnEC2Fleet.PlacementProperty.HostId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostId(java.lang.String hostId) {
                this.hostId = hostId;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getHostResourceGroupArn}
             * @param hostResourceGroupArn `CfnEC2Fleet.PlacementProperty.HostResourceGroupArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostResourceGroupArn(java.lang.String hostResourceGroupArn) {
                this.hostResourceGroupArn = hostResourceGroupArn;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getPartitionNumber}
             * @param partitionNumber `CfnEC2Fleet.PlacementProperty.PartitionNumber`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionNumber(java.lang.Number partitionNumber) {
                this.partitionNumber = partitionNumber;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getSpreadDomain}
             * @param spreadDomain `CfnEC2Fleet.PlacementProperty.SpreadDomain`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spreadDomain(java.lang.String spreadDomain) {
                this.spreadDomain = spreadDomain;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getTenancy}
             * @param tenancy `CfnEC2Fleet.PlacementProperty.Tenancy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tenancy(java.lang.String tenancy) {
                this.tenancy = tenancy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlacementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PlacementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlacementProperty {
            private final java.lang.String affinity;
            private final java.lang.String availabilityZone;
            private final java.lang.String groupName;
            private final java.lang.String hostId;
            private final java.lang.String hostResourceGroupArn;
            private final java.lang.Number partitionNumber;
            private final java.lang.String spreadDomain;
            private final java.lang.String tenancy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.affinity = software.amazon.jsii.Kernel.get(this, "affinity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groupName = software.amazon.jsii.Kernel.get(this, "groupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostId = software.amazon.jsii.Kernel.get(this, "hostId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostResourceGroupArn = software.amazon.jsii.Kernel.get(this, "hostResourceGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.partitionNumber = software.amazon.jsii.Kernel.get(this, "partitionNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.spreadDomain = software.amazon.jsii.Kernel.get(this, "spreadDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tenancy = software.amazon.jsii.Kernel.get(this, "tenancy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.affinity = builder.affinity;
                this.availabilityZone = builder.availabilityZone;
                this.groupName = builder.groupName;
                this.hostId = builder.hostId;
                this.hostResourceGroupArn = builder.hostResourceGroupArn;
                this.partitionNumber = builder.partitionNumber;
                this.spreadDomain = builder.spreadDomain;
                this.tenancy = builder.tenancy;
            }

            @Override
            public final java.lang.String getAffinity() {
                return this.affinity;
            }

            @Override
            public final java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public final java.lang.String getGroupName() {
                return this.groupName;
            }

            @Override
            public final java.lang.String getHostId() {
                return this.hostId;
            }

            @Override
            public final java.lang.String getHostResourceGroupArn() {
                return this.hostResourceGroupArn;
            }

            @Override
            public final java.lang.Number getPartitionNumber() {
                return this.partitionNumber;
            }

            @Override
            public final java.lang.String getSpreadDomain() {
                return this.spreadDomain;
            }

            @Override
            public final java.lang.String getTenancy() {
                return this.tenancy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAffinity() != null) {
                    data.set("affinity", om.valueToTree(this.getAffinity()));
                }
                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getGroupName() != null) {
                    data.set("groupName", om.valueToTree(this.getGroupName()));
                }
                if (this.getHostId() != null) {
                    data.set("hostId", om.valueToTree(this.getHostId()));
                }
                if (this.getHostResourceGroupArn() != null) {
                    data.set("hostResourceGroupArn", om.valueToTree(this.getHostResourceGroupArn()));
                }
                if (this.getPartitionNumber() != null) {
                    data.set("partitionNumber", om.valueToTree(this.getPartitionNumber()));
                }
                if (this.getSpreadDomain() != null) {
                    data.set("spreadDomain", om.valueToTree(this.getSpreadDomain()));
                }
                if (this.getTenancy() != null) {
                    data.set("tenancy", om.valueToTree(this.getTenancy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.PlacementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PlacementProperty.Jsii$Proxy that = (PlacementProperty.Jsii$Proxy) o;

                if (this.affinity != null ? !this.affinity.equals(that.affinity) : that.affinity != null) return false;
                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) return false;
                if (this.hostId != null ? !this.hostId.equals(that.hostId) : that.hostId != null) return false;
                if (this.hostResourceGroupArn != null ? !this.hostResourceGroupArn.equals(that.hostResourceGroupArn) : that.hostResourceGroupArn != null) return false;
                if (this.partitionNumber != null ? !this.partitionNumber.equals(that.partitionNumber) : that.partitionNumber != null) return false;
                if (this.spreadDomain != null ? !this.spreadDomain.equals(that.spreadDomain) : that.spreadDomain != null) return false;
                return this.tenancy != null ? this.tenancy.equals(that.tenancy) : that.tenancy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.affinity != null ? this.affinity.hashCode() : 0;
                result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
                result = 31 * result + (this.groupName != null ? this.groupName.hashCode() : 0);
                result = 31 * result + (this.hostId != null ? this.hostId.hashCode() : 0);
                result = 31 * result + (this.hostResourceGroupArn != null ? this.hostResourceGroupArn.hashCode() : 0);
                result = 31 * result + (this.partitionNumber != null ? this.partitionNumber.hashCode() : 0);
                result = 31 * result + (this.spreadDomain != null ? this.spreadDomain.hashCode() : 0);
                result = 31 * result + (this.tenancy != null ? this.tenancy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * SpotOptionsRequestProperty spotOptionsRequestProperty = SpotOptionsRequestProperty.builder()
     *         .allocationStrategy("allocationStrategy")
     *         .instanceInterruptionBehavior("instanceInterruptionBehavior")
     *         .instancePoolsToUseCount(123)
     *         .maintenanceStrategies(MaintenanceStrategiesProperty.builder()
     *                 .capacityRebalance(CapacityRebalanceProperty.builder()
     *                         .replacementStrategy("replacementStrategy")
     *                         .terminationDelay(123)
     *                         .build())
     *                 .build())
     *         .maxTotalPrice("maxTotalPrice")
     *         .minTargetCapacity(123)
     *         .singleAvailabilityZone(false)
     *         .singleInstanceType(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.SpotOptionsRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(SpotOptionsRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotOptionsRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.AllocationStrategy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllocationStrategy() {
            return null;
        }

        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.InstanceInterruptionBehavior`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceInterruptionBehavior() {
            return null;
        }

        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.InstancePoolsToUseCount`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInstancePoolsToUseCount() {
            return null;
        }

        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.MaintenanceStrategies`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMaintenanceStrategies() {
            return null;
        }

        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.MaxTotalPrice`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaxTotalPrice() {
            return null;
        }

        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.MinTargetCapacity`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinTargetCapacity() {
            return null;
        }

        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.SingleAvailabilityZone`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleAvailabilityZone() {
            return null;
        }

        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.SingleInstanceType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleInstanceType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpotOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpotOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpotOptionsRequestProperty> {
            java.lang.String allocationStrategy;
            java.lang.String instanceInterruptionBehavior;
            java.lang.Number instancePoolsToUseCount;
            java.lang.Object maintenanceStrategies;
            java.lang.String maxTotalPrice;
            java.lang.Number minTargetCapacity;
            java.lang.Object singleAvailabilityZone;
            java.lang.Object singleInstanceType;

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getAllocationStrategy}
             * @param allocationStrategy `CfnEC2Fleet.SpotOptionsRequestProperty.AllocationStrategy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allocationStrategy(java.lang.String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getInstanceInterruptionBehavior}
             * @param instanceInterruptionBehavior `CfnEC2Fleet.SpotOptionsRequestProperty.InstanceInterruptionBehavior`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceInterruptionBehavior(java.lang.String instanceInterruptionBehavior) {
                this.instanceInterruptionBehavior = instanceInterruptionBehavior;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getInstancePoolsToUseCount}
             * @param instancePoolsToUseCount `CfnEC2Fleet.SpotOptionsRequestProperty.InstancePoolsToUseCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instancePoolsToUseCount(java.lang.Number instancePoolsToUseCount) {
                this.instancePoolsToUseCount = instancePoolsToUseCount;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getMaintenanceStrategies}
             * @param maintenanceStrategies `CfnEC2Fleet.SpotOptionsRequestProperty.MaintenanceStrategies`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maintenanceStrategies(software.amazon.awscdk.core.IResolvable maintenanceStrategies) {
                this.maintenanceStrategies = maintenanceStrategies;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getMaintenanceStrategies}
             * @param maintenanceStrategies `CfnEC2Fleet.SpotOptionsRequestProperty.MaintenanceStrategies`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maintenanceStrategies(software.amazon.awscdk.services.ec2.CfnEC2Fleet.MaintenanceStrategiesProperty maintenanceStrategies) {
                this.maintenanceStrategies = maintenanceStrategies;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getMaxTotalPrice}
             * @param maxTotalPrice `CfnEC2Fleet.SpotOptionsRequestProperty.MaxTotalPrice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTotalPrice(java.lang.String maxTotalPrice) {
                this.maxTotalPrice = maxTotalPrice;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getMinTargetCapacity}
             * @param minTargetCapacity `CfnEC2Fleet.SpotOptionsRequestProperty.MinTargetCapacity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minTargetCapacity(java.lang.Number minTargetCapacity) {
                this.minTargetCapacity = minTargetCapacity;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getSingleAvailabilityZone}
             * @param singleAvailabilityZone `CfnEC2Fleet.SpotOptionsRequestProperty.SingleAvailabilityZone`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleAvailabilityZone(java.lang.Boolean singleAvailabilityZone) {
                this.singleAvailabilityZone = singleAvailabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getSingleAvailabilityZone}
             * @param singleAvailabilityZone `CfnEC2Fleet.SpotOptionsRequestProperty.SingleAvailabilityZone`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleAvailabilityZone(software.amazon.awscdk.core.IResolvable singleAvailabilityZone) {
                this.singleAvailabilityZone = singleAvailabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getSingleInstanceType}
             * @param singleInstanceType `CfnEC2Fleet.SpotOptionsRequestProperty.SingleInstanceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleInstanceType(java.lang.Boolean singleInstanceType) {
                this.singleInstanceType = singleInstanceType;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getSingleInstanceType}
             * @param singleInstanceType `CfnEC2Fleet.SpotOptionsRequestProperty.SingleInstanceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleInstanceType(software.amazon.awscdk.core.IResolvable singleInstanceType) {
                this.singleInstanceType = singleInstanceType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotOptionsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpotOptionsRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpotOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotOptionsRequestProperty {
            private final java.lang.String allocationStrategy;
            private final java.lang.String instanceInterruptionBehavior;
            private final java.lang.Number instancePoolsToUseCount;
            private final java.lang.Object maintenanceStrategies;
            private final java.lang.String maxTotalPrice;
            private final java.lang.Number minTargetCapacity;
            private final java.lang.Object singleAvailabilityZone;
            private final java.lang.Object singleInstanceType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allocationStrategy = software.amazon.jsii.Kernel.get(this, "allocationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceInterruptionBehavior = software.amazon.jsii.Kernel.get(this, "instanceInterruptionBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instancePoolsToUseCount = software.amazon.jsii.Kernel.get(this, "instancePoolsToUseCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maintenanceStrategies = software.amazon.jsii.Kernel.get(this, "maintenanceStrategies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxTotalPrice = software.amazon.jsii.Kernel.get(this, "maxTotalPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.minTargetCapacity = software.amazon.jsii.Kernel.get(this, "minTargetCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.singleAvailabilityZone = software.amazon.jsii.Kernel.get(this, "singleAvailabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.singleInstanceType = software.amazon.jsii.Kernel.get(this, "singleInstanceType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allocationStrategy = builder.allocationStrategy;
                this.instanceInterruptionBehavior = builder.instanceInterruptionBehavior;
                this.instancePoolsToUseCount = builder.instancePoolsToUseCount;
                this.maintenanceStrategies = builder.maintenanceStrategies;
                this.maxTotalPrice = builder.maxTotalPrice;
                this.minTargetCapacity = builder.minTargetCapacity;
                this.singleAvailabilityZone = builder.singleAvailabilityZone;
                this.singleInstanceType = builder.singleInstanceType;
            }

            @Override
            public final java.lang.String getAllocationStrategy() {
                return this.allocationStrategy;
            }

            @Override
            public final java.lang.String getInstanceInterruptionBehavior() {
                return this.instanceInterruptionBehavior;
            }

            @Override
            public final java.lang.Number getInstancePoolsToUseCount() {
                return this.instancePoolsToUseCount;
            }

            @Override
            public final java.lang.Object getMaintenanceStrategies() {
                return this.maintenanceStrategies;
            }

            @Override
            public final java.lang.String getMaxTotalPrice() {
                return this.maxTotalPrice;
            }

            @Override
            public final java.lang.Number getMinTargetCapacity() {
                return this.minTargetCapacity;
            }

            @Override
            public final java.lang.Object getSingleAvailabilityZone() {
                return this.singleAvailabilityZone;
            }

            @Override
            public final java.lang.Object getSingleInstanceType() {
                return this.singleInstanceType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllocationStrategy() != null) {
                    data.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
                }
                if (this.getInstanceInterruptionBehavior() != null) {
                    data.set("instanceInterruptionBehavior", om.valueToTree(this.getInstanceInterruptionBehavior()));
                }
                if (this.getInstancePoolsToUseCount() != null) {
                    data.set("instancePoolsToUseCount", om.valueToTree(this.getInstancePoolsToUseCount()));
                }
                if (this.getMaintenanceStrategies() != null) {
                    data.set("maintenanceStrategies", om.valueToTree(this.getMaintenanceStrategies()));
                }
                if (this.getMaxTotalPrice() != null) {
                    data.set("maxTotalPrice", om.valueToTree(this.getMaxTotalPrice()));
                }
                if (this.getMinTargetCapacity() != null) {
                    data.set("minTargetCapacity", om.valueToTree(this.getMinTargetCapacity()));
                }
                if (this.getSingleAvailabilityZone() != null) {
                    data.set("singleAvailabilityZone", om.valueToTree(this.getSingleAvailabilityZone()));
                }
                if (this.getSingleInstanceType() != null) {
                    data.set("singleInstanceType", om.valueToTree(this.getSingleInstanceType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.SpotOptionsRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotOptionsRequestProperty.Jsii$Proxy that = (SpotOptionsRequestProperty.Jsii$Proxy) o;

                if (this.allocationStrategy != null ? !this.allocationStrategy.equals(that.allocationStrategy) : that.allocationStrategy != null) return false;
                if (this.instanceInterruptionBehavior != null ? !this.instanceInterruptionBehavior.equals(that.instanceInterruptionBehavior) : that.instanceInterruptionBehavior != null) return false;
                if (this.instancePoolsToUseCount != null ? !this.instancePoolsToUseCount.equals(that.instancePoolsToUseCount) : that.instancePoolsToUseCount != null) return false;
                if (this.maintenanceStrategies != null ? !this.maintenanceStrategies.equals(that.maintenanceStrategies) : that.maintenanceStrategies != null) return false;
                if (this.maxTotalPrice != null ? !this.maxTotalPrice.equals(that.maxTotalPrice) : that.maxTotalPrice != null) return false;
                if (this.minTargetCapacity != null ? !this.minTargetCapacity.equals(that.minTargetCapacity) : that.minTargetCapacity != null) return false;
                if (this.singleAvailabilityZone != null ? !this.singleAvailabilityZone.equals(that.singleAvailabilityZone) : that.singleAvailabilityZone != null) return false;
                return this.singleInstanceType != null ? this.singleInstanceType.equals(that.singleInstanceType) : that.singleInstanceType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allocationStrategy != null ? this.allocationStrategy.hashCode() : 0;
                result = 31 * result + (this.instanceInterruptionBehavior != null ? this.instanceInterruptionBehavior.hashCode() : 0);
                result = 31 * result + (this.instancePoolsToUseCount != null ? this.instancePoolsToUseCount.hashCode() : 0);
                result = 31 * result + (this.maintenanceStrategies != null ? this.maintenanceStrategies.hashCode() : 0);
                result = 31 * result + (this.maxTotalPrice != null ? this.maxTotalPrice.hashCode() : 0);
                result = 31 * result + (this.minTargetCapacity != null ? this.minTargetCapacity.hashCode() : 0);
                result = 31 * result + (this.singleAvailabilityZone != null ? this.singleAvailabilityZone.hashCode() : 0);
                result = 31 * result + (this.singleInstanceType != null ? this.singleInstanceType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * TagSpecificationProperty tagSpecificationProperty = TagSpecificationProperty.builder()
     *         .resourceType("resourceType")
     *         .tags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.TagSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(TagSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.TagSpecificationProperty.ResourceType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceType() {
            return null;
        }

        /**
         * `CfnEC2Fleet.TagSpecificationProperty.Tags`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagSpecificationProperty> {
            java.lang.String resourceType;
            java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Sets the value of {@link TagSpecificationProperty#getResourceType}
             * @param resourceType `CfnEC2Fleet.TagSpecificationProperty.ResourceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link TagSpecificationProperty#getTags}
             * @param tags `CfnEC2Fleet.TagSpecificationProperty.Tags`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagSpecificationProperty {
            private final java.lang.String resourceType;
            private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceType = builder.resourceType;
                this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            }

            @Override
            public final java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getResourceType() != null) {
                    data.set("resourceType", om.valueToTree(this.getResourceType()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.TagSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagSpecificationProperty.Jsii$Proxy that = (TagSpecificationProperty.Jsii$Proxy) o;

                if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resourceType != null ? this.resourceType.hashCode() : 0;
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * TargetCapacitySpecificationRequestProperty targetCapacitySpecificationRequestProperty = TargetCapacitySpecificationRequestProperty.builder()
     *         .totalTargetCapacity(123)
     *         // the properties below are optional
     *         .defaultTargetCapacityType("defaultTargetCapacityType")
     *         .onDemandTargetCapacity(123)
     *         .spotTargetCapacity(123)
     *         .targetCapacityUnitType("targetCapacityUnitType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.TargetCapacitySpecificationRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetCapacitySpecificationRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetCapacitySpecificationRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.DefaultTargetCapacityType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultTargetCapacityType() {
            return null;
        }

        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.OnDemandTargetCapacity`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOnDemandTargetCapacity() {
            return null;
        }

        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.SpotTargetCapacity`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSpotTargetCapacity() {
            return null;
        }

        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.TargetCapacityUnitType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetCapacityUnitType() {
            return null;
        }

        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.TotalTargetCapacity`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTotalTargetCapacity();

        /**
         * @return a {@link Builder} of {@link TargetCapacitySpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetCapacitySpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetCapacitySpecificationRequestProperty> {
            java.lang.String defaultTargetCapacityType;
            java.lang.Number onDemandTargetCapacity;
            java.lang.Number spotTargetCapacity;
            java.lang.String targetCapacityUnitType;
            java.lang.Number totalTargetCapacity;

            /**
             * Sets the value of {@link TargetCapacitySpecificationRequestProperty#getDefaultTargetCapacityType}
             * @param defaultTargetCapacityType `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.DefaultTargetCapacityType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultTargetCapacityType(java.lang.String defaultTargetCapacityType) {
                this.defaultTargetCapacityType = defaultTargetCapacityType;
                return this;
            }

            /**
             * Sets the value of {@link TargetCapacitySpecificationRequestProperty#getOnDemandTargetCapacity}
             * @param onDemandTargetCapacity `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.OnDemandTargetCapacity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onDemandTargetCapacity(java.lang.Number onDemandTargetCapacity) {
                this.onDemandTargetCapacity = onDemandTargetCapacity;
                return this;
            }

            /**
             * Sets the value of {@link TargetCapacitySpecificationRequestProperty#getSpotTargetCapacity}
             * @param spotTargetCapacity `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.SpotTargetCapacity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotTargetCapacity(java.lang.Number spotTargetCapacity) {
                this.spotTargetCapacity = spotTargetCapacity;
                return this;
            }

            /**
             * Sets the value of {@link TargetCapacitySpecificationRequestProperty#getTargetCapacityUnitType}
             * @param targetCapacityUnitType `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.TargetCapacityUnitType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetCapacityUnitType(java.lang.String targetCapacityUnitType) {
                this.targetCapacityUnitType = targetCapacityUnitType;
                return this;
            }

            /**
             * Sets the value of {@link TargetCapacitySpecificationRequestProperty#getTotalTargetCapacity}
             * @param totalTargetCapacity `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.TotalTargetCapacity`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder totalTargetCapacity(java.lang.Number totalTargetCapacity) {
                this.totalTargetCapacity = totalTargetCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetCapacitySpecificationRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetCapacitySpecificationRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetCapacitySpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetCapacitySpecificationRequestProperty {
            private final java.lang.String defaultTargetCapacityType;
            private final java.lang.Number onDemandTargetCapacity;
            private final java.lang.Number spotTargetCapacity;
            private final java.lang.String targetCapacityUnitType;
            private final java.lang.Number totalTargetCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultTargetCapacityType = software.amazon.jsii.Kernel.get(this, "defaultTargetCapacityType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.onDemandTargetCapacity = software.amazon.jsii.Kernel.get(this, "onDemandTargetCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.spotTargetCapacity = software.amazon.jsii.Kernel.get(this, "spotTargetCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.targetCapacityUnitType = software.amazon.jsii.Kernel.get(this, "targetCapacityUnitType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.totalTargetCapacity = software.amazon.jsii.Kernel.get(this, "totalTargetCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultTargetCapacityType = builder.defaultTargetCapacityType;
                this.onDemandTargetCapacity = builder.onDemandTargetCapacity;
                this.spotTargetCapacity = builder.spotTargetCapacity;
                this.targetCapacityUnitType = builder.targetCapacityUnitType;
                this.totalTargetCapacity = java.util.Objects.requireNonNull(builder.totalTargetCapacity, "totalTargetCapacity is required");
            }

            @Override
            public final java.lang.String getDefaultTargetCapacityType() {
                return this.defaultTargetCapacityType;
            }

            @Override
            public final java.lang.Number getOnDemandTargetCapacity() {
                return this.onDemandTargetCapacity;
            }

            @Override
            public final java.lang.Number getSpotTargetCapacity() {
                return this.spotTargetCapacity;
            }

            @Override
            public final java.lang.String getTargetCapacityUnitType() {
                return this.targetCapacityUnitType;
            }

            @Override
            public final java.lang.Number getTotalTargetCapacity() {
                return this.totalTargetCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDefaultTargetCapacityType() != null) {
                    data.set("defaultTargetCapacityType", om.valueToTree(this.getDefaultTargetCapacityType()));
                }
                if (this.getOnDemandTargetCapacity() != null) {
                    data.set("onDemandTargetCapacity", om.valueToTree(this.getOnDemandTargetCapacity()));
                }
                if (this.getSpotTargetCapacity() != null) {
                    data.set("spotTargetCapacity", om.valueToTree(this.getSpotTargetCapacity()));
                }
                if (this.getTargetCapacityUnitType() != null) {
                    data.set("targetCapacityUnitType", om.valueToTree(this.getTargetCapacityUnitType()));
                }
                data.set("totalTargetCapacity", om.valueToTree(this.getTotalTargetCapacity()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.TargetCapacitySpecificationRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetCapacitySpecificationRequestProperty.Jsii$Proxy that = (TargetCapacitySpecificationRequestProperty.Jsii$Proxy) o;

                if (this.defaultTargetCapacityType != null ? !this.defaultTargetCapacityType.equals(that.defaultTargetCapacityType) : that.defaultTargetCapacityType != null) return false;
                if (this.onDemandTargetCapacity != null ? !this.onDemandTargetCapacity.equals(that.onDemandTargetCapacity) : that.onDemandTargetCapacity != null) return false;
                if (this.spotTargetCapacity != null ? !this.spotTargetCapacity.equals(that.spotTargetCapacity) : that.spotTargetCapacity != null) return false;
                if (this.targetCapacityUnitType != null ? !this.targetCapacityUnitType.equals(that.targetCapacityUnitType) : that.targetCapacityUnitType != null) return false;
                return this.totalTargetCapacity.equals(that.totalTargetCapacity);
            }

            @Override
            public final int hashCode() {
                int result = this.defaultTargetCapacityType != null ? this.defaultTargetCapacityType.hashCode() : 0;
                result = 31 * result + (this.onDemandTargetCapacity != null ? this.onDemandTargetCapacity.hashCode() : 0);
                result = 31 * result + (this.spotTargetCapacity != null ? this.spotTargetCapacity.hashCode() : 0);
                result = 31 * result + (this.targetCapacityUnitType != null ? this.targetCapacityUnitType.hashCode() : 0);
                result = 31 * result + (this.totalTargetCapacity.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * TotalLocalStorageGBRequestProperty totalLocalStorageGBRequestProperty = TotalLocalStorageGBRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.TotalLocalStorageGBRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(TotalLocalStorageGBRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TotalLocalStorageGBRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.TotalLocalStorageGBRequestProperty.Max`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * `CfnEC2Fleet.TotalLocalStorageGBRequestProperty.Min`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TotalLocalStorageGBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TotalLocalStorageGBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TotalLocalStorageGBRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link TotalLocalStorageGBRequestProperty#getMax}
             * @param max `CfnEC2Fleet.TotalLocalStorageGBRequestProperty.Max`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link TotalLocalStorageGBRequestProperty#getMin}
             * @param min `CfnEC2Fleet.TotalLocalStorageGBRequestProperty.Min`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TotalLocalStorageGBRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TotalLocalStorageGBRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TotalLocalStorageGBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TotalLocalStorageGBRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.TotalLocalStorageGBRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TotalLocalStorageGBRequestProperty.Jsii$Proxy that = (TotalLocalStorageGBRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * VCpuCountRangeRequestProperty vCpuCountRangeRequestProperty = VCpuCountRangeRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnEC2Fleet.VCpuCountRangeRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(VCpuCountRangeRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VCpuCountRangeRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEC2Fleet.VCpuCountRangeRequestProperty.Max`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * `CfnEC2Fleet.VCpuCountRangeRequestProperty.Min`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VCpuCountRangeRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VCpuCountRangeRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VCpuCountRangeRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link VCpuCountRangeRequestProperty#getMax}
             * @param max `CfnEC2Fleet.VCpuCountRangeRequestProperty.Max`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link VCpuCountRangeRequestProperty#getMin}
             * @param min `CfnEC2Fleet.VCpuCountRangeRequestProperty.Min`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VCpuCountRangeRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VCpuCountRangeRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VCpuCountRangeRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VCpuCountRangeRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnEC2Fleet.VCpuCountRangeRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VCpuCountRangeRequestProperty.Jsii$Proxy that = (VCpuCountRangeRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnEC2Fleet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnEC2Fleet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnEC2FleetProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnEC2FleetProps.Builder();
        }

        /**
         * `AWS::EC2::EC2Fleet.Context`.
         * <p>
         * @return {@code this}
         * @param context `AWS::EC2::EC2Fleet.Context`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder context(final java.lang.String context) {
            this.props.context(context);
            return this;
        }

        /**
         * `AWS::EC2::EC2Fleet.ExcessCapacityTerminationPolicy`.
         * <p>
         * @return {@code this}
         * @param excessCapacityTerminationPolicy `AWS::EC2::EC2Fleet.ExcessCapacityTerminationPolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excessCapacityTerminationPolicy(final java.lang.String excessCapacityTerminationPolicy) {
            this.props.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy);
            return this;
        }

        /**
         * `AWS::EC2::EC2Fleet.LaunchTemplateConfigs`.
         * <p>
         * @return {@code this}
         * @param launchTemplateConfigs `AWS::EC2::EC2Fleet.LaunchTemplateConfigs`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplateConfigs(final software.amazon.awscdk.core.IResolvable launchTemplateConfigs) {
            this.props.launchTemplateConfigs(launchTemplateConfigs);
            return this;
        }
        /**
         * `AWS::EC2::EC2Fleet.LaunchTemplateConfigs`.
         * <p>
         * @return {@code this}
         * @param launchTemplateConfigs `AWS::EC2::EC2Fleet.LaunchTemplateConfigs`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplateConfigs(final java.util.List<? extends java.lang.Object> launchTemplateConfigs) {
            this.props.launchTemplateConfigs(launchTemplateConfigs);
            return this;
        }

        /**
         * `AWS::EC2::EC2Fleet.OnDemandOptions`.
         * <p>
         * @return {@code this}
         * @param onDemandOptions `AWS::EC2::EC2Fleet.OnDemandOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onDemandOptions(final software.amazon.awscdk.core.IResolvable onDemandOptions) {
            this.props.onDemandOptions(onDemandOptions);
            return this;
        }
        /**
         * `AWS::EC2::EC2Fleet.OnDemandOptions`.
         * <p>
         * @return {@code this}
         * @param onDemandOptions `AWS::EC2::EC2Fleet.OnDemandOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onDemandOptions(final software.amazon.awscdk.services.ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty onDemandOptions) {
            this.props.onDemandOptions(onDemandOptions);
            return this;
        }

        /**
         * `AWS::EC2::EC2Fleet.ReplaceUnhealthyInstances`.
         * <p>
         * @return {@code this}
         * @param replaceUnhealthyInstances `AWS::EC2::EC2Fleet.ReplaceUnhealthyInstances`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceUnhealthyInstances(final java.lang.Boolean replaceUnhealthyInstances) {
            this.props.replaceUnhealthyInstances(replaceUnhealthyInstances);
            return this;
        }
        /**
         * `AWS::EC2::EC2Fleet.ReplaceUnhealthyInstances`.
         * <p>
         * @return {@code this}
         * @param replaceUnhealthyInstances `AWS::EC2::EC2Fleet.ReplaceUnhealthyInstances`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceUnhealthyInstances(final software.amazon.awscdk.core.IResolvable replaceUnhealthyInstances) {
            this.props.replaceUnhealthyInstances(replaceUnhealthyInstances);
            return this;
        }

        /**
         * `AWS::EC2::EC2Fleet.SpotOptions`.
         * <p>
         * @return {@code this}
         * @param spotOptions `AWS::EC2::EC2Fleet.SpotOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotOptions(final software.amazon.awscdk.core.IResolvable spotOptions) {
            this.props.spotOptions(spotOptions);
            return this;
        }
        /**
         * `AWS::EC2::EC2Fleet.SpotOptions`.
         * <p>
         * @return {@code this}
         * @param spotOptions `AWS::EC2::EC2Fleet.SpotOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotOptions(final software.amazon.awscdk.services.ec2.CfnEC2Fleet.SpotOptionsRequestProperty spotOptions) {
            this.props.spotOptions(spotOptions);
            return this;
        }

        /**
         * `AWS::EC2::EC2Fleet.TagSpecifications`.
         * <p>
         * @return {@code this}
         * @param tagSpecifications `AWS::EC2::EC2Fleet.TagSpecifications`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(final software.amazon.awscdk.core.IResolvable tagSpecifications) {
            this.props.tagSpecifications(tagSpecifications);
            return this;
        }
        /**
         * `AWS::EC2::EC2Fleet.TagSpecifications`.
         * <p>
         * @return {@code this}
         * @param tagSpecifications `AWS::EC2::EC2Fleet.TagSpecifications`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(final java.util.List<? extends java.lang.Object> tagSpecifications) {
            this.props.tagSpecifications(tagSpecifications);
            return this;
        }

        /**
         * `AWS::EC2::EC2Fleet.TargetCapacitySpecification`.
         * <p>
         * @return {@code this}
         * @param targetCapacitySpecification `AWS::EC2::EC2Fleet.TargetCapacitySpecification`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetCapacitySpecification(final software.amazon.awscdk.core.IResolvable targetCapacitySpecification) {
            this.props.targetCapacitySpecification(targetCapacitySpecification);
            return this;
        }
        /**
         * `AWS::EC2::EC2Fleet.TargetCapacitySpecification`.
         * <p>
         * @return {@code this}
         * @param targetCapacitySpecification `AWS::EC2::EC2Fleet.TargetCapacitySpecification`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetCapacitySpecification(final software.amazon.awscdk.services.ec2.CfnEC2Fleet.TargetCapacitySpecificationRequestProperty targetCapacitySpecification) {
            this.props.targetCapacitySpecification(targetCapacitySpecification);
            return this;
        }

        /**
         * `AWS::EC2::EC2Fleet.TerminateInstancesWithExpiration`.
         * <p>
         * @return {@code this}
         * @param terminateInstancesWithExpiration `AWS::EC2::EC2Fleet.TerminateInstancesWithExpiration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminateInstancesWithExpiration(final java.lang.Boolean terminateInstancesWithExpiration) {
            this.props.terminateInstancesWithExpiration(terminateInstancesWithExpiration);
            return this;
        }
        /**
         * `AWS::EC2::EC2Fleet.TerminateInstancesWithExpiration`.
         * <p>
         * @return {@code this}
         * @param terminateInstancesWithExpiration `AWS::EC2::EC2Fleet.TerminateInstancesWithExpiration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminateInstancesWithExpiration(final software.amazon.awscdk.core.IResolvable terminateInstancesWithExpiration) {
            this.props.terminateInstancesWithExpiration(terminateInstancesWithExpiration);
            return this;
        }

        /**
         * `AWS::EC2::EC2Fleet.Type`.
         * <p>
         * @return {@code this}
         * @param type `AWS::EC2::EC2Fleet.Type`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * `AWS::EC2::EC2Fleet.ValidFrom`.
         * <p>
         * @return {@code this}
         * @param validFrom `AWS::EC2::EC2Fleet.ValidFrom`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validFrom(final java.lang.String validFrom) {
            this.props.validFrom(validFrom);
            return this;
        }

        /**
         * `AWS::EC2::EC2Fleet.ValidUntil`.
         * <p>
         * @return {@code this}
         * @param validUntil `AWS::EC2::EC2Fleet.ValidUntil`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validUntil(final java.lang.String validUntil) {
            this.props.validUntil(validUntil);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnEC2Fleet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnEC2Fleet build() {
            return new software.amazon.awscdk.services.ec2.CfnEC2Fleet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
