package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::TrafficMirrorSession`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnTrafficMirrorSessionProps cfnTrafficMirrorSessionProps = CfnTrafficMirrorSessionProps.builder()
 *         .networkInterfaceId("networkInterfaceId")
 *         .sessionNumber(123)
 *         .trafficMirrorFilterId("trafficMirrorFilterId")
 *         .trafficMirrorTargetId("trafficMirrorTargetId")
 *         // the properties below are optional
 *         .description("description")
 *         .packetLength(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .virtualNetworkId(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.46.0 (build cd08c55)", date = "2021-11-23T14:40:39.606Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnTrafficMirrorSessionProps")
@software.amazon.jsii.Jsii.Proxy(CfnTrafficMirrorSessionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTrafficMirrorSessionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::TrafficMirrorSession.Description`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * `AWS::EC2::TrafficMirrorSession.NetworkInterfaceId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNetworkInterfaceId();

    /**
     * `AWS::EC2::TrafficMirrorSession.PacketLength`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPacketLength() {
        return null;
    }

    /**
     * `AWS::EC2::TrafficMirrorSession.SessionNumber`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getSessionNumber();

    /**
     * `AWS::EC2::TrafficMirrorSession.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * `AWS::EC2::TrafficMirrorSession.TrafficMirrorFilterId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTrafficMirrorFilterId();

    /**
     * `AWS::EC2::TrafficMirrorSession.TrafficMirrorTargetId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTrafficMirrorTargetId();

    /**
     * `AWS::EC2::TrafficMirrorSession.VirtualNetworkId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getVirtualNetworkId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTrafficMirrorSessionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTrafficMirrorSessionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTrafficMirrorSessionProps> {
        java.lang.String description;
        java.lang.String networkInterfaceId;
        java.lang.Number packetLength;
        java.lang.Number sessionNumber;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        java.lang.String trafficMirrorFilterId;
        java.lang.String trafficMirrorTargetId;
        java.lang.Number virtualNetworkId;

        /**
         * Sets the value of {@link CfnTrafficMirrorSessionProps#getDescription}
         * @param description `AWS::EC2::TrafficMirrorSession.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrafficMirrorSessionProps#getNetworkInterfaceId}
         * @param networkInterfaceId `AWS::EC2::TrafficMirrorSession.NetworkInterfaceId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInterfaceId(java.lang.String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrafficMirrorSessionProps#getPacketLength}
         * @param packetLength `AWS::EC2::TrafficMirrorSession.PacketLength`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packetLength(java.lang.Number packetLength) {
            this.packetLength = packetLength;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrafficMirrorSessionProps#getSessionNumber}
         * @param sessionNumber `AWS::EC2::TrafficMirrorSession.SessionNumber`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sessionNumber(java.lang.Number sessionNumber) {
            this.sessionNumber = sessionNumber;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrafficMirrorSessionProps#getTags}
         * @param tags `AWS::EC2::TrafficMirrorSession.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrafficMirrorSessionProps#getTrafficMirrorFilterId}
         * @param trafficMirrorFilterId `AWS::EC2::TrafficMirrorSession.TrafficMirrorFilterId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficMirrorFilterId(java.lang.String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrafficMirrorSessionProps#getTrafficMirrorTargetId}
         * @param trafficMirrorTargetId `AWS::EC2::TrafficMirrorSession.TrafficMirrorTargetId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficMirrorTargetId(java.lang.String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrafficMirrorSessionProps#getVirtualNetworkId}
         * @param virtualNetworkId `AWS::EC2::TrafficMirrorSession.VirtualNetworkId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualNetworkId(java.lang.Number virtualNetworkId) {
            this.virtualNetworkId = virtualNetworkId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTrafficMirrorSessionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTrafficMirrorSessionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTrafficMirrorSessionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTrafficMirrorSessionProps {
        private final java.lang.String description;
        private final java.lang.String networkInterfaceId;
        private final java.lang.Number packetLength;
        private final java.lang.Number sessionNumber;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.String trafficMirrorFilterId;
        private final java.lang.String trafficMirrorTargetId;
        private final java.lang.Number virtualNetworkId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkInterfaceId = software.amazon.jsii.Kernel.get(this, "networkInterfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.packetLength = software.amazon.jsii.Kernel.get(this, "packetLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.sessionNumber = software.amazon.jsii.Kernel.get(this, "sessionNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.trafficMirrorFilterId = software.amazon.jsii.Kernel.get(this, "trafficMirrorFilterId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.trafficMirrorTargetId = software.amazon.jsii.Kernel.get(this, "trafficMirrorTargetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.virtualNetworkId = software.amazon.jsii.Kernel.get(this, "virtualNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = builder.description;
            this.networkInterfaceId = java.util.Objects.requireNonNull(builder.networkInterfaceId, "networkInterfaceId is required");
            this.packetLength = builder.packetLength;
            this.sessionNumber = java.util.Objects.requireNonNull(builder.sessionNumber, "sessionNumber is required");
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            this.trafficMirrorFilterId = java.util.Objects.requireNonNull(builder.trafficMirrorFilterId, "trafficMirrorFilterId is required");
            this.trafficMirrorTargetId = java.util.Objects.requireNonNull(builder.trafficMirrorTargetId, "trafficMirrorTargetId is required");
            this.virtualNetworkId = builder.virtualNetworkId;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final java.lang.Number getPacketLength() {
            return this.packetLength;
        }

        @Override
        public final java.lang.Number getSessionNumber() {
            return this.sessionNumber;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTrafficMirrorFilterId() {
            return this.trafficMirrorFilterId;
        }

        @Override
        public final java.lang.String getTrafficMirrorTargetId() {
            return this.trafficMirrorTargetId;
        }

        @Override
        public final java.lang.Number getVirtualNetworkId() {
            return this.virtualNetworkId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            data.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
            if (this.getPacketLength() != null) {
                data.set("packetLength", om.valueToTree(this.getPacketLength()));
            }
            data.set("sessionNumber", om.valueToTree(this.getSessionNumber()));
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            data.set("trafficMirrorFilterId", om.valueToTree(this.getTrafficMirrorFilterId()));
            data.set("trafficMirrorTargetId", om.valueToTree(this.getTrafficMirrorTargetId()));
            if (this.getVirtualNetworkId() != null) {
                data.set("virtualNetworkId", om.valueToTree(this.getVirtualNetworkId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnTrafficMirrorSessionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTrafficMirrorSessionProps.Jsii$Proxy that = (CfnTrafficMirrorSessionProps.Jsii$Proxy) o;

            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (!networkInterfaceId.equals(that.networkInterfaceId)) return false;
            if (this.packetLength != null ? !this.packetLength.equals(that.packetLength) : that.packetLength != null) return false;
            if (!sessionNumber.equals(that.sessionNumber)) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (!trafficMirrorFilterId.equals(that.trafficMirrorFilterId)) return false;
            if (!trafficMirrorTargetId.equals(that.trafficMirrorTargetId)) return false;
            return this.virtualNetworkId != null ? this.virtualNetworkId.equals(that.virtualNetworkId) : that.virtualNetworkId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.networkInterfaceId.hashCode());
            result = 31 * result + (this.packetLength != null ? this.packetLength.hashCode() : 0);
            result = 31 * result + (this.sessionNumber.hashCode());
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.trafficMirrorFilterId.hashCode());
            result = 31 * result + (this.trafficMirrorTargetId.hashCode());
            result = 31 * result + (this.virtualNetworkId != null ? this.virtualNetworkId.hashCode() : 0);
            return result;
        }
    }
}
