package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::IPAMPool`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnIPAMPool cfnIPAMPool = CfnIPAMPool.Builder.create(this, "MyCfnIPAMPool")
 *         .addressFamily("addressFamily")
 *         .ipamScopeId("ipamScopeId")
 *         // the properties below are optional
 *         .allocationDefaultNetmaskLength(123)
 *         .allocationMaxNetmaskLength(123)
 *         .allocationMinNetmaskLength(123)
 *         .allocationResourceTags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .autoImport(false)
 *         .description("description")
 *         .locale("locale")
 *         .provisionedCidrs(List.of(ProvisionedCidrProperty.builder()
 *                 .cidr("cidr")
 *                 .build()))
 *         .publiclyAdvertisable(false)
 *         .sourceIpamPoolId("sourceIpamPoolId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-10T18:02:00.695Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnIPAMPool")
public class CfnIPAMPool extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnIPAMPool(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIPAMPool(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnIPAMPool.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::EC2::IPAMPool`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIPAMPool(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnIPAMPoolProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * `AWS::EC2::IPAMPool.AddressFamily`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAddressFamily() {
        return software.amazon.jsii.Kernel.get(this, "addressFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::EC2::IPAMPool.AddressFamily`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAddressFamily(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "addressFamily", java.util.Objects.requireNonNull(value, "addressFamily is required"));
    }

    /**
     * `AWS::EC2::IPAMPool.AllocationDefaultNetmaskLength`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getAllocationDefaultNetmaskLength() {
        return software.amazon.jsii.Kernel.get(this, "allocationDefaultNetmaskLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * `AWS::EC2::IPAMPool.AllocationDefaultNetmaskLength`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllocationDefaultNetmaskLength(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "allocationDefaultNetmaskLength", value);
    }

    /**
     * `AWS::EC2::IPAMPool.AllocationMaxNetmaskLength`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getAllocationMaxNetmaskLength() {
        return software.amazon.jsii.Kernel.get(this, "allocationMaxNetmaskLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * `AWS::EC2::IPAMPool.AllocationMaxNetmaskLength`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllocationMaxNetmaskLength(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "allocationMaxNetmaskLength", value);
    }

    /**
     * `AWS::EC2::IPAMPool.AllocationMinNetmaskLength`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getAllocationMinNetmaskLength() {
        return software.amazon.jsii.Kernel.get(this, "allocationMinNetmaskLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * `AWS::EC2::IPAMPool.AllocationMinNetmaskLength`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllocationMinNetmaskLength(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "allocationMinNetmaskLength", value);
    }

    /**
     * `AWS::EC2::IPAMPool.AllocationResourceTags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAllocationResourceTags() {
        return software.amazon.jsii.Kernel.get(this, "allocationResourceTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::EC2::IPAMPool.AllocationResourceTags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllocationResourceTags(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "allocationResourceTags", value);
    }

    /**
     * `AWS::EC2::IPAMPool.AllocationResourceTags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllocationResourceTags(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "allocationResourceTags", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIpamArn() {
        return software.amazon.jsii.Kernel.get(this, "attrIpamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIpamPoolId() {
        return software.amazon.jsii.Kernel.get(this, "attrIpamPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIpamScopeArn() {
        return software.amazon.jsii.Kernel.get(this, "attrIpamScopeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIpamScopeType() {
        return software.amazon.jsii.Kernel.get(this, "attrIpamScopeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrPoolDepth() {
        return software.amazon.jsii.Kernel.get(this, "attrPoolDepth", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrState() {
        return software.amazon.jsii.Kernel.get(this, "attrState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStateMessage() {
        return software.amazon.jsii.Kernel.get(this, "attrStateMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::EC2::IPAMPool.AutoImport`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoImport() {
        return software.amazon.jsii.Kernel.get(this, "autoImport", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::EC2::IPAMPool.AutoImport`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoImport(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "autoImport", value);
    }

    /**
     * `AWS::EC2::IPAMPool.AutoImport`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoImport(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoImport", value);
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::EC2::IPAMPool.Description`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::EC2::IPAMPool.Description`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * `AWS::EC2::IPAMPool.IpamScopeId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIpamScopeId() {
        return software.amazon.jsii.Kernel.get(this, "ipamScopeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::EC2::IPAMPool.IpamScopeId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIpamScopeId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ipamScopeId", java.util.Objects.requireNonNull(value, "ipamScopeId is required"));
    }

    /**
     * `AWS::EC2::IPAMPool.Locale`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLocale() {
        return software.amazon.jsii.Kernel.get(this, "locale", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::EC2::IPAMPool.Locale`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLocale(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "locale", value);
    }

    /**
     * `AWS::EC2::IPAMPool.ProvisionedCidrs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getProvisionedCidrs() {
        return software.amazon.jsii.Kernel.get(this, "provisionedCidrs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::EC2::IPAMPool.ProvisionedCidrs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisionedCidrs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "provisionedCidrs", value);
    }

    /**
     * `AWS::EC2::IPAMPool.ProvisionedCidrs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisionedCidrs(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "provisionedCidrs", value);
    }

    /**
     * `AWS::EC2::IPAMPool.PubliclyAdvertisable`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPubliclyAdvertisable() {
        return software.amazon.jsii.Kernel.get(this, "publiclyAdvertisable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::EC2::IPAMPool.PubliclyAdvertisable`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPubliclyAdvertisable(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "publiclyAdvertisable", value);
    }

    /**
     * `AWS::EC2::IPAMPool.PubliclyAdvertisable`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPubliclyAdvertisable(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "publiclyAdvertisable", value);
    }

    /**
     * `AWS::EC2::IPAMPool.SourceIpamPoolId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceIpamPoolId() {
        return software.amazon.jsii.Kernel.get(this, "sourceIpamPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::EC2::IPAMPool.SourceIpamPoolId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceIpamPoolId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceIpamPoolId", value);
    }

    /**
     * `AWS::EC2::IPAMPool.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * ProvisionedCidrProperty provisionedCidrProperty = ProvisionedCidrProperty.builder()
     *         .cidr("cidr")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnIPAMPool.ProvisionedCidrProperty")
    @software.amazon.jsii.Jsii.Proxy(ProvisionedCidrProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProvisionedCidrProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnIPAMPool.ProvisionedCidrProperty.Cidr`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCidr();

        /**
         * @return a {@link Builder} of {@link ProvisionedCidrProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProvisionedCidrProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProvisionedCidrProperty> {
            java.lang.String cidr;

            /**
             * Sets the value of {@link ProvisionedCidrProperty#getCidr}
             * @param cidr `CfnIPAMPool.ProvisionedCidrProperty.Cidr`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cidr(java.lang.String cidr) {
                this.cidr = cidr;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProvisionedCidrProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProvisionedCidrProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProvisionedCidrProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProvisionedCidrProperty {
            private final java.lang.String cidr;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cidr = software.amazon.jsii.Kernel.get(this, "cidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cidr = java.util.Objects.requireNonNull(builder.cidr, "cidr is required");
            }

            @Override
            public final java.lang.String getCidr() {
                return this.cidr;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cidr", om.valueToTree(this.getCidr()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnIPAMPool.ProvisionedCidrProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProvisionedCidrProperty.Jsii$Proxy that = (ProvisionedCidrProperty.Jsii$Proxy) o;

                return this.cidr.equals(that.cidr);
            }

            @Override
            public final int hashCode() {
                int result = this.cidr.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnIPAMPool}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnIPAMPool> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnIPAMPoolProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnIPAMPoolProps.Builder();
        }

        /**
         * `AWS::EC2::IPAMPool.AddressFamily`.
         * <p>
         * @return {@code this}
         * @param addressFamily `AWS::EC2::IPAMPool.AddressFamily`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addressFamily(final java.lang.String addressFamily) {
            this.props.addressFamily(addressFamily);
            return this;
        }

        /**
         * `AWS::EC2::IPAMPool.AllocationDefaultNetmaskLength`.
         * <p>
         * @return {@code this}
         * @param allocationDefaultNetmaskLength `AWS::EC2::IPAMPool.AllocationDefaultNetmaskLength`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationDefaultNetmaskLength(final java.lang.Number allocationDefaultNetmaskLength) {
            this.props.allocationDefaultNetmaskLength(allocationDefaultNetmaskLength);
            return this;
        }

        /**
         * `AWS::EC2::IPAMPool.AllocationMaxNetmaskLength`.
         * <p>
         * @return {@code this}
         * @param allocationMaxNetmaskLength `AWS::EC2::IPAMPool.AllocationMaxNetmaskLength`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationMaxNetmaskLength(final java.lang.Number allocationMaxNetmaskLength) {
            this.props.allocationMaxNetmaskLength(allocationMaxNetmaskLength);
            return this;
        }

        /**
         * `AWS::EC2::IPAMPool.AllocationMinNetmaskLength`.
         * <p>
         * @return {@code this}
         * @param allocationMinNetmaskLength `AWS::EC2::IPAMPool.AllocationMinNetmaskLength`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationMinNetmaskLength(final java.lang.Number allocationMinNetmaskLength) {
            this.props.allocationMinNetmaskLength(allocationMinNetmaskLength);
            return this;
        }

        /**
         * `AWS::EC2::IPAMPool.AllocationResourceTags`.
         * <p>
         * @return {@code this}
         * @param allocationResourceTags `AWS::EC2::IPAMPool.AllocationResourceTags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationResourceTags(final software.amazon.awscdk.core.IResolvable allocationResourceTags) {
            this.props.allocationResourceTags(allocationResourceTags);
            return this;
        }
        /**
         * `AWS::EC2::IPAMPool.AllocationResourceTags`.
         * <p>
         * @return {@code this}
         * @param allocationResourceTags `AWS::EC2::IPAMPool.AllocationResourceTags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationResourceTags(final java.util.List<? extends java.lang.Object> allocationResourceTags) {
            this.props.allocationResourceTags(allocationResourceTags);
            return this;
        }

        /**
         * `AWS::EC2::IPAMPool.AutoImport`.
         * <p>
         * @return {@code this}
         * @param autoImport `AWS::EC2::IPAMPool.AutoImport`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoImport(final java.lang.Boolean autoImport) {
            this.props.autoImport(autoImport);
            return this;
        }
        /**
         * `AWS::EC2::IPAMPool.AutoImport`.
         * <p>
         * @return {@code this}
         * @param autoImport `AWS::EC2::IPAMPool.AutoImport`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoImport(final software.amazon.awscdk.core.IResolvable autoImport) {
            this.props.autoImport(autoImport);
            return this;
        }

        /**
         * `AWS::EC2::IPAMPool.Description`.
         * <p>
         * @return {@code this}
         * @param description `AWS::EC2::IPAMPool.Description`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * `AWS::EC2::IPAMPool.IpamScopeId`.
         * <p>
         * @return {@code this}
         * @param ipamScopeId `AWS::EC2::IPAMPool.IpamScopeId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipamScopeId(final java.lang.String ipamScopeId) {
            this.props.ipamScopeId(ipamScopeId);
            return this;
        }

        /**
         * `AWS::EC2::IPAMPool.Locale`.
         * <p>
         * @return {@code this}
         * @param locale `AWS::EC2::IPAMPool.Locale`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locale(final java.lang.String locale) {
            this.props.locale(locale);
            return this;
        }

        /**
         * `AWS::EC2::IPAMPool.ProvisionedCidrs`.
         * <p>
         * @return {@code this}
         * @param provisionedCidrs `AWS::EC2::IPAMPool.ProvisionedCidrs`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedCidrs(final software.amazon.awscdk.core.IResolvable provisionedCidrs) {
            this.props.provisionedCidrs(provisionedCidrs);
            return this;
        }
        /**
         * `AWS::EC2::IPAMPool.ProvisionedCidrs`.
         * <p>
         * @return {@code this}
         * @param provisionedCidrs `AWS::EC2::IPAMPool.ProvisionedCidrs`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedCidrs(final java.util.List<? extends java.lang.Object> provisionedCidrs) {
            this.props.provisionedCidrs(provisionedCidrs);
            return this;
        }

        /**
         * `AWS::EC2::IPAMPool.PubliclyAdvertisable`.
         * <p>
         * @return {@code this}
         * @param publiclyAdvertisable `AWS::EC2::IPAMPool.PubliclyAdvertisable`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAdvertisable(final java.lang.Boolean publiclyAdvertisable) {
            this.props.publiclyAdvertisable(publiclyAdvertisable);
            return this;
        }
        /**
         * `AWS::EC2::IPAMPool.PubliclyAdvertisable`.
         * <p>
         * @return {@code this}
         * @param publiclyAdvertisable `AWS::EC2::IPAMPool.PubliclyAdvertisable`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAdvertisable(final software.amazon.awscdk.core.IResolvable publiclyAdvertisable) {
            this.props.publiclyAdvertisable(publiclyAdvertisable);
            return this;
        }

        /**
         * `AWS::EC2::IPAMPool.SourceIpamPoolId`.
         * <p>
         * @return {@code this}
         * @param sourceIpamPoolId `AWS::EC2::IPAMPool.SourceIpamPoolId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceIpamPoolId(final java.lang.String sourceIpamPoolId) {
            this.props.sourceIpamPoolId(sourceIpamPoolId);
            return this;
        }

        /**
         * `AWS::EC2::IPAMPool.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::EC2::IPAMPool.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnIPAMPool}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnIPAMPool build() {
            return new software.amazon.awscdk.services.ec2.CfnIPAMPool(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
