package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::IPAMPool`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnIPAMPoolProps cfnIPAMPoolProps = CfnIPAMPoolProps.builder()
 *         .addressFamily("addressFamily")
 *         .ipamScopeId("ipamScopeId")
 *         // the properties below are optional
 *         .allocationDefaultNetmaskLength(123)
 *         .allocationMaxNetmaskLength(123)
 *         .allocationMinNetmaskLength(123)
 *         .allocationResourceTags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .autoImport(false)
 *         .description("description")
 *         .locale("locale")
 *         .provisionedCidrs(List.of(ProvisionedCidrProperty.builder()
 *                 .cidr("cidr")
 *                 .build()))
 *         .publiclyAdvertisable(false)
 *         .sourceIpamPoolId("sourceIpamPoolId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-10T18:02:00.696Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnIPAMPoolProps")
@software.amazon.jsii.Jsii.Proxy(CfnIPAMPoolProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIPAMPoolProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::IPAMPool.AddressFamily`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAddressFamily();

    /**
     * `AWS::EC2::IPAMPool.AllocationDefaultNetmaskLength`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAllocationDefaultNetmaskLength() {
        return null;
    }

    /**
     * `AWS::EC2::IPAMPool.AllocationMaxNetmaskLength`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAllocationMaxNetmaskLength() {
        return null;
    }

    /**
     * `AWS::EC2::IPAMPool.AllocationMinNetmaskLength`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAllocationMinNetmaskLength() {
        return null;
    }

    /**
     * `AWS::EC2::IPAMPool.AllocationResourceTags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAllocationResourceTags() {
        return null;
    }

    /**
     * `AWS::EC2::IPAMPool.AutoImport`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoImport() {
        return null;
    }

    /**
     * `AWS::EC2::IPAMPool.Description`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * `AWS::EC2::IPAMPool.IpamScopeId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIpamScopeId();

    /**
     * `AWS::EC2::IPAMPool.Locale`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLocale() {
        return null;
    }

    /**
     * `AWS::EC2::IPAMPool.ProvisionedCidrs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProvisionedCidrs() {
        return null;
    }

    /**
     * `AWS::EC2::IPAMPool.PubliclyAdvertisable`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPubliclyAdvertisable() {
        return null;
    }

    /**
     * `AWS::EC2::IPAMPool.SourceIpamPoolId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceIpamPoolId() {
        return null;
    }

    /**
     * `AWS::EC2::IPAMPool.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIPAMPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIPAMPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIPAMPoolProps> {
        java.lang.String addressFamily;
        java.lang.Number allocationDefaultNetmaskLength;
        java.lang.Number allocationMaxNetmaskLength;
        java.lang.Number allocationMinNetmaskLength;
        java.lang.Object allocationResourceTags;
        java.lang.Object autoImport;
        java.lang.String description;
        java.lang.String ipamScopeId;
        java.lang.String locale;
        java.lang.Object provisionedCidrs;
        java.lang.Object publiclyAdvertisable;
        java.lang.String sourceIpamPoolId;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getAddressFamily}
         * @param addressFamily `AWS::EC2::IPAMPool.AddressFamily`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addressFamily(java.lang.String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getAllocationDefaultNetmaskLength}
         * @param allocationDefaultNetmaskLength `AWS::EC2::IPAMPool.AllocationDefaultNetmaskLength`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationDefaultNetmaskLength(java.lang.Number allocationDefaultNetmaskLength) {
            this.allocationDefaultNetmaskLength = allocationDefaultNetmaskLength;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getAllocationMaxNetmaskLength}
         * @param allocationMaxNetmaskLength `AWS::EC2::IPAMPool.AllocationMaxNetmaskLength`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationMaxNetmaskLength(java.lang.Number allocationMaxNetmaskLength) {
            this.allocationMaxNetmaskLength = allocationMaxNetmaskLength;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getAllocationMinNetmaskLength}
         * @param allocationMinNetmaskLength `AWS::EC2::IPAMPool.AllocationMinNetmaskLength`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationMinNetmaskLength(java.lang.Number allocationMinNetmaskLength) {
            this.allocationMinNetmaskLength = allocationMinNetmaskLength;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getAllocationResourceTags}
         * @param allocationResourceTags `AWS::EC2::IPAMPool.AllocationResourceTags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationResourceTags(software.amazon.awscdk.core.IResolvable allocationResourceTags) {
            this.allocationResourceTags = allocationResourceTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getAllocationResourceTags}
         * @param allocationResourceTags `AWS::EC2::IPAMPool.AllocationResourceTags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationResourceTags(java.util.List<? extends java.lang.Object> allocationResourceTags) {
            this.allocationResourceTags = allocationResourceTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getAutoImport}
         * @param autoImport `AWS::EC2::IPAMPool.AutoImport`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoImport(java.lang.Boolean autoImport) {
            this.autoImport = autoImport;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getAutoImport}
         * @param autoImport `AWS::EC2::IPAMPool.AutoImport`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoImport(software.amazon.awscdk.core.IResolvable autoImport) {
            this.autoImport = autoImport;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getDescription}
         * @param description `AWS::EC2::IPAMPool.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getIpamScopeId}
         * @param ipamScopeId `AWS::EC2::IPAMPool.IpamScopeId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipamScopeId(java.lang.String ipamScopeId) {
            this.ipamScopeId = ipamScopeId;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getLocale}
         * @param locale `AWS::EC2::IPAMPool.Locale`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locale(java.lang.String locale) {
            this.locale = locale;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getProvisionedCidrs}
         * @param provisionedCidrs `AWS::EC2::IPAMPool.ProvisionedCidrs`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedCidrs(software.amazon.awscdk.core.IResolvable provisionedCidrs) {
            this.provisionedCidrs = provisionedCidrs;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getProvisionedCidrs}
         * @param provisionedCidrs `AWS::EC2::IPAMPool.ProvisionedCidrs`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedCidrs(java.util.List<? extends java.lang.Object> provisionedCidrs) {
            this.provisionedCidrs = provisionedCidrs;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getPubliclyAdvertisable}
         * @param publiclyAdvertisable `AWS::EC2::IPAMPool.PubliclyAdvertisable`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAdvertisable(java.lang.Boolean publiclyAdvertisable) {
            this.publiclyAdvertisable = publiclyAdvertisable;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getPubliclyAdvertisable}
         * @param publiclyAdvertisable `AWS::EC2::IPAMPool.PubliclyAdvertisable`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAdvertisable(software.amazon.awscdk.core.IResolvable publiclyAdvertisable) {
            this.publiclyAdvertisable = publiclyAdvertisable;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getSourceIpamPoolId}
         * @param sourceIpamPoolId `AWS::EC2::IPAMPool.SourceIpamPoolId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceIpamPoolId(java.lang.String sourceIpamPoolId) {
            this.sourceIpamPoolId = sourceIpamPoolId;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPAMPoolProps#getTags}
         * @param tags `AWS::EC2::IPAMPool.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIPAMPoolProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIPAMPoolProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIPAMPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIPAMPoolProps {
        private final java.lang.String addressFamily;
        private final java.lang.Number allocationDefaultNetmaskLength;
        private final java.lang.Number allocationMaxNetmaskLength;
        private final java.lang.Number allocationMinNetmaskLength;
        private final java.lang.Object allocationResourceTags;
        private final java.lang.Object autoImport;
        private final java.lang.String description;
        private final java.lang.String ipamScopeId;
        private final java.lang.String locale;
        private final java.lang.Object provisionedCidrs;
        private final java.lang.Object publiclyAdvertisable;
        private final java.lang.String sourceIpamPoolId;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.addressFamily = software.amazon.jsii.Kernel.get(this, "addressFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.allocationDefaultNetmaskLength = software.amazon.jsii.Kernel.get(this, "allocationDefaultNetmaskLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.allocationMaxNetmaskLength = software.amazon.jsii.Kernel.get(this, "allocationMaxNetmaskLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.allocationMinNetmaskLength = software.amazon.jsii.Kernel.get(this, "allocationMinNetmaskLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.allocationResourceTags = software.amazon.jsii.Kernel.get(this, "allocationResourceTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.autoImport = software.amazon.jsii.Kernel.get(this, "autoImport", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipamScopeId = software.amazon.jsii.Kernel.get(this, "ipamScopeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.locale = software.amazon.jsii.Kernel.get(this, "locale", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.provisionedCidrs = software.amazon.jsii.Kernel.get(this, "provisionedCidrs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.publiclyAdvertisable = software.amazon.jsii.Kernel.get(this, "publiclyAdvertisable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sourceIpamPoolId = software.amazon.jsii.Kernel.get(this, "sourceIpamPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.addressFamily = java.util.Objects.requireNonNull(builder.addressFamily, "addressFamily is required");
            this.allocationDefaultNetmaskLength = builder.allocationDefaultNetmaskLength;
            this.allocationMaxNetmaskLength = builder.allocationMaxNetmaskLength;
            this.allocationMinNetmaskLength = builder.allocationMinNetmaskLength;
            this.allocationResourceTags = builder.allocationResourceTags;
            this.autoImport = builder.autoImport;
            this.description = builder.description;
            this.ipamScopeId = java.util.Objects.requireNonNull(builder.ipamScopeId, "ipamScopeId is required");
            this.locale = builder.locale;
            this.provisionedCidrs = builder.provisionedCidrs;
            this.publiclyAdvertisable = builder.publiclyAdvertisable;
            this.sourceIpamPoolId = builder.sourceIpamPoolId;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAddressFamily() {
            return this.addressFamily;
        }

        @Override
        public final java.lang.Number getAllocationDefaultNetmaskLength() {
            return this.allocationDefaultNetmaskLength;
        }

        @Override
        public final java.lang.Number getAllocationMaxNetmaskLength() {
            return this.allocationMaxNetmaskLength;
        }

        @Override
        public final java.lang.Number getAllocationMinNetmaskLength() {
            return this.allocationMinNetmaskLength;
        }

        @Override
        public final java.lang.Object getAllocationResourceTags() {
            return this.allocationResourceTags;
        }

        @Override
        public final java.lang.Object getAutoImport() {
            return this.autoImport;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getIpamScopeId() {
            return this.ipamScopeId;
        }

        @Override
        public final java.lang.String getLocale() {
            return this.locale;
        }

        @Override
        public final java.lang.Object getProvisionedCidrs() {
            return this.provisionedCidrs;
        }

        @Override
        public final java.lang.Object getPubliclyAdvertisable() {
            return this.publiclyAdvertisable;
        }

        @Override
        public final java.lang.String getSourceIpamPoolId() {
            return this.sourceIpamPoolId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("addressFamily", om.valueToTree(this.getAddressFamily()));
            if (this.getAllocationDefaultNetmaskLength() != null) {
                data.set("allocationDefaultNetmaskLength", om.valueToTree(this.getAllocationDefaultNetmaskLength()));
            }
            if (this.getAllocationMaxNetmaskLength() != null) {
                data.set("allocationMaxNetmaskLength", om.valueToTree(this.getAllocationMaxNetmaskLength()));
            }
            if (this.getAllocationMinNetmaskLength() != null) {
                data.set("allocationMinNetmaskLength", om.valueToTree(this.getAllocationMinNetmaskLength()));
            }
            if (this.getAllocationResourceTags() != null) {
                data.set("allocationResourceTags", om.valueToTree(this.getAllocationResourceTags()));
            }
            if (this.getAutoImport() != null) {
                data.set("autoImport", om.valueToTree(this.getAutoImport()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            data.set("ipamScopeId", om.valueToTree(this.getIpamScopeId()));
            if (this.getLocale() != null) {
                data.set("locale", om.valueToTree(this.getLocale()));
            }
            if (this.getProvisionedCidrs() != null) {
                data.set("provisionedCidrs", om.valueToTree(this.getProvisionedCidrs()));
            }
            if (this.getPubliclyAdvertisable() != null) {
                data.set("publiclyAdvertisable", om.valueToTree(this.getPubliclyAdvertisable()));
            }
            if (this.getSourceIpamPoolId() != null) {
                data.set("sourceIpamPoolId", om.valueToTree(this.getSourceIpamPoolId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnIPAMPoolProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIPAMPoolProps.Jsii$Proxy that = (CfnIPAMPoolProps.Jsii$Proxy) o;

            if (!addressFamily.equals(that.addressFamily)) return false;
            if (this.allocationDefaultNetmaskLength != null ? !this.allocationDefaultNetmaskLength.equals(that.allocationDefaultNetmaskLength) : that.allocationDefaultNetmaskLength != null) return false;
            if (this.allocationMaxNetmaskLength != null ? !this.allocationMaxNetmaskLength.equals(that.allocationMaxNetmaskLength) : that.allocationMaxNetmaskLength != null) return false;
            if (this.allocationMinNetmaskLength != null ? !this.allocationMinNetmaskLength.equals(that.allocationMinNetmaskLength) : that.allocationMinNetmaskLength != null) return false;
            if (this.allocationResourceTags != null ? !this.allocationResourceTags.equals(that.allocationResourceTags) : that.allocationResourceTags != null) return false;
            if (this.autoImport != null ? !this.autoImport.equals(that.autoImport) : that.autoImport != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (!ipamScopeId.equals(that.ipamScopeId)) return false;
            if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) return false;
            if (this.provisionedCidrs != null ? !this.provisionedCidrs.equals(that.provisionedCidrs) : that.provisionedCidrs != null) return false;
            if (this.publiclyAdvertisable != null ? !this.publiclyAdvertisable.equals(that.publiclyAdvertisable) : that.publiclyAdvertisable != null) return false;
            if (this.sourceIpamPoolId != null ? !this.sourceIpamPoolId.equals(that.sourceIpamPoolId) : that.sourceIpamPoolId != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.addressFamily.hashCode();
            result = 31 * result + (this.allocationDefaultNetmaskLength != null ? this.allocationDefaultNetmaskLength.hashCode() : 0);
            result = 31 * result + (this.allocationMaxNetmaskLength != null ? this.allocationMaxNetmaskLength.hashCode() : 0);
            result = 31 * result + (this.allocationMinNetmaskLength != null ? this.allocationMinNetmaskLength.hashCode() : 0);
            result = 31 * result + (this.allocationResourceTags != null ? this.allocationResourceTags.hashCode() : 0);
            result = 31 * result + (this.autoImport != null ? this.autoImport.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.ipamScopeId.hashCode());
            result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
            result = 31 * result + (this.provisionedCidrs != null ? this.provisionedCidrs.hashCode() : 0);
            result = 31 * result + (this.publiclyAdvertisable != null ? this.publiclyAdvertisable.hashCode() : 0);
            result = 31 * result + (this.sourceIpamPoolId != null ? this.sourceIpamPoolId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
