package software.amazon.awscdk.services.ec2;

/**
 * An object that represents reasons to restart an InitService.
 * <p>
 * Pass an instance of this object to the <code>InitFile</code>, <code>InitCommand</code>,
 * <code>InitSource</code> and <code>InitPackage</code> objects, and finally to an <code>InitService</code>
 * itself to cause the actions (files, commands, sources, and packages)
 * to trigger a restart of the service.
 * <p>
 * For example, the following will run a custom command to install Nginx,
 * and trigger the nginx service to be restarted after the command has run.
 * <p>
 * <blockquote><pre>
 * InitServiceRestartHandle handle = new InitServiceRestartHandle();
 * CloudFormationInit.fromElements(InitCommand.shellCommand("/usr/bin/custom-nginx-install.sh", InitCommandOptions.builder().serviceRestartHandles(List.of(handle)).build()), InitService.enable("nginx", InitServiceOptions.builder().serviceRestartHandle(handle).build()));
 * </pre></blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket myBucket;
 * InitServiceRestartHandle handle = new InitServiceRestartHandle();
 * CloudFormationInit.fromElements(InitFile.fromString("/etc/nginx/nginx.conf", "...", InitFileOptions.builder().serviceRestartHandles(List.of(handle)).build()), InitSource.fromS3Object("/var/www/html", myBucket, "html.zip", InitSourceOptions.builder().serviceRestartHandles(List.of(handle)).build()), InitService.enable("nginx", InitServiceOptions.builder()
 *         .serviceRestartHandle(handle)
 *         .build()));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-10T18:02:00.894Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.InitServiceRestartHandle")
public class InitServiceRestartHandle extends software.amazon.jsii.JsiiObject {

    protected InitServiceRestartHandle(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InitServiceRestartHandle(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InitServiceRestartHandle() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }
}
