package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::SpotFleet`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnSpotFleetProps cfnSpotFleetProps = CfnSpotFleetProps.builder()
 *         .spotFleetRequestConfigData(SpotFleetRequestConfigDataProperty.builder()
 *                 .iamFleetRole("iamFleetRole")
 *                 .targetCapacity(123)
 *                 // the properties below are optional
 *                 .allocationStrategy("allocationStrategy")
 *                 .context("context")
 *                 .excessCapacityTerminationPolicy("excessCapacityTerminationPolicy")
 *                 .instanceInterruptionBehavior("instanceInterruptionBehavior")
 *                 .instancePoolsToUseCount(123)
 *                 .launchSpecifications(List.of(SpotFleetLaunchSpecificationProperty.builder()
 *                         .imageId("imageId")
 *                         // the properties below are optional
 *                         .blockDeviceMappings(List.of(BlockDeviceMappingProperty.builder()
 *                                 .deviceName("deviceName")
 *                                 // the properties below are optional
 *                                 .ebs(EbsBlockDeviceProperty.builder()
 *                                         .deleteOnTermination(false)
 *                                         .encrypted(false)
 *                                         .iops(123)
 *                                         .snapshotId("snapshotId")
 *                                         .volumeSize(123)
 *                                         .volumeType("volumeType")
 *                                         .build())
 *                                 .noDevice("noDevice")
 *                                 .virtualName("virtualName")
 *                                 .build()))
 *                         .ebsOptimized(false)
 *                         .iamInstanceProfile(IamInstanceProfileSpecificationProperty.builder()
 *                                 .arn("arn")
 *                                 .build())
 *                         .instanceRequirements(InstanceRequirementsRequestProperty.builder()
 *                                 .acceleratorCount(AcceleratorCountRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .acceleratorManufacturers(List.of("acceleratorManufacturers"))
 *                                 .acceleratorNames(List.of("acceleratorNames"))
 *                                 .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .acceleratorTypes(List.of("acceleratorTypes"))
 *                                 .bareMetal("bareMetal")
 *                                 .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .burstablePerformance("burstablePerformance")
 *                                 .cpuManufacturers(List.of("cpuManufacturers"))
 *                                 .excludedInstanceTypes(List.of("excludedInstanceTypes"))
 *                                 .instanceGenerations(List.of("instanceGenerations"))
 *                                 .localStorage("localStorage")
 *                                 .localStorageTypes(List.of("localStorageTypes"))
 *                                 .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .memoryMiB(MemoryMiBRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .onDemandMaxPricePercentageOverLowestPrice(123)
 *                                 .requireHibernateSupport(false)
 *                                 .spotMaxPricePercentageOverLowestPrice(123)
 *                                 .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .vCpuCount(VCpuCountRangeRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .build())
 *                         .instanceType("instanceType")
 *                         .kernelId("kernelId")
 *                         .keyName("keyName")
 *                         .monitoring(SpotFleetMonitoringProperty.builder()
 *                                 .enabled(false)
 *                                 .build())
 *                         .networkInterfaces(List.of(InstanceNetworkInterfaceSpecificationProperty.builder()
 *                                 .associatePublicIpAddress(false)
 *                                 .deleteOnTermination(false)
 *                                 .description("description")
 *                                 .deviceIndex(123)
 *                                 .groups(List.of("groups"))
 *                                 .ipv6AddressCount(123)
 *                                 .ipv6Addresses(List.of(InstanceIpv6AddressProperty.builder()
 *                                         .ipv6Address("ipv6Address")
 *                                         .build()))
 *                                 .networkInterfaceId("networkInterfaceId")
 *                                 .privateIpAddresses(List.of(PrivateIpAddressSpecificationProperty.builder()
 *                                         .privateIpAddress("privateIpAddress")
 *                                         // the properties below are optional
 *                                         .primary(false)
 *                                         .build()))
 *                                 .secondaryPrivateIpAddressCount(123)
 *                                 .subnetId("subnetId")
 *                                 .build()))
 *                         .placement(SpotPlacementProperty.builder()
 *                                 .availabilityZone("availabilityZone")
 *                                 .groupName("groupName")
 *                                 .tenancy("tenancy")
 *                                 .build())
 *                         .ramdiskId("ramdiskId")
 *                         .securityGroups(List.of(GroupIdentifierProperty.builder()
 *                                 .groupId("groupId")
 *                                 .build()))
 *                         .spotPrice("spotPrice")
 *                         .subnetId("subnetId")
 *                         .tagSpecifications(List.of(SpotFleetTagSpecificationProperty.builder()
 *                                 .resourceType("resourceType")
 *                                 .tags(List.of(CfnTag.builder()
 *                                         .key("key")
 *                                         .value("value")
 *                                         .build()))
 *                                 .build()))
 *                         .userData("userData")
 *                         .weightedCapacity(123)
 *                         .build()))
 *                 .launchTemplateConfigs(List.of(LaunchTemplateConfigProperty.builder()
 *                         .launchTemplateSpecification(FleetLaunchTemplateSpecificationProperty.builder()
 *                                 .version("version")
 *                                 // the properties below are optional
 *                                 .launchTemplateId("launchTemplateId")
 *                                 .launchTemplateName("launchTemplateName")
 *                                 .build())
 *                         .overrides(List.of(LaunchTemplateOverridesProperty.builder()
 *                                 .availabilityZone("availabilityZone")
 *                                 .instanceRequirements(InstanceRequirementsRequestProperty.builder()
 *                                         .acceleratorCount(AcceleratorCountRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .acceleratorManufacturers(List.of("acceleratorManufacturers"))
 *                                         .acceleratorNames(List.of("acceleratorNames"))
 *                                         .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .acceleratorTypes(List.of("acceleratorTypes"))
 *                                         .bareMetal("bareMetal")
 *                                         .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .burstablePerformance("burstablePerformance")
 *                                         .cpuManufacturers(List.of("cpuManufacturers"))
 *                                         .excludedInstanceTypes(List.of("excludedInstanceTypes"))
 *                                         .instanceGenerations(List.of("instanceGenerations"))
 *                                         .localStorage("localStorage")
 *                                         .localStorageTypes(List.of("localStorageTypes"))
 *                                         .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .memoryMiB(MemoryMiBRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .onDemandMaxPricePercentageOverLowestPrice(123)
 *                                         .requireHibernateSupport(false)
 *                                         .spotMaxPricePercentageOverLowestPrice(123)
 *                                         .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .vCpuCount(VCpuCountRangeRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .build())
 *                                 .instanceType("instanceType")
 *                                 .spotPrice("spotPrice")
 *                                 .subnetId("subnetId")
 *                                 .weightedCapacity(123)
 *                                 .build()))
 *                         .build()))
 *                 .loadBalancersConfig(LoadBalancersConfigProperty.builder()
 *                         .classicLoadBalancersConfig(ClassicLoadBalancersConfigProperty.builder()
 *                                 .classicLoadBalancers(List.of(ClassicLoadBalancerProperty.builder()
 *                                         .name("name")
 *                                         .build()))
 *                                 .build())
 *                         .targetGroupsConfig(TargetGroupsConfigProperty.builder()
 *                                 .targetGroups(List.of(TargetGroupProperty.builder()
 *                                         .arn("arn")
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .onDemandAllocationStrategy("onDemandAllocationStrategy")
 *                 .onDemandMaxTotalPrice("onDemandMaxTotalPrice")
 *                 .onDemandTargetCapacity(123)
 *                 .replaceUnhealthyInstances(false)
 *                 .spotMaintenanceStrategies(SpotMaintenanceStrategiesProperty.builder()
 *                         .capacityRebalance(SpotCapacityRebalanceProperty.builder()
 *                                 .replacementStrategy("replacementStrategy")
 *                                 .terminationDelay(123)
 *                                 .build())
 *                         .build())
 *                 .spotMaxTotalPrice("spotMaxTotalPrice")
 *                 .spotPrice("spotPrice")
 *                 .targetCapacityUnitType("targetCapacityUnitType")
 *                 .terminateInstancesWithExpiration(false)
 *                 .type("type")
 *                 .validFrom("validFrom")
 *                 .validUntil("validUntil")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-15T10:03:45.003Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSpotFleetProps")
@software.amazon.jsii.Jsii.Proxy(CfnSpotFleetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSpotFleetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::SpotFleet.SpotFleetRequestConfigData`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSpotFleetRequestConfigData();

    /**
     * @return a {@link Builder} of {@link CfnSpotFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSpotFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSpotFleetProps> {
        java.lang.Object spotFleetRequestConfigData;

        /**
         * Sets the value of {@link CfnSpotFleetProps#getSpotFleetRequestConfigData}
         * @param spotFleetRequestConfigData `AWS::EC2::SpotFleet.SpotFleetRequestConfigData`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotFleetRequestConfigData(software.amazon.awscdk.core.IResolvable spotFleetRequestConfigData) {
            this.spotFleetRequestConfigData = spotFleetRequestConfigData;
            return this;
        }

        /**
         * Sets the value of {@link CfnSpotFleetProps#getSpotFleetRequestConfigData}
         * @param spotFleetRequestConfigData `AWS::EC2::SpotFleet.SpotFleetRequestConfigData`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotFleetRequestConfigData(software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetRequestConfigDataProperty spotFleetRequestConfigData) {
            this.spotFleetRequestConfigData = spotFleetRequestConfigData;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSpotFleetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSpotFleetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSpotFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSpotFleetProps {
        private final java.lang.Object spotFleetRequestConfigData;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.spotFleetRequestConfigData = software.amazon.jsii.Kernel.get(this, "spotFleetRequestConfigData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.spotFleetRequestConfigData = java.util.Objects.requireNonNull(builder.spotFleetRequestConfigData, "spotFleetRequestConfigData is required");
        }

        @Override
        public final java.lang.Object getSpotFleetRequestConfigData() {
            return this.spotFleetRequestConfigData;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("spotFleetRequestConfigData", om.valueToTree(this.getSpotFleetRequestConfigData()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSpotFleetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSpotFleetProps.Jsii$Proxy that = (CfnSpotFleetProps.Jsii$Proxy) o;

            return this.spotFleetRequestConfigData.equals(that.spotFleetRequestConfigData);
        }

        @Override
        public final int hashCode() {
            int result = this.spotFleetRequestConfigData.hashCode();
            return result;
        }
    }
}
