/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.ec2.$Module;
import software.amazon.awscdk.services.ec2.CfnInstance;
import software.amazon.awscdk.services.ec2.CfnInstanceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance")
public class CfnInstance
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnInstance.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnInstance(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInstance(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnInstance(@NotNull Construct scope, @NotNull String id, @Nullable CfnInstanceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnInstance(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Nullable
    public String getAdditionalInfo() {
        return (String)Kernel.get((Object)((Object)this), (String)"additionalInfo", (NativeType)NativeType.forClass(String.class));
    }

    public void setAdditionalInfo(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"additionalInfo", (Object)value);
    }

    @Nullable
    public String getAffinity() {
        return (String)Kernel.get((Object)((Object)this), (String)"affinity", (NativeType)NativeType.forClass(String.class));
    }

    public void setAffinity(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"affinity", (Object)value);
    }

    @NotNull
    public String getAttrAvailabilityZone() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrAvailabilityZone", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrPrivateDnsName() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrPrivateDnsName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrPrivateIp() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrPrivateIp", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrPublicDnsName() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrPublicDnsName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrPublicIp() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrPublicIp", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getAvailabilityZone() {
        return (String)Kernel.get((Object)((Object)this), (String)"availabilityZone", (NativeType)NativeType.forClass(String.class));
    }

    public void setAvailabilityZone(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"availabilityZone", (Object)value);
    }

    @Nullable
    public Object getBlockDeviceMappings() {
        return Kernel.get((Object)((Object)this), (String)"blockDeviceMappings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setBlockDeviceMappings(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"blockDeviceMappings", (Object)value);
    }

    public void setBlockDeviceMappings(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"blockDeviceMappings", value);
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Nullable
    public Object getCpuOptions() {
        return Kernel.get((Object)((Object)this), (String)"cpuOptions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCpuOptions(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"cpuOptions", (Object)value);
    }

    public void setCpuOptions(@Nullable CpuOptionsProperty value) {
        Kernel.set((Object)((Object)this), (String)"cpuOptions", (Object)value);
    }

    @Nullable
    public Object getCreditSpecification() {
        return Kernel.get((Object)((Object)this), (String)"creditSpecification", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCreditSpecification(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"creditSpecification", (Object)value);
    }

    public void setCreditSpecification(@Nullable CreditSpecificationProperty value) {
        Kernel.set((Object)((Object)this), (String)"creditSpecification", (Object)value);
    }

    @Nullable
    public Object getDisableApiTermination() {
        return Kernel.get((Object)((Object)this), (String)"disableApiTermination", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDisableApiTermination(@Nullable Boolean value) {
        Kernel.set((Object)((Object)this), (String)"disableApiTermination", (Object)value);
    }

    public void setDisableApiTermination(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"disableApiTermination", (Object)value);
    }

    @Nullable
    public Object getEbsOptimized() {
        return Kernel.get((Object)((Object)this), (String)"ebsOptimized", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEbsOptimized(@Nullable Boolean value) {
        Kernel.set((Object)((Object)this), (String)"ebsOptimized", (Object)value);
    }

    public void setEbsOptimized(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"ebsOptimized", (Object)value);
    }

    @Nullable
    public Object getElasticGpuSpecifications() {
        return Kernel.get((Object)((Object)this), (String)"elasticGpuSpecifications", (NativeType)NativeType.forClass(Object.class));
    }

    public void setElasticGpuSpecifications(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"elasticGpuSpecifications", (Object)value);
    }

    public void setElasticGpuSpecifications(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"elasticGpuSpecifications", value);
    }

    @Nullable
    public Object getElasticInferenceAccelerators() {
        return Kernel.get((Object)((Object)this), (String)"elasticInferenceAccelerators", (NativeType)NativeType.forClass(Object.class));
    }

    public void setElasticInferenceAccelerators(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"elasticInferenceAccelerators", (Object)value);
    }

    public void setElasticInferenceAccelerators(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"elasticInferenceAccelerators", value);
    }

    @Nullable
    public Object getEnclaveOptions() {
        return Kernel.get((Object)((Object)this), (String)"enclaveOptions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEnclaveOptions(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"enclaveOptions", (Object)value);
    }

    public void setEnclaveOptions(@Nullable EnclaveOptionsProperty value) {
        Kernel.set((Object)((Object)this), (String)"enclaveOptions", (Object)value);
    }

    @Nullable
    public Object getHibernationOptions() {
        return Kernel.get((Object)((Object)this), (String)"hibernationOptions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setHibernationOptions(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"hibernationOptions", (Object)value);
    }

    public void setHibernationOptions(@Nullable HibernationOptionsProperty value) {
        Kernel.set((Object)((Object)this), (String)"hibernationOptions", (Object)value);
    }

    @Nullable
    public String getHostId() {
        return (String)Kernel.get((Object)((Object)this), (String)"hostId", (NativeType)NativeType.forClass(String.class));
    }

    public void setHostId(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"hostId", (Object)value);
    }

    @Nullable
    public String getHostResourceGroupArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"hostResourceGroupArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setHostResourceGroupArn(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"hostResourceGroupArn", (Object)value);
    }

    @Nullable
    public String getIamInstanceProfile() {
        return (String)Kernel.get((Object)((Object)this), (String)"iamInstanceProfile", (NativeType)NativeType.forClass(String.class));
    }

    public void setIamInstanceProfile(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"iamInstanceProfile", (Object)value);
    }

    @Nullable
    public String getImageId() {
        return (String)Kernel.get((Object)((Object)this), (String)"imageId", (NativeType)NativeType.forClass(String.class));
    }

    public void setImageId(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"imageId", (Object)value);
    }

    @Nullable
    public String getInstanceInitiatedShutdownBehavior() {
        return (String)Kernel.get((Object)((Object)this), (String)"instanceInitiatedShutdownBehavior", (NativeType)NativeType.forClass(String.class));
    }

    public void setInstanceInitiatedShutdownBehavior(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"instanceInitiatedShutdownBehavior", (Object)value);
    }

    @Nullable
    public String getInstanceType() {
        return (String)Kernel.get((Object)((Object)this), (String)"instanceType", (NativeType)NativeType.forClass(String.class));
    }

    public void setInstanceType(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"instanceType", (Object)value);
    }

    @Nullable
    public Number getIpv6AddressCount() {
        return (Number)Kernel.get((Object)((Object)this), (String)"ipv6AddressCount", (NativeType)NativeType.forClass(Number.class));
    }

    public void setIpv6AddressCount(@Nullable Number value) {
        Kernel.set((Object)((Object)this), (String)"ipv6AddressCount", (Object)value);
    }

    @Nullable
    public Object getIpv6Addresses() {
        return Kernel.get((Object)((Object)this), (String)"ipv6Addresses", (NativeType)NativeType.forClass(Object.class));
    }

    public void setIpv6Addresses(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"ipv6Addresses", (Object)value);
    }

    public void setIpv6Addresses(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"ipv6Addresses", value);
    }

    @Nullable
    public String getKernelId() {
        return (String)Kernel.get((Object)((Object)this), (String)"kernelId", (NativeType)NativeType.forClass(String.class));
    }

    public void setKernelId(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"kernelId", (Object)value);
    }

    @Nullable
    public String getKeyName() {
        return (String)Kernel.get((Object)((Object)this), (String)"keyName", (NativeType)NativeType.forClass(String.class));
    }

    public void setKeyName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"keyName", (Object)value);
    }

    @Nullable
    public Object getLaunchTemplate() {
        return Kernel.get((Object)((Object)this), (String)"launchTemplate", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLaunchTemplate(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"launchTemplate", (Object)value);
    }

    public void setLaunchTemplate(@Nullable LaunchTemplateSpecificationProperty value) {
        Kernel.set((Object)((Object)this), (String)"launchTemplate", (Object)value);
    }

    @Nullable
    public Object getLicenseSpecifications() {
        return Kernel.get((Object)((Object)this), (String)"licenseSpecifications", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLicenseSpecifications(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"licenseSpecifications", (Object)value);
    }

    public void setLicenseSpecifications(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"licenseSpecifications", value);
    }

    @Nullable
    public Object getMonitoring() {
        return Kernel.get((Object)((Object)this), (String)"monitoring", (NativeType)NativeType.forClass(Object.class));
    }

    public void setMonitoring(@Nullable Boolean value) {
        Kernel.set((Object)((Object)this), (String)"monitoring", (Object)value);
    }

    public void setMonitoring(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"monitoring", (Object)value);
    }

    @Nullable
    public Object getNetworkInterfaces() {
        return Kernel.get((Object)((Object)this), (String)"networkInterfaces", (NativeType)NativeType.forClass(Object.class));
    }

    public void setNetworkInterfaces(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"networkInterfaces", (Object)value);
    }

    public void setNetworkInterfaces(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"networkInterfaces", value);
    }

    @Nullable
    public String getPlacementGroupName() {
        return (String)Kernel.get((Object)((Object)this), (String)"placementGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public void setPlacementGroupName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"placementGroupName", (Object)value);
    }

    @Nullable
    public String getPrivateIpAddress() {
        return (String)Kernel.get((Object)((Object)this), (String)"privateIpAddress", (NativeType)NativeType.forClass(String.class));
    }

    public void setPrivateIpAddress(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"privateIpAddress", (Object)value);
    }

    @Nullable
    public Object getPropagateTagsToVolumeOnCreation() {
        return Kernel.get((Object)((Object)this), (String)"propagateTagsToVolumeOnCreation", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPropagateTagsToVolumeOnCreation(@Nullable Boolean value) {
        Kernel.set((Object)((Object)this), (String)"propagateTagsToVolumeOnCreation", (Object)value);
    }

    public void setPropagateTagsToVolumeOnCreation(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"propagateTagsToVolumeOnCreation", (Object)value);
    }

    @Nullable
    public String getRamdiskId() {
        return (String)Kernel.get((Object)((Object)this), (String)"ramdiskId", (NativeType)NativeType.forClass(String.class));
    }

    public void setRamdiskId(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"ramdiskId", (Object)value);
    }

    @Nullable
    public List<String> getSecurityGroupIds() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"securityGroupIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSecurityGroupIds(@Nullable List<String> value) {
        Kernel.set((Object)((Object)this), (String)"securityGroupIds", value);
    }

    @Nullable
    public List<String> getSecurityGroups() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"securityGroups", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSecurityGroups(@Nullable List<String> value) {
        Kernel.set((Object)((Object)this), (String)"securityGroups", value);
    }

    @Nullable
    public Object getSourceDestCheck() {
        return Kernel.get((Object)((Object)this), (String)"sourceDestCheck", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSourceDestCheck(@Nullable Boolean value) {
        Kernel.set((Object)((Object)this), (String)"sourceDestCheck", (Object)value);
    }

    public void setSourceDestCheck(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"sourceDestCheck", (Object)value);
    }

    @Nullable
    public Object getSsmAssociations() {
        return Kernel.get((Object)((Object)this), (String)"ssmAssociations", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSsmAssociations(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"ssmAssociations", (Object)value);
    }

    public void setSsmAssociations(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"ssmAssociations", value);
    }

    @Nullable
    public String getSubnetId() {
        return (String)Kernel.get((Object)((Object)this), (String)"subnetId", (NativeType)NativeType.forClass(String.class));
    }

    public void setSubnetId(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"subnetId", (Object)value);
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)Kernel.get((Object)((Object)this), (String)"tags", (NativeType)NativeType.forClass(TagManager.class));
    }

    @Nullable
    public String getTenancy() {
        return (String)Kernel.get((Object)((Object)this), (String)"tenancy", (NativeType)NativeType.forClass(String.class));
    }

    public void setTenancy(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"tenancy", (Object)value);
    }

    @Nullable
    public String getUserData() {
        return (String)Kernel.get((Object)((Object)this), (String)"userData", (NativeType)NativeType.forClass(String.class));
    }

    public void setUserData(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"userData", (Object)value);
    }

    @Nullable
    public Object getVolumes() {
        return Kernel.get((Object)((Object)this), (String)"volumes", (NativeType)NativeType.forClass(Object.class));
    }

    public void setVolumes(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"volumes", (Object)value);
    }

    public void setVolumes(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"volumes", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnInstance> {
        private final Construct scope;
        private final String id;
        private CfnInstanceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder additionalInfo(String additionalInfo) {
            this.props().additionalInfo(additionalInfo);
            return this;
        }

        public Builder affinity(String affinity) {
            this.props().affinity(affinity);
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.props().availabilityZone(availabilityZone);
            return this;
        }

        public Builder blockDeviceMappings(IResolvable blockDeviceMappings) {
            this.props().blockDeviceMappings(blockDeviceMappings);
            return this;
        }

        public Builder blockDeviceMappings(List<? extends Object> blockDeviceMappings) {
            this.props().blockDeviceMappings(blockDeviceMappings);
            return this;
        }

        public Builder cpuOptions(IResolvable cpuOptions) {
            this.props().cpuOptions(cpuOptions);
            return this;
        }

        public Builder cpuOptions(CpuOptionsProperty cpuOptions) {
            this.props().cpuOptions(cpuOptions);
            return this;
        }

        public Builder creditSpecification(IResolvable creditSpecification) {
            this.props().creditSpecification(creditSpecification);
            return this;
        }

        public Builder creditSpecification(CreditSpecificationProperty creditSpecification) {
            this.props().creditSpecification(creditSpecification);
            return this;
        }

        public Builder disableApiTermination(Boolean disableApiTermination) {
            this.props().disableApiTermination(disableApiTermination);
            return this;
        }

        public Builder disableApiTermination(IResolvable disableApiTermination) {
            this.props().disableApiTermination(disableApiTermination);
            return this;
        }

        public Builder ebsOptimized(Boolean ebsOptimized) {
            this.props().ebsOptimized(ebsOptimized);
            return this;
        }

        public Builder ebsOptimized(IResolvable ebsOptimized) {
            this.props().ebsOptimized(ebsOptimized);
            return this;
        }

        public Builder elasticGpuSpecifications(IResolvable elasticGpuSpecifications) {
            this.props().elasticGpuSpecifications(elasticGpuSpecifications);
            return this;
        }

        public Builder elasticGpuSpecifications(List<? extends Object> elasticGpuSpecifications) {
            this.props().elasticGpuSpecifications(elasticGpuSpecifications);
            return this;
        }

        public Builder elasticInferenceAccelerators(IResolvable elasticInferenceAccelerators) {
            this.props().elasticInferenceAccelerators(elasticInferenceAccelerators);
            return this;
        }

        public Builder elasticInferenceAccelerators(List<? extends Object> elasticInferenceAccelerators) {
            this.props().elasticInferenceAccelerators(elasticInferenceAccelerators);
            return this;
        }

        public Builder enclaveOptions(IResolvable enclaveOptions) {
            this.props().enclaveOptions(enclaveOptions);
            return this;
        }

        public Builder enclaveOptions(EnclaveOptionsProperty enclaveOptions) {
            this.props().enclaveOptions(enclaveOptions);
            return this;
        }

        public Builder hibernationOptions(IResolvable hibernationOptions) {
            this.props().hibernationOptions(hibernationOptions);
            return this;
        }

        public Builder hibernationOptions(HibernationOptionsProperty hibernationOptions) {
            this.props().hibernationOptions(hibernationOptions);
            return this;
        }

        public Builder hostId(String hostId) {
            this.props().hostId(hostId);
            return this;
        }

        public Builder hostResourceGroupArn(String hostResourceGroupArn) {
            this.props().hostResourceGroupArn(hostResourceGroupArn);
            return this;
        }

        public Builder iamInstanceProfile(String iamInstanceProfile) {
            this.props().iamInstanceProfile(iamInstanceProfile);
            return this;
        }

        public Builder imageId(String imageId) {
            this.props().imageId(imageId);
            return this;
        }

        public Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.props().instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior);
            return this;
        }

        public Builder instanceType(String instanceType) {
            this.props().instanceType(instanceType);
            return this;
        }

        public Builder ipv6AddressCount(Number ipv6AddressCount) {
            this.props().ipv6AddressCount(ipv6AddressCount);
            return this;
        }

        public Builder ipv6Addresses(IResolvable ipv6Addresses) {
            this.props().ipv6Addresses(ipv6Addresses);
            return this;
        }

        public Builder ipv6Addresses(List<? extends Object> ipv6Addresses) {
            this.props().ipv6Addresses(ipv6Addresses);
            return this;
        }

        public Builder kernelId(String kernelId) {
            this.props().kernelId(kernelId);
            return this;
        }

        public Builder keyName(String keyName) {
            this.props().keyName(keyName);
            return this;
        }

        public Builder launchTemplate(IResolvable launchTemplate) {
            this.props().launchTemplate(launchTemplate);
            return this;
        }

        public Builder launchTemplate(LaunchTemplateSpecificationProperty launchTemplate) {
            this.props().launchTemplate(launchTemplate);
            return this;
        }

        public Builder licenseSpecifications(IResolvable licenseSpecifications) {
            this.props().licenseSpecifications(licenseSpecifications);
            return this;
        }

        public Builder licenseSpecifications(List<? extends Object> licenseSpecifications) {
            this.props().licenseSpecifications(licenseSpecifications);
            return this;
        }

        public Builder monitoring(Boolean monitoring) {
            this.props().monitoring(monitoring);
            return this;
        }

        public Builder monitoring(IResolvable monitoring) {
            this.props().monitoring(monitoring);
            return this;
        }

        public Builder networkInterfaces(IResolvable networkInterfaces) {
            this.props().networkInterfaces(networkInterfaces);
            return this;
        }

        public Builder networkInterfaces(List<? extends Object> networkInterfaces) {
            this.props().networkInterfaces(networkInterfaces);
            return this;
        }

        public Builder placementGroupName(String placementGroupName) {
            this.props().placementGroupName(placementGroupName);
            return this;
        }

        public Builder privateIpAddress(String privateIpAddress) {
            this.props().privateIpAddress(privateIpAddress);
            return this;
        }

        public Builder propagateTagsToVolumeOnCreation(Boolean propagateTagsToVolumeOnCreation) {
            this.props().propagateTagsToVolumeOnCreation(propagateTagsToVolumeOnCreation);
            return this;
        }

        public Builder propagateTagsToVolumeOnCreation(IResolvable propagateTagsToVolumeOnCreation) {
            this.props().propagateTagsToVolumeOnCreation(propagateTagsToVolumeOnCreation);
            return this;
        }

        public Builder ramdiskId(String ramdiskId) {
            this.props().ramdiskId(ramdiskId);
            return this;
        }

        public Builder securityGroupIds(List<String> securityGroupIds) {
            this.props().securityGroupIds(securityGroupIds);
            return this;
        }

        public Builder securityGroups(List<String> securityGroups) {
            this.props().securityGroups(securityGroups);
            return this;
        }

        public Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.props().sourceDestCheck(sourceDestCheck);
            return this;
        }

        public Builder sourceDestCheck(IResolvable sourceDestCheck) {
            this.props().sourceDestCheck(sourceDestCheck);
            return this;
        }

        public Builder ssmAssociations(IResolvable ssmAssociations) {
            this.props().ssmAssociations(ssmAssociations);
            return this;
        }

        public Builder ssmAssociations(List<? extends Object> ssmAssociations) {
            this.props().ssmAssociations(ssmAssociations);
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.props().subnetId(subnetId);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public Builder tenancy(String tenancy) {
            this.props().tenancy(tenancy);
            return this;
        }

        public Builder userData(String userData) {
            this.props().userData(userData);
            return this;
        }

        public Builder volumes(IResolvable volumes) {
            this.props().volumes(volumes);
            return this;
        }

        public Builder volumes(List<? extends Object> volumes) {
            this.props().volumes(volumes);
            return this;
        }

        public CfnInstance build() {
            return new CfnInstance(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnInstanceProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnInstanceProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.VolumeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VolumeProperty
    extends JsiiSerializable {
        @NotNull
        public String getDevice();

        @NotNull
        public String getVolumeId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VolumeProperty> {
            String device;
            String volumeId;

            public Builder device(String device) {
                this.device = device;
                return this;
            }

            public Builder volumeId(String volumeId) {
                this.volumeId = volumeId;
                return this;
            }

            public VolumeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.SsmAssociationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SsmAssociationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAssociationParameters() {
            return null;
        }

        @NotNull
        public String getDocumentName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SsmAssociationProperty> {
            Object associationParameters;
            String documentName;

            public Builder associationParameters(IResolvable associationParameters) {
                this.associationParameters = associationParameters;
                return this;
            }

            public Builder associationParameters(List<? extends Object> associationParameters) {
                this.associationParameters = associationParameters;
                return this;
            }

            public Builder documentName(String documentName) {
                this.documentName = documentName;
                return this;
            }

            public SsmAssociationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.PrivateIpAddressSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PrivateIpAddressSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getPrimary();

        @NotNull
        public String getPrivateIpAddress();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PrivateIpAddressSpecificationProperty> {
            Object primary;
            String privateIpAddress;

            public Builder primary(Boolean primary) {
                this.primary = primary;
                return this;
            }

            public Builder primary(IResolvable primary) {
                this.primary = primary;
                return this;
            }

            public Builder privateIpAddress(String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            public PrivateIpAddressSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.NoDeviceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NoDeviceProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NoDeviceProperty> {
            public NoDeviceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.NetworkInterfaceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkInterfaceProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAssociatePublicIpAddress() {
            return null;
        }

        @Nullable
        default public Object getDeleteOnTermination() {
            return null;
        }

        @Nullable
        default public String getDescription() {
            return null;
        }

        @NotNull
        public String getDeviceIndex();

        @Nullable
        default public List<String> getGroupSet() {
            return null;
        }

        @Nullable
        default public Number getIpv6AddressCount() {
            return null;
        }

        @Nullable
        default public Object getIpv6Addresses() {
            return null;
        }

        @Nullable
        default public String getNetworkInterfaceId() {
            return null;
        }

        @Nullable
        default public String getPrivateIpAddress() {
            return null;
        }

        @Nullable
        default public Object getPrivateIpAddresses() {
            return null;
        }

        @Nullable
        default public Number getSecondaryPrivateIpAddressCount() {
            return null;
        }

        @Nullable
        default public String getSubnetId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NetworkInterfaceProperty> {
            Object associatePublicIpAddress;
            Object deleteOnTermination;
            String description;
            String deviceIndex;
            List<String> groupSet;
            Number ipv6AddressCount;
            Object ipv6Addresses;
            String networkInterfaceId;
            String privateIpAddress;
            Object privateIpAddresses;
            Number secondaryPrivateIpAddressCount;
            String subnetId;

            public Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            public Builder associatePublicIpAddress(IResolvable associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            public Builder deleteOnTermination(Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder deleteOnTermination(IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder deviceIndex(String deviceIndex) {
                this.deviceIndex = deviceIndex;
                return this;
            }

            public Builder groupSet(List<String> groupSet) {
                this.groupSet = groupSet;
                return this;
            }

            public Builder ipv6AddressCount(Number ipv6AddressCount) {
                this.ipv6AddressCount = ipv6AddressCount;
                return this;
            }

            public Builder ipv6Addresses(IResolvable ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            public Builder ipv6Addresses(List<? extends Object> ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            public Builder networkInterfaceId(String networkInterfaceId) {
                this.networkInterfaceId = networkInterfaceId;
                return this;
            }

            public Builder privateIpAddress(String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            public Builder privateIpAddresses(IResolvable privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            public Builder privateIpAddresses(List<? extends Object> privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            public Builder secondaryPrivateIpAddressCount(Number secondaryPrivateIpAddressCount) {
                this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
                return this;
            }

            public Builder subnetId(String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            public NetworkInterfaceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.LicenseSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LicenseSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public String getLicenseConfigurationArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LicenseSpecificationProperty> {
            String licenseConfigurationArn;

            public Builder licenseConfigurationArn(String licenseConfigurationArn) {
                this.licenseConfigurationArn = licenseConfigurationArn;
                return this;
            }

            public LicenseSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.LaunchTemplateSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LaunchTemplateSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLaunchTemplateId() {
            return null;
        }

        @Nullable
        default public String getLaunchTemplateName() {
            return null;
        }

        @NotNull
        public String getVersion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LaunchTemplateSpecificationProperty> {
            String launchTemplateId;
            String launchTemplateName;
            String version;

            public Builder launchTemplateId(String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            public Builder launchTemplateName(String launchTemplateName) {
                this.launchTemplateName = launchTemplateName;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public LaunchTemplateSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.InstanceIpv6AddressProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceIpv6AddressProperty
    extends JsiiSerializable {
        @NotNull
        public String getIpv6Address();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstanceIpv6AddressProperty> {
            String ipv6Address;

            public Builder ipv6Address(String ipv6Address) {
                this.ipv6Address = ipv6Address;
                return this;
            }

            public InstanceIpv6AddressProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.HibernationOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HibernationOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getConfigured() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HibernationOptionsProperty> {
            Object configured;

            public Builder configured(Boolean configured) {
                this.configured = configured;
                return this;
            }

            public Builder configured(IResolvable configured) {
                this.configured = configured;
                return this;
            }

            public HibernationOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.EnclaveOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EnclaveOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EnclaveOptionsProperty> {
            Object enabled;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public EnclaveOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.ElasticInferenceAcceleratorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ElasticInferenceAcceleratorProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getCount() {
            return null;
        }

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ElasticInferenceAcceleratorProperty> {
            Number count;
            String type;

            public Builder count(Number count) {
                this.count = count;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public ElasticInferenceAcceleratorProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.ElasticGpuSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ElasticGpuSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ElasticGpuSpecificationProperty> {
            String type;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public ElasticGpuSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.EbsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EbsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDeleteOnTermination() {
            return null;
        }

        @Nullable
        default public Object getEncrypted() {
            return null;
        }

        @Nullable
        default public Number getIops() {
            return null;
        }

        @Nullable
        default public String getKmsKeyId() {
            return null;
        }

        @Nullable
        default public String getSnapshotId() {
            return null;
        }

        @Nullable
        default public Number getVolumeSize() {
            return null;
        }

        @Nullable
        default public String getVolumeType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EbsProperty> {
            Object deleteOnTermination;
            Object encrypted;
            Number iops;
            String kmsKeyId;
            String snapshotId;
            Number volumeSize;
            String volumeType;

            public Builder deleteOnTermination(Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder deleteOnTermination(IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder encrypted(Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            public Builder encrypted(IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            public Builder iops(Number iops) {
                this.iops = iops;
                return this;
            }

            public Builder kmsKeyId(String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            public Builder snapshotId(String snapshotId) {
                this.snapshotId = snapshotId;
                return this;
            }

            public Builder volumeSize(Number volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            public Builder volumeType(String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            public EbsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.CreditSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CreditSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCpuCredits() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CreditSpecificationProperty> {
            String cpuCredits;

            public Builder cpuCredits(String cpuCredits) {
                this.cpuCredits = cpuCredits;
                return this;
            }

            public CreditSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.CpuOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CpuOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getCoreCount() {
            return null;
        }

        @Nullable
        default public Number getThreadsPerCore() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CpuOptionsProperty> {
            Number coreCount;
            Number threadsPerCore;

            public Builder coreCount(Number coreCount) {
                this.coreCount = coreCount;
                return this;
            }

            public Builder threadsPerCore(Number threadsPerCore) {
                this.threadsPerCore = threadsPerCore;
                return this;
            }

            public CpuOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.BlockDeviceMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BlockDeviceMappingProperty
    extends JsiiSerializable {
        @NotNull
        public String getDeviceName();

        @Nullable
        default public Object getEbs() {
            return null;
        }

        @Nullable
        default public Object getNoDevice() {
            return null;
        }

        @Nullable
        default public String getVirtualName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BlockDeviceMappingProperty> {
            String deviceName;
            Object ebs;
            Object noDevice;
            String virtualName;

            public Builder deviceName(String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            public Builder ebs(IResolvable ebs) {
                this.ebs = ebs;
                return this;
            }

            public Builder ebs(EbsProperty ebs) {
                this.ebs = ebs;
                return this;
            }

            public Builder noDevice(IResolvable noDevice) {
                this.noDevice = noDevice;
                return this;
            }

            public Builder noDevice(NoDeviceProperty noDevice) {
                this.noDevice = noDevice;
                return this;
            }

            public Builder virtualName(String virtualName) {
                this.virtualName = virtualName;
                return this;
            }

            public BlockDeviceMappingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.AssociationParameterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AssociationParameterProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public List<String> getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AssociationParameterProperty> {
            String key;
            List<String> value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(List<String> value) {
                this.value = value;
                return this;
            }

            public AssociationParameterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

