package software.amazon.awscdk.services.ec2;

/**
 * What generation of Amazon Linux to use.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * ComputeEnvironment myComputeEnv = ComputeEnvironment.Builder.create(this, "ComputeEnv")
 *         .computeResources(ComputeResources.builder()
 *                 .image(EcsOptimizedAmi.Builder.create()
 *                         .generation(AmazonLinuxGeneration.AMAZON_LINUX_2)
 *                         .build())
 *                 .vpc(vpc)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.50.0 (build d1830a4)", date = "2022-01-04T15:38:52.919Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.AmazonLinuxGeneration")
public enum AmazonLinuxGeneration {
    /**
     * Amazon Linux.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AMAZON_LINUX,
    /**
     * Amazon Linux 2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AMAZON_LINUX_2,
}
