package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::EIP`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-22T08:23:25.806Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnEIPProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::EIP.Domain`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-domain
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDomain();

    /**
     * `AWS::EC2::EIP.InstanceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-instanceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getInstanceId();

    /**
     * `AWS::EC2::EIP.PublicIpv4Pool`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-publicipv4pool
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getPublicIpv4Pool();

    /**
     * @return a {@link Builder} of {@link CfnEIPProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEIPProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String domain;
        private java.lang.String instanceId;
        private java.lang.String publicIpv4Pool;

        /**
         * Sets the value of Domain
         * @param domain `AWS::EC2::EIP.Domain`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder domain(java.lang.String domain) {
            this.domain = domain;
            return this;
        }

        /**
         * Sets the value of InstanceId
         * @param instanceId `AWS::EC2::EIP.InstanceId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder instanceId(java.lang.String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        /**
         * Sets the value of PublicIpv4Pool
         * @param publicIpv4Pool `AWS::EC2::EIP.PublicIpv4Pool`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder publicIpv4Pool(java.lang.String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEIPProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnEIPProps build() {
            return new Jsii$Proxy(domain, instanceId, publicIpv4Pool);
        }
    }

    /**
     * An implementation for {@link CfnEIPProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEIPProps {
        private final java.lang.String domain;
        private final java.lang.String instanceId;
        private final java.lang.String publicIpv4Pool;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.domain = this.jsiiGet("domain", java.lang.String.class);
            this.instanceId = this.jsiiGet("instanceId", java.lang.String.class);
            this.publicIpv4Pool = this.jsiiGet("publicIpv4Pool", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String domain, java.lang.String instanceId, java.lang.String publicIpv4Pool) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domain = domain;
            this.instanceId = instanceId;
            this.publicIpv4Pool = publicIpv4Pool;
        }

        @Override
        public java.lang.String getDomain() {
            return this.domain;
        }

        @Override
        public java.lang.String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public java.lang.String getPublicIpv4Pool() {
            return this.publicIpv4Pool;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getDomain() != null) {
                obj.set("domain", om.valueToTree(this.getDomain()));
            }
            if (this.getInstanceId() != null) {
                obj.set("instanceId", om.valueToTree(this.getInstanceId()));
            }
            if (this.getPublicIpv4Pool() != null) {
                obj.set("publicIpv4Pool", om.valueToTree(this.getPublicIpv4Pool()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEIPProps.Jsii$Proxy that = (CfnEIPProps.Jsii$Proxy) o;

            if (this.domain != null ? !this.domain.equals(that.domain) : that.domain != null) return false;
            if (this.instanceId != null ? !this.instanceId.equals(that.instanceId) : that.instanceId != null) return false;
            return this.publicIpv4Pool != null ? this.publicIpv4Pool.equals(that.publicIpv4Pool) : that.publicIpv4Pool == null;
        }

        @Override
        public int hashCode() {
            int result = this.domain != null ? this.domain.hashCode() : 0;
            result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
            result = 31 * result + (this.publicIpv4Pool != null ? this.publicIpv4Pool.hashCode() : 0);
            return result;
        }
    }
}
