package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::SubnetNetworkAclAssociation`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-22T08:23:25.859Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnSubnetNetworkAclAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::SubnetNetworkAclAssociation.NetworkAclId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html#cfn-ec2-subnetnetworkaclassociation-networkaclid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getNetworkAclId();

    /**
     * `AWS::EC2::SubnetNetworkAclAssociation.SubnetId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html#cfn-ec2-subnetnetworkaclassociation-associationid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getSubnetId();

    /**
     * @return a {@link Builder} of {@link CfnSubnetNetworkAclAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSubnetNetworkAclAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String networkAclId;
        private java.lang.String subnetId;

        /**
         * Sets the value of NetworkAclId
         * @param networkAclId `AWS::EC2::SubnetNetworkAclAssociation.NetworkAclId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder networkAclId(java.lang.String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        /**
         * Sets the value of SubnetId
         * @param subnetId `AWS::EC2::SubnetNetworkAclAssociation.SubnetId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder subnetId(java.lang.String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSubnetNetworkAclAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnSubnetNetworkAclAssociationProps build() {
            return new Jsii$Proxy(networkAclId, subnetId);
        }
    }

    /**
     * An implementation for {@link CfnSubnetNetworkAclAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSubnetNetworkAclAssociationProps {
        private final java.lang.String networkAclId;
        private final java.lang.String subnetId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.networkAclId = this.jsiiGet("networkAclId", java.lang.String.class);
            this.subnetId = this.jsiiGet("subnetId", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String networkAclId, java.lang.String subnetId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.networkAclId = java.util.Objects.requireNonNull(networkAclId, "networkAclId is required");
            this.subnetId = java.util.Objects.requireNonNull(subnetId, "subnetId is required");
        }

        @Override
        public java.lang.String getNetworkAclId() {
            return this.networkAclId;
        }

        @Override
        public java.lang.String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("networkAclId", om.valueToTree(this.getNetworkAclId()));
            obj.set("subnetId", om.valueToTree(this.getSubnetId()));
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSubnetNetworkAclAssociationProps.Jsii$Proxy that = (CfnSubnetNetworkAclAssociationProps.Jsii$Proxy) o;

            if (!networkAclId.equals(that.networkAclId)) return false;
            return this.subnetId.equals(that.subnetId);
        }

        @Override
        public int hashCode() {
            int result = this.networkAclId.hashCode();
            result = 31 * result + (this.subnetId.hashCode());
            return result;
        }
    }
}
