package software.amazon.awscdk.services.ec2;

/**
 * Properties of an EC2 Instance.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-22T08:23:25.894Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InstanceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Type of instance to launch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.InstanceType getInstanceType();

    /**
     * AMI to launch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.IMachineImage getMachineImage();

    /**
     * VPC to launch the instance in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * Whether the instance could initiate connections to anywhere by default. This property is only used when you do not provide a security group.
     * 
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getAllowAllOutbound();

    /**
     * In which AZ to place the instance within the VPC.
     * 
     * Default: - Random zone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getAvailabilityZone();

    /**
     * The name of the instance.
     * 
     * Default: - CDK generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getInstanceName();

    /**
     * Name of SSH keypair to grant access to instance.
     * 
     * Default: - No SSH access will be possible.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getKeyName();

    /**
     * The length of time to wait for the resourceSignalCount.
     * 
     * The maximum value is 43200 (12 hours).
     * 
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.Duration getResourceSignalTimeout();

    /**
     * An IAM role to associate with the instance profile assigned to this Auto Scaling Group.
     * 
     * The role must be assumable by the service principal `ec2.amazonaws.com`:
     * 
     * Default: - A role will automatically be created, it can be accessed via the `role` property
     * 
     * Example:
     * 
     *    const role = new iam.Role(this, 'MyRole', {
     *      assumedBy: new iam.ServicePrincipal('ec2.amazonaws.com')
     *    });
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.iam.IRole getRole();

    /**
     * Security Group to assign to this instance.
     * 
     * Default: - create new security group
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup();

    /**
     * Specifies whether to enable an instance launched in a VPC to perform NAT. This controls whether source/destination checking is enabled on the instance. A value of true means that checking is enabled, and false means that checking is disabled. The value must be false for the instance to perform NAT.
     * 
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getSourceDestCheck();

    /**
     * Specific UserData to use.
     * 
     * The UserData may still be mutated after creation.
     * 
     * Default: - A UserData object appropriate for the MachineImage's
     * Operating System is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.UserData getUserData();

    /**
     * Where to place the instance within the VPC.
     * 
     * Default: - Private subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets();

    /**
     * @return a {@link Builder} of {@link InstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private software.amazon.awscdk.services.ec2.IMachineImage machineImage;
        private software.amazon.awscdk.services.ec2.IVpc vpc;
        private java.lang.Boolean allowAllOutbound;
        private java.lang.String availabilityZone;
        private java.lang.String instanceName;
        private java.lang.String keyName;
        private software.amazon.awscdk.core.Duration resourceSignalTimeout;
        private software.amazon.awscdk.services.iam.IRole role;
        private software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private java.lang.Boolean sourceDestCheck;
        private software.amazon.awscdk.services.ec2.UserData userData;
        private software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of InstanceType
         * @param instanceType Type of instance to launch. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of MachineImage
         * @param machineImage AMI to launch. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder machineImage(software.amazon.awscdk.services.ec2.IMachineImage machineImage) {
            this.machineImage = machineImage;
            return this;
        }

        /**
         * Sets the value of Vpc
         * @param vpc VPC to launch the instance in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of AllowAllOutbound
         * @param allowAllOutbound Whether the instance could initiate connections to anywhere by default. This property is only used when you do not provide a security group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(java.lang.Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        /**
         * Sets the value of AvailabilityZone
         * @param availabilityZone In which AZ to place the instance within the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of InstanceName
         * @param instanceName The name of the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceName(java.lang.String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        /**
         * Sets the value of KeyName
         * @param keyName Name of SSH keypair to grant access to instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyName(java.lang.String keyName) {
            this.keyName = keyName;
            return this;
        }

        /**
         * Sets the value of ResourceSignalTimeout
         * @param resourceSignalTimeout The length of time to wait for the resourceSignalCount.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceSignalTimeout(software.amazon.awscdk.core.Duration resourceSignalTimeout) {
            this.resourceSignalTimeout = resourceSignalTimeout;
            return this;
        }

        /**
         * Sets the value of Role
         * @param role An IAM role to associate with the instance profile assigned to this Auto Scaling Group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of SecurityGroup
         * @param securityGroup Security Group to assign to this instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of SourceDestCheck
         * @param sourceDestCheck Specifies whether to enable an instance launched in a VPC to perform NAT. This controls whether source/destination checking is enabled on the instance. A value of true means that checking is enabled, and false means that checking is disabled. The value must be false for the instance to perform NAT.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDestCheck(java.lang.Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        /**
         * Sets the value of UserData
         * @param userData Specific UserData to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(software.amazon.awscdk.services.ec2.UserData userData) {
            this.userData = userData;
            return this;
        }

        /**
         * Sets the value of VpcSubnets
         * @param vpcSubnets Where to place the instance within the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public InstanceProps build() {
            return new Jsii$Proxy(instanceType, machineImage, vpc, allowAllOutbound, availabilityZone, instanceName, keyName, resourceSignalTimeout, role, securityGroup, sourceDestCheck, userData, vpcSubnets);
        }
    }

    /**
     * An implementation for {@link InstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceProps {
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final software.amazon.awscdk.services.ec2.IMachineImage machineImage;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.Boolean allowAllOutbound;
        private final java.lang.String availabilityZone;
        private final java.lang.String instanceName;
        private final java.lang.String keyName;
        private final software.amazon.awscdk.core.Duration resourceSignalTimeout;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final java.lang.Boolean sourceDestCheck;
        private final software.amazon.awscdk.services.ec2.UserData userData;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.instanceType = this.jsiiGet("instanceType", software.amazon.awscdk.services.ec2.InstanceType.class);
            this.machineImage = this.jsiiGet("machineImage", software.amazon.awscdk.services.ec2.IMachineImage.class);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
            this.allowAllOutbound = this.jsiiGet("allowAllOutbound", java.lang.Boolean.class);
            this.availabilityZone = this.jsiiGet("availabilityZone", java.lang.String.class);
            this.instanceName = this.jsiiGet("instanceName", java.lang.String.class);
            this.keyName = this.jsiiGet("keyName", java.lang.String.class);
            this.resourceSignalTimeout = this.jsiiGet("resourceSignalTimeout", software.amazon.awscdk.core.Duration.class);
            this.role = this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
            this.securityGroup = this.jsiiGet("securityGroup", software.amazon.awscdk.services.ec2.ISecurityGroup.class);
            this.sourceDestCheck = this.jsiiGet("sourceDestCheck", java.lang.Boolean.class);
            this.userData = this.jsiiGet("userData", software.amazon.awscdk.services.ec2.UserData.class);
            this.vpcSubnets = this.jsiiGet("vpcSubnets", software.amazon.awscdk.services.ec2.SubnetSelection.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.services.ec2.InstanceType instanceType, software.amazon.awscdk.services.ec2.IMachineImage machineImage, software.amazon.awscdk.services.ec2.IVpc vpc, java.lang.Boolean allowAllOutbound, java.lang.String availabilityZone, java.lang.String instanceName, java.lang.String keyName, software.amazon.awscdk.core.Duration resourceSignalTimeout, software.amazon.awscdk.services.iam.IRole role, software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup, java.lang.Boolean sourceDestCheck, software.amazon.awscdk.services.ec2.UserData userData, software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceType = java.util.Objects.requireNonNull(instanceType, "instanceType is required");
            this.machineImage = java.util.Objects.requireNonNull(machineImage, "machineImage is required");
            this.vpc = java.util.Objects.requireNonNull(vpc, "vpc is required");
            this.allowAllOutbound = allowAllOutbound;
            this.availabilityZone = availabilityZone;
            this.instanceName = instanceName;
            this.keyName = keyName;
            this.resourceSignalTimeout = resourceSignalTimeout;
            this.role = role;
            this.securityGroup = securityGroup;
            this.sourceDestCheck = sourceDestCheck;
            this.userData = userData;
            this.vpcSubnets = vpcSubnets;
        }

        @Override
        public software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IMachineImage getMachineImage() {
            return this.machineImage;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public java.lang.Boolean getAllowAllOutbound() {
            return this.allowAllOutbound;
        }

        @Override
        public java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public java.lang.String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public java.lang.String getKeyName() {
            return this.keyName;
        }

        @Override
        public software.amazon.awscdk.core.Duration getResourceSignalTimeout() {
            return this.resourceSignalTimeout;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public java.lang.Boolean getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        @Override
        public software.amazon.awscdk.services.ec2.UserData getUserData() {
            return this.userData;
        }

        @Override
        public software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("instanceType", om.valueToTree(this.getInstanceType()));
            obj.set("machineImage", om.valueToTree(this.getMachineImage()));
            obj.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getAllowAllOutbound() != null) {
                obj.set("allowAllOutbound", om.valueToTree(this.getAllowAllOutbound()));
            }
            if (this.getAvailabilityZone() != null) {
                obj.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getInstanceName() != null) {
                obj.set("instanceName", om.valueToTree(this.getInstanceName()));
            }
            if (this.getKeyName() != null) {
                obj.set("keyName", om.valueToTree(this.getKeyName()));
            }
            if (this.getResourceSignalTimeout() != null) {
                obj.set("resourceSignalTimeout", om.valueToTree(this.getResourceSignalTimeout()));
            }
            if (this.getRole() != null) {
                obj.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSecurityGroup() != null) {
                obj.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getSourceDestCheck() != null) {
                obj.set("sourceDestCheck", om.valueToTree(this.getSourceDestCheck()));
            }
            if (this.getUserData() != null) {
                obj.set("userData", om.valueToTree(this.getUserData()));
            }
            if (this.getVpcSubnets() != null) {
                obj.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InstanceProps.Jsii$Proxy that = (InstanceProps.Jsii$Proxy) o;

            if (!instanceType.equals(that.instanceType)) return false;
            if (!machineImage.equals(that.machineImage)) return false;
            if (!vpc.equals(that.vpc)) return false;
            if (this.allowAllOutbound != null ? !this.allowAllOutbound.equals(that.allowAllOutbound) : that.allowAllOutbound != null) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.instanceName != null ? !this.instanceName.equals(that.instanceName) : that.instanceName != null) return false;
            if (this.keyName != null ? !this.keyName.equals(that.keyName) : that.keyName != null) return false;
            if (this.resourceSignalTimeout != null ? !this.resourceSignalTimeout.equals(that.resourceSignalTimeout) : that.resourceSignalTimeout != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            if (this.sourceDestCheck != null ? !this.sourceDestCheck.equals(that.sourceDestCheck) : that.sourceDestCheck != null) return false;
            if (this.userData != null ? !this.userData.equals(that.userData) : that.userData != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public int hashCode() {
            int result = this.instanceType.hashCode();
            result = 31 * result + (this.machineImage.hashCode());
            result = 31 * result + (this.vpc.hashCode());
            result = 31 * result + (this.allowAllOutbound != null ? this.allowAllOutbound.hashCode() : 0);
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.instanceName != null ? this.instanceName.hashCode() : 0);
            result = 31 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
            result = 31 * result + (this.resourceSignalTimeout != null ? this.resourceSignalTimeout.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.sourceDestCheck != null ? this.sourceDestCheck.hashCode() : 0);
            result = 31 * result + (this.userData != null ? this.userData.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
