package software.amazon.awscdk.services.ec2;

/**
 * Construction properties for an ImportedInterfaceVpcEndpoint.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-22T08:23:25.896Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InterfaceVpcEndpointAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The port of the service of the interface VPC endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getPort();

    /**
     * The identifier of the security group associated with the interface VPC endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getSecurityGroupId();

    /**
     * The interface VPC endpoint identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getVpcEndpointId();

    /**
     * @return a {@link Builder} of {@link InterfaceVpcEndpointAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InterfaceVpcEndpointAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.Number port;
        private java.lang.String securityGroupId;
        private java.lang.String vpcEndpointId;

        /**
         * Sets the value of Port
         * @param port The port of the service of the interface VPC endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of SecurityGroupId
         * @param securityGroupId The identifier of the security group associated with the interface VPC endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupId(java.lang.String securityGroupId) {
            this.securityGroupId = securityGroupId;
            return this;
        }

        /**
         * Sets the value of VpcEndpointId
         * @param vpcEndpointId The interface VPC endpoint identifier. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcEndpointId(java.lang.String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InterfaceVpcEndpointAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public InterfaceVpcEndpointAttributes build() {
            return new Jsii$Proxy(port, securityGroupId, vpcEndpointId);
        }
    }

    /**
     * An implementation for {@link InterfaceVpcEndpointAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InterfaceVpcEndpointAttributes {
        private final java.lang.Number port;
        private final java.lang.String securityGroupId;
        private final java.lang.String vpcEndpointId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.port = this.jsiiGet("port", java.lang.Number.class);
            this.securityGroupId = this.jsiiGet("securityGroupId", java.lang.String.class);
            this.vpcEndpointId = this.jsiiGet("vpcEndpointId", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Number port, java.lang.String securityGroupId, java.lang.String vpcEndpointId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.port = java.util.Objects.requireNonNull(port, "port is required");
            this.securityGroupId = java.util.Objects.requireNonNull(securityGroupId, "securityGroupId is required");
            this.vpcEndpointId = java.util.Objects.requireNonNull(vpcEndpointId, "vpcEndpointId is required");
        }

        @Override
        public java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public java.lang.String getSecurityGroupId() {
            return this.securityGroupId;
        }

        @Override
        public java.lang.String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("port", om.valueToTree(this.getPort()));
            obj.set("securityGroupId", om.valueToTree(this.getSecurityGroupId()));
            obj.set("vpcEndpointId", om.valueToTree(this.getVpcEndpointId()));
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InterfaceVpcEndpointAttributes.Jsii$Proxy that = (InterfaceVpcEndpointAttributes.Jsii$Proxy) o;

            if (!port.equals(that.port)) return false;
            if (!securityGroupId.equals(that.securityGroupId)) return false;
            return this.vpcEndpointId.equals(that.vpcEndpointId);
        }

        @Override
        public int hashCode() {
            int result = this.port.hashCode();
            result = 31 * result + (this.securityGroupId.hashCode());
            result = 31 * result + (this.vpcEndpointId.hashCode());
            return result;
        }
    }
}
