package software.amazon.awscdk.services.ec2;

/**
 * Properties to create a SubnetNetworkAclAssociation.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-22T08:23:25.905Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface SubnetNetworkAclAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Network ACL this association is defined for.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.ec2.INetworkAcl getNetworkAcl();

    /**
     * ID of the Subnet.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.ec2.ISubnet getSubnet();

    /**
     * The name of the SubnetNetworkAclAssociation.
     * 
     * It is not recommended to use an explicit name.
     * 
     * Default: If you don't specify a SubnetNetworkAclAssociationName, AWS CloudFormation generates a
     * unique physical ID and uses that ID for the group name.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getSubnetNetworkAclAssociationName();

    /**
     * @return a {@link Builder} of {@link SubnetNetworkAclAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SubnetNetworkAclAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private software.amazon.awscdk.services.ec2.INetworkAcl networkAcl;
        private software.amazon.awscdk.services.ec2.ISubnet subnet;
        private java.lang.String subnetNetworkAclAssociationName;

        /**
         * Sets the value of NetworkAcl
         * @param networkAcl The Network ACL this association is defined for. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder networkAcl(software.amazon.awscdk.services.ec2.INetworkAcl networkAcl) {
            this.networkAcl = networkAcl;
            return this;
        }

        /**
         * Sets the value of Subnet
         * @param subnet ID of the Subnet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnet(software.amazon.awscdk.services.ec2.ISubnet subnet) {
            this.subnet = subnet;
            return this;
        }

        /**
         * Sets the value of SubnetNetworkAclAssociationName
         * @param subnetNetworkAclAssociationName The name of the SubnetNetworkAclAssociation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnetNetworkAclAssociationName(java.lang.String subnetNetworkAclAssociationName) {
            this.subnetNetworkAclAssociationName = subnetNetworkAclAssociationName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SubnetNetworkAclAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public SubnetNetworkAclAssociationProps build() {
            return new Jsii$Proxy(networkAcl, subnet, subnetNetworkAclAssociationName);
        }
    }

    /**
     * An implementation for {@link SubnetNetworkAclAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubnetNetworkAclAssociationProps {
        private final software.amazon.awscdk.services.ec2.INetworkAcl networkAcl;
        private final software.amazon.awscdk.services.ec2.ISubnet subnet;
        private final java.lang.String subnetNetworkAclAssociationName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.networkAcl = this.jsiiGet("networkAcl", software.amazon.awscdk.services.ec2.INetworkAcl.class);
            this.subnet = this.jsiiGet("subnet", software.amazon.awscdk.services.ec2.ISubnet.class);
            this.subnetNetworkAclAssociationName = this.jsiiGet("subnetNetworkAclAssociationName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.services.ec2.INetworkAcl networkAcl, software.amazon.awscdk.services.ec2.ISubnet subnet, java.lang.String subnetNetworkAclAssociationName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.networkAcl = java.util.Objects.requireNonNull(networkAcl, "networkAcl is required");
            this.subnet = java.util.Objects.requireNonNull(subnet, "subnet is required");
            this.subnetNetworkAclAssociationName = subnetNetworkAclAssociationName;
        }

        @Override
        public software.amazon.awscdk.services.ec2.INetworkAcl getNetworkAcl() {
            return this.networkAcl;
        }

        @Override
        public software.amazon.awscdk.services.ec2.ISubnet getSubnet() {
            return this.subnet;
        }

        @Override
        public java.lang.String getSubnetNetworkAclAssociationName() {
            return this.subnetNetworkAclAssociationName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("networkAcl", om.valueToTree(this.getNetworkAcl()));
            obj.set("subnet", om.valueToTree(this.getSubnet()));
            if (this.getSubnetNetworkAclAssociationName() != null) {
                obj.set("subnetNetworkAclAssociationName", om.valueToTree(this.getSubnetNetworkAclAssociationName()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SubnetNetworkAclAssociationProps.Jsii$Proxy that = (SubnetNetworkAclAssociationProps.Jsii$Proxy) o;

            if (!networkAcl.equals(that.networkAcl)) return false;
            if (!subnet.equals(that.subnet)) return false;
            return this.subnetNetworkAclAssociationName != null ? this.subnetNetworkAclAssociationName.equals(that.subnetNetworkAclAssociationName) : that.subnetNetworkAclAssociationName == null;
        }

        @Override
        public int hashCode() {
            int result = this.networkAcl.hashCode();
            result = 31 * result + (this.subnet.hashCode());
            result = 31 * result + (this.subnetNetworkAclAssociationName != null ? this.subnetNetworkAclAssociationName.hashCode() : 0);
            return result;
        }
    }
}
