/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.ec2.CfnTrafficMirrorFilterRule;
import software.amazon.awscdk.services.ec2.CfnTrafficMirrorFilterRuleProps;
import software.amazon.jsii.JsiiSerializable;

public interface CfnTrafficMirrorFilterRuleProps
extends JsiiSerializable {
    public String getDestinationCidrBlock();

    public String getRuleAction();

    public Number getRuleNumber();

    public String getSourceCidrBlock();

    public String getTrafficDirection();

    public String getTrafficMirrorFilterId();

    public String getDescription();

    public Object getDestinationPortRange();

    public Number getProtocol();

    public Object getSourcePortRange();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String destinationCidrBlock;
        private String ruleAction;
        private Number ruleNumber;
        private String sourceCidrBlock;
        private String trafficDirection;
        private String trafficMirrorFilterId;
        private String description;
        private Object destinationPortRange;
        private Number protocol;
        private Object sourcePortRange;

        public Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        public Builder ruleNumber(Number ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public Builder sourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
            return this;
        }

        public Builder trafficDirection(String trafficDirection) {
            this.trafficDirection = trafficDirection;
            return this;
        }

        public Builder trafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder destinationPortRange(IResolvable destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
            return this;
        }

        public Builder destinationPortRange(CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
            return this;
        }

        public Builder protocol(Number protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder sourcePortRange(IResolvable sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
            return this;
        }

        public Builder sourcePortRange(CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
            return this;
        }

        public CfnTrafficMirrorFilterRuleProps build() {
            return new Jsii.Proxy(this.destinationCidrBlock, this.ruleAction, this.ruleNumber, this.sourceCidrBlock, this.trafficDirection, this.trafficMirrorFilterId, this.description, this.destinationPortRange, this.protocol, this.sourcePortRange, null);
        }
    }
}

