package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnTransitGatewayMulticastGroupMember`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnTransitGatewayMulticastGroupMemberProps cfnTransitGatewayMulticastGroupMemberProps = CfnTransitGatewayMulticastGroupMemberProps.builder()
 *         .groupIpAddress("groupIpAddress")
 *         .networkInterfaceId("networkInterfaceId")
 *         .transitGatewayMulticastDomainId("transitGatewayMulticastDomainId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-20T19:49:59.920Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnTransitGatewayMulticastGroupMemberProps")
@software.amazon.jsii.Jsii.Proxy(CfnTransitGatewayMulticastGroupMemberProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTransitGatewayMulticastGroupMemberProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The IP address assigned to the transit gateway multicast group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGroupIpAddress();

    /**
     * The group members' network interface IDs to register with the transit gateway multicast group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNetworkInterfaceId();

    /**
     * The ID of the transit gateway multicast domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTransitGatewayMulticastDomainId();

    /**
     * @return a {@link Builder} of {@link CfnTransitGatewayMulticastGroupMemberProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTransitGatewayMulticastGroupMemberProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTransitGatewayMulticastGroupMemberProps> {
        java.lang.String groupIpAddress;
        java.lang.String networkInterfaceId;
        java.lang.String transitGatewayMulticastDomainId;

        /**
         * Sets the value of {@link CfnTransitGatewayMulticastGroupMemberProps#getGroupIpAddress}
         * @param groupIpAddress The IP address assigned to the transit gateway multicast group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupIpAddress(java.lang.String groupIpAddress) {
            this.groupIpAddress = groupIpAddress;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayMulticastGroupMemberProps#getNetworkInterfaceId}
         * @param networkInterfaceId The group members' network interface IDs to register with the transit gateway multicast group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInterfaceId(java.lang.String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayMulticastGroupMemberProps#getTransitGatewayMulticastDomainId}
         * @param transitGatewayMulticastDomainId The ID of the transit gateway multicast domain. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitGatewayMulticastDomainId(java.lang.String transitGatewayMulticastDomainId) {
            this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTransitGatewayMulticastGroupMemberProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTransitGatewayMulticastGroupMemberProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTransitGatewayMulticastGroupMemberProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTransitGatewayMulticastGroupMemberProps {
        private final java.lang.String groupIpAddress;
        private final java.lang.String networkInterfaceId;
        private final java.lang.String transitGatewayMulticastDomainId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.groupIpAddress = software.amazon.jsii.Kernel.get(this, "groupIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkInterfaceId = software.amazon.jsii.Kernel.get(this, "networkInterfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.transitGatewayMulticastDomainId = software.amazon.jsii.Kernel.get(this, "transitGatewayMulticastDomainId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.groupIpAddress = java.util.Objects.requireNonNull(builder.groupIpAddress, "groupIpAddress is required");
            this.networkInterfaceId = java.util.Objects.requireNonNull(builder.networkInterfaceId, "networkInterfaceId is required");
            this.transitGatewayMulticastDomainId = java.util.Objects.requireNonNull(builder.transitGatewayMulticastDomainId, "transitGatewayMulticastDomainId is required");
        }

        @Override
        public final java.lang.String getGroupIpAddress() {
            return this.groupIpAddress;
        }

        @Override
        public final java.lang.String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final java.lang.String getTransitGatewayMulticastDomainId() {
            return this.transitGatewayMulticastDomainId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("groupIpAddress", om.valueToTree(this.getGroupIpAddress()));
            data.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
            data.set("transitGatewayMulticastDomainId", om.valueToTree(this.getTransitGatewayMulticastDomainId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnTransitGatewayMulticastGroupMemberProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTransitGatewayMulticastGroupMemberProps.Jsii$Proxy that = (CfnTransitGatewayMulticastGroupMemberProps.Jsii$Proxy) o;

            if (!groupIpAddress.equals(that.groupIpAddress)) return false;
            if (!networkInterfaceId.equals(that.networkInterfaceId)) return false;
            return this.transitGatewayMulticastDomainId.equals(that.transitGatewayMulticastDomainId);
        }

        @Override
        public final int hashCode() {
            int result = this.groupIpAddress.hashCode();
            result = 31 * result + (this.networkInterfaceId.hashCode());
            result = 31 * result + (this.transitGatewayMulticastDomainId.hashCode());
            return result;
        }
    }
}
