package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnVPCCidrBlock`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnVPCCidrBlockProps cfnVPCCidrBlockProps = CfnVPCCidrBlockProps.builder()
 *         .vpcId("vpcId")
 *         // the properties below are optional
 *         .amazonProvidedIpv6CidrBlock(false)
 *         .cidrBlock("cidrBlock")
 *         .ipv6CidrBlock("ipv6CidrBlock")
 *         .ipv6Pool("ipv6Pool")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-20T19:49:59.959Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnVPCCidrBlockProps")
@software.amazon.jsii.Jsii.Proxy(CfnVPCCidrBlockProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVPCCidrBlockProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpcId();

    /**
     * Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC.
     * <p>
     * You cannot specify the range of IPv6 addresses, or the size of the CIDR block.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAmazonProvidedIpv6CidrBlock() {
        return null;
    }

    /**
     * An IPv4 CIDR block to associate with the VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCidrBlock() {
        return null;
    }

    /**
     * An IPv6 CIDR block from the IPv6 address pool. You must also specify `Ipv6Pool` in the request.
     * <p>
     * To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpv6CidrBlock() {
        return null;
    }

    /**
     * The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpv6Pool() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVPCCidrBlockProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVPCCidrBlockProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVPCCidrBlockProps> {
        java.lang.String vpcId;
        java.lang.Object amazonProvidedIpv6CidrBlock;
        java.lang.String cidrBlock;
        java.lang.String ipv6CidrBlock;
        java.lang.String ipv6Pool;

        /**
         * Sets the value of {@link CfnVPCCidrBlockProps#getVpcId}
         * @param vpcId The ID of the VPC. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCCidrBlockProps#getAmazonProvidedIpv6CidrBlock}
         * @param amazonProvidedIpv6CidrBlock Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC.
         *                                    You cannot specify the range of IPv6 addresses, or the size of the CIDR block.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amazonProvidedIpv6CidrBlock(java.lang.Boolean amazonProvidedIpv6CidrBlock) {
            this.amazonProvidedIpv6CidrBlock = amazonProvidedIpv6CidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCCidrBlockProps#getAmazonProvidedIpv6CidrBlock}
         * @param amazonProvidedIpv6CidrBlock Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC.
         *                                    You cannot specify the range of IPv6 addresses, or the size of the CIDR block.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amazonProvidedIpv6CidrBlock(software.amazon.awscdk.core.IResolvable amazonProvidedIpv6CidrBlock) {
            this.amazonProvidedIpv6CidrBlock = amazonProvidedIpv6CidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCCidrBlockProps#getCidrBlock}
         * @param cidrBlock An IPv4 CIDR block to associate with the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrBlock(java.lang.String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCCidrBlockProps#getIpv6CidrBlock}
         * @param ipv6CidrBlock An IPv6 CIDR block from the IPv6 address pool. You must also specify `Ipv6Pool` in the request.
         *                      To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6CidrBlock(java.lang.String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCCidrBlockProps#getIpv6Pool}
         * @param ipv6Pool The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6Pool(java.lang.String ipv6Pool) {
            this.ipv6Pool = ipv6Pool;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVPCCidrBlockProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVPCCidrBlockProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVPCCidrBlockProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVPCCidrBlockProps {
        private final java.lang.String vpcId;
        private final java.lang.Object amazonProvidedIpv6CidrBlock;
        private final java.lang.String cidrBlock;
        private final java.lang.String ipv6CidrBlock;
        private final java.lang.String ipv6Pool;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.amazonProvidedIpv6CidrBlock = software.amazon.jsii.Kernel.get(this, "amazonProvidedIpv6CidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cidrBlock = software.amazon.jsii.Kernel.get(this, "cidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipv6CidrBlock = software.amazon.jsii.Kernel.get(this, "ipv6CidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipv6Pool = software.amazon.jsii.Kernel.get(this, "ipv6Pool", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpcId = java.util.Objects.requireNonNull(builder.vpcId, "vpcId is required");
            this.amazonProvidedIpv6CidrBlock = builder.amazonProvidedIpv6CidrBlock;
            this.cidrBlock = builder.cidrBlock;
            this.ipv6CidrBlock = builder.ipv6CidrBlock;
            this.ipv6Pool = builder.ipv6Pool;
        }

        @Override
        public final java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final java.lang.Object getAmazonProvidedIpv6CidrBlock() {
            return this.amazonProvidedIpv6CidrBlock;
        }

        @Override
        public final java.lang.String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public final java.lang.String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        @Override
        public final java.lang.String getIpv6Pool() {
            return this.ipv6Pool;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpcId", om.valueToTree(this.getVpcId()));
            if (this.getAmazonProvidedIpv6CidrBlock() != null) {
                data.set("amazonProvidedIpv6CidrBlock", om.valueToTree(this.getAmazonProvidedIpv6CidrBlock()));
            }
            if (this.getCidrBlock() != null) {
                data.set("cidrBlock", om.valueToTree(this.getCidrBlock()));
            }
            if (this.getIpv6CidrBlock() != null) {
                data.set("ipv6CidrBlock", om.valueToTree(this.getIpv6CidrBlock()));
            }
            if (this.getIpv6Pool() != null) {
                data.set("ipv6Pool", om.valueToTree(this.getIpv6Pool()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnVPCCidrBlockProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVPCCidrBlockProps.Jsii$Proxy that = (CfnVPCCidrBlockProps.Jsii$Proxy) o;

            if (!vpcId.equals(that.vpcId)) return false;
            if (this.amazonProvidedIpv6CidrBlock != null ? !this.amazonProvidedIpv6CidrBlock.equals(that.amazonProvidedIpv6CidrBlock) : that.amazonProvidedIpv6CidrBlock != null) return false;
            if (this.cidrBlock != null ? !this.cidrBlock.equals(that.cidrBlock) : that.cidrBlock != null) return false;
            if (this.ipv6CidrBlock != null ? !this.ipv6CidrBlock.equals(that.ipv6CidrBlock) : that.ipv6CidrBlock != null) return false;
            return this.ipv6Pool != null ? this.ipv6Pool.equals(that.ipv6Pool) : that.ipv6Pool == null;
        }

        @Override
        public final int hashCode() {
            int result = this.vpcId.hashCode();
            result = 31 * result + (this.amazonProvidedIpv6CidrBlock != null ? this.amazonProvidedIpv6CidrBlock.hashCode() : 0);
            result = 31 * result + (this.cidrBlock != null ? this.cidrBlock.hashCode() : 0);
            result = 31 * result + (this.ipv6CidrBlock != null ? this.ipv6CidrBlock.hashCode() : 0);
            result = 31 * result + (this.ipv6Pool != null ? this.ipv6Pool.hashCode() : 0);
            return result;
        }
    }
}
