package software.amazon.awscdk.services.ec2;

/**
 * Interface for security group-like objects.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-20T19:50:00.081Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.ISecurityGroup")
@software.amazon.jsii.Jsii.Proxy(ISecurityGroup.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ISecurityGroup extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.IResource, software.amazon.awscdk.services.ec2.IPeer {

    /**
     * Whether the SecurityGroup has been configured to allow all outbound traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getAllowAllOutbound();

    /**
     * ID for the current security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSecurityGroupId();

    /**
     * Add an egress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     * @param description
     * @param remoteRule
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addEgressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection, final @org.jetbrains.annotations.Nullable java.lang.String description, final @org.jetbrains.annotations.Nullable java.lang.Boolean remoteRule);

    /**
     * Add an egress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addEgressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection, final @org.jetbrains.annotations.Nullable java.lang.String description);

    /**
     * Add an egress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addEgressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection);

    /**
     * Add an ingress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     * @param description
     * @param remoteRule
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addIngressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection, final @org.jetbrains.annotations.Nullable java.lang.String description, final @org.jetbrains.annotations.Nullable java.lang.Boolean remoteRule);

    /**
     * Add an ingress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addIngressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection, final @org.jetbrains.annotations.Nullable java.lang.String description);

    /**
     * Add an ingress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addIngressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.ISecurityGroup.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class));
        }

        /**
         * The network connections associated with this resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
            return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
        }

        /**
         * Whether the rule can be inlined into a SecurityGroup or not.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.Boolean getCanInlineRule() {
            return software.amazon.jsii.Kernel.get(this, "canInlineRule", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * A unique identifier for this connection peer.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getUniqueId() {
            return software.amazon.jsii.Kernel.get(this, "uniqueId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Whether the SecurityGroup has been configured to allow all outbound traffic.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.Boolean getAllowAllOutbound() {
            return software.amazon.jsii.Kernel.get(this, "allowAllOutbound", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * ID for the current security group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getSecurityGroupId() {
            return software.amazon.jsii.Kernel.get(this, "securityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Produce the egress rule JSON for the given connection.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.Object toEgressRuleConfig() {
            return software.amazon.jsii.Kernel.call(this, "toEgressRuleConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Produce the ingress rule JSON for the given connection.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.Object toIngressRuleConfig() {
            return software.amazon.jsii.Kernel.call(this, "toIngressRuleConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Add an egress rule for the current security group.
         * <p>
         * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
         * securityGroup and they are in different stack. If false (default) the
         * rule object is created under the current SecurityGroup object. If true and the
         * peer is also a SecurityGroup, the rule object is created under the remote
         * SecurityGroup object.
         * <p>
         * @param peer This parameter is required.
         * @param connection This parameter is required.
         * @param description
         * @param remoteRule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addEgressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection, final @org.jetbrains.annotations.Nullable java.lang.String description, final @org.jetbrains.annotations.Nullable java.lang.Boolean remoteRule) {
            software.amazon.jsii.Kernel.call(this, "addEgressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required"), description, remoteRule });
        }

        /**
         * Add an egress rule for the current security group.
         * <p>
         * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
         * securityGroup and they are in different stack. If false (default) the
         * rule object is created under the current SecurityGroup object. If true and the
         * peer is also a SecurityGroup, the rule object is created under the remote
         * SecurityGroup object.
         * <p>
         * @param peer This parameter is required.
         * @param connection This parameter is required.
         * @param description
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addEgressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection, final @org.jetbrains.annotations.Nullable java.lang.String description) {
            software.amazon.jsii.Kernel.call(this, "addEgressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required"), description });
        }

        /**
         * Add an egress rule for the current security group.
         * <p>
         * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
         * securityGroup and they are in different stack. If false (default) the
         * rule object is created under the current SecurityGroup object. If true and the
         * peer is also a SecurityGroup, the rule object is created under the remote
         * SecurityGroup object.
         * <p>
         * @param peer This parameter is required.
         * @param connection This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addEgressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection) {
            software.amazon.jsii.Kernel.call(this, "addEgressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required") });
        }

        /**
         * Add an ingress rule for the current security group.
         * <p>
         * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
         * securityGroup and they are in different stack. If false (default) the
         * rule object is created under the current SecurityGroup object. If true and the
         * peer is also a SecurityGroup, the rule object is created under the remote
         * SecurityGroup object.
         * <p>
         * @param peer This parameter is required.
         * @param connection This parameter is required.
         * @param description
         * @param remoteRule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addIngressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection, final @org.jetbrains.annotations.Nullable java.lang.String description, final @org.jetbrains.annotations.Nullable java.lang.Boolean remoteRule) {
            software.amazon.jsii.Kernel.call(this, "addIngressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required"), description, remoteRule });
        }

        /**
         * Add an ingress rule for the current security group.
         * <p>
         * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
         * securityGroup and they are in different stack. If false (default) the
         * rule object is created under the current SecurityGroup object. If true and the
         * peer is also a SecurityGroup, the rule object is created under the remote
         * SecurityGroup object.
         * <p>
         * @param peer This parameter is required.
         * @param connection This parameter is required.
         * @param description
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addIngressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection, final @org.jetbrains.annotations.Nullable java.lang.String description) {
            software.amazon.jsii.Kernel.call(this, "addIngressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required"), description });
        }

        /**
         * Add an ingress rule for the current security group.
         * <p>
         * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
         * securityGroup and they are in different stack. If false (default) the
         * rule object is created under the current SecurityGroup object. If true and the
         * peer is also a SecurityGroup, the rule object is created under the remote
         * SecurityGroup object.
         * <p>
         * @param peer This parameter is required.
         * @param connection This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addIngressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection) {
            software.amazon.jsii.Kernel.call(this, "addIngressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required") });
        }
    }

    /**
     * Internal default implementation for {@link ISecurityGroup}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends ISecurityGroup, software.amazon.awscdk.core.IResource.Jsii$Default, software.amazon.awscdk.services.ec2.IPeer.Jsii$Default {

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class));
        }

        /**
         * The network connections associated with this resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
            return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
        }

        /**
         * Whether the rule can be inlined into a SecurityGroup or not.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.Boolean getCanInlineRule() {
            return software.amazon.jsii.Kernel.get(this, "canInlineRule", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * A unique identifier for this connection peer.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getUniqueId() {
            return software.amazon.jsii.Kernel.get(this, "uniqueId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Whether the SecurityGroup has been configured to allow all outbound traffic.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.Boolean getAllowAllOutbound() {
            return software.amazon.jsii.Kernel.get(this, "allowAllOutbound", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * ID for the current security group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getSecurityGroupId() {
            return software.amazon.jsii.Kernel.get(this, "securityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Produce the egress rule JSON for the given connection.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull java.lang.Object toEgressRuleConfig() {
            return software.amazon.jsii.Kernel.call(this, "toEgressRuleConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Produce the ingress rule JSON for the given connection.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull java.lang.Object toIngressRuleConfig() {
            return software.amazon.jsii.Kernel.call(this, "toIngressRuleConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Add an egress rule for the current security group.
         * <p>
         * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
         * securityGroup and they are in different stack. If false (default) the
         * rule object is created under the current SecurityGroup object. If true and the
         * peer is also a SecurityGroup, the rule object is created under the remote
         * SecurityGroup object.
         * <p>
         * @param peer This parameter is required.
         * @param connection This parameter is required.
         * @param description
         * @param remoteRule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addEgressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection, final @org.jetbrains.annotations.Nullable java.lang.String description, final @org.jetbrains.annotations.Nullable java.lang.Boolean remoteRule) {
            software.amazon.jsii.Kernel.call(this, "addEgressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required"), description, remoteRule });
        }

        /**
         * Add an ingress rule for the current security group.
         * <p>
         * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
         * securityGroup and they are in different stack. If false (default) the
         * rule object is created under the current SecurityGroup object. If true and the
         * peer is also a SecurityGroup, the rule object is created under the remote
         * SecurityGroup object.
         * <p>
         * @param peer This parameter is required.
         * @param connection This parameter is required.
         * @param description
         * @param remoteRule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addIngressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection, final @org.jetbrains.annotations.Nullable java.lang.String description, final @org.jetbrains.annotations.Nullable java.lang.Boolean remoteRule) {
            software.amazon.jsii.Kernel.call(this, "addIngressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required"), description, remoteRule });
        }
    }
}
