package software.amazon.awscdk.services.ec2;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc = Vpc.Builder.create(this, "MyVpc")
 *         .vpnConnections(Map.of(
 *                 "dynamic", VpnConnectionOptions.builder() // Dynamic routing (BGP)
 *                         .ip("1.2.3.4").build(),
 *                 "static", VpnConnectionOptions.builder() // Static routing
 *                         .ip("4.5.6.7")
 *                         .staticRoutes(List.of("192.168.10.0/24", "192.168.20.0/24")).build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-20T19:50:00.253Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.VpnConnectionOptions")
@software.amazon.jsii.Jsii.Proxy(VpnConnectionOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpnConnectionOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ip address of the customer gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIp();

    /**
     * The ASN of the customer gateway.
     * <p>
     * Default: 65000
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAsn() {
        return null;
    }

    /**
     * The static routes to be routed from the VPN gateway to the customer gateway.
     * <p>
     * Default: Dynamic routing (BGP)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStaticRoutes() {
        return null;
    }

    /**
     * The tunnel options for the VPN connection.
     * <p>
     * At most two elements (one per tunnel).
     * Duplicates not allowed.
     * <p>
     * Default: Amazon generated tunnel options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption> getTunnelOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VpnConnectionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpnConnectionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VpnConnectionOptions> {
        java.lang.String ip;
        java.lang.Number asn;
        java.util.List<java.lang.String> staticRoutes;
        java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption> tunnelOptions;

        /**
         * Sets the value of {@link VpnConnectionOptions#getIp}
         * @param ip The ip address of the customer gateway. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ip(java.lang.String ip) {
            this.ip = ip;
            return this;
        }

        /**
         * Sets the value of {@link VpnConnectionOptions#getAsn}
         * @param asn The ASN of the customer gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder asn(java.lang.Number asn) {
            this.asn = asn;
            return this;
        }

        /**
         * Sets the value of {@link VpnConnectionOptions#getStaticRoutes}
         * @param staticRoutes The static routes to be routed from the VPN gateway to the customer gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder staticRoutes(java.util.List<java.lang.String> staticRoutes) {
            this.staticRoutes = staticRoutes;
            return this;
        }

        /**
         * Sets the value of {@link VpnConnectionOptions#getTunnelOptions}
         * @param tunnelOptions The tunnel options for the VPN connection.
         *                      At most two elements (one per tunnel).
         *                      Duplicates not allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tunnelOptions(java.util.List<? extends software.amazon.awscdk.services.ec2.VpnTunnelOption> tunnelOptions) {
            this.tunnelOptions = (java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption>)tunnelOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpnConnectionOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VpnConnectionOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VpnConnectionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpnConnectionOptions {
        private final java.lang.String ip;
        private final java.lang.Number asn;
        private final java.util.List<java.lang.String> staticRoutes;
        private final java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption> tunnelOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ip = software.amazon.jsii.Kernel.get(this, "ip", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.asn = software.amazon.jsii.Kernel.get(this, "asn", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.staticRoutes = software.amazon.jsii.Kernel.get(this, "staticRoutes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tunnelOptions = software.amazon.jsii.Kernel.get(this, "tunnelOptions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.VpnTunnelOption.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ip = java.util.Objects.requireNonNull(builder.ip, "ip is required");
            this.asn = builder.asn;
            this.staticRoutes = builder.staticRoutes;
            this.tunnelOptions = (java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption>)builder.tunnelOptions;
        }

        @Override
        public final java.lang.String getIp() {
            return this.ip;
        }

        @Override
        public final java.lang.Number getAsn() {
            return this.asn;
        }

        @Override
        public final java.util.List<java.lang.String> getStaticRoutes() {
            return this.staticRoutes;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption> getTunnelOptions() {
            return this.tunnelOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ip", om.valueToTree(this.getIp()));
            if (this.getAsn() != null) {
                data.set("asn", om.valueToTree(this.getAsn()));
            }
            if (this.getStaticRoutes() != null) {
                data.set("staticRoutes", om.valueToTree(this.getStaticRoutes()));
            }
            if (this.getTunnelOptions() != null) {
                data.set("tunnelOptions", om.valueToTree(this.getTunnelOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.VpnConnectionOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpnConnectionOptions.Jsii$Proxy that = (VpnConnectionOptions.Jsii$Proxy) o;

            if (!ip.equals(that.ip)) return false;
            if (this.asn != null ? !this.asn.equals(that.asn) : that.asn != null) return false;
            if (this.staticRoutes != null ? !this.staticRoutes.equals(that.staticRoutes) : that.staticRoutes != null) return false;
            return this.tunnelOptions != null ? this.tunnelOptions.equals(that.tunnelOptions) : that.tunnelOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.ip.hashCode();
            result = 31 * result + (this.asn != null ? this.asn.hashCode() : 0);
            result = 31 * result + (this.staticRoutes != null ? this.staticRoutes.hashCode() : 0);
            result = 31 * result + (this.tunnelOptions != null ? this.tunnelOptions.hashCode() : 0);
            return result;
        }
    }
}
