package software.amazon.awscdk.services.ec2;

/**
 * Interface for the Spot market instance options provided in a LaunchTemplate.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.core.*;
 * Expiration expiration;
 * LaunchTemplateSpotOptions launchTemplateSpotOptions = LaunchTemplateSpotOptions.builder()
 *         .blockDuration(Duration.minutes(30))
 *         .interruptionBehavior(SpotInstanceInterruption.STOP)
 *         .maxPrice(123)
 *         .requestType(SpotRequestType.ONE_TIME)
 *         .validUntil(expiration)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-27T11:48:56.592Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.LaunchTemplateSpotOptions")
@software.amazon.jsii.Jsii.Proxy(LaunchTemplateSpotOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LaunchTemplateSpotOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Spot Instances with a defined duration (also known as Spot blocks) are designed not to be interrupted and will run continuously for the duration you select.
     * <p>
     * You can use a duration of 1, 2, 3, 4, 5, or 6 hours.
     * <p>
     * Default: Requested spot instances do not have a pre-defined duration.
     * <p>
     * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html#fixed-duration-spot-instances
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getBlockDuration() {
        return null;
    }

    /**
     * The behavior when a Spot Instance is interrupted.
     * <p>
     * Default: Spot instances will terminate when interrupted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SpotInstanceInterruption getInterruptionBehavior() {
        return null;
    }

    /**
     * Maximum hourly price you're willing to pay for each Spot instance.
     * <p>
     * The value is given
     * in dollars. ex: 0.01 for 1 cent per hour, or 0.001 for one-tenth of a cent per hour.
     * <p>
     * Default: Maximum hourly price will default to the on-demand price for the instance type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxPrice() {
        return null;
    }

    /**
     * The Spot Instance request type.
     * <p>
     * If you are using Spot Instances with an Auto Scaling group, use one-time requests, as the
     * Amazon EC2 Auto Scaling service handles requesting new Spot Instances whenever the group is
     * below its desired capacity.
     * <p>
     * Default: One-time spot request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SpotRequestType getRequestType() {
        return null;
    }

    /**
     * The end date of the request.
     * <p>
     * For a one-time request, the request remains active until all instances
     * launch, the request is canceled, or this date is reached. If the request is persistent, it remains
     * active until it is canceled or this date and time is reached.
     * <p>
     * Default: The default end date is 7 days from the current date.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Expiration getValidUntil() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LaunchTemplateSpotOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LaunchTemplateSpotOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LaunchTemplateSpotOptions> {
        software.amazon.awscdk.core.Duration blockDuration;
        software.amazon.awscdk.services.ec2.SpotInstanceInterruption interruptionBehavior;
        java.lang.Number maxPrice;
        software.amazon.awscdk.services.ec2.SpotRequestType requestType;
        software.amazon.awscdk.core.Expiration validUntil;

        /**
         * Sets the value of {@link LaunchTemplateSpotOptions#getBlockDuration}
         * @param blockDuration Spot Instances with a defined duration (also known as Spot blocks) are designed not to be interrupted and will run continuously for the duration you select.
         *                      You can use a duration of 1, 2, 3, 4, 5, or 6 hours.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockDuration(software.amazon.awscdk.core.Duration blockDuration) {
            this.blockDuration = blockDuration;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateSpotOptions#getInterruptionBehavior}
         * @param interruptionBehavior The behavior when a Spot Instance is interrupted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder interruptionBehavior(software.amazon.awscdk.services.ec2.SpotInstanceInterruption interruptionBehavior) {
            this.interruptionBehavior = interruptionBehavior;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateSpotOptions#getMaxPrice}
         * @param maxPrice Maximum hourly price you're willing to pay for each Spot instance.
         *                 The value is given
         *                 in dollars. ex: 0.01 for 1 cent per hour, or 0.001 for one-tenth of a cent per hour.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxPrice(java.lang.Number maxPrice) {
            this.maxPrice = maxPrice;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateSpotOptions#getRequestType}
         * @param requestType The Spot Instance request type.
         *                    If you are using Spot Instances with an Auto Scaling group, use one-time requests, as the
         *                    Amazon EC2 Auto Scaling service handles requesting new Spot Instances whenever the group is
         *                    below its desired capacity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestType(software.amazon.awscdk.services.ec2.SpotRequestType requestType) {
            this.requestType = requestType;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateSpotOptions#getValidUntil}
         * @param validUntil The end date of the request.
         *                   For a one-time request, the request remains active until all instances
         *                   launch, the request is canceled, or this date is reached. If the request is persistent, it remains
         *                   active until it is canceled or this date and time is reached.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validUntil(software.amazon.awscdk.core.Expiration validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LaunchTemplateSpotOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LaunchTemplateSpotOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LaunchTemplateSpotOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchTemplateSpotOptions {
        private final software.amazon.awscdk.core.Duration blockDuration;
        private final software.amazon.awscdk.services.ec2.SpotInstanceInterruption interruptionBehavior;
        private final java.lang.Number maxPrice;
        private final software.amazon.awscdk.services.ec2.SpotRequestType requestType;
        private final software.amazon.awscdk.core.Expiration validUntil;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.blockDuration = software.amazon.jsii.Kernel.get(this, "blockDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.interruptionBehavior = software.amazon.jsii.Kernel.get(this, "interruptionBehavior", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SpotInstanceInterruption.class));
            this.maxPrice = software.amazon.jsii.Kernel.get(this, "maxPrice", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.requestType = software.amazon.jsii.Kernel.get(this, "requestType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SpotRequestType.class));
            this.validUntil = software.amazon.jsii.Kernel.get(this, "validUntil", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Expiration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.blockDuration = builder.blockDuration;
            this.interruptionBehavior = builder.interruptionBehavior;
            this.maxPrice = builder.maxPrice;
            this.requestType = builder.requestType;
            this.validUntil = builder.validUntil;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getBlockDuration() {
            return this.blockDuration;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SpotInstanceInterruption getInterruptionBehavior() {
            return this.interruptionBehavior;
        }

        @Override
        public final java.lang.Number getMaxPrice() {
            return this.maxPrice;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SpotRequestType getRequestType() {
            return this.requestType;
        }

        @Override
        public final software.amazon.awscdk.core.Expiration getValidUntil() {
            return this.validUntil;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBlockDuration() != null) {
                data.set("blockDuration", om.valueToTree(this.getBlockDuration()));
            }
            if (this.getInterruptionBehavior() != null) {
                data.set("interruptionBehavior", om.valueToTree(this.getInterruptionBehavior()));
            }
            if (this.getMaxPrice() != null) {
                data.set("maxPrice", om.valueToTree(this.getMaxPrice()));
            }
            if (this.getRequestType() != null) {
                data.set("requestType", om.valueToTree(this.getRequestType()));
            }
            if (this.getValidUntil() != null) {
                data.set("validUntil", om.valueToTree(this.getValidUntil()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.LaunchTemplateSpotOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LaunchTemplateSpotOptions.Jsii$Proxy that = (LaunchTemplateSpotOptions.Jsii$Proxy) o;

            if (this.blockDuration != null ? !this.blockDuration.equals(that.blockDuration) : that.blockDuration != null) return false;
            if (this.interruptionBehavior != null ? !this.interruptionBehavior.equals(that.interruptionBehavior) : that.interruptionBehavior != null) return false;
            if (this.maxPrice != null ? !this.maxPrice.equals(that.maxPrice) : that.maxPrice != null) return false;
            if (this.requestType != null ? !this.requestType.equals(that.requestType) : that.requestType != null) return false;
            return this.validUntil != null ? this.validUntil.equals(that.validUntil) : that.validUntil == null;
        }

        @Override
        public final int hashCode() {
            int result = this.blockDuration != null ? this.blockDuration.hashCode() : 0;
            result = 31 * result + (this.interruptionBehavior != null ? this.interruptionBehavior.hashCode() : 0);
            result = 31 * result + (this.maxPrice != null ? this.maxPrice.hashCode() : 0);
            result = 31 * result + (this.requestType != null ? this.requestType.hashCode() : 0);
            result = 31 * result + (this.validUntil != null ? this.validUntil.hashCode() : 0);
            return result;
        }
    }
}
